/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvMemoryFind;
import com.ibm.jvm.dump.format.DvMemoryFindResults;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.Dvifm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class DvFindInMemory
implements ActionListener,
KeyListener {
    Dvifm theIFM;
    JInternalFrame jif;
    DvConsole dvConsole;
    DvMemoryFind dvMemoryFind;
    JTextField findText;
    JTextField startField;
    JTextField finishField;
    JTextField boundaryField;
    JTextField bytesField;
    JTextField occurenceField;
    JButton findButton = new JButton("Find");
    JButton cancelButton = new JButton("Cancel");

    public DvFindInMemory(JInternalFrame jInternalFrame, DvConsole dvConsole, DvMemoryFind dvMemoryFind) {
        this.theIFM = DvUtils.getTheIFM();
        this.jif = jInternalFrame;
        this.dvConsole = dvConsole;
        this.dvMemoryFind = dvMemoryFind;
        this.constructWindow();
    }

    private void constructWindow() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.findButton = new JButton("Find");
        this.cancelButton = new JButton("Cancel");
        this.findButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        jPanel.setLayout(new GridLayout(0, 1));
        JPanel jPanel3 = this.constructFindPanel();
        jTabbedPane.addTab("Find", jPanel3);
        JPanel jPanel4 = this.constructOptionsPanel();
        jTabbedPane.addTab("Options", jPanel4);
        jTabbedPane.setSelectedIndex(0);
        jPanel2.add(this.findButton);
        jPanel2.add(this.cancelButton);
        jPanel.add(jTabbedPane);
        this.theIFM.addContentToFrame(this.jif, jPanel, jPanel2);
        this.findText.requestFocus();
    }

    private JPanel constructFindPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(50, 30, 50, 30));
        JLabel jLabel = new JLabel("Search For:");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 10, 10));
        jPanel2.add(jLabel);
        jPanel.add((Component)jPanel2, "West");
        this.findText = new JTextField(this.dvMemoryFind.findText, 10);
        this.findText.addKeyListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1, 10, 10));
        jPanel3.add(this.findText);
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    private JPanel constructOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(25, 30, 25, 30));
        JLabel jLabel = new JLabel("Start Address");
        JLabel jLabel2 = new JLabel("Finish Address");
        JLabel jLabel3 = new JLabel("Byte Boundary");
        JLabel jLabel4 = new JLabel("Display Bytes");
        JLabel jLabel5 = new JLabel("Occurences");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1, 3, 3));
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel2.add(jLabel3);
        jPanel2.add(jLabel4);
        jPanel2.add(jLabel5);
        jPanel.add((Component)jPanel2, "West");
        this.startField = new JTextField(this.dvMemoryFind.startAddress, 10);
        this.finishField = new JTextField(this.dvMemoryFind.finishAddress, 10);
        this.boundaryField = new JTextField(Integer.toString(this.dvMemoryFind.byteBoundary), 10);
        this.bytesField = new JTextField(Integer.toString(this.dvMemoryFind.displayBytes), 10);
        this.occurenceField = new JTextField(Integer.toString(this.dvMemoryFind.occurences), 10);
        this.startField.addKeyListener(this);
        this.finishField.addKeyListener(this);
        this.boundaryField.addKeyListener(this);
        this.bytesField.addKeyListener(this);
        this.occurenceField.addKeyListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1, 3, 3));
        jPanel3.add(this.startField);
        jPanel3.add(this.finishField);
        jPanel3.add(this.boundaryField);
        jPanel3.add(this.bytesField);
        jPanel3.add(this.occurenceField);
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    public void doFindInMemory() {
        this.dvMemoryFind.findText = this.findText.getText();
        this.dvMemoryFind.startAddress = this.startField.getText();
        this.dvMemoryFind.finishAddress = this.finishField.getText();
        this.dvMemoryFind.displayBytes = Integer.valueOf(this.bytesField.getText());
        this.dvMemoryFind.byteBoundary = Integer.valueOf(this.boundaryField.getText());
        this.dvMemoryFind.occurences = Integer.valueOf(this.occurenceField.getText());
        Dvifm dvifm = DvUtils.getTheIFM();
        JInternalFrame jInternalFrame = dvifm.createNewFrame("Memory Find - " + this.dvMemoryFind.findText, dvifm.getDefaultProperties(), 6);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 325, 470, 300, 75);
        DvMemoryFindResults dvMemoryFindResults = new DvMemoryFindResults(jInternalFrame, this.dvConsole, this.dvMemoryFind);
        dvMemoryFindResults.DoFindResults();
    }

    public boolean checkValidFields() {
        boolean bl = true;
        String string = this.findText.getText();
        String string2 = this.startField.getText();
        String string3 = this.finishField.getText();
        int n = Integer.valueOf(this.bytesField.getText());
        int n2 = Integer.valueOf(this.boundaryField.getText());
        int n3 = Integer.valueOf(this.occurenceField.getText());
        long l = -1L;
        long l2 = -1L;
        DvUtils.writetoTrace("Find " + this.findText.getText());
        if (!string2.equals("")) {
            try {
                l = DvUtils.hexToLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                JOptionPane.showMessageDialog(null, "Invalid Start Address");
                this.startField.requestFocus();
                return bl;
            }
            DvUtils.writetoTrace("StartAddress = " + l);
        }
        if (!string3.equals("")) {
            try {
                l2 = DvUtils.hexToLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                JOptionPane.showMessageDialog(null, "Invalid finish Address");
                this.finishField.requestFocus();
                return bl;
            }
            DvUtils.writetoTrace("endAddress = " + l2);
        }
        if (this.findText.getText().equals("")) {
            bl = false;
            JOptionPane.showMessageDialog(null, "A search string must be entered.");
            this.findText.requestFocus();
        } else if (l != -1L && l2 != -1L) {
            if (l > l2) {
                bl = false;
                JOptionPane.showMessageDialog(null, "Start Address must be less than finish Address");
                this.startField.requestFocus();
            }
        } else if (n2 < 1 || n2 > 100) {
            bl = false;
            JOptionPane.showMessageDialog(null, "Boundary must be in the range 1 to 100");
            this.boundaryField.requestFocus();
        } else if (n < 1) {
            bl = false;
            JOptionPane.showMessageDialog(null, "Display bytes must be greater than 1");
            this.bytesField.requestFocus();
        } else if (n3 < 1 || n3 > Short.MAX_VALUE) {
            bl = false;
            JOptionPane.showMessageDialog(null, "Occurrences must be in the range 0 to 32767 ");
            this.occurenceField.requestFocus();
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.findButton) {
            DvUtils.writetoTrace("Find Button action in FindInMemory");
            if (this.checkValidFields()) {
                this.doFindInMemory();
            }
        } else if (actionEvent.getSource() == this.cancelButton) {
            DvUtils.writetoTrace("Cancel Button action in FindInMemory");
            this.jif.setVisible(false);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            DvUtils.writetoTrace("Enter Key pressed in findText field");
            if (this.checkValidFields()) {
                this.doFindInMemory();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

