/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.CTypeFile;
import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvEnvData;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DvConsole
implements Observer {
    static PrintStream original_output = System.out;
    static PrintStream original_error = System.err;
    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    boolean traceOn = false;
    String traceFileName = null;
    String output = null;
    String inputFileName = null;
    static Properties inParams;
    static DvDump theDump;
    static CommandPlugin currentCP;
    static Vector cmdList;
    static Vector commandPlugins;
    static Vector fastPath;
    static String currDump;
    private static Properties myHelpProps;
    private static Enumeration myPropsEnum;
    static int currASIndex;
    static int currProcessIndex;
    static int currThreadIndex;
    static Vector currentClassSpecs;
    static Vector currentCBSpecs;
    static int currWidth;
    static char currOffset;
    static Vector viewerInit;
    static boolean echoOn;
    static boolean ipDump;
    static boolean ipInput;
    static boolean ipOutput;
    static int traceHandle;
    static String[] templates;
    static boolean runningUnderGUI;
    static Dumpviewer theGUI;
    static String lastMemCommandPosition;
    static int lastMemCommandLength;
    private static Vector outputVector;
    private static boolean useOutputVector;
    private static DvConsole that;
    private static CommandPlugin childCP;

    public DvConsole(boolean bl, Dumpviewer dumpviewer, Vector vector) {
        Object object;
        that = this;
        DvUtils.writetoTrace("DvConsole:DvConsole(" + bl + ")");
        runningUnderGUI = bl;
        theGUI = dumpviewer;
        DvUtils.setConsoleOutput(!bl);
        viewerInit = vector;
        commandPlugins = DvUtils.findCommandPlugins();
        int n = commandPlugins.size();
        String[] stringArray = null;
        DvCommand dvCommand = null;
        DvUtils.writetoTrace("Asking each command plugin what it supports ");
        int n2 = 0;
        while (n2 < n) {
            object = (CommandPlugin)commandPlugins.get(n2);
            DvUtils.writetoTrace(" Plugin " + ((CommandPlugin)object).pluginName() + " supports: ");
            stringArray = ((CommandPlugin)object).getSyntax();
            int n3 = 0;
            while (n3 < stringArray.length) {
                dvCommand = new DvCommand(stringArray[n3], n2);
                DvUtils.writetoTrace("    " + stringArray[n3]);
                cmdList.add(dvCommand);
                ++n3;
            }
            ++n2;
        }
        DvUtils.initSetCommand();
        if (ipOutput) {
            object = "Set Output=" + inParams.getProperty("o");
            this.execCmd(new ValidCmd((String)object));
        }
        if (ipDump) {
            object = "Set Dump=" + inParams.getProperty("d");
            this.execCmd(new ValidCmd((String)object));
        }
        if (ipInput) {
            object = "Exec " + inParams.getProperty("i");
            this.execCmd(new ValidCmd((String)object));
        }
        object = "";
        DvUtils.writetoTrace("Entering master loop - terminated with quit command");
        while (!runningUnderGUI && !((String)object).equals("quit")) {
            DvConsole.output("\nReady......");
            try {
                object = this.in.readLine();
            }
            catch (IOException iOException) {
                DvUtils.errorMsg(" IOException in DvConsole constructor input loop", 0);
            }
            if (echoOn) {
                DvConsole.output((String)object);
            }
            if (null != object) {
                object = ((String)object).trim();
                String string = new String((String)object);
                if (!((String)(object = this.preProcessInput((String)object))).equals(string)) {
                    DvConsole.output("Transformed command:" + (String)object + "\n");
                }
                ValidCmd validCmd = DvConsole.validate((String)object);
                if (validCmd.errorPos == 0) {
                    DvConsole.output("\n ......command executing");
                    this.execCmd(validCmd);
                    while (null != currentCP && currentCP.getInProgress()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            System.err.println("\nInterruptedException");
                        }
                    }
                    continue;
                }
                String string2 = new String();
                int n4 = 0;
                while (n4 < validCmd.errorPos) {
                    string2 = string2 + " ";
                    ++n4;
                }
                DvConsole.output("\n !!!Invalid Command: " + validCmd.savedCmd + "\n" + "                    " + string2 + "^\n");
                if (null == currentCP) continue;
                DvConsole.currentCP.cpInProgress = false;
                continue;
            }
            object = "";
        }
    }

    public static void main(String[] stringArray) {
        templates = new String[1];
        DvConsole.templates[0] = "0 DvConsole: %s";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (stringArray.length > 0) {
            inParams = new Properties();
            if (stringArray[0].charAt(0) != '-') {
                stringArray[0] = "-d" + stringArray[0];
            }
            int n = 0;
            while (n < stringArray.length && !bl) {
                if (bl2) {
                    if (stringArray[n].charAt(0) != '-') {
                        stringArray[n] = stringArray[n - 1] + stringArray[n];
                        bl2 = false;
                    } else {
                        DvConsole.output("\nError: value required for argument '" + stringArray[n - 1] + "'");
                        bl = true;
                    }
                }
                if (stringArray[n].charAt(0) == '-' && !bl) {
                    int n2 = 45;
                    if (stringArray[n].length() != 1) {
                        n2 = stringArray[n].charAt(1);
                    }
                    switch (n2) {
                        case 68: 
                        case 100: {
                            if (stringArray[n].toUpperCase().equals("-D")) {
                                bl2 = true;
                                break;
                            }
                            if (stringArray[n].charAt(2) == '-') {
                                DvConsole.output("\nError: invalid value following '-d'");
                                bl = true;
                                break;
                            }
                            if (bl4) {
                                DvConsole.output("\nError: '-d' option was specified twice");
                                bl = true;
                                break;
                            }
                            bl4 = true;
                            ipDump = true;
                            inParams.setProperty("d", stringArray[n].substring(2));
                            break;
                        }
                        case 73: 
                        case 105: {
                            if (stringArray[n].toUpperCase().equals("-I")) {
                                bl2 = true;
                                break;
                            }
                            if (stringArray[n].charAt(2) == '-') {
                                DvConsole.output("\nError: invalid value following '-i'");
                                bl = true;
                                break;
                            }
                            if (bl6) {
                                DvConsole.output("\nError: '-i' option was specified twice");
                                bl = true;
                                break;
                            }
                            bl6 = true;
                            ipInput = true;
                            inParams.setProperty("i", stringArray[n].substring(2));
                            break;
                        }
                        case 79: 
                        case 111: {
                            if (stringArray[n].toUpperCase().equals("-O")) {
                                bl2 = true;
                                break;
                            }
                            if (stringArray[n].charAt(2) == '-') {
                                DvConsole.output("\nError: invalid value following '-o'");
                                bl = true;
                                break;
                            }
                            if (bl5) {
                                DvConsole.output("\nError: '-o' option was specified twice");
                                bl = true;
                                break;
                            }
                            bl5 = true;
                            ipOutput = true;
                            inParams.setProperty("o", stringArray[n].substring(2));
                            break;
                        }
                        case 116: {
                            if (stringArray[n].equals("-t")) {
                                bl2 = true;
                                break;
                            }
                            if (stringArray[n].charAt(2) == '-') {
                                DvConsole.output("\nError: invalid value following '-t'");
                                bl = true;
                                break;
                            }
                            if (bl7) {
                                DvConsole.output("\nError: '-t' option was specified twice");
                                bl = true;
                                break;
                            }
                            bl7 = true;
                            DvUtils.setVerbose(true);
                            inParams.setProperty("t", stringArray[n].substring(2));
                            break;
                        }
                        case 84: {
                            if (bl7) {
                                DvConsole.output("\nError: '-t' option was specified twice");
                                bl = true;
                                break;
                            }
                            bl7 = true;
                            DvUtils.setVerbose(true);
                            inParams.setProperty("t", stringArray[n].substring(2));
                            break;
                        }
                        case 63: 
                        case 72: 
                        case 104: {
                            bl3 = true;
                            break;
                        }
                        default: {
                            DvConsole.output("\nError: invalid option '" + stringArray[n] + "'");
                            bl = true;
                            break;
                        }
                    }
                } else {
                    DvConsole.output("\nError: options must begin with '-'");
                    bl = true;
                }
                ++n;
            }
        } else {
            bl3 = true;
        }
        if (bl2) {
            DvConsole.output("\nError: value required for argument '" + stringArray[stringArray.length - 1] + "'");
            bl = true;
        }
        if (bl || bl3) {
            DvConsole.output("\nUsage: jformat [[-d]dumpfilename] [other options]\n");
            DvConsole.output("where options include: ");
            DvConsole.output("       -d dumpfilename    - the dump to format");
            DvConsole.output("       -o outputfilename  - output to file");
            DvConsole.output("       -i inputfilename   - input from file");
            DvConsole.output("       -t tracefilename   - trace to file");
            DvConsole.output("       -T                 - trace to console");
            DvConsole.output("       -? or -h           - help");
            DvConsole.output(" ");
        }
        if (bl) {
            return;
        }
        DvUtils.writetoTrace("DvConsole:main - instantiating DvConsole instance");
        DvConsole dvConsole = new DvConsole(false, null, null);
    }

    public static boolean setTheDump(DvDump dvDump, Vector vector, String string) {
        Object object;
        String string2;
        Object object2;
        DvUtils.writetoTrace(" Entry to DvConsole:setTheDump (" + string + ")");
        boolean bl = false;
        theDump = dvDump;
        DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
        DvUtils.setValue("ASID", dvAddressSpaceArray[0].id());
        DvProcess[] dvProcessArray = dvAddressSpaceArray[0].getProcesses();
        DvProcess dvProcess = dvProcessArray[0];
        DvUtils.setValue("PID", dvProcess.id());
        Object object3 = dvProcessArray[0].getCurrentThread();
        dvAddressSpaceArray[0].getMemRanges();
        if (null != object3 && ((DvThread)object3).isJava()) {
            DvUtils.setValue("THREAD", ((DvThread)object3).id());
        } else {
            object2 = dvProcessArray[0].getThreads();
            boolean bl2 = false;
            if (((DvThread[])object2).length != 0) {
                int n = 0;
                while (n < ((DvThread[])object2).length) {
                    if (object2[n].isJava() && ((DvThread)object2[n]).eeAddress().getAddressAsLong() != 0L) {
                        DvUtils.writetoTrace(" Found a suitable 1st thread:" + ((DvThread)object2[n]).id());
                        bl2 = true;
                        DvUtils.setValue("THREAD", ((DvThread)object2[n]).id());
                        object3 = object2[n];
                        n = ((Object)object2).length;
                    }
                    ++n;
                }
            }
        }
        DvUtils.setValue("DUMP", string);
        object2 = null;
        try {
            object2 = dvProcess.getEnvData();
        }
        catch (Error error) {
            // empty catch block
        }
        if (null != object2) {
            string2 = ((DvEnvData)object2).javaVersion();
            String string3 = DvUtils.getCtypeFile(theDump, string2);
            if (string3 != null) {
                // empty if block
            }
        } else {
            DvUtils.writetoTrace(" EnvData is null");
            string2 = DvUtils.getCtypeFile(theDump, "abcd");
            if (string2 != null) {
                // empty if block
            }
        }
        boolean bl3 = false;
        byte[] byArray = dvDump.getCTypedefs();
        bl3 = true;
        if (byArray != null) {
            object = new CTypeFile(byArray);
            if (object != null) {
                bl3 = true;
                vector.add("Using typedefs from core...");
            }
        } else {
            bl3 = DvUtils.loadFormatFile(vector);
        }
        if (!bl3) {
            vector.add(" !!! Error establishing format file        !!!");
            vector.add(" !!! Use SET FORMATFILE= command and retry !!!");
            return bl;
        }
        bl = true;
        object = dvAddressSpaceArray[0].createAddress(((DvThread)object3).eeAddress().getAddressAsLong());
        if (DvUtils.checkAddressInDump((DvAddress)object, dvAddressSpaceArray[0])) {
            CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpaceArray[0], (DvAddress)object, "execenv");
            if (null != cTypeObject) {
                CTypeObject cTypeObject2 = cTypeObject.getField("jvmP");
                if (null != cTypeObject2) {
                    String string4 = cTypeObject2.toString();
                    if (string4.startsWith("null ")) {
                        string4 = string4.substring(5);
                    }
                    if (string4.startsWith("(null) ")) {
                        string4 = string4.substring(7);
                    }
                    string4 = DvUtils.removeAtSign(string4);
                    string4 = DvUtils.remove0x(string4);
                    DvAddress dvAddress = null;
                    DvAddress dvAddress2 = null;
                    boolean bl4 = true;
                    try {
                        dvAddress2 = dvAddressSpaceArray[0].createAddress(DvUtils.hexToLong(string4));
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = false;
                        DvUtils.writetoTrace(" DvConsole:setTheDump -String returned for jvmP_cTO is:<<" + string4 + ">>");
                        vector.add("\n jvmP addressing failure");
                    }
                    CTypeObject cTypeObject3 = null;
                    if (bl4) {
                        block32: {
                            try {
                                dvAddress = dvAddressSpaceArray[0].readPointer(dvAddress2);
                            }
                            catch (DvAddressException dvAddressException) {
                                if (null == vector) break block32;
                                vector.add("\n jvmP addressing failure");
                            }
                        }
                        if (null != dvAddress) {
                            cTypeObject3 = DvUtils.formatAddrAsType(dvAddressSpaceArray[0], dvAddress, "Jvm");
                        }
                    }
                    if (null != cTypeObject3) {
                        DvUtils.setupJVMHints(cTypeObject3, dvAddressSpaceArray[0]);
                    } else if (null != vector) {
                        vector.add(" Unable to format Jvm!");
                    }
                } else if (null != vector) {
                    vector.add(" Unable to get jvmP!");
                }
            }
        } else {
            DvUtils.writetoTrace(" execenv was 0");
            vector.add(" execenv was 0!");
        }
        DvUtils.writetoTrace(" Exit from DvConsole:setTheDump");
        return bl;
    }

    private static void showHelp(String string) {
        String string2;
        String string3;
        String string4;
        block7: {
            DvUtils.writetoTrace("DvConsole:showHelp entry");
            string4 = null;
            string3 = "";
            string2 = null;
            if (null == myHelpProps) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(".\\DvGenericHelp.properties");
                    myHelpProps = new Properties();
                    myHelpProps.load(fileInputStream);
                }
                catch (IOException iOException) {
                    String string5 = System.getProperty("file.separator");
                    String string6 = "com" + string5 + "ibm" + string5 + "jvm" + string5 + "dump" + string5 + "DvGenericHelp.properties";
                    myHelpProps = DvUtils.searchClassPathForPropFile(string6);
                    if (null != myHelpProps) break block7;
                    string6 = "DvGenericHelp.properties";
                    myHelpProps = DvUtils.searchClassPathForPropFile(string6);
                }
            }
        }
        if (null != myHelpProps) {
            myPropsEnum = myHelpProps.propertyNames();
            int n = 1;
            while (n < 999) {
                string4 = string + n;
                string2 = myHelpProps.getProperty(string4);
                if (null != string2) {
                    string3 = string3 + string2;
                } else {
                    n = 999;
                }
                ++n;
            }
        }
        DvConsole.output(string3);
        DvUtils.writetoTrace("DvConsole:showHelp exit");
    }

    public void execValidCommand(String string) {
        DvUtils.writetoTrace("DvConsole:execValidCommand entry (" + string + ")");
        ValidCmd validCmd = new ValidCmd(string);
        this.execCmd(validCmd);
        DvUtils.writetoTrace("DvConsole:execValidCommand exit");
    }

    private static ValidCmd validate(String string) {
        ValidCmd validCmd = new ValidCmd(string);
        return validCmd;
    }

    private static void output(String string) {
        if (useOutputVector) {
            if (outputVector == null || string == null) {
                String string2 = "***ERROR*** Either output vector or object does not exist!\n" + string;
                DvUtils.output(string2);
            } else {
                outputVector.add(string);
            }
        } else {
            DvUtils.output(string);
        }
    }

    public void execCmd(ValidCmd validCmd) {
        block23: {
            block22: {
                boolean bl = false;
                if (!validCmd.isNonPlugin) break block22;
                switch (validCmd.mainVerbOne) {
                    case '!': {
                        if (null != currentCP) {
                            currentCP.setForcedEnd(true);
                        }
                        break block23;
                    }
                    case '+': {
                        this.doPlusMinus(true);
                        break block23;
                    }
                    case '-': {
                        this.doPlusMinus(false);
                        break block23;
                    }
                    case '*': {
                        DvConsole.output(validCmd.savedCmd);
                        break block23;
                    }
                    case 'Q': {
                        System.exit(0);
                        break block23;
                    }
                    case 'E': {
                        this.execExecuteCmd(validCmd.modifier);
                        break block23;
                    }
                    default: {
                        if (null != currentCP && DvConsole.currentCP.cpInProgress) {
                            this.doSingleOutput("\n Unable to execute " + validCmd.savedCmd + "\n .. last command still in progress\n");
                            return;
                        }
                        break block23;
                    }
                }
            }
            if (null != currentCP && DvConsole.currentCP.cpInProgress) {
                this.doSingleOutput("\n Unable to execute " + validCmd.savedCmd + "\n .. last command still in progress\n");
                return;
            }
            Class clazz = null;
            Method method = null;
            CommandPlugin commandPlugin = (CommandPlugin)commandPlugins.get(validCmd.pluginID);
            try {
                clazz = commandPlugin.getClass();
                method = clazz.getMethod(validCmd.method, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!runningUnderGUI) {
                    this.doSingleOutput("\n ***** Error *****\n Expected method (" + validCmd.method + ") not found in " + clazz.getName() + "\n ***** Error *****\n");
                }
                return;
            }
            try {
                currentCP = (CommandPlugin)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                System.err.println(" InstantiationException");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(" IllegalAccessException");
            }
            currentCP.setMethod(method);
            currentCP.setVerb(validCmd.mainVerb);
            currentCP.setParamString(validCmd.params);
            if (null != validCmd.enhancersString) {
                currentCP.setEnhancers(validCmd.enhancersString);
            }
            currentCP.setVerbModifier(validCmd.modifier);
            currentCP.setSeperator(validCmd.seperator);
            currentCP.setForcedEnd(false);
            currentCP.setTheDump(theDump);
            if (!runningUnderGUI) {
                currentCP.addObserverToResponse(this);
            } else {
                currentCP.addObserverToResponse(theGUI);
            }
            try {
                currentCP.start();
            }
            catch (Exception exception) {
                System.err.println("\n!!! Exception !!!");
            }
        }
    }

    private boolean execExecuteCmd(String string) {
        boolean bl = false;
        String string2 = null;
        BufferedReader bufferedReader = null;
        int n = 0;
        string = string.trim();
        DvConsole.output("Will try and execute " + string + "!");
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            DvConsole.output("File " + string + " not found");
        }
        if (null != bufferedReader) {
            boolean bl2 = false;
            while (!bl2) {
                try {
                    string2 = bufferedReader.readLine();
                    string2 = this.preProcessInput(string2);
                    DvConsole.output("\n Execute(" + string + ":" + ++n + "): " + string2 + "\n");
                    if (null == string2) {
                        bl2 = true;
                        continue;
                    }
                    ValidCmd validCmd = DvConsole.validate(string2);
                    if (validCmd.errorPos == 0) {
                        this.execCmd(validCmd);
                        while (DvConsole.currentCP.cpInProgress) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    System.err.println("Error pos is" + validCmd.errorPos);
                    String string3 = "Invalid Command - possible reasons:";
                    string3 = string3 + "\n An expected plugin was not found";
                    string3 = string3 + "\n .... what else ?????";
                    System.err.println(string3);
                }
                catch (IOException iOException) {
                    bl2 = true;
                }
            }
        }
        return bl;
    }

    public static String[] execValidCmdToArray(String string) {
        String[] stringArray = that.doExecValidCmdToArray(string);
        return stringArray;
    }

    private String[] doExecValidCmdToArray(String string) {
        outputVector = new Vector();
        useOutputVector = true;
        Class clazz = null;
        Method method = null;
        ValidCmd validCmd = new ValidCmd(string);
        CommandPlugin commandPlugin = (CommandPlugin)commandPlugins.get(validCmd.pluginID);
        try {
            clazz = commandPlugin.getClass();
            method = clazz.getMethod(validCmd.method, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("***** Error *****\nExpected method " + validCmd.method + " not found in " + clazz.getName() + "\n" + "***** Error *****\n");
            String[] stringArray = new String[]{"***ERROR***"};
            return stringArray;
        }
        try {
            childCP = (CommandPlugin)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            System.err.println(" InstantiationException");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(" IllegalAccessException");
        }
        childCP.setMethod(method);
        childCP.setVerb(validCmd.mainVerb);
        childCP.setParamString(validCmd.params);
        if (null != validCmd.enhancersString) {
            childCP.setEnhancers(validCmd.enhancersString);
        }
        childCP.setVerbModifier(validCmd.modifier);
        childCP.setSeperator(validCmd.seperator);
        childCP.setForcedEnd(false);
        childCP.setTheDump(theDump);
        childCP.addObserverToResponse(this);
        try {
            childCP.start();
        }
        catch (Exception exception) {
            System.err.println("\n!!! Exception !!!");
        }
        while (childCP.getInProgress()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("\nInterruptedException");
            }
        }
        useOutputVector = false;
        String[] stringArray = new String[outputVector.size() + 1];
        Enumeration enumeration = outputVector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        outputVector = null;
        return stringArray;
    }

    public void update(Observable observable, Object object) {
        DvUtils.writetoTrace("Entry DvConsole:output");
        Observable observable2 = observable;
        synchronized (observable2) {
            this.doSingleOutput(object);
        }
        DvUtils.writetoTrace("Exit DvConsole:output");
    }

    private void doSingleOutput(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = 0;
            while (n < vector.size()) {
                this.doSingleOutput(vector.get(n));
                ++n;
            }
        } else if (object instanceof Array) {
            Array array = (Array)object;
            int n = 0;
            while (n < Array.getLength(array)) {
                this.doSingleOutput(Array.get(array, n));
                ++n;
            }
        } else if (object instanceof String) {
            String string = (String)object;
            DvConsole.output(string);
        } else if (null != object) {
            DvConsole.output(object.toString());
        } else {
            DvConsole.output(" --- null --- ");
        }
    }

    private void doPlusMinus(boolean bl) {
        if (null != lastMemCommandPosition) {
            long l = DvUtils.hexToLong(lastMemCommandPosition);
            l = bl ? (l += (long)lastMemCommandLength) : (l -= (long)lastMemCommandLength);
            String string = "dis mem(" + Long.toHexString(l) + "," + lastMemCommandLength + ")";
            this.doSingleOutput(string);
            ValidCmd validCmd = DvConsole.validate(string);
            this.execCmd(validCmd);
        } else {
            this.doSingleOutput("\n No previous dis mem command found\n");
        }
    }

    private String preProcessInput(String string) {
        int n;
        String string2 = " ";
        String string3 = new String(string);
        string3 = " " + string3 + " ";
        boolean bl = false;
        boolean bl2 = false;
        while (!bl2) {
            n = string3.length();
            int n2 = 0;
            boolean bl3 = false;
            n2 = n;
            while (n2 > 0 && !bl3) {
                if (string3.charAt(n2 - 1) == '$') {
                    boolean bl4 = false;
                    int n3 = 0;
                    n3 = n2;
                    while (n3 < n && !bl4) {
                        char c = string3.charAt(n3);
                        if (c == ' ' || c == ',' || c == '(' || c == ')' || c == '=' || c == '^') {
                            bl4 = true;
                        }
                        ++n3;
                    }
                    if (n3 == n2) {
                        DvUtils.writetoTrace(" Invalid command format (command substitution)");
                        bl2 = true;
                        bl = true;
                        bl3 = true;
                    } else {
                        String string4 = string3.substring(n2, n3 - 1);
                        String string5 = DvUtils.getValue(string4);
                        if (null == string5) {
                            bl2 = true;
                            bl = true;
                            bl3 = true;
                        } else {
                            String string6 = string3.substring(0, n2 - 1);
                            String string7 = string3.substring(n2 + string4.length());
                            string3 = string6 + "^" + string5 + string7;
                        }
                        bl3 = true;
                    }
                }
                --n2;
            }
            if (n2 != 0) continue;
            bl2 = true;
        }
        if (bl) {
            return string;
        }
        n = 0;
        while (n < string3.length()) {
            if (string3.charAt(n) != '^') {
                string2 = string2 + string3.charAt(n);
            }
            ++n;
        }
        string2 = string2.trim();
        return string2;
    }

    public static Vector getCommandPluginVector() {
        return commandPlugins;
    }

    public static CommandPlugin getCurrentCP() {
        return currentCP;
    }

    public static DvDump getCurrentDump() {
        return theDump;
    }

    public static int getCurrentAsIndex() {
        return currASIndex;
    }

    public static int getCurrentProcessIndex() {
        return currProcessIndex;
    }

    public static int getCurrentThreadIndex() {
        return currThreadIndex;
    }

    public static void setLastDisMem(String string, int n) {
        lastMemCommandPosition = string;
        lastMemCommandLength = n;
    }

    public static PrintStream getOriginal_output() {
        return original_output;
    }

    public static PrintStream getOriginal_error() {
        return original_error;
    }

    static {
        cmdList = new Vector();
        commandPlugins = new Vector();
        fastPath = new Vector();
        currDump = null;
        myHelpProps = null;
        currASIndex = 0;
        currProcessIndex = 0;
        currThreadIndex = 0;
        currentClassSpecs = new Vector();
        currentCBSpecs = new Vector();
        currWidth = 80;
        currOffset = (char)78;
        echoOn = false;
        ipDump = false;
        ipInput = false;
        ipOutput = false;
        runningUnderGUI = false;
        theGUI = null;
        outputVector = null;
        useOutputVector = false;
        that = null;
    }

    static class ValidCmd {
        public int errorPos = 1;
        public String mainVerb;
        public int pluginID = -1;
        public boolean isNonPlugin = false;
        public String seperator = null;
        public String savedCmd;
        public char mainVerbOne;
        public String restOfInput = null;
        public String params = null;
        public String modifier = null;
        public String method = null;
        public String enhancersString = null;

        public ValidCmd(String string) {
            this.savedCmd = string.trim();
            String string2 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(this.savedCmd);
            try {
                string2 = stringTokenizer.nextToken();
                this.mainVerb = string2.toUpperCase();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.mainVerb = null;
            }
            if (this.mainVerb != null) {
                int n;
                this.mainVerbOne = this.mainVerb.charAt(0);
                this.seperator = null;
                if (stringTokenizer.hasMoreTokens()) {
                    this.restOfInput = string.substring(this.mainVerb.length()).trim();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(this.restOfInput, "=( ");
                    this.modifier = stringTokenizer2.nextToken();
                    this.modifier = this.modifier.trim();
                    this.restOfInput = this.restOfInput.substring(this.modifier.length()).trim();
                    this.seperator = " ";
                    if (this.restOfInput.startsWith("=")) {
                        this.seperator = "=";
                        this.restOfInput = this.restOfInput.substring(1);
                    }
                    if (this.restOfInput.startsWith("(")) {
                        this.seperator = "(";
                        this.restOfInput = this.restOfInput.substring(1);
                    }
                    if (stringTokenizer2.hasMoreTokens()) {
                        this.params = this.restOfInput;
                        if (this.seperator.equals("(")) {
                            if (this.params.endsWith(")")) {
                                this.params = this.params.substring(0, this.params.length() - 1);
                            } else {
                                n = this.params.indexOf(41);
                                if (-1 == n) {
                                    this.errorPos = this.params.length() + this.mainVerb.length() + this.modifier.length() + 2;
                                    return;
                                }
                                this.enhancersString = this.params.substring(n + 1);
                                this.params = this.params.substring(0, n);
                            }
                        }
                    }
                }
                switch (this.mainVerbOne) {
                    case '!': {
                        this.isNonPlugin = true;
                        this.errorPos = 0;
                        break;
                    }
                    case '+': 
                    case '-': {
                        this.isNonPlugin = true;
                        this.errorPos = 0;
                        break;
                    }
                    case '*': {
                        this.isNonPlugin = true;
                        this.errorPos = 0;
                        break;
                    }
                    case 'Q': {
                        if (!this.mainVerb.equals("Q") && !this.mainVerb.equals("QUIT")) break;
                        this.isNonPlugin = true;
                        this.errorPos = 0;
                        break;
                    }
                    case 'E': {
                        if (!this.mainVerb.equals("E") && !this.mainVerb.equals("EXEC") && !this.mainVerb.equals("EXECUTE")) break;
                        this.isNonPlugin = true;
                        this.errorPos = 0;
                        break;
                    }
                    default: {
                        this.errorPos = 1;
                    }
                }
                if (0 != this.errorPos) {
                    this.isNonPlugin = false;
                    boolean bl = false;
                    n = 0;
                    int n2 = -1;
                    DvCommand dvCommand = null;
                    int n3 = 0;
                    while (n3 < cmdList.size() && n2 == -1) {
                        dvCommand = (DvCommand)cmdList.get(n3);
                        if (this.mainVerb.equals(dvCommand.verb) || this.mainVerb.equals(dvCommand.verbShort)) {
                            bl = true;
                            if (this.modifier == null && dvCommand.modifier == null || this.modifier != null && this.modifier.toUpperCase().equals(dvCommand.modifier) || this.modifier != null && this.modifier.toUpperCase().equals(dvCommand.modifierShort)) {
                                n2 = dvCommand.index;
                                this.pluginID = dvCommand.index;
                                this.method = dvCommand.method;
                                this.errorPos = 0;
                                n = 1;
                            }
                        }
                        ++n3;
                    }
                    int n4 = 0;
                    while (n4 < cmdList.size() && n2 == -1) {
                        dvCommand = (DvCommand)cmdList.get(n4);
                        if (this.mainVerb.equals(dvCommand.verb) || this.mainVerb.equals(dvCommand.verbShort)) {
                            bl = true;
                            if (this.modifier == null && dvCommand.modifier == null || this.modifier != null && this.modifier.toUpperCase().equals(dvCommand.modifier) || this.modifier != null && this.modifier.toUpperCase().equals(dvCommand.modifierShort) || null != dvCommand.modifier && dvCommand.modifier.equals("*")) {
                                n2 = dvCommand.index;
                                this.pluginID = dvCommand.index;
                                this.method = dvCommand.method;
                                this.errorPos = 0;
                                n = 1;
                            }
                        }
                        ++n4;
                    }
                    if (bl) {
                        if (0 == n && null != this.modifier) {
                            this.errorPos = this.savedCmd.indexOf(this.modifier.trim()) + 1;
                        }
                    } else {
                        this.errorPos = 1;
                    }
                }
            }
        }
    }

    public class DvCommand {
        String verb = null;
        String verbShort = null;
        String modifier = null;
        String modifierShort = null;
        String method = null;
        int index;

        public DvCommand(String string, int n) {
            this.index = n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (5 != stringTokenizer.countTokens()) {
                System.err.println("!!!Bad command definition!!!");
            } else {
                this.verb = stringTokenizer.nextToken().toUpperCase();
                this.verbShort = stringTokenizer.nextToken().toUpperCase();
                this.modifier = stringTokenizer.nextToken().toUpperCase();
                if (this.modifier.equals(" ")) {
                    this.modifier = null;
                }
                this.modifierShort = stringTokenizer.nextToken().toUpperCase();
                if (this.modifierShort.equals(" ")) {
                    this.modifierShort = null;
                }
                this.method = stringTokenizer.nextToken();
            }
        }
    }
}

