/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.ClassDetails;
import com.ibm.jvm.dump.format.DVExitListener;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvClassDetailsDisplay;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvConstants;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvFileHistory;
import com.ibm.jvm.dump.format.DvFindInMemory;
import com.ibm.jvm.dump.format.DvFormatAs;
import com.ibm.jvm.dump.format.DvMemRanges;
import com.ibm.jvm.dump.format.DvMemoryFind;
import com.ibm.jvm.dump.format.DvMemoryScroller;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.Dvifm;
import com.ibm.jvm.dump.format.DvifmFrame;
import com.ibm.jvm.dump.format.SwingWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class Dumpviewer
extends JFrame
implements Observer,
DvFileHistory.IFileHistory {
    static boolean waitingOnConsoleCommand = false;
    static Object savedConsoleOutput = null;
    static boolean Trace_is_on = true;
    public static Dvifm theIFM;
    static JDesktopPane desktop;
    static JCheckBoxMenuItem mbiTc;
    static JCheckBoxMenuItem wm;
    static DVExitListener exitListener;
    public static JInternalFrame wm_frame;
    static JTree wm_tree;
    static JInternalFrame tc_frame;
    static JInternalFrame status_frame;
    static JInternalFrame message_frame;
    static String theFileName;
    static JMenuBar mainmenubar;
    static JMenu mbFile;
    static JMenu mbMemory;
    static JMenu mbWindows;
    static JMenu mbEdit;
    static JMenu mbSubmenu;
    static JMenu mbFormat;
    static JMenu mbClasses;
    static JMenu mbObjects;
    static JLabel status;
    static JInternalFrame mMapDisplayed;
    static Vector consoleInitOutput;
    static boolean is32BitDump;
    static boolean is64BitDump;
    static boolean isBigEndDump;
    static boolean isLittleEndDump;
    static int currentAS;
    static DvConsole dvConsole;
    static Dumpviewer selfRef;
    static JTree classTree;
    static JInternalFrame classSummaryJif;
    String[] dumpPlugins;
    static DvDump theDump;
    static boolean file_chosen;
    static DvMemoryFind dvMemoryFind;
    private DvFileHistory fileHistory;

    public Dumpviewer() {
        super("Dumpviewer");
        String string = DvUtils.getDvProperty("Version");
        this.setTitle(string);
        selfRef = this;
        String string2 = DvUtils.getDvProperty("ConsoleTrace");
        if (null != string2 && string2.equals("Y")) {
            DvUtils.enableConsoleTrace(true);
        }
        String string3 = DvUtils.getDvProperty("EarlyTrace");
        DvComponentListener dvComponentListener = new DvComponentListener();
        this.addComponentListener(dvComponentListener);
        desktop = new JDesktopPane();
        this.setupDesk(desktop);
        desktop.putClientProperty("JDesktopPane.dragMode", "outline");
        this.setContentPane(desktop);
        this.fileHistory = new DvFileHistory(this);
        this.fileHistory.initFileMenuHistory();
        exitListener = new DVExitListener(this.fileHistory);
        this.addWindowListener(exitListener);
        dvConsole = new DvConsole(true, this, consoleInitOutput);
        theIFM = new Dvifm();
        dvMemoryFind = new DvMemoryFind();
        theIFM.addPluginMenuItem(dvConsole);
        DvUtils.setTheIFM(theIFM);
        if (null != string3 && string3.equals("Y")) {
            mbiTc.setSelected(true);
        }
        DvUtils.writetoTrace("DeskTop height/width is " + selfRef.getHeight() + "/" + selfRef.getWidth());
        this.addStatusLine();
        wm.setSelected(true);
        status.setText("Awaiting user input....");
    }

    private void addStatusLine() {
        status_frame = theIFM.createNewFrame("Status Line", 0, 4);
        Dumpviewer.addIFrameToDesktop(status_frame, 30, this.getWidth() - 10, 0, this.getHeight() - 80);
        status = new JLabel("Initializing....");
        status_frame.setBackground(Color.lightGray);
        status_frame.setBorder(BorderFactory.createLoweredBevelBorder());
        status_frame.getContentPane().add("West", status);
    }

    public static void main(String[] stringArray) {
        Dumpviewer dumpviewer = new Dumpviewer();
        dumpviewer.setVisible(true);
        if (null != consoleInitOutput) {
            message_frame = theIFM.createNewFrame("Message", theIFM.getDefaultProperties() - 2, 0);
            Dumpviewer.addIFrameToDesktop(message_frame, 200, 400, 5, selfRef.getHeight() - 330);
            JTextArea jTextArea = new JTextArea("", 8, 25);
            jTextArea.setEditable(false);
            theIFM.addContentToFrame(message_frame, jTextArea);
            String string = "";
            int n = 0;
            while (n < consoleInitOutput.size()) {
                string = string + (String)consoleInitOutput.get(n);
                string = string + "\n";
                ++n;
            }
            jTextArea.setText(string);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("\nInterruptedException");
            }
            try {
                message_frame.setIcon(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public JInternalFrame setupASIDframe() {
        JInternalFrame jInternalFrame = theIFM.createNewFrame("Asid-Process-Threads", theIFM.getDefaultProperties() - 2, 0);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 120, this.getWidth() - 10, 0, 0);
        JTable jTable = Dumpviewer.fillASIDtable(jInternalFrame);
        waitingOnConsoleCommand = true;
        String string = "DIS SYS";
        DvUtils.writetoTrace("Issuing command: " + string);
        dvConsole.execValidCommand(string);
        while (waitingOnConsoleCommand) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("\nInterruptedException");
            }
        }
        DvUtils.writetoTrace(string + " has returned");
        Vector vector = (Vector)savedConsoleOutput;
        String string2 = "";
        int n = 0;
        while (n < vector.size()) {
            string2 = string2 + vector.get(n) + "\n";
            ++n;
        }
        theIFM.addContentToFrame(jInternalFrame, jTable, string2);
        JMenuItem jMenuItem = new JMenuItem("Test");
        theIFM.addPopupMenuItemToFrame(jInternalFrame, jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Test1");
        theIFM.addPopupMenuItemToFrame(jInternalFrame, jMenuItem2);
        return jInternalFrame;
    }

    public static void setupWMFrame() {
        DvUtils.writetoTrace("setting up Window Manager");
        wm_frame = theIFM.createNewFrame("Window Manager", theIFM.getDefaultProperties() - 2 - 8, 3);
        Dumpviewer.addIFrameToDesktop(wm_frame, 200, 200, selfRef.getWidth() - 210, selfRef.getHeight() - 280);
        wm_tree = Dumpviewer.fillWMTree(wm_frame);
        theIFM.addContentToFrame(wm_frame, wm_tree);
    }

    public static JInternalFrame setupFormatFrame(String string, String string2) {
        DvUtils.writetoTrace("setting up Format Frame " + string2);
        JInternalFrame jInternalFrame = theIFM.createNewFrame(string2, theIFM.getDefaultProperties(), 0);
        Dumpviewer.addIFrameToDesktop(jInternalFrame);
        JTree jTree = Dumpviewer.fillFormatTree(string);
        theIFM.addContentToFrame(jInternalFrame, jTree);
        FormatMouseListener formatMouseListener = new FormatMouseListener();
        formatMouseListener.whatIframe = jInternalFrame;
        formatMouseListener.whatJTree = jTree;
        jTree.addMouseListener(formatMouseListener);
        return jInternalFrame;
    }

    public static void setupTraceFrame() {
        tc_frame = theIFM.createNewFrame("Trace Console", theIFM.getDefaultProperties() - 2, 2);
        Dumpviewer.addIFrameToDesktop(tc_frame, 200, 400, 5, selfRef.getHeight() - 280);
        JTextArea jTextArea = new JTextArea("", 8, 25);
        jTextArea.setEditable(false);
        theIFM.addContentToFrame(tc_frame, jTextArea);
        Calendar calendar = Calendar.getInstance();
        DvUtils.setTc_text(jTextArea);
        DvUtils.enableConsoleTrace(true);
        DvUtils.writetoTrace("Trace Console started at " + calendar.getTime().toString());
    }

    public static JTree fillWMTree(JInternalFrame jInternalFrame) {
        Serializable serializable;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Windows");
        boolean bl = false;
        int n = -1;
        int n2 = 0;
        Enumeration enumeration = theIFM.getIFrameElements();
        while (enumeration.hasMoreElements()) {
            serializable = new DefaultMutableTreeNode(((DvifmFrame)enumeration.nextElement()).iframeTitle);
            defaultMutableTreeNode.insert((MutableTreeNode)((Object)serializable), n2);
            ++n2;
        }
        serializable = new JTree(defaultMutableTreeNode);
        ((JTree)serializable).getSelectionModel().setSelectionMode(1);
        Icon icon = null;
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(icon);
        defaultTreeCellRenderer.setClosedIcon(icon);
        defaultTreeCellRenderer.setOpenIcon(icon);
        ((JTree)serializable).setCellRenderer(defaultTreeCellRenderer);
        WMMouseListener wMMouseListener = new WMMouseListener();
        wMMouseListener.whatIframe = jInternalFrame;
        ((Component)serializable).addMouseListener(wMMouseListener);
        return serializable;
    }

    public static JTree fillFormatTree(String string) {
        String string2 = "";
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            vector2.add(stringTokenizer.nextToken());
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode((String)vector2.get(0));
        vector.add(defaultMutableTreeNode);
        boolean bl = true;
        int n = -1;
        boolean bl2 = false;
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        int n2 = 1;
        while (n2 < vector2.size()) {
            int n3 = 0;
            string2 = (String)vector2.get(n2);
            int n4 = 0;
            while (n4 < string2.length()) {
                if (' ' != string2.charAt(n4)) {
                    int n5 = n4 / 2;
                    if (n5 != n3) {
                        defaultMutableTreeNode2 = (DefaultMutableTreeNode)vector.get(n5 - 1);
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(string2);
                    if (vector.size() <= n5) {
                        vector.add(defaultMutableTreeNode3);
                    } else {
                        vector.set(n5, defaultMutableTreeNode3);
                    }
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    n3 = n5;
                    n4 = string2.length();
                }
                ++n4;
            }
            ++n2;
        }
        JTree jTree = new JTree(defaultMutableTreeNode);
        jTree.getSelectionModel().setSelectionMode(1);
        Icon icon = null;
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(icon);
        defaultTreeCellRenderer.setClosedIcon(icon);
        defaultTreeCellRenderer.setOpenIcon(icon);
        jTree.setCellRenderer(defaultTreeCellRenderer);
        return jTree;
    }

    public static JTable fillASIDtable(JInternalFrame jInternalFrame) {
        String[] stringArray = new String[]{"ASID", "Process", "# Threads"};
        JTable jTable = null;
        int n = 0;
        DvAddressSpace[] dvAddressSpaceArray = theDump.getAddressSpaces();
        if (null == dvAddressSpaceArray[0]) {
            System.err.println("\nAs_array[0] is null!!!!");
        }
        dvAddressSpaceArray[0].getMemRanges();
        int n2 = dvAddressSpaceArray.length;
        DvProcess[] dvProcessArray = null;
        int n3 = 0;
        while (n3 < n2) {
            dvProcessArray = dvAddressSpaceArray[n3].getProcesses();
            n += dvProcessArray.length;
            ++n3;
        }
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        long[] lArray3 = new long[n];
        long l = 0L;
        while (l < (long)n2) {
            long l2 = 0L;
            l2 = Long.valueOf(dvAddressSpaceArray[(int)l].id());
            dvProcessArray = dvAddressSpaceArray[(int)l].getProcesses();
            long l3 = dvProcessArray.length;
            long l4 = 0L;
            while (l4 < l3) {
                lArray[(int)(l + l4)] = l2;
                lArray2[(int)(l + l4)] = Long.valueOf(dvProcessArray[(int)l4].id());
                int n4 = dvProcessArray[(int)l4].getThreads().length;
                lArray3[(int)(l + l4)] = n4;
                ++l4;
            }
            ++l;
        }
        AsidTableModel asidTableModel = new AsidTableModel(lArray, lArray2, lArray3, n, stringArray);
        jTable = new JTable(asidTableModel);
        jTable.setAutoResizeMode(0);
        return jTable;
    }

    public static void addIFrameToDesktop(JInternalFrame jInternalFrame) {
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 300, 300, 10, 10);
    }

    public static void addIFrameToDesktop(JInternalFrame jInternalFrame, int n, int n2, int n3, int n4) {
        DvUtils.writetoTrace("Adding frame to desktop h:" + n + " w:" + n2 + " x: " + n3 + " y: " + n4);
        jInternalFrame.setVisible(true);
        jInternalFrame.setLocation(n3, n4);
        jInternalFrame.setSize(n2, n);
        jInternalFrame.setBackground(Color.white);
        desktop.add(jInternalFrame);
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setupStatusLine(JDesktopPane jDesktopPane) {
        status = new JLabel("Status Line");
        status.setBorder(BorderFactory.createLoweredBevelBorder());
        status.setVisible(true);
        jDesktopPane.add((Component)status, "South");
    }

    public void setupDesk(JDesktopPane jDesktopPane) {
        this.setupMenuBar(jDesktopPane);
        mbMemory.setEnabled(false);
        mbFormat.setEnabled(false);
        mbEdit.setEnabled(false);
        mbClasses.setEnabled(false);
        mbObjects.setEnabled(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension((int)(dimension.getWidth() - 40.0), (int)(dimension.getHeight() - 40.0));
        this.setBounds(50, 50, (int)(dimension.getWidth() - 100.0), (int)(dimension.getHeight() - 100.0));
    }

    public void setupMenuBar(JDesktopPane jDesktopPane) {
        mbObjects = new JMenu("Objects");
        mbFormat = new JMenu("Format");
        mbClasses = new JMenu("Classes");
        mbClasses.setMnemonic(67);
        mbFile = new JMenu("File");
        mbFile.setMnemonic(70);
        mbEdit = new JMenu("Edit");
        mbEdit.setMnemonic(69);
        mbWindows = new JMenu("Windows");
        mbWindows.setMnemonic(87);
        mbMemory = new JMenu("Memory");
        mbMemory.setMnemonic(77);
        JMenuItem jMenuItem = new JMenuItem("Map");
        JMenuItem jMenuItem2 = new JMenuItem("Display");
        JMenuItem jMenuItem3 = new JMenuItem("Find");
        mbMemory.add(jMenuItem);
        mbMemory.add(jMenuItem2);
        mbMemory.add(jMenuItem3);
        GenericMMBActionListener genericMMBActionListener = new GenericMMBActionListener();
        genericMMBActionListener.setOwner("mmap");
        jMenuItem.addActionListener(genericMMBActionListener);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Dumpviewer.findInMemory();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Dumpviewer.displayMemory();
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem("Format .. as ..");
        mbFormat.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Execenv (current thread)");
        JMenuItem jMenuItem6 = new JMenuItem("JVM");
        mbFormat.add(jMenuItem4);
        mbFormat.add(jMenuItem5);
        mbFormat.add(jMenuItem6);
        GenericMMBActionListener genericMMBActionListener2 = new GenericMMBActionListener();
        genericMMBActionListener2.setOwner("format");
        jMenuItem6.addActionListener(genericMMBActionListener2);
        jMenuItem4.addActionListener(genericMMBActionListener2);
        jMenuItem5.addActionListener(genericMMBActionListener2);
        JMenuItem jMenuItem7 = new JMenuItem("Open");
        jMenuItem7.setMnemonic(79);
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        GenericMMBActionListener genericMMBActionListener3 = new GenericMMBActionListener();
        genericMMBActionListener3.setOwner("open");
        jMenuItem7.addActionListener(genericMMBActionListener3);
        mbFile.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Quit");
        jMenuItem8.setMnemonic(81);
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                exitListener.doTerminationCode();
            }
        });
        mbFile.add(jMenuItem8);
        wm = new JCheckBoxMenuItem("Window Manager");
        mbWindows.add(wm);
        JMenuItem jMenuItem9 = new JMenuItem("Class Summary (tree)");
        mbClasses.add(jMenuItem9);
        GenericMMBActionListener genericMMBActionListener4 = new GenericMMBActionListener();
        genericMMBActionListener4.setOwner("classes");
        jMenuItem9.addActionListener(genericMMBActionListener4);
        mbiTc = new JCheckBoxMenuItem("Trace Console");
        mbWindows.add(mbiTc);
        CheckBoxListener checkBoxListener = new CheckBoxListener();
        mbiTc.addItemListener(checkBoxListener);
        wm.addItemListener(checkBoxListener);
        mainmenubar = new JMenuBar();
        mainmenubar.add(mbFile);
        mainmenubar.add(mbEdit);
        mainmenubar.add(mbWindows);
        mainmenubar.add(mbMemory);
        mainmenubar.add(mbFormat);
        mainmenubar.add(mbClasses);
        mainmenubar.add(mbObjects);
        this.setJMenuBar(mainmenubar);
    }

    private static void displayClassSummary() {
        Dvifm dvifm = DvUtils.getTheIFM();
        classSummaryJif = dvifm.createNewFrame("Class Summary", dvifm.getDefaultProperties(), 6);
        Dumpviewer.addIFrameToDesktop(classSummaryJif, 325, 470, 300, 75);
        SwingWorker swingWorker = new SwingWorker(){
            boolean resultFound = false;

            public Object construct() {
                Object var1_1 = null;
                classTree = Dumpviewer.getCSResults();
                if (classTree == null) {
                    System.out.println("!!!! ClassTree is null!!!!");
                }
                return var1_1;
            }

            public void finished() {
                Dvifm dvifm = DvUtils.getTheIFM();
                dvifm.addContentToFrame(classSummaryJif, classTree);
                FormatMouseListener formatMouseListener = new FormatMouseListener();
                formatMouseListener.whatIframe = classSummaryJif;
                formatMouseListener.whatJTree = classTree;
                classTree.addMouseListener(formatMouseListener);
                DvUtils.writetoTrace("Finished in displayClassSummary swing worker");
            }
        };
        swingWorker.start();
    }

    private static JTree getCSResults() {
        String string = "";
        boolean bl = false;
        classTree = null;
        DvUtils.writetoTrace("GetCSResults entry");
        waitingOnConsoleCommand = true;
        dvConsole.execValidCommand("dis cls");
        while (waitingOnConsoleCommand) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("\nInterruptedException");
            }
        }
        if (savedConsoleOutput instanceof Vector) {
            Vector vector = new Vector();
            Vector vector2 = (Vector)savedConsoleOutput;
            int n = 0;
            while (n < vector2.size()) {
                Object object = vector2.get(n);
                if (!(object instanceof String) && object instanceof ClassDetails) {
                    vector.add(((ClassDetails)object).name);
                }
                ++n;
            }
            int n2 = vector.size();
            Object[] objectArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                objectArray[n3] = (String)vector.get(n3);
                ++n3;
            }
            Arrays.sort(objectArray);
            classTree = Dumpviewer.fillNamesTree((String[])objectArray);
        } else {
            System.out.println("summats gone awry");
        }
        DvUtils.writetoTrace("GetCSResults exit");
        return classTree;
    }

    private static JTree fillNamesTree(String[] stringArray) {
        Serializable serializable;
        String string;
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode;
        Serializable serializable2 = defaultMutableTreeNode = new DefaultMutableTreeNode("Classes");
        String string2 = "";
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = new StringTokenizer(stringArray[n2], "/");
            string = ((StringTokenizer)object).nextToken();
            if (!string.startsWith("[")) {
                if (string.equals(string2)) {
                    serializable = new DefaultMutableTreeNode(stringArray[n2]);
                    serializable2.add((MutableTreeNode)((Object)serializable));
                } else {
                    serializable = new DefaultMutableTreeNode(string);
                    serializable2 = defaultMutableTreeNode;
                    serializable2.add((MutableTreeNode)((Object)serializable));
                    string2 = new String(string);
                    serializable2 = serializable;
                }
            }
            ++n2;
        }
        object = new JTree(defaultMutableTreeNode);
        ((JTree)object).getSelectionModel().setSelectionMode(1);
        string = null;
        serializable = new DefaultTreeCellRenderer();
        serializable.setLeafIcon((Icon)((Object)string));
        serializable.setClosedIcon((Icon)((Object)string));
        serializable.setOpenIcon((Icon)((Object)string));
        ((JTree)object).setCellRenderer((TreeCellRenderer)((Object)serializable));
        return object;
    }

    private static void displayMemoryMap() {
        if (null == mMapDisplayed) {
            mMapDisplayed = theIFM.createNewFrame("Memory Mapping", theIFM.getDefaultProperties(), 5);
            Dumpviewer.addIFrameToDesktop(mMapDisplayed, 300, 250, 100, 100);
        }
        DvMemRanges[] dvMemRangesArray = theDump.getAddressSpaces()[0].getMemRanges();
        String[] stringArray = new String[]{"Start Address", "End Address  ", "Length   "};
        JTable jTable = null;
        int n = dvMemRangesArray.length;
        String[] stringArray2 = new String[n];
        String[] stringArray3 = new String[n];
        long[] lArray = new long[n];
        DvAddress dvAddress = null;
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = dvMemRangesArray[n2].addressStart().convertToHex();
            lArray[n2] = dvMemRangesArray[n2].length();
            dvAddress = new DvAddress(dvMemRangesArray[n2].addressStart().getAddressAsLong() + lArray[n2]);
            stringArray3[n2] = dvAddress.convertToHex();
            ++n2;
        }
        MmapTableModel mmapTableModel = new MmapTableModel(stringArray2, stringArray3, lArray, n, stringArray);
        jTable = new JTable(mmapTableModel);
        jTable.setAutoResizeMode(0);
        theIFM.addContentToFrame(mMapDisplayed, jTable);
        MmapMouseListener mmapMouseListener = new MmapMouseListener();
        mmapMouseListener.setOwner(mMapDisplayed);
        jTable.addMouseListener(mmapMouseListener);
    }

    private boolean doOpenFile() {
        boolean bl = false;
        DvUtils.writetoTrace("Dumpviewer: doOpenFile entry");
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return true;
            }

            public String getDescription() {
                return "*.*";
            }
        });
        int n = jFileChooser.showOpenDialog(desktop);
        if (n == 0 && null != (theDump = DvUtils.findDumpPlugin(theFileName = jFileChooser.getSelectedFile().getPath()))) {
            Vector vector = new Vector();
            if (DvConsole.setTheDump(theDump, vector, theFileName)) {
                this.fileHistory.insertPathname(theFileName);
                mbMemory.setEnabled(true);
                mbFormat.setEnabled(true);
                mbWindows.setEnabled(true);
                mbEdit.setEnabled(true);
                mbObjects.setEnabled(true);
                mbClasses.setEnabled(true);
                file_chosen = true;
                bl = true;
            } else {
                bl = false;
            }
            if (0 != vector.size()) {
                int n2 = 0;
                while (n2 < vector.size()) {
                    DvUtils.writetoTrace((String)vector.get(n2));
                    ++n2;
                }
            }
        }
        DvUtils.writetoTrace("Dumpviewer: doOpenFile exit - " + (bl ? "true" : "false"));
        return bl;
    }

    public static String convertArchitecture(int n) {
        int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};
        int n2 = n;
        boolean bl = false;
        String string = "";
        if (n2 < 32768) {
            int n3 = nArray.length - 1;
            while (n3 > -1) {
                if (n2 >= nArray[n3]) {
                    try {
                        string = string + DvConstants.ARCH_DESCRIPTIONS[n3];
                        bl = true;
                        if (nArray[n3] == 1) {
                            is32BitDump = true;
                        }
                        if (nArray[n3] == 2) {
                            is64BitDump = true;
                        }
                        if (nArray[n3] == 4) {
                            isBigEndDump = true;
                        }
                        if (nArray[n3] == 8) {
                            isLittleEndDump = true;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    n2 -= nArray[n3];
                }
                --n3;
            }
        }
        if (bl) {
            return string;
        }
        return "Architecture unknown";
    }

    public static void displayMemory() {
        JInternalFrame jInternalFrame = theIFM.createNewFrame("Memory Scroller ????????", theIFM.getDefaultProperties(), 6);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 400, 500, 250, 50);
        DvUtils.setTheIFM(theIFM);
        DvMemoryScroller dvMemoryScroller = new DvMemoryScroller(jInternalFrame, dvConsole);
    }

    public static void displayMemory(DvAddress dvAddress, long l) {
        JInternalFrame jInternalFrame = theIFM.createNewFrame("Memory Scroller " + dvAddress.convertToHex(), theIFM.getDefaultProperties(), 6);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 400, 500, 250, 50);
        DvUtils.setTheIFM(theIFM);
        DvMemoryScroller dvMemoryScroller = new DvMemoryScroller(jInternalFrame, dvConsole, dvAddress, l);
    }

    public static void findInMemory() {
        JInternalFrame jInternalFrame = theIFM.createNewFrame("Memory Find", theIFM.getDefaultProperties(), 6);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 270, 320, 350, 200);
        DvUtils.setTheIFM(theIFM);
        DvFindInMemory dvFindInMemory = new DvFindInMemory(jInternalFrame, dvConsole, dvMemoryFind);
    }

    public void update(Observable observable, Object object) {
        Observable observable2 = observable;
        synchronized (observable2) {
            waitingOnConsoleCommand = false;
            savedConsoleOutput = object;
        }
    }

    public String getApplicationName() {
        return "DUMPVIEWER";
    }

    public JMenu getFileMenu() {
        return mainmenubar.getMenu(0);
    }

    public void loadFile(String string) {
        boolean bl = false;
        theDump = DvUtils.findDumpPlugin(string);
        if (null != theDump) {
            Vector vector = new Vector();
            if (DvConsole.setTheDump(theDump, vector, string)) {
                bl = true;
            }
            if (0 != vector.size()) {
                int n = 0;
                while (n < vector.size()) {
                    DvUtils.writetoTrace((String)vector.get(n));
                    ++n;
                }
            }
            if (bl) {
                mbMemory.setEnabled(true);
                mbWindows.setEnabled(true);
                mbFormat.setEnabled(true);
                mbEdit.setEnabled(true);
                mbClasses.setEnabled(true);
                mbObjects.setEnabled(true);
                file_chosen = true;
                DvUtils.writetoTrace("Dumpviewer: loadFile success - " + string);
                this.showASIDFrame();
            }
        }
        if (!bl) {
            DvUtils.writetoTrace("Dumpviewer: loadFile failure - " + string);
        }
    }

    private void formatAs() {
        JInternalFrame jInternalFrame = theIFM.createNewFrame("Format As input", theIFM.getDefaultProperties(), 6);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 270, 320, 350, 200);
        DvUtils.setTheIFM(theIFM);
        DvFormatAs dvFormatAs = new DvFormatAs(jInternalFrame, dvConsole, "");
    }

    private void formatJVM() {
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(theDump, "A");
        if (null != dvAddressSpace) {
            String string = "Error Format of JVM failed\n";
            String string2 = DvUtils.getJVMHint(dvAddressSpace, "JVM");
            if (null != string2) {
                long l = Long.parseLong(string2, 16);
                DvAddress dvAddress = dvAddressSpace.createAddress(l);
                String string3 = "Format jvm @0x" + Long.toHexString(l);
                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                    CTypeObject cTypeObject = Dumpviewer.formatGeneric(dvAddress, "Jvm", dvAddressSpace);
                    if (null != cTypeObject) {
                        DvUtils.writetoTrace("  ... CTypeObject obtained");
                        string = cTypeObject.toString();
                    } else {
                        DvUtils.writetoTrace(" Format of jvm failed!!!!");
                    }
                    JInternalFrame jInternalFrame = Dumpviewer.setupFormatFrame(string, string3);
                } else {
                    DvUtils.writetoTrace(" Address " + Long.toHexString(l) + " is not available in the dump");
                }
            } else {
                DvUtils.writetoTrace(" Unable to comply - no hint found for JVM");
            }
        } else {
            DvUtils.writetoTrace(" formatExecEnv:No valid address space found");
        }
    }

    private void formatExecEnv() {
        DvThread dvThread = (DvThread)DvUtils.getAPT(theDump, "T");
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(theDump, "A");
        if (null != dvAddressSpace && null != dvThread) {
            long l = dvThread.eeAddress().getAddressAsLong();
            DvAddress dvAddress = dvAddressSpace.createAddress(l);
            String string = "Format execenv @0x" + Long.toHexString(l);
            if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                String string2 = "Error Format of execenv failed\n";
                CTypeObject cTypeObject = Dumpviewer.formatGeneric(dvAddress, "execenv", dvAddressSpace);
                if (null != cTypeObject) {
                    DvUtils.writetoTrace("  ... CTypeObject obtained");
                    string2 = cTypeObject.toString();
                } else {
                    DvUtils.writetoTrace(" Format of execenv failed!!!!");
                }
                JInternalFrame jInternalFrame = Dumpviewer.setupFormatFrame(string2, string);
            } else {
                DvUtils.writetoTrace(" Address " + dvThread.eeAddress().convertToHex() + " is not available in the dump");
            }
        } else {
            DvUtils.writetoTrace(" formatExecEnv:No valid address space/thread found");
        }
    }

    public static CTypeObject formatGeneric(DvAddress dvAddress, String string, DvAddressSpace dvAddressSpace) {
        CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, string);
        return cTypeObject;
    }

    private void showASIDFrame() {
        String string = "unknown";
        String string2 = "unknown";
        String string3 = "unknown";
        boolean bl = false;
        String string4 = "unknown";
        String string5 = "unknown";
        status.setText("Dump format identified as....");
        JInternalFrame jInternalFrame = this.setupASIDframe();
        int n = theDump.getArchitecture();
        if (-1 == n) {
            status.setText("Unknown bitness");
        } else {
            status.setText("arch= " + Dumpviewer.convertArchitecture(n));
            if (is32BitDump) {
                string = "32-Bit";
            } else if (is64BitDump) {
                string = "64-Bit";
            }
            if (isBigEndDump) {
                string2 = "Big Endian";
            } else if (isLittleEndDump) {
                string2 = "Little Endian";
            }
        }
    }

    static {
        wm_frame = null;
        status_frame = null;
        message_frame = null;
        mMapDisplayed = null;
        consoleInitOutput = new Vector();
        is32BitDump = false;
        is64BitDump = false;
        isBigEndDump = false;
        isLittleEndDump = false;
        currentAS = 0;
        classTree = null;
        classSummaryJif = null;
        file_chosen = false;
    }

    static class MmapMouseListener
    implements MouseListener {
        private JInternalFrame whatIframe;

        MmapMouseListener() {
        }

        public void setOwner(JInternalFrame jInternalFrame) {
            this.whatIframe = jInternalFrame;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            JTable jTable;
            int n2 = mouseEvent.getClickCount();
            DvUtils.writetoTrace("Mouse click in the Memory Manager - count " + n2);
            if ((mouseEvent.getModifiers() & 4) == 4) {
                DvUtils.writetoTrace("its the right mouse button");
            } else if (n2 > 1 && null != (jTable = theIFM.findTable(this.whatIframe)) && -1 != (n = jTable.getSelectedRow())) {
                DvAddressSpace[] dvAddressSpaceArray = theDump.getAddressSpaces();
                DvAddress dvAddress = dvAddressSpaceArray[currentAS].getMemRanges()[n].addressStart();
                long l = dvAddressSpaceArray[currentAS].getMemRanges()[n].length();
                Dumpviewer.displayMemory(dvAddress, l);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    static class FormatMouseListener
    implements MouseListener {
        private JInternalFrame whatIframe;
        private JTree whatJTree;

        FormatMouseListener() {
        }

        public void setOwner(JInternalFrame jInternalFrame) {
            this.whatIframe = jInternalFrame;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            boolean bl = false;
            int n = mouseEvent.getClickCount();
            DvUtils.writetoTrace("Mouse click in Format Mouse Listener - count " + n);
            DvUtils.writetoTrace(" Window title is - " + this.whatIframe.getTitle());
            if (this.whatIframe.getTitle().equals("Class Summary")) {
                bl = true;
            }
            if ((mouseEvent.getModifiers() & 4) == 4) {
                DvUtils.writetoTrace(" .... its the right mouse button");
                if (n > 1) {
                    DvUtils.writetoTrace(" .... and a double click");
                    int n2 = this.whatJTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n2 != -1) {
                        this.whatJTree.setSelectionRow(n2);
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.whatJTree.getLastSelectedPathComponent();
                        Object object = defaultMutableTreeNode.getUserObject();
                        String string = object.toString();
                        if (!bl) {
                            int n3 = string.toUpperCase().indexOf("0X");
                            if (-1 != n3) {
                                String string2 = string.substring(n3 + 2);
                                try {
                                    long l = Long.parseLong(string2, 16);
                                    JInternalFrame jInternalFrame = theIFM.createNewFrame("Format As input", theIFM.getDefaultProperties(), 6);
                                    Dumpviewer.addIFrameToDesktop(jInternalFrame, 270, 320, 350, 200);
                                    DvUtils.setTheIFM(theIFM);
                                    DvFormatAs dvFormatAs = new DvFormatAs(jInternalFrame, dvConsole, string2);
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                        } else {
                            DvUtils.writetoTrace("Will launch new window for " + string);
                            JInternalFrame jInternalFrame = theIFM.createNewFrame(string + " details", theIFM.getDefaultProperties(), 6);
                            Dumpviewer.addIFrameToDesktop(jInternalFrame, 400, 420, 250, 150);
                            DvUtils.setTheIFM(theIFM);
                            DvClassDetailsDisplay dvClassDetailsDisplay = new DvClassDetailsDisplay(jInternalFrame, dvConsole, string);
                        }
                    }
                } else {
                    DvUtils.writetoTrace(" .... just a single click");
                }
            } else {
                DvUtils.writetoTrace(" .... its the left mouse button");
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    static class WMMouseListener
    implements MouseListener {
        private JInternalFrame whatIframe;

        WMMouseListener() {
        }

        public void setOwner(JInternalFrame jInternalFrame) {
            this.whatIframe = jInternalFrame;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getClickCount();
            DvUtils.writetoTrace("Mouse click in the Window Manager - count " + n);
            if (n > 1) {
                try {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)theIFM.findTree(this.whatIframe).getLastSelectedPathComponent();
                    if (defaultMutableTreeNode != null) {
                        Object object = defaultMutableTreeNode.getUserObject();
                        DvifmFrame dvifmFrame = theIFM.findDvifmFrame((String)object);
                        theIFM.setIFrameSelected(dvifmFrame.iframe);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    class GenericMMBActionListener
    implements ActionListener {
        String whatcmd = null;

        GenericMMBActionListener() {
        }

        public void setOwner(String string) {
            this.whatcmd = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DvUtils.writetoTrace("Menu bar action detected");
            DvUtils.writetoTrace("  ...." + this.whatcmd);
            if (this.whatcmd.equals("open")) {
                status.setText("Identifying Dump...");
                boolean bl = Dumpviewer.this.doOpenFile();
                if (bl) {
                    Dumpviewer.this.showASIDFrame();
                } else {
                    DvUtils.writetoTrace("!!!!!!!!\nDump format not recognised\n!!!!!!!!");
                    status.setText("Dump format not recognised");
                }
                return;
            }
            if (this.whatcmd.equals("classes")) {
                status.setText("Displaying Memory Map...");
                if (actionEvent.getSource() instanceof JMenuItem) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    String string = jMenuItem.getActionCommand();
                    DvUtils.writetoTrace(" .... \"" + string + "\"");
                    if (string.startsWith("Display")) {
                        // empty if block
                    }
                    if (string.startsWith("Class")) {
                        Dumpviewer.displayClassSummary();
                    }
                }
                return;
            }
            if (this.whatcmd.equals("mmap")) {
                status.setText("Displaying Memory Map...");
                Dumpviewer.displayMemoryMap();
                return;
            }
            if (this.whatcmd.equals("format")) {
                status.setText("Displaying format ...");
                if (actionEvent.getSource() instanceof JMenuItem) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    String string = jMenuItem.getActionCommand();
                    DvUtils.writetoTrace(" .... \"" + string + "\"");
                    if (string.startsWith("Exec")) {
                        Dumpviewer.this.formatExecEnv();
                    }
                    if (string.startsWith("JVM")) {
                        Dumpviewer.this.formatJVM();
                    }
                    if (-1 != string.indexOf("as")) {
                        Dumpviewer.this.formatAs();
                    }
                }
                return;
            }
        }
    }

    class DvComponentListener
    implements ComponentListener {
        DvComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (null != status_frame) {
                status_frame.reshape(0, Dumpviewer.this.getHeight() - 80, Dumpviewer.this.getWidth() - 10, 30);
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    static class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable;
            boolean bl = true;
            if (itemEvent.getStateChange() == 2) {
                bl = false;
            }
            if ((itemSelectable = itemEvent.getItemSelectable()) == mbiTc) {
                if (!bl) {
                    Calendar calendar = Calendar.getInstance();
                    DvUtils.writetoTrace("Trace Console stopped at " + calendar.getTime().toString());
                    theIFM.removeIFrame(tc_frame, true);
                    DvUtils.enableConsoleTrace(false);
                } else {
                    Dumpviewer.setupTraceFrame();
                }
            } else if (itemSelectable == wm) {
                if (!bl) {
                    theIFM.removeIFrame(wm_frame, true);
                } else {
                    Dumpviewer.setupWMFrame();
                }
            }
        }
    }

    static class MmapTableModel
    extends AbstractTableModel {
        boolean valsgiven = false;
        String[] col1_vals;
        String[] col2_vals;
        long[] col3_vals;
        String[] columnNames = new String[]{"C1", "C2", "C3", "C4", "C5", "C6"};
        int nRows;
        int nColumns;

        public int getColumnCount() {
            return this.nColumns;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return this.nRows;
        }

        public Object getValueAt(int n, int n2) {
            if (!this.valsgiven) {
                return new Integer(0);
            }
            if (n2 == 0) {
                return new String(this.col1_vals[n]);
            }
            if (n2 == 1) {
                return new String(this.col2_vals[n]);
            }
            if (n2 == 2) {
                return new Long(this.col3_vals[n]);
            }
            return new Long(999L);
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public MmapTableModel(int n, int n2, String[] stringArray) {
            this.nRows = n;
            this.nColumns = n2;
            try {
                this.columnNames[0] = stringArray[0];
                this.columnNames[1] = stringArray[1];
                this.columnNames[2] = stringArray[2];
                this.columnNames[3] = stringArray[3];
                this.columnNames[4] = stringArray[4];
                this.columnNames[5] = stringArray[5];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }

        public MmapTableModel(String[] stringArray, String[] stringArray2, long[] lArray, int n, String[] stringArray3) {
            this.valsgiven = true;
            this.nRows = n;
            this.nColumns = stringArray3.length;
            this.col1_vals = stringArray;
            this.col2_vals = stringArray2;
            this.col3_vals = lArray;
            try {
                this.columnNames[0] = stringArray3[0];
                this.columnNames[1] = stringArray3[1];
                this.columnNames[2] = stringArray3[2];
                this.columnNames[3] = stringArray3[3];
                this.columnNames[4] = stringArray3[4];
                this.columnNames[5] = stringArray3[5];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    static class AsidTableModel
    extends AbstractTableModel {
        boolean valsgiven = false;
        long[] col1_vals;
        long[] col2_vals;
        long[] col3_vals;
        String[] columnNames = new String[]{"C1", "C2", "C3", "C4", "C5", "C6"};
        int nRows;
        int nColumns;

        public int getColumnCount() {
            return this.nColumns;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return this.nRows;
        }

        public Object getValueAt(int n, int n2) {
            if (!this.valsgiven) {
                return new Integer(0);
            }
            if (n2 == 0) {
                return new Long(this.col1_vals[n]);
            }
            if (n2 == 1) {
                return new Long(this.col2_vals[n]);
            }
            if (n2 == 2) {
                return new Long(this.col3_vals[n]);
            }
            return new Long(0L);
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public AsidTableModel(int n, int n2, String[] stringArray) {
            this.nRows = n;
            this.nColumns = n2;
            try {
                this.columnNames[0] = stringArray[0];
                this.columnNames[1] = stringArray[1];
                this.columnNames[2] = stringArray[2];
                this.columnNames[3] = stringArray[3];
                this.columnNames[4] = stringArray[4];
                this.columnNames[5] = stringArray[5];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }

        public AsidTableModel(long[] lArray, long[] lArray2, long[] lArray3, int n, String[] stringArray) {
            this.valsgiven = true;
            this.nRows = n;
            this.nColumns = stringArray.length;
            this.col1_vals = lArray;
            this.col2_vals = lArray2;
            this.col3_vals = lArray3;
            try {
                this.columnNames[0] = stringArray[0];
                this.columnNames[1] = stringArray[1];
                this.columnNames[2] = stringArray[2];
                this.columnNames[3] = stringArray[3];
                this.columnNames[4] = stringArray[4];
                this.columnNames[5] = stringArray[5];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }
}

