/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.Extract;
import com.ibm.jvm.dump.format.DvUtils;
import java.io.RandomAccessFile;

public class Main {
    static int trace = 0;
    RandomAccessFile file = null;
    private static String coreName;
    private static String sdffName;
    private static String exeName;
    private static boolean headerOnly;

    private static void help() {
        System.out.println("Usage: jextract [options] [-o outFilename] [-f executablePathName] coreFilename");
        System.out.println("where options include:");
        System.out.println("\t-verbose:  enable verbose output");
        System.out.println("\t-? -help   print this help message");
        System.out.println("\t-Xt[level]  set trace level");
        System.out.println("\t-Xheader   generate only SDFF header");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        String string;
        int n = 0;
        if (stringArray.length > 0) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (!stringArray[n2].startsWith("-")) {
                    if (coreName == null) {
                        coreName = stringArray[n2];
                    } else {
                        Main.help();
                    }
                } else if (stringArray[n2].startsWith("-o")) {
                    if (n2 == stringArray.length - 1 || stringArray[n2 + 1].startsWith("-")) {
                        Main.help();
                    }
                    sdffName = stringArray[n2 + 1];
                    ++n2;
                } else if (stringArray[n2].startsWith("-f")) {
                    if (n2 == stringArray.length - 1 || stringArray[n2 + 1].startsWith("-")) {
                        Main.help();
                    }
                    exeName = stringArray[n2 + 1];
                    ++n2;
                } else if (stringArray[n2].startsWith("-verbose")) {
                    if (n < 1) {
                        n = 1;
                    }
                    DvUtils.setVerbose(true);
                } else if (stringArray[n2].startsWith("-Xt")) {
                    string = stringArray[n2].substring(stringArray[n2].length() - 1);
                    try {
                        n = Integer.parseInt(string.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Can't understand " + string);
                        Main.help();
                    }
                    if (n < 0 || n > 3) {
                        System.err.println("Invalid trace level");
                        Main.help();
                    }
                } else if (stringArray[n2].startsWith("-Xheader")) {
                    headerOnly = true;
                } else {
                    System.err.println("Invalid option " + stringArray[n2]);
                    Main.help();
                }
                ++n2;
            }
        }
        if (coreName == null) {
            System.err.println("Core file not specified");
            Main.help();
        }
        if (sdffName == null) {
            sdffName = "sdff";
            String string2 = System.getProperty("file.separator");
            string = coreName;
            if (coreName.lastIndexOf(string2) > 0) {
                sdffName = coreName.substring(0, coreName.lastIndexOf(string2) + 1) + "sdff";
                string = coreName.substring(coreName.lastIndexOf(string2) + 1, coreName.length());
            }
            if (string.indexOf(46) >= 0) {
                sdffName = sdffName + string.substring(string.indexOf(46), string.length());
            }
        }
        if (n > 0) {
            DvUtils.trace("trace level set to " + n, 0, true);
        }
        new Extract(n, coreName, sdffName, exeName, headerOnly);
    }

    static {
        headerOnly = false;
    }
}

