/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.iiop;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.jvm.classloader.TransientAllocation;
import com.ibm.rmi.util.Utility;
import java.util.Arrays;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;

public class ObjectKey
implements TransientAllocation {
    private byte[] objectKey;
    public static final int INVALID_SERVER_ID = -1;
    private static final int JMBI_VERSION = 74;
    private static final int KMBI_VERSION = 75;
    private static final int XMBI_MAGIC = 5063241;
    private static final String MBI_MAGIC_SUFFIX = "MBI";
    private static final int IBM_MAGIC_OFFSET = 0;
    private static final int IBM_SCID_OFFSET = 4;
    private static final int IBM_SERVERID_OFFSET = 8;
    private static final int IBM_USERKEYOFFSET_OFFSET = 12;
    private static final int IBM_USERKEYLEN_SIZE = 2;
    private static final int JMBI_SERVERUUID_SIZE = 16;
    private static final int JMBI_SERVERUUID_OFFSET = 12;
    private static final int JMBI_USERKEYOFFSET_OFFSET = 28;
    private static final int JMBI_USERKEYLEN_OFFSET = 32;
    private static final int IBM_OBJECTKEY_SIZE = 16;
    private static final int IBM_USERKEY_OFFSET = 14;
    private static final int JMBI_OBJECTKEY_SIZE = 36;
    private static final int JMBI_USERKEY_OFFSET = 36;
    private String stringOfKey = null;
    private int hash = 0;

    public ObjectKey(byte[] byArray) {
        this.objectKey = byArray;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, this, "<init>:238", this.toString());
        }
    }

    public ObjectKey(int n, int n2, int n3, byte[] byArray) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4132L, (Object)this, "<init>:263", (Object)("magic=0x" + Integer.toHexString(n) + ",subcontractId=0x" + Integer.toHexString(n2) + ",serverId=0x" + Integer.toHexString(n3)));
        }
        int n4 = n >>> 24;
        switch (n4) {
            case 74: {
                this.objectKey = new byte[36 + byArray.length];
                break;
            }
            default: {
                this.objectKey = new byte[16 + byArray.length];
            }
        }
        Utility.intToBytes(n, this.objectKey, 0);
        Utility.intToBytes(n2, this.objectKey, 4);
        Utility.intToBytes(n3, this.objectKey, 8);
        switch (n4) {
            case 74: {
                Utility.intToBytes(36, this.objectKey, 28);
                Utility.intToBytes(byArray.length, this.objectKey, 32);
                System.arraycopy(byArray, 0, this.objectKey, 36, byArray.length);
                break;
            }
            default: {
                Utility.shortToBytes((short)14, this.objectKey, 12);
                Utility.shortToBytes((short)byArray.length, this.objectKey, 14);
                System.arraycopy(byArray, 0, this.objectKey, 16, byArray.length);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4132L, this, "<init>:316", (Object)this.toString());
        }
    }

    public int getMagic() {
        int n = this.getMagic0();
        if (n != 0) {
            return n;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, (Object)this, "getMagic:337", "Malformed objectKey - error extracting magic.", (Object)this.toString());
        }
        throw new INV_OBJREF("Malformed objectKey - error extracting magic.", 1229125523, CompletionStatus.COMPLETED_MAYBE);
    }

    private int getMagic0() {
        if (this.objectKey.length >= 4) {
            return Utility.bytesToInt(this.objectKey, 0);
        }
        return 0;
    }

    public boolean isMBI() {
        return ObjectKey.isMBI(this.getMagic0());
    }

    public static boolean isMBI(int n) {
        return (n & 0xFFFFFF) == 5063241;
    }

    public static boolean isMBI(String string) {
        return string.length() >= 4 && string.regionMatches(1, MBI_MAGIC_SUFFIX, 0, 3);
    }

    public int getVersion() {
        return this.getMagic0() >>> 24;
    }

    public int getSCID() {
        if (this.isMBI() && this.objectKey.length >= 8) {
            return Utility.bytesToInt(this.objectKey, 4);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, (Object)this, "getSCID:416", "Malformed objectKey - error getting SCID.", (Object)this.toString());
        }
        throw new INV_OBJREF("Malformed objectKey - error getting SCID.", 1229125524, CompletionStatus.COMPLETED_MAYBE);
    }

    public void setSCID(int n) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "setSCID:438", (Object)("subcontractId=0x" + Integer.toHexString(n)));
        }
        if (!this.isMBI() || this.objectKey.length < 8) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, (Object)this, "setSCID:449", "Malformed objectKey - error setting SCID.", (Object)this.toString());
            }
            throw new INV_OBJREF("Malformed objectKey - error setting SCID.", 1229125524, CompletionStatus.COMPLETED_MAYBE);
        }
        Utility.intToBytes(n, this.objectKey, 4);
        this.stringOfKey = null;
        this.hash = 0;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "setSCID:460", (Object)this.toString());
        }
    }

    public int getServerId() {
        if (this.objectKey.length >= 12) {
            return Utility.bytesToInt(this.objectKey, 8);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, (Object)this, "getServerId:481", "Malformed objectKey - error getting ServerId.", (Object)this.toString());
        }
        return -1;
    }

    public void setServerId(int n) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "setServerId:501", (Object)("serverId=0x" + Integer.toHexString(n)));
        }
        if (!this.isMBI() || this.objectKey.length < 12) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, (Object)this, "setServerId:512", "Malformed objectKey - error setting ServerId.", (Object)this.toString());
            }
            throw new INV_OBJREF("Malformed objectKey - error setting ServerId.", 1229125525, CompletionStatus.COMPLETED_MAYBE);
        }
        Utility.intToBytes(n, this.objectKey, 8);
        this.stringOfKey = null;
        this.hash = 0;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "setServerId:524", (Object)this.toString());
        }
    }

    public byte[] getServerUUID() {
        if (this.getVersion() == 74) {
            if (this.objectKey.length >= 28) {
                byte[] byArray = new byte[16];
                System.arraycopy(this.objectKey, 12, byArray, 0, 16);
                return byArray;
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, (Object)this, "getServerUUID:552", "Malformed objectKey - error extracting ServerUUID.", (Object)this.toString());
            }
            throw new INV_OBJREF("Malformed objectKey - error extracting ServerUUID.", 1229125526, CompletionStatus.COMPLETED_MAYBE);
        }
        return null;
    }

    public void setServerUUID(byte[] byArray) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "setServerUUID:583");
        }
        switch (this.getVersion()) {
            case 74: {
                if (byArray != null) {
                    if (byArray.length == 16) {
                        System.arraycopy(byArray, 0, this.objectKey, 12, 16);
                        this.stringOfKey = null;
                        this.hash = 0;
                        break;
                    }
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8208L, (Object)this, "setServerUUID:600", "Malformed ServerUUID - invalid length = " + byArray.length, (Object)this.toString());
                    }
                    throw new BAD_PARAM("Invalid length ServerUUID specified", 1229124135, CompletionStatus.COMPLETED_MAYBE);
                }
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(8208L, (Object)this, "setServerUUID:614", "Malformed ServerUUID - serverUUID of null specified ", (Object)this.toString());
                }
                throw new BAD_PARAM("NULL ServerUUID specified", 1229124136, CompletionStatus.COMPLETED_MAYBE);
            }
            default: {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(8208L, (Object)this, "setServerUUID:629", "Malformed objectkey - Attempt to set a ServerUUID on a key type of " + this.getVersion(), (Object)this.toString());
                }
                throw new INV_OBJREF("ServerUUID specified for non-JMBI ObjectKey", 1229125527, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "setServerUUID:640", (Object)this.toString());
        }
    }

    public byte[] getUserKey() {
        byte[] byArray = null;
        if (!this.isMBI()) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, (Object)this, "getUserKey:665", "Malformed objectkey - Attempt to get a UserKey from a key type of " + this.getVersion(), (Object)this.toString());
            }
            throw new INV_OBJREF("Attempt to get user key from non-IBM objectKey", 1229125523, CompletionStatus.COMPLETED_MAYBE);
        }
        try {
            switch (this.getVersion()) {
                case 74: {
                    int n = Utility.bytesToInt(this.objectKey, 32);
                    if (n > 0) {
                        byArray = new byte[n];
                        int n2 = Utility.bytesToInt(this.objectKey, 28);
                        System.arraycopy(this.objectKey, n2, byArray, 0, n);
                    }
                    break;
                }
                default: {
                    short s = Utility.bytesToShort(this.objectKey, 12);
                    short s2 = Utility.bytesToShort(this.objectKey, s);
                    if (s2 > 0) {
                        byArray = new byte[s2];
                        System.arraycopy(this.objectKey, s + 2, byArray, 0, s2);
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, this, "getUserKey:710", exception.toString());
            }
            byArray = null;
        }
        return byArray;
    }

    public void setUserKey(byte[] byArray) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "setUserKey:737");
        }
        if (!this.isMBI()) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, (Object)this, "setUserKey:744", "Malformed objectkey - Attempt to set a UserKey in a key type of " + this.getVersion(), (Object)this.toString());
            }
            throw new INV_OBJREF("Attempt to set user key in non-IBM objectKey", 1229125523, CompletionStatus.COMPLETED_MAYBE);
        }
        switch (this.getVersion()) {
            case 74: {
                int n = Utility.bytesToInt(this.objectKey, 28);
                byte[] byArray2 = new byte[n];
                System.arraycopy(this.objectKey, 0, byArray2, 0, n);
                this.objectKey = new byte[n + byArray.length];
                System.arraycopy(byArray2, 0, this.objectKey, 0, n);
                Utility.intToBytes(byArray.length, this.objectKey, n - 4);
                System.arraycopy(byArray, 0, this.objectKey, n, byArray.length);
                break;
            }
            default: {
                short s = Utility.bytesToShort(this.objectKey, 12);
                byte[] byArray3 = new byte[s];
                System.arraycopy(this.objectKey, 0, byArray3, 0, s);
                this.objectKey = new byte[s + 2 + byArray.length];
                System.arraycopy(byArray3, 0, this.objectKey, 0, s);
                Utility.shortToBytes((short)byArray.length, this.objectKey, s);
                System.arraycopy(byArray, 0, this.objectKey, s + 2, byArray.length);
            }
        }
        this.stringOfKey = null;
        this.hash = 0;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "setUserKey:784", (Object)this.toString());
        }
    }

    public byte[] getObjectKey() {
        return this.objectKey;
    }

    public String toString() {
        if (this.stringOfKey == null) {
            this.stringOfKey = "0x" + Utility.bytesToHexString(this.objectKey);
        }
        return this.stringOfKey;
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            int n2 = 0;
            while (n2 < this.objectKey.length) {
                n = 31 * n + this.objectKey[n2];
                ++n2;
            }
            this.hash = n;
        }
        return n;
    }

    public boolean equals(Object object) {
        return Arrays.equals(this.objectKey, ((ObjectKey)object).getObjectKey());
    }
}

