/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.iiop;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.util.Utility;
import java.util.ArrayList;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextPackage.InvalidName;

public final class INSUtil {
    public static final String corbanamePrefix = "corbaname:";
    public static final String corbalocPrefix = "corbaloc:";
    public static final int defaultPort = 2809;
    private static final String className = "INSUtil";
    private static final String ncFieldSeparator = ".";
    private static final String ncArraySeparator = "/";
    private static final String charsToEscape = "\\/.";
    private static final String RFC2396 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789;/:?@&=+$,-_.!~*'()";

    private INSUtil() {
    }

    public static String decode2936(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            if (c == '%') {
                int n2;
                if (n + 2 >= stringBuffer.length()) {
                    throw new BAD_PARAM("incomplete key_string escape sequence", 1330446346, CompletionStatus.COMPLETED_NO);
                }
                try {
                    n2 = Utility.hexOf(stringBuffer.charAt(n + 1)) * 16 + Utility.hexOf(stringBuffer.charAt(n + 2));
                }
                catch (DATA_CONVERSION dATA_CONVERSION) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8208L, className, "decode2936:122", dATA_CONVERSION.toString());
                    }
                    throw new BAD_PARAM("Bad hex digit", 1330446346, CompletionStatus.COMPLETED_NO);
                }
                stringBuffer.setCharAt(n, (char)n2);
                stringBuffer.delete(n + 1, n + 3);
            } else if (RFC2396.indexOf(c) == -1) {
                throw new BAD_PARAM("invalid key_string character '" + c + "'", 1330446346, CompletionStatus.COMPLETED_NO);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String encode2936(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            if (RFC2396.indexOf(c) == -1) {
                stringBuffer.setCharAt(n, '%');
                char[] cArray = Integer.toHexString(c).toCharArray();
                if (cArray.length == 2) {
                    stringBuffer.insert(n + 1, cArray);
                } else if (cArray.length == 1) {
                    stringBuffer.insert(n + 1, '0');
                    stringBuffer.insert(n + 2, cArray[0]);
                } else {
                    throw new BAD_PARAM("invalid character '" + c + "' in \"" + string + "\"", 1330446346, CompletionStatus.COMPLETED_NO);
                }
                n += 2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String unescapedStringOf(String string) throws InvalidName {
        if (string == null || string.length() == 0 || string.indexOf(92) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '\\') {
                if (n + 1 == stringBuffer.length()) {
                    throw new InvalidName();
                }
                if (charsToEscape.indexOf(stringBuffer.charAt(n + 1)) != -1) {
                    stringBuffer.deleteCharAt(n);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String escapedStringOf(String string) {
        if (string == null || string.length() == 0 || string.indexOf(47) == -1 && string.indexOf(92) == -1 && string.indexOf(46) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (charsToEscape.indexOf(stringBuffer.charAt(n)) != -1) {
                stringBuffer.insert(n, '\\');
                ++n;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static int firstOccurrence(String string, char c) {
        int n = string.indexOf(c);
        boolean bl = false;
        while (n != -1 && !bl) {
            bl = true;
            int n2 = n - 1;
            while (n2 >= 0 && string.charAt(n2) == '\\') {
                bl = !bl;
                --n2;
            }
            if (bl) continue;
            n = string.indexOf(c, n + 1);
        }
        return n;
    }

    public static String nameToString(NameComponent[] nameComponentArray) {
        if (nameComponentArray.length == 0) {
            return null;
        }
        String string = INSUtil.nameComponentToString(nameComponentArray[0]);
        int n = 1;
        while (n < nameComponentArray.length) {
            string = string + ncArraySeparator + INSUtil.nameComponentToString(nameComponentArray[n]);
            ++n;
        }
        return string;
    }

    private static String nameComponentToString(NameComponent nameComponent) {
        boolean bl;
        boolean bl2 = nameComponent.id != null && nameComponent.id.length() > 0;
        boolean bl3 = bl = nameComponent.kind != null && nameComponent.kind.length() > 0;
        if (!bl2 && !bl) {
            return ncFieldSeparator;
        }
        if (!bl) {
            return INSUtil.escapedStringOf(nameComponent.id);
        }
        if (!bl2) {
            return ncFieldSeparator + INSUtil.escapedStringOf(nameComponent.kind);
        }
        return INSUtil.escapedStringOf(nameComponent.id) + ncFieldSeparator + INSUtil.escapedStringOf(nameComponent.kind);
    }

    public static NameComponent[] stringToName(String string) throws InvalidName {
        ArrayList arrayList = new ArrayList();
        while (string.length() > 0) {
            int n = INSUtil.firstOccurrence(string, '/');
            if (n == -1) {
                arrayList.add(INSUtil.stringToNameComponent(string));
                string = "";
                continue;
            }
            arrayList.add(INSUtil.stringToNameComponent(string.substring(0, n)));
            string = string.substring(n + 1);
        }
        NameComponent[] nameComponentArray = new NameComponent[arrayList.size()];
        return (NameComponent[])arrayList.toArray(nameComponentArray);
    }

    private static NameComponent stringToNameComponent(String string) throws InvalidName {
        String string2;
        String string3;
        if (string == null || string.length() == 0) {
            throw new InvalidName();
        }
        int n = INSUtil.firstOccurrence(string, '.');
        if (n > 0 && n + 1 == string.length()) {
            throw new InvalidName();
        }
        if (n == -1) {
            string3 = new String(string);
            string2 = new String("");
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
            if (INSUtil.firstOccurrence(string2, '.') != -1) {
                throw new InvalidName();
            }
        }
        return new NameComponent(INSUtil.unescapedStringOf(string3), INSUtil.unescapedStringOf(string2));
    }

    public static String encodeCorbaname(String string, String string2) throws InvalidName, InvalidAddress {
        if (string == null || string.length() == 0) {
            throw new InvalidAddress();
        }
        String string3 = new String(corbanamePrefix);
        int n = string.indexOf(47);
        if (n == 0) {
            throw new InvalidAddress();
        }
        if (n == -1 || n + 1 == string.length()) {
            string3 = string3 + string;
        } else {
            try {
                string3 = string3 + string.substring(0, n + 1) + INSUtil.encode2936(string.substring(n + 1));
            }
            catch (BAD_PARAM bAD_PARAM) {
                ORBRas.orbTrcLogger.exception(4104L, className, "encodeCorbaname:416", (Exception)bAD_PARAM);
                throw new InvalidAddress();
            }
        }
        if (string2 != null && string2.length() != 0) {
            try {
                string3 = string3 + "#" + INSUtil.encode2936(string2);
            }
            catch (BAD_PARAM bAD_PARAM) {
                ORBRas.orbTrcLogger.exception(4104L, className, "encodeCorbaname:431", (Exception)bAD_PARAM);
                throw new InvalidName();
            }
        }
        return string3;
    }
}

