package com.ibm.extricity.adapters.mqseries.mqak;

/**
 * ProcessData.java 1.0 11/3/2000
 *
 * This class is used as a parameter class for maintaining Process Correlation
 * data for the Extricity MQAK Adapter functions
 *
 * OCO Source Materials
 *
 * 5799-RNK
 *
 * (C) Copyright IBM Corp. 2000
 *
 * The source code for this program is not published
 * or otherwise divested of its trade secrets,
 * irrespective of what has been deposited with the
 * U. S. Copyright Office.
 *
 * @author Thomas W. Jaworski
**/
public class ProcessData implements ProcessDataInt
{
   protected String Item1 = null;
   protected String Item1Name = "BOCorrelationID";
   protected String Item2Name = "TradingPartner";
   protected String Item2 = null;

/**
 * ProcessData constructor comment.
 */
protected ProcessData()
{
   super();
}

/**
 * ProcessData constructor comment.
 */
protected ProcessData(String item1,String item2)
{
   super();
   Item1 = item1;
   Item2 = item2;
}

/**
 * Insert the method's description here.
 * Creation date: (11/14/00 2:07:13 PM)
 * @param id java.lang.String
 */
public String getBOCorrelationID()
{
   return Item1;
}

/**
 * Insert the method's description here.
 * Creation date: (11/14/00 2:07:13 PM)
 * @param id java.lang.String
 */
public String getCommitContext()
{
   return Item2;
}

/**
 * Insert the method's description here.
 * Creation date: (11/14/00 2:07:13 PM)
 * @param id java.lang.String
 */
public String getMsgXML()
{
   return Item1;
}

/**
 * Insert the method's description here.
 * Creation date: (11/14/00 2:07:13 PM)
 * @param id java.lang.String
 */
public String getTradingPartner()
{
   return Item2;
}

/**
 * Insert the method's description here.
 * Creation date: (11/14/00 2:07:13 PM)
 * @param id java.lang.String
 */
public void setBOCorrelationID(String id)
{
   Item1 = id;
   Item1Name = "BOCorrelationID";
}

/**
 * Insert the method's description here.
 * Creation date: (11/14/00 2:07:13 PM)
 * @param id java.lang.String
 */
public void setCommitContext(String context)
{
   Item2 = context;
   Item2Name = "CommitContext";
}

/**
 * Insert the method's description here.
 * Creation date: (11/14/00 2:07:13 PM)
 * @param id java.lang.String
 */
public void setMsgXML(String xml)
{
   Item1 = xml;
   Item1Name = "MsgXML";
}

/**
 * Insert the method's description here.
 * Creation date: (11/14/00 2:07:13 PM)
 * @param id java.lang.String
 */
public void setTradingPartner(String id)
{
   Item2 = id;
   Item2Name = "TradingPartner";
}

/**
 * Insert the method's description here.
 * Creation date: (11/8/00 3:33:54 PM)
 * @return java.lang.String
 */
public String toString()
{
   return "{"+Item1Name+"="+Item1+","+Item2Name+"="+Item2+"}";
}
}
