package com.ibm.extricity.adapters.mqseries.mqak;

/**
 * MQNMRFH2FormatterExt.java 1.0        10/20/2000
 *
 * The MQNMRFH2FormatterExt is derived from <EM>MQNMRFH2Formatter</EM> class.
 * This class is used to extend the RFH2 Header Formater for use with Extricity
 *
 * OCO Source Materials
 *
 * 5799-RNK
 *
 * (C) Copyright IBM Corp. 2000
 *
 * The source code for this program is not published
 * or otherwise divested of its trade secrets,
 * irrespective of what has been deposited with the
 * U. S. Copyright Office.
 *
 * @author Thomas W. Jaworski
**/
import java.io.*;
import com.ibm.epic.adapters.eak.nativeadapter.*;
import com.ibm.epic.adapters.eak.common.*;
import com.ibm.logging.*;
import com.ibm.mq.*;
import com.ibm.epic.adapters.eak.mcs.*;

public class MQNMRFH2FormatterExt extends com.ibm.epic.adapters.eak.nativeadapter.MQNMRFH2Formatter
{

/**
 * This makes a MQMessage with the body data contained in an RFH2 header.
 *
 * @param epicMessageExt The input message to generate the MQMessage from
 *
 * @return The MQMessage to send using MQ.
 *
 * @see retrieveMessage
 *
 * @exception AdapterException thrown if the bodyData cannot be set into the message
 */
public MQMessage convertMessage( EpicMessage epicMessageOrg )
   throws AdapterException
{
   // Make sure we have the extended EpicMessage
   if(!(epicMessageOrg instanceof EpicMessageExt))
   {
          return super.convertMessage(epicMessageOrg);
   }

   EpicMessageExt epicMessage = (EpicMessageExt)epicMessageOrg;

   if (trace)
          traceClient.writeTrace(IRecordType.TYPE_ENTRY, CLASS_NAME,
                                                "convertMessage(EpicMessage)", "AQM5001",
                                                AdapterUtil.DEFAULTTRACEMSGFILE,
                                                new Object[]{"AQM5001"});
   MQMessage mqMessage = null;
   RFH2Header rfh;

   /* if trace is on then call the 1 arg constructor, so it will trace also */
   if (trace)
         rfh = new RFH2Header(getApplicationName());
   else
         rfh = new RFH2Header();

   String tmp = null;

   tmp = epicMessage.getSourceLogicalID();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("SourceLogicalID", tmp);

   tmp = epicMessage.getDestinationLogicalID();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("DestinationLogicalID", tmp);

   tmp = epicMessage.getMsgType();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("MessageType", tmp);

   tmp = epicMessage.getRespondToLogicalID();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("RespondToLogicalID", tmp);

   rfh.addUSRValue("TimeStampCreated",
          Long.toString(epicMessage.getTimeStamp()));

   rfh.addUSRValue("TimeStampExpired",
          Long.toString(epicMessage.getExpirationTimeStamp()));

   tmp = epicMessage.getTransactionID();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("TransactionID", tmp);

   tmp = epicMessage.getUniqueMsgID();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("UniqueID", tmp);

   tmp = epicMessage.getProcessingCategory();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("ProcessingCategory", tmp);

   tmp = epicMessage.getBodyCategory();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("BodyCategory", tmp);

   tmp = epicMessage.getBodyType();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("BodyType", tmp);

   tmp = epicMessage.getBodySecondaryType();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("BodySecondaryType", tmp);

   tmp = epicMessage.getAckRequested();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("AckRequested", tmp);

   //  Put all fields into the <usr> folder
   tmp = epicMessage.getUserArea();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("UserArea", tmp);

   tmp = epicMessage.getMsgHeaderVersion();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("MsgHeaderVersion", tmp);

   tmp = epicMessage.getCorrelationID();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("CorrelationID", tmp);

   tmp = epicMessage.getGroupStatus();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("GroupStatus", tmp);

   tmp = epicMessage.getQosPolicy();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("QOSPolicy", tmp);

   tmp = epicMessage.getDeliveryCategory();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("DeliveryCategory", tmp);

   tmp = epicMessage.getPublicationTopic();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("PublicationTopic", tmp);

   tmp = epicMessage.getSessionID();
   if(tmp != null && tmp.length() != 0)
          rfh.addUSRValue("SessionID", tmp);

   rfh.addUSRValue("EncryptionStatus",
          (new Boolean(epicMessage.getEncryptionStatus()).toString()));

   tmp = epicMessage.getBodyData();
   if(tmp != null && tmp.length() != 0)
          rfh.setData(tmp);

   boolean xmlflag = MQAOXMLIJ.isXML(epicMessage.getBodyData());
   if(xmlflag)
   {
          rfh.setMcd_msd("XML");
          rfh.setMcd_format("XML");
   }

   mqMessage = rfh.formatMQMessage_RFH2Header();

   rfh.close(); // @P1C

   if(epicMessage.getLMSMessageID() == epicMessage.LMS_MESSAGE_ID_NONE)
   {
          mqMessage.messageId = MQC.MQMI_NONE;
   }
   else
   {
          mqMessage.messageId = epicMessage.getByteArrLMSMessageID();
   }

   if(epicMessage.getCorrelationID() == epicMessage.LMS_CORELATION_ID_NONE)
   {
          mqMessage.correlationId = MQC.MQCI_NONE;
   }
   else
   {
          mqMessage.correlationId = epicMessage.getByteArrLMSCorrelationID();
   }

   if (trace)
          traceClient.writeTrace(IRecordType.TYPE_EXIT, CLASS_NAME,
                                                "convertMessage(EpicMessage)", "AQM5002",
                                                AdapterUtil.DEFAULTTRACEMSGFILE,
                                                new Object[]{"AQM5002"});
   return mqMessage;
}

/**
 * The method takes a received MQMessage and generates an EpicMessage from it.
 * The message must be in the correct format, as generated by <CODE>formatMessage</CODE>.
 *
 * @param mqMessage the raw message received from a remote adapter
 * @param addr This parameter is ignored since all header information is present in the MQMessage.
 *
 * @return The epic message generated from the received message
 *
 * @exception AdapterException thrown if the message data cannot be read or if
 * the message is not String format
 */
public EpicMessage convertMessage( MQMessage mqMessage, MQAOAddress addr )
          throws AdapterException {
   EpicMessageExt em = null;

   if (trace)
          traceClient.writeTrace(IRecordType.TYPE_ENTRY, CLASS_NAME,
                                                "convertMessage(MQMessage)", "AQM5001",
                                                AdapterUtil.DEFAULTTRACEMSGFILE,
                                                new Object[]{"AQM5001"});

   int msg_length = mqMessage.getTotalMessageLength();

   if (trace)
          traceClient.writeTrace(IRecordType.TYPE_INFO, CLASS_NAME,
                                                "convertMessage(MQMessage)", "AQM5003", AdapterUtil.DEFAULTTRACEMSGFILE,
                                                new Object[]{"AQM5003","message length", new Integer(msg_length)});

   if(msg_length < 1) return em;

   if (!mqMessage.format.equals(RFH2Header.MQFMT_RF_HEADER_2))
   {
          AdapterException ae = new AdapterException("AQM0114",
                 new Object[]{"AQM0114",
                                  (CLASS_NAME + "::convertMessage(MQMessage)"),
                                  RFH2Header.MQFMT_RF_HEADER_2,
                                  mqMessage.format,
                                  ""});

          if (trace)
                 traceClient.writeTrace(IRecordType.TYPE_ERROR_EXC, CLASS_NAME,
                                                "convertMessage(MQMessage)", "AQM5011",
                                                AdapterUtil.DEFAULTTRACEMSGFILE,
                                                new Object[]{ "AQM5011",ae.getClass().getName(),
                                                                  ae.getMessage(),""});

          throw ae;
   }

   RFH2Header rfh;

   /* if trace is on then call the 1 arg constructor, so it will trace also */
   if (trace)
         rfh = new RFH2Header(getApplicationName());
   else
         rfh = new RFH2Header();

   rfh.parseRFH2(mqMessage);


   if (trace)
          traceClient.writeTrace(IRecordType.TYPE_INFO, CLASS_NAME,
                                                "convertMessage(MQMessage)", "AQM5003", AdapterUtil.DEFAULTTRACEMSGFILE,
                                                new Object[]{"AQM5003","RFH2Header", rfh});

   String srcid = (String)rfh.getUSRValue("SourceLogicalID");
   String tmp = (String)rfh.getUSRValue("MessageType");

   em = new EpicMessageExt(srcid, tmp);

   if(mqMessage.messageId == MQC.MQMI_NONE)
   {
          em.setLMSMessageID(em.LMS_MESSAGE_ID_NONE);
          ((ENAService)addr).setLastLMSMessageID(em.LMS_MESSAGE_ID_NONE);
   }
   else
   {
          em.setLMSMessageID(mqMessage.messageId);
          ((ENAService)addr).setLastLMSMessageID(em.getLMSMessageID());
   }

   if(mqMessage.correlationId == MQC.MQCI_NONE)
   {
          em.setLMSCorrelationID(em.LMS_CORELATION_ID_NONE);
          ((ENAService)addr).setLastLMSCorrelationID(em.LMS_CORELATION_ID_NONE);
   }
   else
   {
          em.setLMSCorrelationID(mqMessage.correlationId);
          ((ENAService)addr).setLastLMSCorrelationID(em.getLMSCorrelationID());
   }

   em.setRespondToLogicalID((String)rfh.getUSRValue("RespondToLogicalID"));

   em.setDestinationLogicalID((String)rfh.getUSRValue("DestinationLogicalID"));

   try
   {
           Long ts = new Long((String)rfh.getUSRValue("TimeStampCreated"));
           em.setTimeStamp(ts.longValue());
   }
   catch(Exception e)
   {
   }

   try
   {
           Long ets = new Long((String)rfh.getUSRValue("TimeStampExpired"));
           em.setExpirationTimeStamp(ets.longValue());
   }
   catch(Exception e)
   {
   }

   em.setTransactionID((String)rfh.getUSRValue("TransactionID"));

   em.setUniqueMsgID((String)rfh.getUSRValue("UniqueID"));

   em.setProcessingCategory((String)rfh.getUSRValue("ProcessingCategory"));

   em.setBodyCategory((String)rfh.getUSRValue("BodyCategory"));

   em.setBodyType((String)rfh.getUSRValue("BodyType"));

   em.setBodySecondaryType((String)rfh.getUSRValue("BodySecondaryType"));

   em.setAckRequested((String)rfh.getUSRValue("AckRequested"));

   em.setUserArea((String)rfh.getUSRValue("UserArea"));

   em.setMsgHeaderVersion((String)rfh.getUSRValue("MsgHeaderVersion"));

   em.setCorrelationID((String)rfh.getUSRValue("CorrelationID"));

   em.setGroupStatus((String)rfh.getUSRValue("GroupStatus"));

   em.setQosPolicy((String)rfh.getUSRValue("QOSPolicy"));

   em.setDeliveryCategory((String)rfh.getUSRValue("DeliveryCategory"));

   em.setPublicationTopic((String)rfh.getUSRValue("PublicationTopic"));

   em.setSessionID((String)rfh.getUSRValue("SessionID"));

   Boolean encStat = new Boolean((String)rfh.getUSRValue("EncryptionStatus"));
   em.setEncryptionStatus(encStat.booleanValue());

   em.setBodyData(rfh.getData());

   rfh.close(); // @P1C

   if (trace)
          traceClient.writeTrace(IRecordType.TYPE_EXIT, CLASS_NAME,
                                                "convertMessage(MQMessage)", "AQM5002",
                                                AdapterUtil.DEFAULTTRACEMSGFILE,
                                                new Object[]{"AQM5002"});

   return em;
}
}
