package com.ibm.extricity.adapters.mqseries.mqak;

/**
 * Insert the type's description here.
 * Creation date: (3/6/01 11:23:19 AM)
 * @author: Administrator
 */
import com.ibm.epic.adapters.eak.mcs.*;
import com.ibm.epic.adapters.eak.nativeadapter.*;
import com.ibm.epic.adapters.eak.common.AdapterException;
import java.io.*;
import java.util.*;

public class MQAOAdapterVerify
{
/**
 * MQAPAdapterVerify constructor comment.
 */
public MQAOAdapterVerify()
{
	super();
}


/**
 * Insert the method's description here.
 * Creation date: (10/23/00 3:07:55 PM)
 * @param args java.lang.String[]
 */
public static void main(String[] args)
{
	InputStream propin = null;
	InputStreamReader msgin = null;
	Properties prop = null;
	String filename = args[0];

	if(filename == null)
	{
		filename = "MQAOAdapterVerify.properties";
	}
	try
	{
		try
		{
			propin = new FileInputStream(filename);
		}
		catch(FileNotFoundException e1)
		{
			try
			{
				propin = new FileInputStream("MQAOAdapterVerify.properties");
			}
			catch(FileNotFoundException e2)
			{
				System.out.println("!!!Properties file not found-- Using builtin defaults!!!");
				e1.printStackTrace();
			}
		}
		if(propin != null)
		{
			prop = new Properties();
			prop.load(propin);
			try
			{
				EpicNativeAdapter theENA = new EpicNativeAdapter(prop.getProperty("ApplicationID","MQSIPAM"), "IBM Extricity MQAK Adapter");
				EpicMessageExt theEM;
				// Create the message
				theEM = new EpicMessageExt(prop.getProperty("ApplicationID","MQSIPAM"), prop.getProperty("MessageType","GatewayMessage"));
				theEM.setLMSCorrelationID(theEM.LMS_CORELATION_ID_NONE);
				// Fill the message header
				theEM.setAckRequested(prop.getProperty("AckRequested","False"));
				theEM.setDestinationComponent(prop.getProperty("DestinationComponent","GATEWAY"));
				theEM.setSrcTradingPartnerID(prop.getProperty("SrcTradingPartnerID","0123456789"));
				theEM.setDstTradingPartnerID(prop.getProperty("DstTradingPartnerID","9876543210"));
				theEM.setBOCorrelationID(prop.getProperty("BOCorrelationID","TEST COR ID"));
				theEM.setExtricityProcessID(prop.getProperty("ExtricityProcessID","NONE"),false);
				theEM.setProtocolAndVersion(prop.getProperty("ProtocolAndVersion","XCBL"));
				theEM.setProcessTransactionID(prop.getProperty("ProcessTransactionID","PO"));
				theEM.setUniqueMsgID(prop.getProperty("UniqueMsgID","1234"));
				// Fill the message data
				filename = prop.getProperty("BodyDataFile",null);
				if(filename == null)
				{
					theEM.setBodyData(prop.getProperty("BodyData","<OAG_PO_SIM><PONumber>PO123456789</PONumber><SupplierId>987654321</SupplierId></OAG_PO_SIM>"));
				}
				else
				{
					try
					{
						msgin = new InputStreamReader(new FileInputStream(filename));
					}
					catch(FileNotFoundException e1)
					{
						System.out.println("Body file not found e="+e1.toString());
						return;
					}
					char[] buf = new char[8192];
					int num;
					StringBuffer str = new StringBuffer(8192);
					while((num = msgin.read(buf)) >= 0)
					{
						str.append(buf,0,num);
					}
					theEM.setBodyData(str.toString());
				}
				//if(_DEBUG)
				{
					System.out.println("main theEM: " + theEM.toString());
				}
				// Send the message
				theENA.begin();
				theENA.sendMsg(theEM);
				theENA.commit();
			}
			catch (AdapterException e)
			{
				System.out.println("main exception: " + e.toString());
			}
		}
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
}
}