package com.ibm.extricity.adapters.mqseries.mqak;

/**
 * Insert the type's description here.
 * Creation date: (11/29/00 1:19:25 PM)
 * @author: Administrator
 */
import java.io.*;
import java.util.*;

import com.ibm.epic.adapters.eak.mcs.*;

public class MQAOAdapterTester implements Runnable
{
   protected static boolean _DEBUG = true;
   protected static boolean TRACE = true;
   protected static final String BFT_PFX = "BFT:";
   protected static final String FAST_PFX = "FAST:";
   protected static String MYCR = "\n";

   protected static final String PropFileName = new String("MQAOAdapterTester.properties");

   protected static PrintWriter logFile = null;

   private String gatewayComp = "GATEWAY";
   private String appComp = "BFM";
   private String protAndVer = "UNKNOWN";
   private String msgBodyCategory = "DEFAULT";
   private int NumTPs;
   private Vector TPIds = new Vector();
   private Hashtable traceLog = new Hashtable();
   private Hashtable notifyLog = new Hashtable();

   private boolean xmlDumps = true;
   private boolean fullDumps = true;

   private int poStartInstance = 0;
   private int poMaxNum = -1;

   private ValWithRnd poGen = new ValWithRnd(240,true);
   private ValWithRnd poCluster = new ValWithRnd(1);
   private ValWithRnd poDropReflect1st = new ValWithRnd(0);
   private ValWithRnd poDropReflectAll = new ValWithRnd(0);
   private ValWithRnd poAckDropReflect1st = new ValWithRnd(0);
   private ValWithRnd poAckDropReflectAll = new ValWithRnd(0);
   private ValWithRnd poAccDropReflect1st = new ValWithRnd(0);
   private ValWithRnd poAccDropReflectAll = new ValWithRnd(0);
   private ValWithRnd otherAckDropReflect1st = new ValWithRnd(0);
   private ValWithRnd oOtherAckDropReflectAll = new ValWithRnd(0);
   private ValWithRnd poRejectRate = new ValWithRnd(0);

/**
 * MQAOAdapterTester constructor comment.
 */
public MQAOAdapterTester()
{
   super();
}

/**
 * Insert the method's description here.
 * Creation date: (6/1/00 3:18:23 PM)
 */
public LogData addTrace(String corId,String msgData)
{
   return addTrace(corId,msgData,null,LogData.STATE_NOCHANGE);
}

/**
 * Insert the method's description here.
 * Creation date: (6/1/00 3:18:23 PM)
 */
public LogData addTrace(String corId,String msgData,int newState)
{
   return addTrace(corId,msgData,null,newState);
}

/**
 * Insert the method's description here.
 * Creation date: (6/1/00 3:18:23 PM)
 */
public LogData addTrace(String corId,String msgData,String realCorId)
{
   return addTrace(corId,msgData,realCorId,LogData.STATE_NOCHANGE);
}

/**
 * Insert the method's description here.
 * Creation date: (6/1/00 3:18:23 PM)
 */
public LogData addTrace(String corId,String msgData,String realCorId,int newState)
{
   LogData logDt;
   LogData traceDt;

   msgData = (new Date()).toString() + ":" + msgData;

   // Check for null
   if(corId == null)
   {
	  // Cannot corelate to anything!
	  if(TRACE)
	  {
		 outputTraceMsg("XXXX(-null-) -- Invalid corilation ID" + MYCR + msgData + MYCR + "XXXX");
	  }
	  traceDt = null;
   }
   else if(corId.compareTo("BFP1") == 0)
   {
	  // Invalid default Corilation ID
	  if(TRACE)
	  {
		 outputTraceMsg("XXXX(BFP1) -- Invalid default corilation ID" + MYCR + msgData + MYCR + "XXXX");
	  }
	  traceDt = null;
   }
   // Is it a fast-notify corelation ID?
   else if( (LogData.mySubString(corId,0,FAST_PFX.length()).compareTo(FAST_PFX) == 0) ||
		   (LogData.mySubString(corId,0,FAST_PFX.length()+1).compareTo("E"+FAST_PFX) == 0) ||
		   (LogData.mySubString(corId,0,FAST_PFX.length()+1).compareTo("W"+FAST_PFX) == 0) )
   {
	  if( (LogData.mySubString(corId,0,FAST_PFX.length()+1).compareTo("E"+FAST_PFX) == 0) ||
		  (LogData.mySubString(corId,0,FAST_PFX.length()+1).compareTo("W"+FAST_PFX) == 0) )
	  {
		 corId = corId.substring(1);
	  }
	  logDt = (LogData)notifyLog.get(corId);
	  if(logDt == null)
	  {
		 // build a new entry
		 logDt = new LogData(msgData,LogData.STATE_INIT);
		 notifyLog.put(corId,logDt);
	  }
	  else if(logDt.Data != null)
	  {
		 logDt.Data = logDt.Data + MYCR + msgData;
	  }
	  else
	  {
		 logDt.Data = msgData;
	  }
	  // Update the state if necesary
	  if(newState != LogData.STATE_NOCHANGE)
	  {
		 logDt.State = newState;
	  }
	  // Do we have a real ID
	  if(realCorId != null)
	  {
		 logDt.RealKey = realCorId;
	  }
	  // Do we corelate back to real
	  if(logDt.RealKey == null)
	  {
		 if(TRACE)
		 {
			if(fullDumps)
			{
			   System.out.println("XXXX(" + corId + ")\n" + logDt.Data + "\nXXXX");
			}
			else
			{
			   System.out.println("ADDING(" + corId + ")\n" + msgData);
			}
		 }
		 return logDt;
	  }
	  else
	  {
		 traceDt = (LogData)traceLog.remove(logDt.RealKey);
		 if(traceDt == null)
		 {
			traceDt = new LogData("",logDt.State);
		 }
		 else
		 {
			traceDt.Data = traceDt.Data + MYCR;
			if(newState != LogData.STATE_NOCHANGE)
			{
			   traceDt.State = newState;
			}
		 }
		 if(logDt.Data != null)
		 {
			traceDt.Data = traceDt.Data + logDt.Data;
			logDt.Data = null;
		 }
		 traceLog.put(logDt.RealKey,traceDt);
		 if(TRACE)
		 {
			if(fullDumps)
			{
			   System.out.println("XXXX(" + logDt.RealKey + "-[" + corId + "])\n" + traceDt.Data + "\nXXXX");
			}
			else
			{
			   System.out.println("ADDING(" + logDt.RealKey + "-[" + corId + "])\n" + msgData);
			}
		 }
	  }
   }
   else if( (LogData.mySubString(corId,0,BFT_PFX.length()).compareTo(BFT_PFX) == 0) ||
		   (LogData.mySubString(corId,0,BFT_PFX.length()+1).compareTo("E"+BFT_PFX) == 0) ||
		   (LogData.mySubString(corId,0,BFT_PFX.length()+1).compareTo("W"+BFT_PFX) == 0) )
   {
	  if( (LogData.mySubString(corId,0,BFT_PFX.length()+1).compareTo("E"+BFT_PFX) == 0) ||
		  (LogData.mySubString(corId,0,BFT_PFX.length()+1).compareTo("W"+BFT_PFX) == 0) )
	  {
		 corId = corId.substring(1);
	  }
	  traceDt = (LogData)traceLog.remove(corId);
	  if(traceDt == null)
	  {
		 traceDt = new LogData(msgData,LogData.STATE_INIT);
		 traceDt.RealKey = null;
	  }
	  else
	  {
		 traceDt.Data = traceDt.Data + MYCR + msgData;
	  }
	  if(newState != LogData.STATE_NOCHANGE)
	  {
		 traceDt.State = newState;
	  }
	  traceLog.put(corId,traceDt);
	  if(TRACE)
	  {
		 if(fullDumps)
		 {
			System.out.println("XXXX(" + corId + ")\n" + traceDt.Data + "\nXXXX");
		 }
		 else
		 {
			System.out.println("ADDING(" + corId + ")\n" + msgData);
		 }
	  }
   }
   else
   {
	  // Unknown Corilation ID
	  if(TRACE)
	  {
		 outputTraceMsg("XXXX("+corId+") -- Unknown corilation ID" + MYCR + msgData + MYCR + "XXXX");
	  }
	  traceDt = null;
   }
   return traceDt;
}

/**
 * Insert the method's description here.
 * Creation date: (10/23/00 3:07:55 PM)
 * @param args java.lang.String[]
 */
public static void main(String[] args)
{
   MQAOAdapterTester tester = new MQAOAdapterTester();

   tester.readProperties();
   /*
   // Create
   //String theXML = "<Pip3A4PurchaseOrderRequest><PurchaseOrder><ProductLineItem><shipFrom><GlobalLocationIdentifier>Home</GlobalLocationIdentifier></shipFrom><ProductQuantity>10</ProductQuantity><LineNumber>001</LineNumber><productUnit><ProductPackageDescription><ProductDescription><GlobalProductIdentifier>Junk</GlobalProductIdentifier></ProductDescription></ProductPackageDescription></productUnit><requestedShipDate><DateStamp>11/30/2000</DateStamp></requestedShipDate><GlobalProductUnitOfMeasureCode>Piece</GlobalProductUnitOfMeasureCode><SpecialHandlingInstruction><SpecialHandlingText><FreeFormText>None</FreeFormText></SpecialHandlingText></SpecialHandlingInstruction><requestedPrice><FinancialAmount><GlobalCurrencyCode>USD</GlobalCurrencyCode><MonetaryAmount>1000.00</MonetaryAmount></FinancialAmount></requestedPrice></ProductLineItem><GlobalShipmentTermsCode>FOB</GlobalShipmentTermsCode><RevisionNumber>0</RevisionNumber><GlobalFinanceTermsCode>NET30</GlobalFinanceTermsCode><PartnerDescription><GlobalPartnerClassificationCode>Provider</GlobalPartnerClassificationCode></PartnerDescription><GlobalPurchaseOrderTypeCode>RN</GlobalPurchaseOrderTypeCode></PurchaseOrder><fromRole><PartnerRoleDescription><GlobalPartnerRoleClassificationCode>Buyer</GlobalPartnerRoleClassificationCode></PartnerRoleDescription></fromRole><toRole><PartnerRoleDescription><GlobalPartnerRoleClassificationCode>Seler</GlobalPartnerRoleClassificationCode></PartnerRoleDescription></toRole><thisDocumentGenerationDateTime><DateTimeStamp>11/2/2000 09:17:00</DateTimeStamp></thisDocumentGenerationDateTime><thisDocumentIdentifier><ProprietaryDocumentIdentifier>PO98798</ProprietaryDocumentIdentifier></thisDocumentIdentifier><GlobalDocumentFunctionCode>PO</GlobalDocumentFunctionCode></Pip3A4PurchaseOrderRequest>";
   // Accept
   String theXML = "<Pip3A4PurchaseOrderAcceptance><PurchaseOrder><GlobalPurchaseOrderStatusCode>Accept</GlobalPurchaseOrderStatusCode><GlobalShipmentTermsCode>FOB</GlobalShipmentTermsCode><RevisionNumber>0</RevisionNumber><purchaseOrderDate><DateStamp>11/30/2000</DateStamp></purchaseOrderDate><purchaseOrderNumber><ProprietaryDocumentIdentifier>PO98798</ProprietaryDocumentIdentifier></purchaseOrderNumber></PurchaseOrder><fromRole><PartnerRoleDescription><GlobalPartnerRoleClassificationCode>Seler</GlobalPartnerRoleClassificationCode><PartnerDescription><GlobalPartnerClassificationCode>Seler</GlobalPartnerClassificationCode><BusinessDescription><GlobalBusinessIdentifier>Manufacturer</GlobalBusinessIdentifier><GlobalSupplyChainCode>Manufacturer</GlobalSupplyChainCode></BusinessDescription></PartnerDescription></PartnerRoleDescription></fromRole><toRole><PartnerRoleDescription><GlobalPartnerRoleClassificationCode>Buyer</GlobalPartnerRoleClassificationCode><PartnerDescription><GlobalPartnerClassificationCode>Buyer</GlobalPartnerClassificationCode><BusinessDescription><GlobalBusinessIdentifier>Shopper</GlobalBusinessIdentifier><GlobalSupplyChainCode>Shopper</GlobalSupplyChainCode></BusinessDescription></PartnerDescription></PartnerRoleDescription></toRole><thisDocumentGenerationDateTime><DateTimeStamp>11/2/2000 09:17:00</DateTimeStamp></thisDocumentGenerationDateTime><thisDocumentIdentifier><ProprietaryDocumentIdentifier>PO98798</ProprietaryDocumentIdentifier></thisDocumentIdentifier><requestingDocumentIdentifier><ProprietaryDocumentIdentifier>PO98798</ProprietaryDocumentIdentifier></requestingDocumentIdentifier><GlobalDocumentFunctionCode>PO</GlobalDocumentFunctionCode><requestingDocumentDateTime><DateTimeStamp>11/2/2000 09:17:00</DateTimeStamp></requestingDocumentDateTime></Pip3A4PurchaseOrderAcceptance>";
   String theCorID = new String("4.ijcxbwsq");//(new Date()).toString();
   //String theCorID = new String("16.ij12cmjo");//(new Date()).toString();
   //String theCorID = new String("14.ij12cmjo");//(new Date()).toString();
   String theMsgID = null;
   String pID = "4.iiclkt4n.im4d42.000000e2970e17104.ihxblcrg.im4d42..DICAM.847409406.ORG-3A4-1_1-Create Purchase Order.1.0.1";

   _DEBUG = true;

   try
   {
	  ProcessDataInt pd = new ProcessData(theCorID,"847409406");

	  if((new Random((new Date()).getTime())).nextFloat() < 0.0)
	  {
		 theCorID = EpicMessageExt.NO_EXTRICITYPROCESSID;
	  }
	  ad.startup("BFM","GATEWAY","RosettaNet-1_1","DEFAULT",true,true);
	  msghdr.setData("SrcTradingPartnerID","847409406");
	  msghdr.setData("DstTradingPartnerID","103");
	  msghdr.setData("BOCorrelationID",theCorID);
	  msghdr.setData("ProcessTransactionID","3A4-1_1-CreatePurchaseOrder");
	  System.out.println("SEND msghdr: " + msghdr.toString());
	  System.out.println("   XML: " + theXML);
	  comCtx = ad.executeSendMsg(theCorID,msghdr,theXML,opstat,"TestUniqueID");
	  //comCtx = ad.executeSendMsg(theCorID,msghdr,theXML,opstat,"TestUniqueID");
	  ad.executeCommit(theCorID,comCtx,opstat);

	  //ad.poolENA.clear();
	  ad.startup("GATEWAY","BFM","RosettaNet-1_1","DEFAULT",true,true);
	  if(theCorID.compareTo(EpicMessageExt.NO_EXTRICITYPROCESSID) == 0)
	  {
		 do
		 {
			//theXML = ad.executeRecvMsg(theCorID,theMsgID,null,msghdr,comctx,opstat);
			ad.checkForEvents(ec);
			theMsgID = ec.getVariantEvent();
		 } while(theMsgID == null);
		 System.out.println("\n\n======================\nEVENT msgid: " + theMsgID + "\n================\n");
	  }
	  //theCorID = "Wed Oct 25 10:41:51 EDT ";
	  msghdr.clearAll();
	  ProcessDataInt pdXML = ad.executeRecvMsg(pID,theMsgID,false,null,msghdr,opstat);
	  System.out.println("RECEIVE msghdr: " + msghdr.toString());
	  System.out.println("   XML: " + pdXML.getMsgXML());
	  ad.executeCommit(pID,pdXML.getCommitContext(),opstat);
	  theCorID = msghdr.getData("BOCorrelationID");

	  //ProcessData pd = new ProcessData(pID,"847409406");
	  ad.executeSetProcessData(theCorID,pd);
	  pd = ad.executeGetProcessData(theCorID);
	  System.out.println("PROCESSDATA: " + pd.toString());
	  ad.executeDelProcessData(theCorID);
   }
   catch(ISException e)
   {
	  System.out.println("executeRecvMsg->ISException: " + e.toString());
   }*/
}

/**
 * Insert the method's description here.
 * Creation date: (6/6/00 9:48:23 AM)
 * @param corId java.lang.String
 * @param realCorId java.lang.String
 */
public void outputTrace(String corId, String realCorId)
{
   LogData logDt;

   // Is it a fast-notify corelation ID?
   if(corId.substring(0,FAST_PFX.length()).compareTo(FAST_PFX) == 0)
   {
	  if(realCorId == null)
	  {
		 logDt = (LogData)notifyLog.get(corId);
		 if(logDt != null)
		 {
			// Do we have a real ID
			corId = logDt.RealKey;
		 }
		 else
		 {
			corId = null;
		 }
	  }
	  else
	  {
		 corId = realCorId;
	  }
   }
   if(corId != null)
   {
	  logDt = (LogData)traceLog.get(corId);
	  if(logDt != null)
	  {
		 outputTraceMsg("XXX:"+corId+MYCR+logDt.Data+MYCR+"XXX");
	  }
   }
   System.out.println("@@@---Processing complete for:"+corId);
}

/**
 * Insert the method's description here.
 * Creation date: (6/6/00 5:12:43 PM)
 * @param msg java.lang.String
 */
public void outputTraceMsg(String msg)
{
   if(logFile == null)
   {
	  try
	  {
		 logFile = new PrintWriter(new FileOutputStream("GatewayTester.log",true));
	  }
	  catch(Exception e)
	  {
		 e.printStackTrace();
	  }
   }
   try
   {
	  if(TRACE)
	  {
		 System.out.println(msg);
	  }
	  logFile.flush();
   }
   catch(Exception e)
   {
	  e.printStackTrace();
   }
   logFile.println(msg);
}

/**
 * Insert the method's description here.
 * Creation date: (11/30/00 10:31:28 AM)
 */
public void readProperties()
{
   InputStream propin = null;
   Properties prop = null;
   String partnerDUNS;
   String tmp;
   int ix;

   try
   {
	  try
	  {
		 propin = new FileInputStream(PropFileName);
	  }
	  catch(FileNotFoundException e1)
	  {
		 try
		 {
			propin = new FileInputStream("properties/"+PropFileName);
		 }
		 catch(FileNotFoundException e2)
		 {
			try
			{
			   propin = new FileInputStream("d:/ePIC/ExtricityMQAOAdapter/"+PropFileName);
			}
			catch(FileNotFoundException e)
			{
			   System.out.println("!!!Properties file not found-- Using builtin defaults!!!");
			   outputTraceMsg("!!!Properties file not found-- Using builtin defaults!!!");
			   e.printStackTrace();
			}
		 }
	  }
	  if(propin != null)
	  {
		 prop = new Properties();
		 prop.load(propin);
		 appComp = prop.getProperty("BFMName","BFM");
		 gatewayComp = prop.getProperty("GatewayName","GATEWAY");
		 protAndVer = prop.getProperty("ProtocolAndVersion","RosettaNet_RNIF1.1");
		 msgBodyCategory = prop.getProperty("BodyCategory","DEFAULT");

		 //# Business partner definitions
		 NumTPs = 0;
		 while( (partnerDUNS = prop.getProperty("BusinessPartnerId_" + NumTPs,null)) != null )
		 {
			//tp.spawnListner(listenUrl,partnerDUNS,srvUrl);
			TPIds.addElement(partnerDUNS);
			NumTPs += 1;
		 };
		 //# Logging control definitions
		 fullDumps = (new Boolean(prop.getProperty("FullDumps","true"))).booleanValue();
		 xmlDumps = (new Boolean(prop.getProperty("XMLDumps","true"))).booleanValue();
		 //# Stress definitions (Fixed: #, Random: R#)
		 poStartInstance = (new Integer(prop.getProperty("POStartInstance","0"))).intValue();
		 poMaxNum = (new Integer(prop.getProperty("POMaxNum","-1"))).intValue();
		 poGen = new ValWithRnd(prop.getProperty("POGenRate","R240"));
		 poCluster = new ValWithRnd(prop.getProperty("POClusterSize","1"),1);
		 poDropReflect1st = new ValWithRnd(prop.getProperty("PODropReflect1st","0"));
		 poDropReflectAll = new ValWithRnd(prop.getProperty("PODropReflectAll","0"));
		 poAckDropReflect1st = new ValWithRnd(prop.getProperty("POAckDropReflect1st","0"));
		 poAckDropReflectAll = new ValWithRnd(prop.getProperty("POAckDropReflectAll","0"));
		 poAccDropReflect1st = new ValWithRnd(prop.getProperty("POAccDropReflect1st","0"));
		 poAccDropReflectAll = new ValWithRnd(prop.getProperty("POAccDropReflectAll","0"));
		 otherAckDropReflect1st = new ValWithRnd(prop.getProperty("OtherAckDropReflect1st","0"));
		 oOtherAckDropReflectAll = new ValWithRnd(prop.getProperty("OtherAckDropReflectAll","0"));
		 poRejectRate = new ValWithRnd(prop.getProperty("PORejectRate","0"));
	  }
   }
   catch(Exception e)
   {
	  e.printStackTrace();
   }
}

/**
 * Insert the method's description here.
 * Creation date: (5/23/00 4:45:32 PM)
 */
public void run()
{
   int insId;
   int clSize = 1;
   int newState;
   long sval;

   outputTraceMsg((new Date()).toString() + ":=============== PO generation started! ===============");
   insId = poStartInstance;
   while( (insId < poMaxNum) || (poMaxNum < 0) )
   {
	  clSize = poCluster.getVal();
	  while( (clSize > 0) && ((insId < poMaxNum) || (poMaxNum < 0)) )
	  {
		 newState = LogData.STATE_NOCHANGE;
		 if(poDropReflect1st.getOutOf100())
		 {
			newState = LogData.STATE_POLOOSE1ST;
		 }
		 else if(poDropReflectAll.getOutOf100())
		 {
			newState = LogData.STATE_POLOOSEALL;
		 }
		 addTrace(BFT_PFX+insId,"@@@>>>Generating:BFT:"+insId,newState);
		 sendPORequest(BFT_PFX + insId,"" + insId,(String)TPIds.elementAt(insId % NumTPs),(String)TPIds.elementAt((insId + 1) % NumTPs));
		 insId++;
		 clSize--;
	  }
	  try
	  {
		 sval = poGen.getVal();
		 System.out.println("Sleeping for:"+sval+"sec.");
		 Thread.sleep(sval * 1000);
	  }
	  catch(Exception e)
	  {
		 e.printStackTrace(System.out);
	  }
   };
   outputTraceMsg((new Date()).toString() + ":=============== PO generation complete! ===============");
}

/**
 * Insert the method's description here.
 * Creation date: (5/19/00 1:35:21 PM)
 */
public void sendPORequest(String colIx,String instanceId,String ReqId,String DstId)
{
   EpicMessage msgout;
   GatewayCommands cmdout;
   MQAOCSRJ preamblecsr = null;
   MQAOCSRJ srvHeadercsr = null;
   MQAOCSRJ requestcsr = null;

   try
   {
	  preamblecsr = getXMLCSRJ("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +
					"<!DOCTYPE Preamble SYSTEM \"PreamblePartMessageGuideline.dtd\">" +
				"<Preamble><VersionIdentifier>1.1</VersionIdentifier>" +
				"<DateTimeStamp>"+"19990531T132000.0500Z"+"</DateTimeStamp>" +
				"<GlobalAdministeringAuthorityCode>RosettaNet</GlobalAdministeringAuthorityCode>" +
				"<GlobalUsageCode>Test</GlobalUsageCode></Preamble>");

	  requestcsr = MQAOXMLIJ.createXMLDocument("Pip3A4PurchaseOrderRequest",
								"3A4PurchaseOrderRequestMessageGuideline_v1_1.dtd",
								"3A4PurchaseOrderRequestMessageGuideline_v1_1.dtd",
								"1.0",
								"UTF-8",
								null);
	  MQAOXMLIJ.addElement(requestcsr,"Pip3A4PurchaseOrderRequest");

	  srvHeadercsr = MQAOXMLIJ.createXMLDocument("ServiceHeader",
								  "ServiceHeaderPartMessageGuideline.dtd",
								  "ServiceHeaderPartMessageGuideline.dtd",
								  "1.0",
								  "UTF-8",
								  null);
	  MQAOXMLIJ.addElement(srvHeadercsr,"ServiceHeader");
	  MQAOXMLIJ.addElement(srvHeadercsr,"ProcessControl");
	  MQAOXMLIJ.addElement(srvHeadercsr,"ProcessIdentity");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"GlobalProcessCode","Manage Purchase Order");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"VersionIdentifier","1.1");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"GlobalProcessIndicatorCode","3A4");
	  MQAOXMLIJ.addElement(srvHeadercsr,"initiatingPartner");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"GlobalBusinessIdentifier",ReqId);
	  srvHeadercsr.up();
	  MQAOXMLIJ.addElementText(srvHeadercsr,"InstanceIdentifier",instanceId);
	  MQAOXMLIJ.addElement(srvHeadercsr,"description");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"FreeFormText",colIx);
	  MQAOXMLIJ.getElement(srvHeadercsr,"FreeFormText");
	  MQAOXMLIJ.addAttribute(srvHeadercsr,"xml:lang","en");
	  srvHeadercsr.up();
	  srvHeadercsr.up();
	  srvHeadercsr.up();
	  MQAOXMLIJ.addElement(srvHeadercsr,"ServiceRoute");
	  MQAOXMLIJ.addElement(srvHeadercsr,"fromService");
	  MQAOXMLIJ.addElement(srvHeadercsr,"BusinessServiceDescription");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"GlobalBusinessServiceCode","Buyer Service");
	  srvHeadercsr.up();
	  srvHeadercsr.up();
	  MQAOXMLIJ.addElement(srvHeadercsr,"toService");
	  MQAOXMLIJ.addElement(srvHeadercsr,"BusinessServiceDescription");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"GlobalBusinessServiceCode","Seller Service");
	  srvHeadercsr.up();
	  srvHeadercsr.up();
	  srvHeadercsr.up();
	  MQAOXMLIJ.addElement(srvHeadercsr,"TransactionControl");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"GlobalTransactionCommandCode","Send");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"AttemptCount","1");
	  MQAOXMLIJ.addElement(srvHeadercsr,"TransactionIdentity");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"GlobalTransactionCode","Create Purchase Order");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"InstanceIdentifier","1");
	  MQAOXMLIJ.addElement(srvHeadercsr,"description");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"FreeFormText","Activity creates a Purchase Order Notification.");
	  MQAOXMLIJ.getElement(srvHeadercsr,"FreeFormText");
	  MQAOXMLIJ.addAttribute(srvHeadercsr,"xml:lang","en");
	  srvHeadercsr.up();
	  srvHeadercsr.up();
	  srvHeadercsr.up();
	  MQAOXMLIJ.addElement(srvHeadercsr,"PartnerRoleRoute");
	  MQAOXMLIJ.addElement(srvHeadercsr,"fromRole");
	  MQAOXMLIJ.addElement(srvHeadercsr,"PartnerRoleDescription");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"GlobalPartnerRoleClassificationCode","Buyer");
	  srvHeadercsr.up();
	  srvHeadercsr.up();
	  MQAOXMLIJ.addElement(srvHeadercsr,"toRole");
	  MQAOXMLIJ.addElement(srvHeadercsr,"PartnerRoleDescription");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"GlobalPartnerRoleClassificationCode","Seller");
	  srvHeadercsr.up();
	  srvHeadercsr.up();
	  srvHeadercsr.up();
	  MQAOXMLIJ.addElement(srvHeadercsr,"ActionControl");
	  MQAOXMLIJ.addElement(srvHeadercsr,"ActionIdentity");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"GlobalBusinessActionCode","Purchase Order Request");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"VersionIdentifier","1.1");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"InstanceIdentifier","1");
	  MQAOXMLIJ.addElement(srvHeadercsr,"description");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"FreeFormText","A notification informing the Seller that A Purchase Order has been issued.");
	  MQAOXMLIJ.getElement(srvHeadercsr,"FreeFormText");
	  MQAOXMLIJ.addAttribute(srvHeadercsr,"xml:lang","en");
	  srvHeadercsr.up();
	  srvHeadercsr.up();
	  srvHeadercsr.up();
	  MQAOXMLIJ.addElementText(srvHeadercsr,"GlobalDocumentFunctionCode","Request");
	  MQAOXMLIJ.addElement(srvHeadercsr,"PartnerRoute");
	  MQAOXMLIJ.addElement(srvHeadercsr,"fromPartner");
	  MQAOXMLIJ.addElement(srvHeadercsr,"PartnerDescription");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"GlobalPartnerClassificationCode","Shopper");
	  MQAOXMLIJ.addElement(srvHeadercsr,"BusinessDescription");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"GlobalBusinessIdentifier",ReqId);
	  srvHeadercsr.up();
	  srvHeadercsr.up();
	  srvHeadercsr.up();
	  MQAOXMLIJ.addElement(srvHeadercsr,"toPartner");
	  MQAOXMLIJ.addElement(srvHeadercsr,"PartnerDescription");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"GlobalPartnerClassificationCode","Manufacturer");
	  MQAOXMLIJ.addElement(srvHeadercsr,"BusinessDescription");
	  MQAOXMLIJ.addElementText(srvHeadercsr,"GlobalBusinessIdentifier",DstId);
	  if(supPerformance)
	  {
		 srvHeadercsr.up();
		 srvHeadercsr.up();
		 srvHeadercsr.up();
		 srvHeadercsr.up();
		 MQAOXMLIJ.addElement(srvHeadercsr,"PerformanceControlRequest");
		 MQAOXMLIJ.addElement(srvHeadercsr,"timeToAcknowledgeAcceptance");
		 MQAOXMLIJ.addElementText(srvHeadercsr,"TimeDuration",ackAccTime);
		 srvHeadercsr.up();
		 MQAOXMLIJ.addElement(srvHeadercsr,"timeToAcknowledgeReceipt");
		 MQAOXMLIJ.addElementText(srvHeadercsr,"TimeDuration",ackRecTime);
		 srvHeadercsr.up();
		 MQAOXMLIJ.addElement(srvHeadercsr,"timeToPerform");
		 MQAOXMLIJ.addElementText(srvHeadercsr,"TimeDuration",perform);
	  }

	  // Output the xml
	  if(xmlDumps)
	  {
		 System.out.println("SRVHDR:\n" + MQAOXMLIJ.printWithFormat(srvHeadercsr));
	  }
	  // Build reply command
	  // - Header
	  cmdout = new GatewayCommands();
	  cmdout.setCommand("CreateTPPInstanceCommand");
	  //cmdout.setMailboxID(cmdin.getMailboxID());
	  cmdout.setTpID(ReqId);
	  cmdout.setTppType("RosettaNet");
	  cmdout.setBFPCorrelationID(colIx);
	  cmdout.setProcessID("3A4");
	  // - Parameters
	  cmdout.setBFPNotificationID(colIx);
	  cmdout.setEPNotificationID("E"+colIx);
	  cmdout.setWMPNotificationID("W"+colIx);
	  // Build the RosettaNet body
	  cmdout.setMessage(MQAOXMLIJ.printWithoutFormat(preamblecsr) +
			  MQAOXMLIJ.printWithoutFormat(srvHeadercsr) +
			  MQAOXMLIJ.printWithoutFormat(requestcsr));

	  // Build the MQAO message
	  msgout = new EpicMessage("DEFAULT","APPLICATION");
	  msgout.setDestinationLogicalID("GATEWAY");
	  msgout.setSourceLogicalID("BFM");
	  msgout.setBodyCategory("GATEWAY");
	  msgout.setBodyType("REPLY");
	  msgout.setBodyData(cmdout.createCommandMsg());

	  addTrace(cmdout.getBFPCorrelationID(),
			  "###>>>REPLY(CreateTPPInstanceCommand):TPPInstanceID="+cmdout.getTPPInstanceID()+
			 ",BFPCorrelationID="+cmdout.getBFPCorrelationID()+
			 ",MessageRecordID="+cmdout.getMessageRecordID());

	  // Send the MQAO message
	  getEpicNativeAdapter().sendMsg(msgout);
   }
   catch(Exception e)
   {
	  e.printStackTrace();
   }
}
}