package com.ibm.extricity.adapters.mqseries.mqak;

/**
 * MQAOAdapterImp.java 1.0      10/4/2000
 *
 * The MQAOAdapterImp is derived from <EM>Adapter</EM> class.
 * This class (originaly generated by Extricity Adapter Designer) is used
 * as an interface for performing the Extricity MQAK Adapter functions
 *
 * OCO Source Materials
 *
 * 5799-RNK
 *
 * (C) Copyright IBM Corp. 2000
 *
 * The source code for this program is not published
 * or otherwise divested of its trade secrets,
 * irrespective of what has been deposited with the
 * U. S. Copyright Office.
 *
 * @author Thomas W. Jaworski
**/
import java.io.*;
import com.extricity.adapter.api.*;
import com.extricity.document.api.*;

import java.net.URLClassLoader;
import java.net.URL;
import java.util.*;
import javax.naming.*;
import javax.naming.directory.*;

import javax.activation.*;import javax.mail.*;import com.ibm.misc.*;import javax.mail.internet.*;public class MQAOAdapterImp extends Adapter {
        protected boolean _DEBUG = false;

        protected MQAOAdapterHelperInt helper;

        //-------------------------------------------------------------------------
        // Constants - Protected - Internal
        //-------------------------------------------------------------------------

        protected static final String UNKNOWN_OPERATION_TYPE_ID =
                "Trying to execute an Adapter operation with an unknown operation type";
        protected static final String UNKNOWN_OPERATION_ID =
                "Trying to execute an unknown Adapter operation";


        //-------------------------------------------------------------------------
        // Constants - Protected - Adapter Properties
        //-------------------------------------------------------------------------

        protected static final String PROP_DESTINATIONCOMPONENT =
                "DestinationComponent";
        protected static final String PROP_PROTOCOLANDVERSION = "ProtocolAndVersion";
        protected static final String PROP_MSGBODYCATEGORY = "MsgBodyCategory";
        protected static final String PROP_GATEWAYCOMPONENT = "GatewayComponent";
        protected static final String PROP_ENABLETRACE = "EnableTrace";
        protected static final String PROP_EXPLICITCOMMIT = "ExplicitCommit";
        protected static final String PROP_ADAPTMESSAGES = "AdaptMessages";
        protected static final String PROP_EPICURL = "EpicURL";
        protected static final String PROP_INTERNALAPPID = "InternalAppId";
        protected static final String PROP_MQAKURL = "MQAKURL";
        protected static final String PROP_PARTNERURL = "PartnerURL";


        //-------------------------------------------------------------------------
        // Constants - Protected - Adapter Events
        //-------------------------------------------------------------------------

        protected static final String EVENT_PIP_START = "PIP Start";
        protected static final String EVENT_PROCESS_END = "Process End";

        //-------------------------------------------------------------------------
        // Constants - Private - Advanced Operations
        //-------------------------------------------------------------------------

        // RecvBO constants
        protected static final String RECVPREFIX = "Recv";
        protected static final String RECVBO_INPUT_PROCESSID = "ProcessID";
        protected static final String RECVBO_INPUT_MSGFILTER = "MsgFilter";
        protected static final String RECVBO_INPUT_MSGID = "MsgId";
        protected static final String RECVBO_INPUT_PEEKONLY = "PeekOnly";
        protected static final String RECVBO_OUTPUT_MSGHDR = "MsgHdr";
        protected static final String RECVBO_OUTPUT_OPSTATUS = "OPStatus";
        protected static final String RECVBO_OUTPUT_MSGBO = "MsgBO";
        protected static final String RECVBO_OUTPUT_COMMITCONTEXT = "CommitContext";

        // SendBO constants
        protected static final String SENDPREFIX = "Send";
        protected static final String SENDBO_INPUT_PROCESSID = "ProcessID";
        protected static final String SENDBO_INPUT_MSGBO = "MsgBO";
        protected static final String SENDBO_INPUT_MSGHDR = "MsgHdr";
        protected static final String SENDBO_OUTPUT_OPSTATUS = "OPStatus";
        protected static final String SENDBO_OUTPUT_COMMITCONTEXT = "CommitContext";

        // "RecvPip3A4PurchaseOrderRequest" constants
        //protected static final String RECVPIP3A4PURCHASEORDERREQUEST = "RecvPip3A4PurchaseOrderRequest";

        // "SendPip3A4PurchaseOrderRequest" constants
        //protected static final String SENDPIP3A4PURCHASEORDERREQUEST = "SendPip3A4PurchaseOrderRequest";

        // "RecvPip3A4PurchaseOrderAcceptance" constants
        //protected static final String RECVPIP3A4PURCHASEORDERACCEPTANCE = "RecvPip3A4PurchaseOrderAcceptance";

        // "SendPip3A4PurchaseOrderAcceptance" constants
        //protected static final String SENDPIP3A4PURCHASEORDERACCEPTANCE = "SendPip3A4PurchaseOrderAcceptance";

        // "RecvPip3A4PurchaseOrderChange" constants
        //protected static final String RECVPIP3A4PURCHASEORDERCHANGE = "RecvPip3A4PurchaseOrderChange";

        // "SendPip3A4PurchaseOrderChange" constants
        //protected static final String SENDPIP3A4PURCHASEORDERCHANGE = "SendPip3A4PurchaseOrderChange";

        // "RecvPip3A4PurchaseOrderCancellation" constants
        //protected static final String RECVPIP3A4PURCHASEORDERCANCELLATION = "RecvPip3A4PurchaseOrderCancellation";

        // "SendPip3A4PurchaseOrderCancellation" constants
        //protected static final String SENDPIP3A4PURCHASEORDERCANCELLATION = "SendPip3A4PurchaseOrderCancellation";

        // "RecvXMLMsg" constants
        protected static final String RECVXMLMSG = "RecvXMLMsg";
        protected static final String RECVXMLMSG_INPUT_PROCESSID = "ProcessID";
        protected static final String RECVXMLMSG_INPUT_MSGFILTER = "MsgFilter";
        protected static final String RECVXMLMSG_INPUT_MSGID = "MsgId";
        protected static final String RECVXMLMSG_INPUT_PEEKONLY = "PeekOnly";
        protected static final String RECVXMLMSG_OUTPUT_MSGXML = "MsgXML";
        protected static final String RECVXMLMSG_OUTPUT_MSGHDR = "MsgHdr";
        protected static final String RECVXMLMSG_OUTPUT_OPSTATUS = "OPStatus";
        protected static final String RECVXMLMSG_OUTPUT_COMMITCONTEXT = "CommitContext";

        // "SendXMLMsg" constants
        protected static final String SENDXMLMSG = "SendXMLMsg";
        protected static final String SENDXMLMSGWCARD = "SendXMLMsgWithCard";

        protected static final String SENDXMLMSG_INPUT_PROCESSID = "ProcessID";
        protected static final String SENDXMLMSG_INPUT_MSGXML = "MsgXML";
        protected static final String SENDXMLMSG_INPUT_MSGHDR = "MsgHdr";
        protected static final String SENDXMLMSG_OUTPUT_OPSTATUS = "OPStatus";
        protected static final String SENDXMLMSG_OUTPUT_COMMITCONTEXT = "CommitContext";
        protected static final String SENDXMLMSG_INPUT_CARDNUM = "PCardNumber";
        protected static final String SENDXML_EXTRINSIC_OPEN = "<Extrinsic name=\"CardSuffix\">";
        protected static final String SENDXML_EXTRINSIC_CLOSE = "</Extrinsic>";

        // "Commit" constants
        protected static final String COMMIT = "Commit";
        protected static final String COMMIT_INPUT_PROCESSID = "ProcessID";
        protected static final String COMMIT_INPUT_COMMITCONTEXT = "CommitContext";
        protected static final String COMMIT_OUTPUT_OPSTATUS = "OPStatus";

        // "GetPublicProcessID" constants
        protected static final String GETPUBLICPROCESSID = "GetPublicProcessID";
        protected static final String GETPUBLICPROCESSID_OUTPUT_OPSTATUS = "OPStatus";
        protected static final String GETPUBLICPROCESSID_OUTPUT_PUBLICPROCESSID =
                "PublicProcessID";

        // "GetProcessData" constants
        protected static final String GETPROCESSDATA = "GetProcessData";
        protected static final String GETPROCESSDATA_INPUT_PROCESSID = "ProcessID";
        protected static final String GETPROCESSDATA_OUTPUT_TRADINGPARTNER =
                "TradingPartner";
        protected static final String GETPROCESSDATA_OUTPUT_BOCORRELATIONID =
                "BOCorrelationID";

        // "SetProcessData" constants
        protected static final String SETPROCESSDATA = "SetProcessData";
        protected static final String SETPROCESSDATA_INPUT_BOCORRELATIONID =
                "BOCorrelationID";
        protected static final String SETPROCESSDATA_INPUT_TRADINGPARTNER =
                "TradingPartner";
        protected static final String SETPROCESSDATA_INPUT_PROCESSID = "ProcessID";

        // "DelProcessData" constants
        protected static final String DELPROCESSDATA = "DelProcessData";
        protected static final String DELPROCESSDATA_INPUT_PROCESSID = "ProcessID";

        // "LogException" constants
        protected static final String LOGEXCEPTION = "LogException";
        protected static final String LOGEXCEPTION_INPUT_LOGMESSAGE = "LogMessage";
        protected static final String LOGEXCEPTION_INPUT_PROCESSID = "ProcessID";
        protected static final String LOGEXCEPTION_INPUT_SUBCOMPONENT = "SubComponent";
        protected static final String LOGEXCEPTION_INPUT_EXCEPTIONID = "ExceptionID";
        protected static final String LOGEXCEPTION_INPUT_PROCESSNAME = "ProcessName";
        protected static final String LOGEXCEPTION_OUTPUT_OPSTATUS = "OPStatus";

        protected static final String ADMIN_EMAIL_ADDR = "adminEmailAddr";
        // "Audit logging " constants
        protected static final String AUDIT_LOG = "auditLog";           protected static final String AUDIT_LOG_CONTENT = "auditContent";
        // "Buyer profile authentication" constants
        protected static final String BUYER_AUTHENTICATION = "buyerAuthentication";     protected static final String BUYER_IDENTIFIER = "buyerId";
        // "Retrieve admin user's email addrs " constants
        protected static final String GET_ADMIN_EMAIL_ADDR = "getAdminEmailAddr";

        // "EncryptPCard" constants
        protected static final String ENCRYPTCARD = "EncryptPCard";
        protected static final String PCARDNUM = "PCardNum";
        protected static final String CRPTONUM = "EncryptedPCardNum";

        // "Properties file" constants
        protected static final String READPROPERTIES = "ReadResponseProperties";
        protected static final String PROPERTY_FILENAME = "PropertyFile";
        protected static final String LANG = "language";
        protected static final String COUNTRY_CODE = "CountryCode";
        protected static final String RESPONSE_STATUS = "ResponseStatus";
        protected static final String RESPONSE_CODE = "ResponseCode";
        protected static final String RESPONSE_TEXT = "ResponseText";
        protected static final String RESPONSE_DATA = "ResponseData";

        // "Credit/Procurement Card Check" constants
        protected static final String CHECK_CARD = "checkCardNumber";
        protected static final String CARD_NUMBER = "CardNumber";
        protected static final String IS_CARD_VALID = "isCardValid";

        //-------------------------------------------------------------------------
        // Variables - Protected - Adapter Properties
        //-------------------------------------------------------------------------

        /**
        * Component to which communication will go to.  This corresponds to the
        * MQAK Application in the directory.
        */
        protected String destinationcomponent;

        /**
        * The protocol and version that will be set for all outgoing messages.
        */
        protected String protocolandversion;

        /**
        * BodyCategory used for messaging.  Set to:
        * "DEFAULT" - process all messages. (default)
        * <specific protocol&version> - use defined specific protocol and version.
        */
        protected String msgbodycategory;

        /**
        * Component which identifies the gateway.  This corresponds to the MQAK
        * Application in the directory.
        */
        protected String gatewaycomponent;

        /**
        * Enable Debug/Trace output.
        */
        protected boolean enabletrace;

        /**
        * Explicit commit required for all Send & Receive opeartions.
        */
        protected boolean explicitcommit;

        /**
        * Adapt to messages that are sent without MQSeries CorrelationID being set
        * to the proper Extricity Process ID value.  (This feature allows for
        * interoperability with older versions of MQAO).
        */
        protected boolean adaptmessages;

        /**
        * URL for access to ePIC java classes.
        */
        protected String epicurl;

        /**
        * Application ID used for access to STATE queues.  DEFAULT = use value of
        * GatewayComponent.
        */
        protected String internalappid;

        /**
        * URL for access to MQAK java classes.
        */
        protected String mqakurl;

        /**
        * URL for access to partner java classes.
        */
        protected String partnerurl;

   //-------------------------------------------------------------------------
   // Constructors
   //-------------------------------------------------------------------------

   /**
   * Default constructor.
   */
   public MQAOAdapterImp()
   {
         super();
   }


   //-------------------------------------------------------------------------
   // Methods - Lifecycle
   //-------------------------------------------------------------------------

   /**
   * Called when the adapter is started for the first time.
   *
   * @param context Holds Adapter specific properties, may be empty.
   *
   * @exception ISException Thrown if there is a problem starting the
   * Adapter.
   */
   public void startup(AdapterContext context)
         throws ISException {

         // load the properties from the adapter
         loadAdapterProperties(context);

         try
         {
                URL[] mqakURL = new URL[]{new URL(mqakurl),new URL(partnerurl),new URL(epicurl)};
                ExtURLClassLoader theLoader = new ExtURLClassLoader(mqakURL,this.getClass().getClassLoader());

                theLoader._DEBUG = enabletrace;
                // Load the helper using the special class loader
                helper = (MQAOAdapterHelperInt)theLoader.loadClass("com.ibm.extricity.adapters.mqseries.mqak.MQAOAdapterHelper").newInstance();
                if(helper == null)
                {
                   System.out.println("--->Helper is: null");
                   throw new ISException("Could not load helper class: com.ibm.extricity.adapters.mqseries.mqak.MQAOAdapterHelper");
                }
                else
                {
                   System.out.println("--->Helper is: "+helper.toString());
                }
         }
         catch(Exception e)
         {
                System.out.println("--->Exception when loading: "+e.toString());
                e.printStackTrace();
                throw new ISException(e.toString());
         }

         // add startup code here
         helper.startup(gatewaycomponent,internalappid,destinationcomponent,protocolandversion,msgbodycategory,exceptionlogext,enabletrace,explicitcommit,adaptmessages,recvpollrate);
   }


   /**
   * Called when the adapter is stopped. Allows the adapter to perform any
   * necessary cleanup work.  Please note that the method signature
   * contains the <code>throws ISException</code> clause only for
   * backward compatibility reasons.  Adapter developer should handle
   * all error cases in shutdown, and should not throw
   * <code>ISException</code> or
   * <code>EndSystemNotAvailableException</code>.
   *
   * @param context Holds Adapter specific properties, may be empty.
   *
   * @exception ISException Thrown if there is a problem starting the
   * Adapter.
   */
   public void shutdown(AdapterContext context)
         throws ISException {

         // add shutdown code here
         helper.shutdown();
   }


//-------------------------------------------------------------------------
// Methods - Execution
//-------------------------------------------------------------------------

/**
* Called to execute a specific operation. This method must be overridden
* by all Adapter subclasses.
*
* This method can be called by multiple threads.
*
* If the adapter subclass supports transactions, the transaction will be
* either commited after this method returns or rolled back if an exception
* is thrown. If the Adapter subclass does not support transactions, it
* must either commit or rollback all stateful actions performed during
* execution of this method.
*
* @param context Runtime context for the operation. Container for
* operation inputs and outputs (output values must be added by the Adapter
* subclass implementation).
*
* @exception ISException Thrown if there is an error during execution.
*/
public void execute(OperationContext context) throws ISException {
        int operation_type_id;
        String operation_id;

        operation_type_id = context.getOperationTypeID();
        operation_id = context.getOperationID();

        switch (operation_type_id) {
                case OperationContext.GET :
                        throw new ISException(UNKNOWN_OPERATION_ID + ": " + operation_id);
                        //break;

                case OperationContext.POST :
                        throw new ISException(UNKNOWN_OPERATION_ID + ": " + operation_id);
                        //break;

                case OperationContext.ADVANCED :
                        if (operation_id.equals(COMMIT)) {
                                executeCommit(context);
                        } else
                                if (operation_id.equals(RECVXMLMSG)) {
                                        executeRecvXMLMsg(context);
                                } else
                                        if (operation_id.equals(SENDXMLMSG)) {
                                                executeSendXMLMsg(context);
                                        } else if(operation_id.equals(SENDXMLMSGWCARD)){
                                                executeSendXMLMsgWithCardSuffix(context);
                                        } else
                                                if (operation_id.equals(GETPUBLICPROCESSID)) {
                                                        executeGetPublicProcessID(context);
                                                } else
                                                        if (operation_id.equals(GETPROCESSDATA)) {
                                                                executeGetProcessData(context);
                                                        } else
                                                                if (operation_id.equals(SETPROCESSDATA)) {
                                                                        executeSetProcessData(context);
                                                                } else
                                                                        if (operation_id.equals(DELPROCESSDATA)) {
                                                                                executeDelProcessData(context);
                                                                        } else
                                                                                if (operation_id.equals(LOGEXCEPTION)) {
                                                                                        executeLogException(context);
                                                                                } else
                                                                                        if (operation_id.equals(AUDIT_LOG)) {
                                                                                                executeAuditLog(context);
                                                                                        } else
                                                                                                if (operation_id.equals(BUYER_AUTHENTICATION)) {
                                                                                                        executeBuyerAuthentication(context);
                                                                                                } else
                                                                                                        if (operation_id.equals(GET_ADMIN_EMAIL_ADDR)) {
                                                                                                                executeGetAdminUserEmailAddr(context);
                                                                                                        } else
                                                                                                                if (operation_id.equals(READPROPERTIES)) {
                                                                                                                        executeReadProperties(context);
                                                                                                                } else
                                                                                                                        if (operation_id.equals(CHECK_CARD)) {
                                                                                                                                executeCardCheck(context);
                                                                                                                        } else
                                                                                                                                if (operation_id.equals(ENCRYPTCARD)) {
                                                                                                                                        executeEncryptPCardNumber(context);
                                                                                                                                } else
                                                                                                                                        if (operation_id.substring(0, 4).equals(RECVPREFIX)) {
                                                                                                                                                executeRecvBO(context);
                                                                                                                                        } else
                                                                                                                                                if (operation_id.substring(0, 4).equals(SENDPREFIX)) {
                                                                                                                                                        executeSendBO(context);
                                                                                                                                                } else
                                                                                                                                                        if (operation_id.equals(SENDMAIL)) {
                                                                                                                                                                executeSendMail(context);
                                                                                                                                                        } else {
                                                                                                                                                                throw new ISException(UNKNOWN_OPERATION_ID + ": " + operation_id);
                                                                                                                                                        }
                        break;

                default :
                        throw new ISException(UNKNOWN_OPERATION_TYPE_ID + ": " + operation_type_id);
        }
}



/**
   * If this method is multi-thread safe, you can remove the synchronized
   * modifier to improve performance.
   */
protected void executeSendXMLMsg(OperationContext context) throws ISException {
        String input_var_processid;
        Element input_bo_msghdr;
        String input_var_msgxml;
        String output_var_commitcontext = null;
        //Element output_bo_commitcontext;
        Element output_bo_opstatus;

        // load the inputs from the OperationContext
        input_var_processid = context.getInputVariant(SENDXMLMSG_INPUT_PROCESSID);
        input_bo_msghdr = context.getInputBOElement(SENDXMLMSG_INPUT_MSGHDR);
        input_var_msgxml = context.getInputVariant(SENDXMLMSG_INPUT_MSGXML);
        if (_DEBUG) {
                System.out.println(
                        "========== executeSendXMLMsg =========\n  input_var_processid="
                                + input_var_processid
                                + "\n  input_bo_msghdr="
                                + input_bo_msghdr.toString(true)
                                + "\n  input_var_msgxml="
                                + input_var_msgxml);
        }
        // create the output Business Objects
        //output_bo_commitcontext = context.createOutputBOElement(SENDXMLMSG_OUTPUT_COMMITCONTEXT);
        output_bo_opstatus = context.createOutputBOElement(SENDXMLMSG_OUTPUT_OPSTATUS);
        output_bo_opstatus.setData("result", "success");

        // add execute code here
        try {
                output_var_commitcontext =
                        helper.executeSendMsg(
                                input_var_processid,
                                input_bo_msghdr,
                                input_var_msgxml,
                                output_bo_opstatus,
                                context.getExecutionID().getDisplayName());
        } catch (Exception e) {
                if (_DEBUG) {
                        System.out.println("\n  Error during executeSendXMLMsg: " + e.getMessage());
                        System.out.println(
                                "\n  An Exception has been logged onto Solution Manager, processId= "
                                        + input_var_processid);
                }
                output_bo_opstatus.setData("result", "failed");
        }
        //helper.executeSendMsg(input_var_processid,input_bo_msghdr,input_var_msgxml,output_bo_commitcontext,output_bo_opstatus,context.getExecutionID().getDisplayName());

        // store the output Variants in the OperationContext
        context.setOutputVariant(
                SENDXMLMSG_OUTPUT_COMMITCONTEXT,
                output_var_commitcontext);
        if (_DEBUG) {
                System.out.println("\n  output_var_commitcontext=" + output_var_commitcontext +
                //System.out.println("\n  output_bo_commitcontext="+output_bo_commitcontext.toString(true)+
                "\n  output_bo_opstatus="
                        + output_bo_opstatus.toString(true)
                        + "\n==========================================");
        }
}


/**
   * If this method is multi-thread safe, you can remove the synchronized
   * modifier to improve performance.
   */
protected void executeRecvXMLMsg(OperationContext context) throws ISException {
        String input_var_processid;
        String input_var_msgid;
        String input_var_peekonly;
        Element input_bo_msgfilter;
        Element output_bo_msghdr;
        String output_var_msgxml = null;
        String output_var_commitcontext = null;
        //Element output_bo_commitcontext;
        Element output_bo_opstatus;
        boolean peekonly = false;

        // load the inputs from the OperationContext
        input_var_processid = context.getInputVariant(RECVXMLMSG_INPUT_PROCESSID);
        input_var_msgid = context.getInputVariant(RECVXMLMSG_INPUT_MSGID);
        input_var_peekonly = context.getInputVariant(RECVXMLMSG_INPUT_PEEKONLY);
        if (input_var_peekonly != null) {
                peekonly =
                        (input_var_peekonly.compareToIgnoreCase("yes") == 0)
                                || (input_var_peekonly.compareToIgnoreCase("true") == 0)
                                || (input_var_peekonly.compareToIgnoreCase("1") == 0);
        }
        try {
                input_bo_msgfilter = context.getInputBOElement(RECVXMLMSG_INPUT_MSGFILTER);
        } catch (Exception e) {
                input_bo_msgfilter = null;
        }
        if (_DEBUG) {
                System.out.println(
                        "========== executeRecvXMLMsg =========\n  input_var_processid="
                                + input_var_processid
                                + "\n  input_var_msgid="
                                + input_var_msgid);
                if (input_bo_msgfilter == null) {
                        System.out.println("  input_bo_msgfilter=null");
                } else {
                        System.out.println("  input_bo_msgfilter=" + input_bo_msgfilter.toString(true));
                }
        }
        // create the output Business Objects
        output_bo_msghdr = context.createOutputBOElement(RECVXMLMSG_OUTPUT_MSGHDR);
        //output_bo_commitcontext = context.createOutputBOElement(RECVXMLMSG_OUTPUT_COMMITCONTEXT);
        output_bo_opstatus = context.createOutputBOElement(RECVXMLMSG_OUTPUT_OPSTATUS);
        output_bo_opstatus.setData("result", "success");

        // add execute code here
        try {
                ProcessDataInt pd =
                        helper.executeRecvMsg(
                                input_var_processid,
                                input_var_msgid,
                                peekonly,
                                input_bo_msgfilter,
                                output_bo_msghdr,
                                output_bo_opstatus);

                if ((pd.getMsgXML() == null) && (recvpollrate > 0)) {
                        context.requestRetry(recvpollrate);
                        if (_DEBUG) {
                                System.out.println(
                                        "\n  WAITING FOR MESSAGE" + "\n==========================================");
                        }
                } else {
                        // set the value of the output Variants
                        output_var_msgxml = pd.getMsgXML();
                        output_var_commitcontext = pd.getCommitContext();
                        //output_var_msgxml = helper.executeRecvMsg(input_var_processid,input_var_msgid,peekonly,input_bo_msgfilter,
                        //                 output_bo_msghdr,output_bo_commitcontext,output_bo_opstatus);

                        // store the output Variants in the OperationContext
                        context.setOutputVariant(
                                RECVXMLMSG_OUTPUT_COMMITCONTEXT,
                                output_var_commitcontext);
                        context.setOutputVariant(RECVXMLMSG_OUTPUT_MSGXML, output_var_msgxml);

                }
        } catch (Exception e) {
                if (_DEBUG) {
                        System.out.println("\n  Error during executeRecvXMLMsg: " + e.getMessage());
                        System.out.println(
                                "\n  An Exception has been logged onto Solution Manager, processId= "
                                        + input_var_processid);
                }
                output_bo_opstatus.setData("result", "failed");
        }
        if (_DEBUG) {
                System.out
                        .println(
                                "\n  output_bo_msghdr="
                                + output_bo_msghdr.toString(true)
                                + "\n  output_var_msgxml="
                                + output_var_msgxml
                                + "\n  output_var_commitcontext="
                                + output_var_commitcontext
                                +"\n  output_bo_opstatus="
                        + output_bo_opstatus.toString(true)
                        + "\n==========================================");
        }
}


   /**
   * Called when execute has already been called for this operation, but
   * execution results were inconclusive.
   *
   * Operation output values must be set in the context.The multi-thread and
   * transactional issues for execute() are the same for reExecute().
   *
   * @param context Runtime context for the operation. Container for
   * operation inputs and outputs (output values must be added by the Adapter
   * subclass implementation).
   *
   * @exception ISException Thrown if there is an error re-executing the
   * operation.
   */
   public void reExecute(OperationContext context)
         throws ISException {

         // add reExecute code here
         execute(context);
   }


   //-------------------------------------------------------------------------
   // Methods - Runtime - Event Production
   //-------------------------------------------------------------------------

   /**
   * Called to check for new IS events. Produced events must be added to the
   * EventContext.
   *
   * @param context Context for the check call, functions as container for
   * produced events.
   *
   * @exception ISException Thrown if there is an error checking for the
   * event.
   */
   public final void checkForEvents(EventContext context)
         throws ISException {

         if(_DEBUG)
         {
                System.out.println("========== checkForEvents =========");
         }
         // add event production code here
         helper.checkForEvents(context);
         if(_DEBUG)
         {
                System.out.println("\n==========================================");
         }
   }


   //-------------------------------------------------------------------------
   // Methods - Private
   //-------------------------------------------------------------------------

   /**
   * Loads values for declared properties from the AdapterContext.
   */
   private void loadAdapterProperties(AdapterContext context)
         throws ISException {

         if (context == null) {
           return;
         }

         enabletrace = context.getPropertyAsBoolean(PROP_ENABLETRACE);
         _DEBUG = enabletrace;
         explicitcommit = context.getPropertyAsBoolean(PROP_EXPLICITCOMMIT);
         destinationcomponent = context.getPropertyAsString(PROP_DESTINATIONCOMPONENT);
         protocolandversion = context.getPropertyAsString(PROP_PROTOCOLANDVERSION);
         gatewaycomponent = context.getPropertyAsString(PROP_GATEWAYCOMPONENT);
         if (context.isPropertyBound(PROP_INTERNALAPPID))
         {
           internalappid = context.getPropertyAsString(PROP_INTERNALAPPID);
           if(internalappid.compareTo("DEFAULT") == 0)
           {
             internalappid = gatewaycomponent;
           }
         }
         else
         {
           internalappid = gatewaycomponent;
         }

         if(context.isPropertyBound(PROP_EXCEPTIONLOGEXT))
         {
           exceptionlogext = context.getPropertyAsString(PROP_EXCEPTIONLOGEXT);
         }
         else
         {
           exceptionlogext = null;
         }

         partnerurl = context.getPropertyAsString(PROP_PARTNERURL);
         mqakurl = context.getPropertyAsString(PROP_MQAKURL);
         epicurl = context.getPropertyAsString(PROP_EPICURL);
         adaptmessages = context.getPropertyAsBoolean(PROP_ADAPTMESSAGES);
         recvpollrate = context.getPropertyAsInt(PROP_RECVPOLLRATE);

         if (context.isPropertyBound(PROP_MSGBODYCATEGORY))
         {
           msgbodycategory = context.getPropertyAsString(PROP_MSGBODYCATEGORY);
         }
         else
         {
           msgbodycategory = "DEFAULT";
         }
         if(_DEBUG)
         {
                System.out.println("========== loadAdapterProperties =========\n  explicitcommit="+explicitcommit+
                                "\n  destinationcomponent="+destinationcomponent+
                                "\n  protocolandversion="+protocolandversion+
                                "\n  gatewaycomponent="+gatewaycomponent+
                                "\n  internalappid="+internalappid+
                                "\n  msgbodycategory="+msgbodycategory+
                                "\n  adaptmessages="+adaptmessages+
                                "\n  exceptionlogext="+exceptionlogext+
                                "\n  explicitcommit="+explicitcommit+
                                "\n  recvpollrate="+recvpollrate+
                                "\n  partnerurl="+partnerurl+
                                "\n  mqakurl="+mqakurl+
                                "\n  epicurl="+epicurl+
                                "\n==========================================");

         }
   }


   /**
   * simply throws the <code>EndSystemNotAvailableException</code>.  Call
   * this method when connection to the end system is lost.
   *
   * @throws EndSystemNotAvailableException always
   */
   private void endSystemNotAvailable()
         throws EndSystemNotAvailableException {
         throw new EndSystemNotAvailableException();
   }


   /**
   * simply throws the <code>EndSystemNotAvailableException</code>.  Call
   * this method when connection to the end system is lost.
   *
   * @throws EndSystemNotAvailableException always
   * @param message message for the exception
   */
   private void endSystemNotAvailable(String message)
         throws EndSystemNotAvailableException {
         throw new EndSystemNotAvailableException(message);
   }


   /**
   * simply throws the <code>EndSystemNotAvailableException</code>.  Call
   * this method when connection to the end system is lost.
   *
   * @throws EndSystemNotAvailableException always
   * @param t nested exception
   */
   private void endSystemNotAvailable(Throwable t)
         throws EndSystemNotAvailableException {
         throw new EndSystemNotAvailableException(t);
   }


   /**
   * simply throws the <code>EndSystemNotAvailableException</code>.  Call
   * this method when connection to the end system is lost.
   *
   * @throws EndSystemNotAvailableException always
   * @param message message for the exception
   * @param t nested exception
   */
   private void endSystemNotAvailable(String message, Throwable t)
         throws EndSystemNotAvailableException {
         throw new EndSystemNotAvailableException(message, t);
   }


/**
   * If this method is multi-thread safe, you can remove the synchronized
   * modifier to improve performance.
   */
protected void executeCommit(OperationContext context) throws ISException {
        String input_var_processid;
        String input_var_commitcontext;
        //Element input_bo_commitcontext;
        Element output_bo_opstatus;

        // load the inputs from the OperationContext
        input_var_processid = context.getInputVariant(COMMIT_INPUT_PROCESSID);
        input_var_commitcontext = context.getInputVariant(COMMIT_INPUT_COMMITCONTEXT);
        //input_bo_commitcontext = context.getInputBOElement(COMMIT_INPUT_COMMITCONTEXT);
        if (_DEBUG) {
                System.out.println(
                        "========== executeCommit =========\n  input_var_processid="
                                + input_var_processid
                                + "\n  input_var_commitcontext="
                                + input_var_commitcontext);
                //System.out.println("========== executeCommit =========\n  input_var_processid="+input_var_processid+
                //         "\n  input_bo_commitcontext="+input_bo_commitcontext.toString(true));
        }
        // create the output Business Objects
        output_bo_opstatus = context.createOutputBOElement(COMMIT_OUTPUT_OPSTATUS);
        output_bo_opstatus.setData("result", "success");

        // add execute code here
        try {
                helper.executeCommit(
                        input_var_processid,
                        input_var_commitcontext,
                        output_bo_opstatus);
                //helper.executeCommit(input_var_processid,input_bo_commitcontext,output_bo_opstatus);
        } catch (Exception e) {
                if (_DEBUG) {
                        System.out.println(
                                "\n  Error during executeCommit: "+ e.getMessage());
                        System.out.println(
                                "\n  An Exception has been logged onto Solution Manager, processId= "+ input_var_processid);
                }
                output_bo_opstatus.setData("result", "failed");
        }
        if (_DEBUG) {
                System.out.println(
                        "\n  output_bo_opstatus="
                                + output_bo_opstatus.toString(true)
                                + "\n==========================================");
        }
}

   /**
   * Remove Data Associated with the Public Process.
   */
   protected void executeDelProcessData(OperationContext context)
         throws ISException {
         String input_var_processid;

         // load the inputs from the OperationContext
         input_var_processid = context.getInputVariant(DELPROCESSDATA_INPUT_PROCESSID);


         if(_DEBUG)
         {
                System.out.println("========== executeDelProcessData =========\n  input_var_processid="+input_var_processid);
         }
         // add execute code here
         try{
         helper.executeDelProcessData(input_var_processid);
         } catch (Exception e) {
                if (_DEBUG) {
                        System.out.println(
                                "\n  Error during executeDelProcessData: "+ e.getMessage());
                        System.out.println(
                                "\n  An Exception has been logged onto Solution Manager, processId= "+ input_var_processid);
                }
        }
         if(_DEBUG)
         {
                System.out.println("\n==========================================");
         }
   }

/**
   * Get Data Associated with the Public Process.
   */
protected void executeGetProcessData(OperationContext context)
        throws ISException {
        String input_var_processid;
        String output_var_bocorrelationid = new String();
        String output_var_tradingpartner = new String();
        ProcessDataInt pd;

        // load the inputs from the OperationContext
        input_var_processid = context.getInputVariant(GETPROCESSDATA_INPUT_PROCESSID);
        if (_DEBUG) {
                System.out.println(
                        "========== executeGetProcessData =========\n  input_var_processid="
                                + input_var_processid);
        }
        // add execute code here
        try {
                pd = helper.executeGetProcessData(input_var_processid);
                // set the value of the output Variants
                output_var_bocorrelationid = pd.getBOCorrelationID();
                output_var_tradingpartner = pd.getTradingPartner();

                // store the output Variants in the OperationContext
                context.setOutputVariant(
                        GETPROCESSDATA_OUTPUT_BOCORRELATIONID,
                        output_var_bocorrelationid);
                context.setOutputVariant(
                        GETPROCESSDATA_OUTPUT_TRADINGPARTNER,
                        output_var_tradingpartner);
        } catch (Exception e) {
                if (_DEBUG) {
                        System.out.println("\n  Error during executeGetProcessData: " + e.getMessage());
                        System.out.println(
                                "\n  An Exception has been logged onto Solution Manager, processId= "
                                        + input_var_processid);
                }

        }

        if (_DEBUG) {
                System.out.println(
                        "\n  output_var_bocorrelationid="
                                + output_var_bocorrelationid
                                + "\n  output_var_tradingpartner="
                                + output_var_tradingpartner
                                + "\n==========================================");
        }
}

   /**
   * Get the value of the PublicProcessID.
   */
   protected void executeGetPublicProcessID(OperationContext context)
         throws ISException {
         String output_var_publicprocessid = null;
         Element output_bo_opstatus;

         if(_DEBUG)
         {
                System.out.println("========== executeGetPublicProcessID =========");
         }
         // create the output Business Objects
         output_bo_opstatus = context.createOutputBOElement(GETPUBLICPROCESSID_OUTPUT_OPSTATUS);
         output_bo_opstatus.setData("result","success");



         // set the value of the output Variants
         try{
         output_var_publicprocessid = helper.executeGetPublicProcessID(context.getExecutionID().getPrivateProcessID(),output_bo_opstatus);
         } catch (Exception e) {
                if (_DEBUG) {
                        System.out.println(
                                "\n  Error during executeGetPublicProcessID: "+ e.getMessage());
                }
                output_bo_opstatus.setData("result", "failed");
        }


         // store the output Variants in the OperationContext
         context.setOutputVariant(GETPUBLICPROCESSID_OUTPUT_PUBLICPROCESSID, output_var_publicprocessid);
         if(_DEBUG)
         {
                System.out.println("\n  output_var_publicprocessid="+output_var_publicprocessid+
                                "\n  output_bo_opstatus="+output_bo_opstatus.toString(true)+
                                "\n==========================================");
         }
   }

   /**
   * If this method is multi-thread safe, you can remove the synchronized
   * modifier to improve performance.
   */
   protected void executeRecvBO(OperationContext context)
         throws ISException {
         String input_var_processid;
         String input_var_msgid;
         String input_var_peekonly;
         Element input_bo_msgfilter;
         Element output_bo_msghdr;
         Element output_bo_msgbo;
         String output_var_commitcontext = null;
         //Element output_bo_commitcontext;
         Element output_bo_opstatus;
         boolean peekonly = false;

         // load the inputs from the OperationContext
         input_var_processid = context.getInputVariant(RECVBO_INPUT_PROCESSID);
         input_var_msgid = context.getInputVariant(RECVBO_INPUT_MSGID);
         input_var_peekonly = context.getInputVariant(RECVXMLMSG_INPUT_PEEKONLY);
         if(input_var_peekonly != null)
         {
                 peekonly = (input_var_peekonly.compareToIgnoreCase("yes") == 0) ||
                          (input_var_peekonly.compareToIgnoreCase("true") == 0) ||
                          (input_var_peekonly.compareToIgnoreCase("1") == 0);
         }
         try
         {
            input_bo_msgfilter = context.getInputBOElement(RECVBO_INPUT_MSGFILTER);
         }
         catch(Exception e)
         {
                input_bo_msgfilter = null;
         }
         if(_DEBUG)
         {
                System.out.println("========== executeRecvBO =========\n  input_var_processid="+input_var_processid+
                                "\n  input_var_msgid="+input_var_msgid);
                if(input_bo_msgfilter == null)
                {
                   System.out.println("  input_bo_msgfilter=null");
                }
                else
                {
                   System.out.println("  input_bo_msgfilter="+input_bo_msgfilter.toString(true));
                }
         }
         // create the output Business Objects
         output_bo_msghdr = context.createOutputBOElement(RECVBO_OUTPUT_MSGHDR);
         output_bo_msgbo = context.createOutputBOElement(RECVBO_OUTPUT_MSGBO);
         //output_bo_commitcontext = context.createOutputBOElement(RECVBO_OUTPUT_COMMITCONTEXT);
         output_bo_opstatus = context.createOutputBOElement(RECVBO_OUTPUT_OPSTATUS);
         output_bo_opstatus.setData("result","success");

         // add execute code here
         try
         {
                StringReader msgXML;
                ProcessDataInt pd = helper.executeRecvMsg(input_var_processid,input_var_msgid,peekonly,input_bo_msgfilter,output_bo_msghdr,output_bo_opstatus);

                if( (pd.getMsgXML() == null) && (recvpollrate > 0) )
                {
                   context.requestRetry(recvpollrate);
               if(_DEBUG)
               {
                      System.out.println("\n  WAITING FOR MESSAGE"+
                                                 "\n==========================================");
               }
                }
                else
                {
                   msgXML = new StringReader(pd.getMsgXML());
                   output_var_commitcontext = pd.getCommitContext();
                   //msgXML = new StringReader(helper.executeRecvMsg(input_var_processid,input_var_msgid,peekonly,input_bo_msgfilter,output_bo_msghdr,output_bo_commitcontext,output_bo_opstatus));
                   output_bo_msgbo.getBusinessObject().fromStream(msgXML);

               // store the output Variants in the OperationContext
               context.setOutputVariant(RECVBO_OUTPUT_COMMITCONTEXT, output_var_commitcontext);
               if(_DEBUG)
               {
                      System.out.println("\n  output_bo_msghdr="+output_bo_msghdr.toString(true)+
                                                 "\n  output_bo_msgbo="+output_bo_msgbo.toString(true)+
                                                 "\n  output_var_commitcontext="+output_var_commitcontext+
                                                 //"\n  output_bo_commitcontext="+output_bo_commitcontext.toString(true)+
                                                 "\n  output_bo_opstatus="+output_bo_opstatus.toString(true)+
                                                 "\n==========================================");
               }
                }
         }
         catch(ISException e)
         {
                throw e;
         }
         catch(Exception e)
         {
                throw new ISException("executeRecvBO received exception: " + e.toString());
         }
   }

   /**
   * If this method is multi-thread safe, you can remove the synchronized
   * modifier to improve performance.
   */
   protected void executeSendBO(OperationContext context)
         throws ISException {
         String input_var_processid;
         Element input_bo_msghdr;
         Element input_bo_msgbo;
         String output_var_commitcontext = null;
         //Element output_bo_commitcontext;
         Element output_bo_opstatus;

         // load the inputs from the OperationContext
         input_var_processid = context.getInputVariant(SENDBO_INPUT_PROCESSID);
         input_bo_msghdr = context.getInputBOElement(SENDBO_INPUT_MSGHDR);
         input_bo_msgbo = context.getInputBOElement(SENDBO_INPUT_MSGBO);
         if(_DEBUG)
         {
                System.out.println("========== executeSendBO =========\n  input_var_processid="+input_var_processid+
                                "\n  input_bo_msghdr="+input_bo_msghdr.toString(true)+
                                "\n  input_bo_msgbo="+input_bo_msgbo.toString(true));
         }
         // create the output Business Objects
         //output_bo_commitcontext = context.createOutputBOElement(SENDBO_OUTPUT_COMMITCONTEXT);
         output_bo_opstatus = context.createOutputBOElement(SENDBO_OUTPUT_OPSTATUS);
         output_bo_opstatus.setData("result","success");

         // add execute code here
         try
         {
                StringWriter msgXML = new StringWriter();

                input_bo_msgbo.getBusinessObject().toStream(msgXML);
                output_var_commitcontext = helper.executeSendMsg(input_var_processid,input_bo_msghdr,msgXML.toString(),output_bo_opstatus,context.getExecutionID().getDisplayName());
                //helper.executeSendMsg(input_var_processid,input_bo_msghdr,msgXML.toString(),output_bo_commitcontext,output_bo_opstatus,context.getExecutionID().getDisplayName());
         }
         catch(ISException e)
         {
                throw e;
         }
         catch(Exception e)
         {
                throw new ISException("executeSendBO received exception: " + e.toString());
         }

         // store the output Variants in the OperationContext
         context.setOutputVariant(SENDBO_OUTPUT_COMMITCONTEXT, output_var_commitcontext);
         if(_DEBUG)
         {
                System.out.println("\n  output_var_commitcontext="+output_var_commitcontext+
                //System.out.println("\n  output_bo_commitcontext="+output_bo_commitcontext.toString(true)+
                                "\n  output_bo_opstatus="+output_bo_opstatus.toString(true)+
                                "\n==========================================");
         }
   }

   /**
   * Set Data Associated with the Public Process.
   */
   protected void executeSetProcessData(OperationContext context)
         throws ISException {
         String input_var_processid;
         String input_var_bocorrelationid;
         String input_var_tradingpartner;
         ProcessData pd;

         // load the inputs from the OperationContext
         input_var_processid = context.getInputVariant(SETPROCESSDATA_INPUT_PROCESSID);
         input_var_bocorrelationid = context.getInputVariant(SETPROCESSDATA_INPUT_BOCORRELATIONID);
         input_var_tradingpartner = context.getInputVariant(SETPROCESSDATA_INPUT_TRADINGPARTNER);
         if(_DEBUG)
         {
                System.out.println("========== executeSetProcessData =========\n  input_var_processid="+input_var_processid+
                                "\n  input_var_bocorrelationid="+input_var_bocorrelationid+
                                "\n  input_var_tradingpartner="+input_var_tradingpartner);
         }
         pd = new ProcessData(input_var_bocorrelationid,input_var_tradingpartner);
         // add execute code here
         helper.executeSetProcessData(input_var_processid,pd);
         if(_DEBUG)
         {
                System.out.println("\n==========================================");
         }
   }

/**
        * If this method is multi-thread safe, you can remove the synchronized
        * modifier to improve performance.
        */
protected synchronized void executeLogException(OperationContext context)
        throws ISException {
        String input_var_subcomponent;
        String input_var_processid;
        String input_var_logmessage;
        String input_var_exceptionid;
        String input_var_processname;
        String input_var_extdata;
        Element output_bo_opstatus;

        // load the inputs from the OperationContext
        input_var_processid = context.getInputVariant(LOGEXCEPTION_INPUT_PROCESSID);
        input_var_subcomponent =
                context.getInputVariant(LOGEXCEPTION_INPUT_SUBCOMPONENT);
        input_var_logmessage = context.getInputVariant(LOGEXCEPTION_INPUT_LOGMESSAGE);
        input_var_exceptionid = context.getInputVariant(LOGEXCEPTION_INPUT_EXCEPTIONID);
        input_var_processname = context.getInputVariant(LOGEXCEPTION_INPUT_PROCESSNAME);
        input_var_extdata = context.getInputVariant(LOGEXCEPTION_INPUT_EXTDATA);
        // create the output Business Objects
        output_bo_opstatus = context.createOutputBOElement(SENDXMLMSG_OUTPUT_OPSTATUS);
        output_bo_opstatus.setData("result", "success");
        if (_DEBUG) {
                System.out.println(
                        "========== executeSendBO =========\n  input_var_processid="
                                + input_var_processid
                                + "\n  input_var_subcomponent="
                                + input_var_subcomponent
                                + "\n  input_var_logmessage="
                                + input_var_logmessage
                                + "\n  input_var_exceptionid="
                                + input_var_exceptionid
                                + "\n  input_var_processname="
                                + input_var_processname
                                + "\n  input_var_extdata="
                                + input_var_extdata);
        }

        // add execute code here
        try {
                helper.executeLogException(
                        input_var_processid,
                        input_var_subcomponent,
                        input_var_logmessage,
                        input_var_exceptionid,
                        input_var_processname,
                        input_var_extdata,
                        output_bo_opstatus);
        } catch (Exception e) {
                if (_DEBUG) {
                        System.out.println(
                                "\n  Error during executeLogException: " + e.getMessage());
                }
                output_bo_opstatus.setData("result", "failed");
        }
        if (_DEBUG) {
                System.out.println("\n==========================================");
        }
}

        /**
         * Exception logging extension class name.  (Must implement the
         * MQAOExceptionLogExt)
         */
        protected String exceptionlogext;
        protected static final String LOGEXCEPTION_INPUT_EXTDATA = "ExtData";
        protected static final String PROP_EXCEPTIONLOGEXT = "ExceptionLogExt";
        protected static final String PROP_RECVPOLLRATE = "RecvPollRate";
        /**
         * Poll rate for receiving of messages.  Set to 0 for asynchronous message
         * reception - only works with PAM.
         */
        protected int recvpollrate;
/**
   * If this method is multi-thread safe, you can remove the synchronized
   * modifier to improve performance.
   */
protected void executeAuditLog(OperationContext context) throws ISException {
        String input_var_audit_content;

        //Element input_bo_commitcontext;
        Element output_bo_opstatus;

        // create the output Business Objects
        output_bo_opstatus = context.createOutputBOElement(AUDIT_OUTPUT_OPSTATUS);

        // load the inputs from the OperationContext
        input_var_audit_content = context.getInputVariant(AUDIT_LOG_CONTENT);

        if (_DEBUG) {
                System.out.println(
                        "========== executeAuditLog =========\n  input_var_audit_content= "
                                + input_var_audit_content);

        }

        //callding helper method to do audit logging
        helper.executeAuditLog(input_var_audit_content, output_bo_opstatus);

        if (_DEBUG) {
                System.out.println(
                        "\n  output_bo_opstatus="
                                + output_bo_opstatus.toString(true)
                                + "\n==========================================");
        }
}
protected void executeBuyerAuthentication(OperationContext context)
        throws ISException {
        String input_var_buyerId;

        //Element input_bo_commitcontext;
        Element output_bo_opstatus;

        // load the inputs from the OperationContext
        input_var_buyerId = context.getInputVariant(BUYER_IDENTIFIER);

        if (_DEBUG) {
                System.out.println(
                        "========== executeBuyerAuthentication =========\n  input_variant_buyer_identifier="
                                + input_var_buyerId);

        }

        String base = "o=b2bgateway";
        String filter ="ePICTPId="+input_var_buyerId;
                // create the output Business Objects
        output_bo_opstatus = context.createOutputBOElement(BUYER_AUTH_OUTPUT_OPSTATUS);

        helper.executeBuyerAuthentication(base, filter, output_bo_opstatus);

        if (_DEBUG) {
                System.out.println(
                        "\n  output_bo_opstatus="
                                + output_bo_opstatus.toString(true)
                                + "\n==========================================");
        }
}
protected void executeEncryptPCardNumber(OperationContext context)
        throws ISException {
        if (_DEBUG) {
                System.out.println("===============================");
                System.out.println("Start executeEncryptPCardNumber \n");
        }
        String inputNumber = (String) context.getInput(PCARDNUM);
        Element output_bo_opstatus =
                context.createOutputBOElement(ENCRYPT_OUTPUT_OPSTATUS);

        String outputNumber =
                helper.executeEncryptPCard(inputNumber, output_bo_opstatus);

        context.setOutputVariant(CRPTONUM, outputNumber);
        if (_DEBUG) {
                System.out.println(
                        "\n  outputNumber="
                                + outputNumber
                                + "\n  output_bo_opstatus="
                                + output_bo_opstatus.toString(true)
                                + "\n==========================================");
        }
}
private void executeReadProperties(OperationContext context) throws ISException{
         if(_DEBUG)
         {
                System.out.println("========== executeReadProperties =========\n");

         }
         String processId = (String) context.getInput(PROCESS_ID);
         String baseFileName = (String) context.getInput(PROPERTY_FILENAME);
         String language = (String) context.getInput(LANG);
         String cntryCode = (String) context.getInput(COUNTRY_CODE);
         String respStatusId = (String) context.getInput(RESPONSE_STATUS);

        Vector resp = helper.executeReadResponseProperties(processId, baseFileName, language, cntryCode, respStatusId);
        if(resp != null){

        context.setOutputVariant(RESPONSE_CODE, (String)resp.elementAt(0));
        context.setOutputVariant(RESPONSE_TEXT,  (String)resp.elementAt(1));
        context.setOutputVariant(RESPONSE_DATA,  (String)resp.elementAt(2));

        }
        else{
        context.setOutputVariant(RESPONSE_CODE, "");
        context.setOutputVariant(RESPONSE_TEXT, "");
        context.setOutputVariant(RESPONSE_DATA, "");

                }

         if(_DEBUG)
         {
                System.out.println(resp.toString());
                System.out.println("========== executeReadProperties =========\n");
         }

}

                                                                           /**
 * Insert the method's description here.
 * Creation date: (3/4/2002 10:45:11 AM)
 */
public void executeCardCheck(OperationContext context) throws ISException{
         Boolean isValid = Boolean.FALSE;
         if(_DEBUG)
         {
                System.out.println("========= start executeCardCheck ================ \n");
         }
                String cardNumber = (String) context.getInput(CARD_NUMBER);
                if(cardNumber.length() > 0)
                {
                        isValid = new Boolean(helper.executeCardCheck(cardNumber));
                        context.setOutputVariant(IS_CARD_VALID, isValid.toString());
                }

         if(_DEBUG)
         {
                System.out.println("========= end executeCardCheck ================ \n");
         }

}
   /* If this method is multi-thread safe, you can remove the synchronized
   * modifier to improve performance.
   */
protected void executeGetAdminUserEmailAddr(OperationContext context)
        throws ISException {

        //Element input_bo_commitcontext;
        Element output_bo_opstatus;
        // create the output Business Objects
        output_bo_opstatus = context.createOutputBOElement(ADMIN_EMAIL_OUTPUT_OPSTATUS);

        //output email address variant
        String output_email_addr = null;

        if (_DEBUG) {
                System.out.println("========== executeGetAdminUserEmailAddr =========\n ");

        }
        String dn= "cn=Admin,ou=SystemAdministration,o=b2bgateway";
        String attrid = "mail";

        //calling helper method to retrieve the email address
        output_email_addr = helper.executeGetAdminUserEmailAddr(dn, attrid, output_bo_opstatus);


        context.setOutputVariant(ADMIN_EMAIL_ADDR, output_email_addr);

        if (_DEBUG) {
                System.out.println(
                        "\n  output_bo_opstatus="
                                + output_bo_opstatus.toString(true)
                                + "\n output_email_addr= "
                                + output_email_addr
                                + "\n==========================================");
        }
}
        protected static final String ADMIN_EMAIL_OUTPUT_OPSTATUS = "OPStatus"; protected static final String AUDIT_OUTPUT_OPSTATUS = "OPStatus";       protected static final String BUYER_AUTH_OUTPUT_OPSTATUS = "OPStatus";  protected static final String ENCRYPT_OUTPUT_OPSTATUS = "OPStatus";   protected static final String MAILSERVER = "mailserver";   protected static final String PAM_CFG_PROPERTIES = "PAMConfig";   protected static final String PROCESS_ID = "ProcessID";   protected static final String SEND_MAIL_TYPE = "MessageType";   // "Send Mail" constants
   protected static final String SENDMAIL ="sendMail";/**
 * This method will send e-mail based on the message type.
 * Creation date: (3/6/2002 10:23:38 AM)
 * @param msgType java.lang.String
 */


public void executeSendMail(OperationContext context) throws ISException
{
        if(_DEBUG)
         {
                System.out.println("========== executeSendMail =========\n");
         }

         //Element input_bo_commitcontext;
         Element output_bo_opstatus;
         String errorCode = "";

         String recipients = "";
         String sender = "";
         String subject = "";
         String msgText = "";
         java.util.ResourceBundle bundle;

         boolean sendResult = false;

         // retrieve type from context
         String msgType = (String) context.getInput(SEND_MAIL_TYPE);
         String processId = (String) context.getInput(PROCESS_ID);

         try{

                // get property information
                bundle = ResourceBundle.getBundle(PAM_CFG_PROPERTIES);
                String mailserver = bundle.getString(MAILSERVER);
                if(msgType.equalsIgnoreCase("LDAP_FAIL"))
                {
                        // retrieve info from properties file
                        recipients = bundle.getString("LDAP_FAIL_ADMIN_LIST");
                        subject = bundle.getString("LDAP_FAIL_SUBJECT");
                        msgText = bundle.getString("LDAP_FAIL_TEXT");
                        sender = bundle.getString("sender");

                        // send the mail and record the results
                        sendResult = helper.executeSendMail(processId, mailserver, recipients, sender, subject, msgText);
                        errorCode = (sendResult) ? "success" : "fail";
                }
        }catch(Exception e){
                errorCode = "fail";
        }

         // create the output Business Objects
         output_bo_opstatus = context.createOutputBOElement(COMMIT_OUTPUT_OPSTATUS);
         output_bo_opstatus.setData("result",errorCode);

        if(_DEBUG)
         {
                System.out.println("========== executeSendMail =========\n");
         }
}/**
 * Insert the method's description here.
 * Creation date: (3/13/2002 1:29:52 PM)
 * @param context com.extricity.adapter.api.OperationContext
 */
protected void executeSendXMLMsgWithCardSuffix(OperationContext context)
        throws ISException {

        String input_var_processid;
        Element input_bo_msghdr;
        String input_var_msgxml;
        String input_cardnum = null;
        String output_var_commitcontext = null;
        //Element output_bo_commitcontext;
        Element output_bo_opstatus;

        // load the inputs from the OperationContext
        input_var_processid = context.getInputVariant(SENDXMLMSG_INPUT_PROCESSID);
        input_bo_msghdr = context.getInputBOElement(SENDXMLMSG_INPUT_MSGHDR);
        input_var_msgxml = context.getInputVariant(SENDXMLMSG_INPUT_MSGXML);
        input_cardnum = context.getInputVariant(SENDXMLMSG_INPUT_CARDNUM);

        int i = input_var_msgxml.indexOf("</Payment>");
        String pre = input_var_msgxml.substring(0, i + 10);
        String post = input_var_msgxml.substring(i + 10);
        String middle =
                SENDXML_EXTRINSIC_OPEN
                        + input_cardnum.substring(input_cardnum.length() - 4, input_cardnum.length())
                        + SENDXML_EXTRINSIC_CLOSE;
        String new_msgxml = pre + middle + post;

        input_var_msgxml = new_msgxml;

        if (_DEBUG) {
                System.out.println(
                        "========== executeSendXMLMsgWithCardSuffix =========\n  input_var_processid="
                                + input_var_processid
                                + "\n  input_bo_msghdr="
                                + input_bo_msghdr.toString(true)
                                + "\n  input_var_msgxml="
                                + input_var_msgxml);
        }
        // create the output Business Objects
        //output_bo_commitcontext = context.createOutputBOElement(SENDXMLMSG_OUTPUT_COMMITCONTEXT);
        output_bo_opstatus = context.createOutputBOElement(SENDXMLMSG_OUTPUT_OPSTATUS);
        output_bo_opstatus.setData("result", "success");

        // add execute code here
        try {
                output_var_commitcontext =
                        helper.executeSendMsg(
                                input_var_processid,
                                input_bo_msghdr,
                                input_var_msgxml,
                                output_bo_opstatus,
                                context.getExecutionID().getDisplayName());
                //helper.executeSendMsg(input_var_processid,input_bo_msghdr,input_var_msgxml,output_bo_commitcontext,output_bo_opstatus,context.getExecutionID().getDisplayName());
        } catch (Exception e) {
                if (_DEBUG) {
                        System.out.println("\n  Error during executeSendXMLMsgWithCardSuffix: " + e.getMessage());
                        System.out.println(
                                "\n  An Exception has been logged onto Solution Manager, processId= "
                                        + input_var_processid);
                }
                output_bo_opstatus.setData("result", "failed");
        }

        // store the output Variants in the OperationContext
        context.setOutputVariant(
                SENDXMLMSG_OUTPUT_COMMITCONTEXT,
                output_var_commitcontext);
        if (_DEBUG) {
                System.out.println("\n  output_var_commitcontext=" + output_var_commitcontext +
                //System.out.println("\n  output_bo_commitcontext="+output_bo_commitcontext.toString(true)+
                "\n  output_bo_opstatus="
                        + output_bo_opstatus.toString(true)
                        + "\n==========================================");
        }
}}
