package com.ibm.extricity.adapters.mqseries.mqak;

/**
 * MQAOAdapterHelperInt.java 1.010/14/2000
 *
 * This interface is used to define the Extricity MQAK Adapter functions
 *
 * OCO Source Materials
 *
 * 5799-RNK
 *
 * (C) Copyright IBM Corp. 2000
 *
 * The source code for this program is not published
 * or otherwise divested of its trade secrets,
 * irrespective of what has been deposited with the
 * U. S. Copyright Office.
 *
 * @author Thomas W. Jaworski
**/

import java.util.*;

import com.extricity.adapter.api.*;
import com.extricity.document.api.*;

import com.extricity.engine.mgr.runtime.priv.PrivateProcessID;
import CRStation.defs.machine.ProcessID;

import com.ibm.epic.adapters.eak.mcs.*;
import com.ibm.epic.adapters.eak.nativeadapter.*;
import com.ibm.epic.adapters.eak.common.AdapterException;

public interface MQAOAdapterHelperInt {
                public void checkForEvents(EventContext context)
                throws com.extricity.adapter.api.ISException;
        public void executeCommit(
                String processID,
                String i_commitcontext,
                Element o_opstatus)
                throws com.extricity.adapter.api.ISException;
        public void executeDelProcessData(String processID)
                throws com.extricity.adapter.api.ISException;
        public ProcessDataInt executeGetProcessData(String processID)
                throws com.extricity.adapter.api.ISException;
        public String executeGetPublicProcessID(
                String prvProcIDStr,
                Element o_opstatus)
                throws com.extricity.adapter.api.ISException;
        public ProcessDataInt executeRecvMsg(
                String processID,
                String i_msgid,
                boolean peekonly,
                Element i_msgfilter,
                Element o_msghdr,
                Element o_opstatus)
                throws com.extricity.adapter.api.ISException;
        public String executeSendMsg(
                String processID,
                Element i_msghdr,
                String i_msgxml,
                Element o_opstatus,
                String uniqueID)
                throws com.extricity.adapter.api.ISException;
        public void executeSetProcessData(String processID, ProcessDataInt pd)
                throws com.extricity.adapter.api.ISException;
        public void shutdown() throws com.extricity.adapter.api.ISException;

        public void executeLogException(
                String processID,
                String subComponent,
                String logMessage,
                String exceptionId,
                String processName,
                String extData,
                Element opStatus)
                throws com.extricity.adapter.api.ISException;

        public void startup(
                String gatewaycomp,
                String internalappid,
                String destcomp,
                String protandver,
                String msgbodycat,
                String exceptionlogext,
                boolean debug,
                boolean expcommit,
                boolean adaptmessages,
                int recvpollrate)
                throws com.extricity.adapter.api.ISException;

        public String executeEncryptPCard(String pCard, Element o_opstatus)
                throws com.extricity.adapter.api.ISException;

        public void executeBuyerAuthentication(
                String base,
                String filter,
                Element o_opstatus)
                throws com.extricity.adapter.api.ISException;

        public String executeGetAdminUserEmailAddr(
                String base,
                String attrId,
                Element o_opstatus)
                throws com.extricity.adapter.api.ISException;

        public void executeAuditLog(String auditContent, Element o_opstatus)
                throws com.extricity.adapter.api.ISException;

/**
 * Insert the method's description here.
 * Creation date: (3/7/2002 10:25:02 AM)
 * @param cardnumber java.lang.String
 * @param o_opstatus com.extricity.document.api.Element
 */
public boolean executeCardCheck(String cardnumber) throws com.extricity.adapter.api.ISException;        public Vector executeReadResponseProperties(String processID, String basefile, String lang, String ctry, String status)
        throws com.extricity.adapter.api.ISException;public boolean executeSendMail(String processID, String mailserver, String recipient, String sender, String subject, String msgtext) throws com.extricity.adapter.api.ISException;}
