package com.ibm.extricity.adapters.mqseries.mqak;

/**
 * MQAOAdapterHelper.java 1.0   10/6/2000
 *
 * This class is used to perform the Extricity MQAK Adapter functions
 *
 * OCO Source Materials
 *
 * 5799-RNK
 *
 * (C) Copyright IBM Corp. 2000
 *
 * The source code for this program is not published
 * or otherwise divested of its trade secrets,
 * irrespective of what has been deposited with the
 * U. S. Copyright Office.
 *
 * @author Thomas W. Jaworski
**/

import java.util.*;

import com.extricity.adapter.api.*;
import com.extricity.document.api.*;

import com.extricity.engine.mgr.runtime.priv.PrivateProcessID;
import CRStation.defs.machine.ProcessID;

import com.ibm.epic.adapters.eak.mcs.*;
import com.ibm.epic.adapters.eak.nativeadapter.*;
import com.ibm.epic.adapters.eak.common.AdapterException;

import com.ibm.epic.LogTrace.*;

import javax.mail.internet.*;import javax.mail.*;import com.ibm.misc.*;import javax.naming.directory.*;import javax.naming.*;import com.ibm.dk.NTF.psg.PSGCCEncryption;public class MQAOAdapterHelper
        extends com.extricity.ibm.process.ProcessCompletionNotification
        implements MQAOAdapterHelperInt, Runnable {
        private String gatewayComp = "GATEWAY";
        private String destComp = "BFM";
        private String protAndVer = "UNKNOWN";
        private String msgBodyCategory = "DEFAULT";

        protected static boolean _DEBUG = true;

        protected boolean expCommit = true;

        // State connection
        //private EpicNativeAdapter stateENA = null;

        // Connection pool
        private Vector poolENA = new Vector();

        // Process locked connections
        private Hashtable lockedENA = new Hashtable();

        private boolean isFirst = true;

        // Event list
        private Vector termEvents = new Vector();

/**
 * MQAOAdapterHelper constructor.
 */
public MQAOAdapterHelper()
{
   super();
}

/**
 * Insert the method's description here.
 * Creation date: (11/20/00 6:10:43 PM)
 * @param processID CRStation.defs.machine.ProcessID
 */
public void addEvent(String processID)
{
   try
   {
          ProcessData pd = (ProcessData)executeGetProcessData(processID);
          if(pd.getBOCorrelationID() != null)
          {
                 synchronized(termEvents)
                 {
                        termEvents.add(processID);
                 }
                 if(_DEBUG)
                 {
                        System.out.println("  addEvent Completion Event Added ProcessID="+processID+
                                                 " ProcessData="+pd.toString());
                 }
          }
          else if(_DEBUG)
          {
                 System.out.println("  addEvent Process Not Found ProcessID="+processID);
          }
   }
   catch(ISException e)
   {
          System.out.println("  addEvent received exception: "+e.toString());
   }
}

/**
 * Check for process start message.
 * Creation date: (10/6/00 3:11:27 PM)
 * @param context com.extricity.adapter.api.EventContext
 * @exception com.extricity.adapter.api.ISException The exception description.
 */
public void checkForEvents(EventContext context)
   throws com.extricity.adapter.api.ISException
{
   if(_DEBUG)
   {
          System.out.println("checkForEvents");
   }
   // Make sure that processes get to re-start first before we start checking for new process start messages
   if(isFirst)
   {
          isFirst = false;
          if(_DEBUG)
          {
                 System.out.println("  checkForEvents SKIPPED");
          }
          return;
   }

   EpicNativeAdapter theENA = getEpicNativeAdapter("ProcessID=DSIPATCHER");
   ENAService theENAServ = new ENAService();
   theENAServ.setApplicationName(gatewayComp);
   theENAServ.setBodyCategory(msgBodyCategory);
   theENAServ.setBodyType("DEFAULT");
   EpicMessageExt theEM;

   // Peek a message for a specific process
   theENAServ.setPeekOnly(true);
   theENAServ.addFilter(theENAServ.FILTERNAME_LMS_CORRELATION_ID,EpicMessageExt.NO_EXTRICITYPROCESSID);
   //theENAServ.addFilter(theENAServ.FILTERNAME_LMS_CORRELATION_ID,"Wed Oct 25 10:41:51 EDT ");
   theENAServ.setTimout(0);
   try
   {
          theENA.begin();
          theEM = (EpicMessageExt)theENA.receiveMsg(theENAServ);
   }
   catch(AdapterException e)
   {
          // Return the ENA to pool
          retEpicNativeAdapter(theENA);

          logException("ProcessID=DSIPATCHER","Adapter",e.toString(),ADAPTER_EXCEPTION,"NONE");
          throw new ISException(e.toString());
   }
   if(theEM != null)
   {
          if(_DEBUG)
          {
                 System.out.println("  checkForEvents: theEM(MsgID="+theEM.getLMSMessageID()+"): " + theEM.toString());
          }
          context.addVariantEvent(MQAOAdapterImp.EVENT_PIP_START, theEM.getLMSMessageID(), "IBM Extricity MQAK Adapter");
   }
   else if(_DEBUG)
   {
          System.out.println("  checkForEvents: NO-EVENT-MESSAGE");
   }
   synchronized(termEvents)
   {
          while(!termEvents.isEmpty())
          {
                 String eventProcessId = (String)termEvents.remove(0);
                 context.addVariantEvent(MQAOAdapterImp.EVENT_PROCESS_END, eventProcessId, "IBM Extricity MQAK Adapter");
                 if(_DEBUG)
                 {
                        System.out.println("  checkForEvents: Process Complete Event ProcessId="+eventProcessId);
                 }
          }
   }
   // Return the ENA to pool
   retEpicNativeAdapter(theENA);
}



/**
 * Insert the method's description here.
 * Creation date: (10/16/00 4:38:19 PM)
 * @param processID String - Extricity public process id
 * @param i_commitcontext com.extricity.document.api.Element
 * @param o_opstatus com.extricity.document.api.Element
 * @exception com.extricity.adapter.api.ISException The exception description.
 */
public void executeCommit(String processID, String i_commitcontext, Element o_opstatus)
   throws com.extricity.adapter.api.ISException
{
   EpicNativeAdapter theENA = null;

   if(_DEBUG)
   {
          System.out.println("executeCommit:\n  processID="+processID+"\n  i_commitcontext="+i_commitcontext+"");
   }
   // Check if it is a send
   if(i_commitcontext.startsWith("_COMMIT_"))
   {
          // Get a native adapter
          theENA = getEpicNativeAdapter(processID);
          // Find the message on the _STATE_ queue based on the commit context and remove it
          ENAService theENAServ = new ENAService();
          theENAServ.setApplicationName(internalAppId);
          theENAServ.setBodyCategory("_STATE_");
          theENAServ.setBodyType("_STATE_");
          // Receive a message for a specific Correlation ID
          theENAServ.addFilter(theENAServ.FILTERNAME_LMS_CORRELATION_ID,EpicMessageExt.encodeLMSCorrelationID(i_commitcontext));
          theENAServ.setTimout(0);
          // Do the receive
          try
          {
                 theENA.begin();
                 if(theENA.receiveMsg(theENAServ) == null)
                 {
                        if(_DEBUG)
                        {
                           System.out.println("  executeCommit (SEND) NO-MESSAGE-MEETING-CRITERIA");
                        }
                 }
          }
          catch(AdapterException e)
          {
                 // Return the ENA to pool
                 retEpicNativeAdapter(theENA);

                 logException(processID,"Adapter",e.toString(),ADAPTER_EXCEPTION,"NONE");
                 throw new ISException(e.toString());
          }
   }
   // It's a receive
   else
   {
          // Detect re-start
          theENA = restEpicNativeAdapter(processID);
          if(theENA == null)
          {
                 // Get an ENA to work with
                 theENA = getEpicNativeAdapter(processID);
                 // Find the message on the queue based on the commit context and remove it
                 ENAService theENAServ = new ENAService(gatewayComp,msgBodyCategory,"DEFAULT");
                 // Receive a message for a specific LMS Message ID
                 theENAServ.addFilter(theENAServ.FILTERNAME_LMS_MESSAGE_ID,i_commitcontext);
                 theENAServ.setTimout(0);
                 // Do the receive
                 try
                 {
                        theENA.begin();
                        if(theENA.receiveMsg(theENAServ) != null)
                        {
                           if(_DEBUG)
                           {
                                  System.out.println("  executeCommit (RECV) DUPLICATE-MESSAGE-DELETED");
                           }
                        }
                 }
                 catch(AdapterException e)
                 {
                        // Return the ENA to pool
                        retEpicNativeAdapter(theENA);

                        logException(processID,"Adapter",e.toString(),ADAPTER_EXCEPTION,"NONE");
                        throw new ISException(e.toString());
                 }
          }
   }
   // Do the commit
   commit(processID,theENA);

   // Return the ENA to pool
   retEpicNativeAdapter(theENA);
}

/**
 * Insert the method's description here.
 * Creation date: (11/6/00 2:12:19 PM)
 * @return com.ibm.extricity.adapters.mqseries.mqak.ProcessData
 * @param processID java.lang.String
 */
public void executeDelProcessData(String processID)
   throws com.extricity.adapter.api.ISException
{
   EpicNativeAdapter theENA = getEpicNativeAdapter(processID);
   ENAService theENAServ = new ENAService();
   theENAServ.setApplicationName(internalAppId);
   theENAServ.setBodyCategory("_STATE_");
   theENAServ.setBodyType("_STATE_");
   EpicMessageExt theEM;

   if(_DEBUG)
   {
          System.out.println("executeDelProcessData:\n  processID="+processID);
   }
   // Receive a message for a specific process
   theENAServ.addFilter(theENAServ.FILTERNAME_LMS_CORRELATION_ID,EpicMessageExt.encodeLMSCorrelationID(processID));
   theENAServ.setTimout(0);
   // Do the remove
   try
   {
          theENA.begin();
          theEM = (EpicMessageExt)theENA.receiveMsg(theENAServ);
          theENA.commit();
          if(_DEBUG && (theEM == null))
          {
                 System.out.println("  executeDelProcessData NO-MESSAGE-MEETING-CRITERIA");
          }
   }
   catch(AdapterException e)
   {
          // Return the ENA to pool
          retEpicNativeAdapter(theENA);

          logException(processID,"Adapter",e.toString(),ADAPTER_EXCEPTION,"NONE");
          throw new ISException(e.toString());
   }
   // Return the ENA to pool
   retEpicNativeAdapter(theENA);
}

/**
 * Insert the method's description here.
 * Creation date: (11/6/00 2:12:19 PM)
 * @return com.ibm.extricity.adapters.mqseries.mqak.ProcessData
 * @param processID java.lang.String
 */
public ProcessDataInt executeGetProcessData(String processID)
   throws com.extricity.adapter.api.ISException
{
   EpicNativeAdapter theENA = getEpicNativeAdapter(processID);
   ENAService theENAServ = new ENAService();
   theENAServ.setApplicationName(internalAppId);
   theENAServ.setBodyCategory("_STATE_");
   theENAServ.setBodyType("_STATE_");
   EpicMessageExt theEM;
   ProcessData pd = new ProcessData();

   if(_DEBUG)
   {
          System.out.println("executeGetProcessData:\n  processID="+processID);
   }
   // Peek a message for a specific process
   theENAServ.addFilter(theENAServ.FILTERNAME_LMS_CORRELATION_ID,EpicMessageExt.encodeLMSCorrelationID(processID));
   theENAServ.setPeekOnly(true);
   theENAServ.setTimout(0);
   // Do the peek
   try
   {
          theEM = (EpicMessageExt)theENA.receiveMsg(theENAServ);
          if(theEM == null)
          {
                 if(_DEBUG)
                 {
                        System.out.println("  executeDelProcessData NO-MESSAGE-MEETING-CRITERIA");
                 }
          }
          else
          {
                 pd.setBOCorrelationID(theEM.getBOCorrelationID());
                 pd.setTradingPartner(theEM.getDstTradingPartnerID());
                 if(_DEBUG)
                 {
                        System.out.println("  executeGetProcessData ProcessData="+pd.toString());
                 }
          }
   }
   catch(AdapterException e)
   {
          // Return the ENA to pool
          retEpicNativeAdapter(theENA);

          logException(processID,"Adapter",e.toString(),ADAPTER_EXCEPTION,"NONE");
          throw new ISException(e.toString());
   }

   // Return the ENA to pool
   retEpicNativeAdapter(theENA);

   return pd;
}

/**
 * Insert the method's description here.
 * Creation date: (10/25/00 9:51:13 AM)
 * @return java.lang.String
 * @param prvProcID java.lang.String
 */
public String executeGetPublicProcessID(String prvProcIDStr, Element o_opstatus)
   throws com.extricity.adapter.api.ISException
{
   PrivateProcessID prvProcID = new PrivateProcessID();
   try
   {
          prvProcID.fromString(prvProcIDStr);
   }
   catch(Throwable e)
   {
          logException("ProcessID=UNKONWN","Adapter",e.toString(),ADAPTER_EXCEPTION,"NONE");
          throw new ISException(e.toString());
   }
   if(_DEBUG)
   {
          System.out.println("executeGetPublicProcessID:  PubProcessId="+prvProcID.getPublicProcessID().toString());
   }
   //System.out.println("prvProcID.getPublicProcessID().getID()="+prvProcID.getPublicProcessID().getID()+
   //           "\nprvProcID.getPublicProcessID().getProcessDefID()="+prvProcID.getPublicProcessID().getProcessDefID()+
   //           "\nprvProcID.getPublicProcessID().getDisplayName()="+prvProcID.getPublicProcessID().getDisplayName());
   return prvProcID.getPublicProcessID().getDisplayName();
}

/**
 * Insert the method's description here.
 * Creation date: (10/16/00 4:40:24 PM)
 * @return java.lang.String
 * @param processID String - Extricity public process id
 * @param i_msgid String - LMS Message ID
 * @param i_msgfilter com.extricity.document.api.Element
 * @param o_msghdr com.extricity.document.api.Element
 * @param o_commitcontext com.extricity.document.api.Element
 * @param o_opstatus com.extricity.document.api.Element
 * @exception com.extricity.adapter.api.ISException The exception description.
 */
public ProcessDataInt executeRecvMsg(String processID, String i_msgid,boolean peekonly, Element i_msgfilter, Element o_msghdr, Element o_opstatus)
   throws com.extricity.adapter.api.ISException
{
   EpicNativeAdapter theENA = getEpicNativeAdapter(processID);
   ENAService theENAServ = new ENAService();
   theENAServ.setApplicationName(gatewayComp);
   theENAServ.setBodyCategory(msgBodyCategory);
   theENAServ.setBodyType("DEFAULT");
   EpicMessageExt theEM;
   ProcessData pd = new ProcessData();

   if(_DEBUG)
   {
          System.out.println("executeRecvMsg:\n  processID="+processID+"\n  MsgID="+i_msgid);
   }
   // Are we requesting a specific message
   if(i_msgid == null)
   {
          if(_DEBUG)
          {
                 System.out.println("  executeRecvMsg CorID="+processID);
          }
          // Receive a message for a specific process
          theENAServ.addFilter(theENAServ.FILTERNAME_LMS_CORRELATION_ID,EpicMessageExt.encodeLMSCorrelationID(processID));
   }
   else
   {
          if(_DEBUG)
          {
                 System.out.println("  executeRecvMsg MsgID="+i_msgid);
          }
          // Receive a message for a specific LMS Message ID
          theENAServ.addFilter(theENAServ.FILTERNAME_LMS_MESSAGE_ID,i_msgid);
   }
   theENAServ.setPeekOnly(peekonly);
   if(recvPollRate > 0)
   {
          // Check for 1 second
          theENAServ.setTimout(1000);
   }
   // Do the receive
   try
   {
          theENA.begin();
          do
          {
                 theEM = (EpicMessageExt)theENA.receiveMsg(theENAServ);
                 if(_DEBUG && (theEM == null))
                 {
                        System.out.println("  executeRecvMsg NO-MESSAGE-MEETING-CRITERIA");
                 }
          } while((theEM == null) && (i_msgid == null) && (recvPollRate == 0));
   }
   catch(AdapterException e)
   {
          // Return the ENA to pool
          retEpicNativeAdapter(theENA);

          logException(processID,"Adapter",e.toString(),ADAPTER_EXCEPTION,"NONE");
          throw new ISException(e.toString());
   }

   if(theEM == null)
   {
          if(i_msgid != null)
          {
             throw new ISException("NO-MESSAGE-MEETING-CRITERIA("+i_msgid+")");
          }
          pd.setMsgXML(null);
   }
   else
   {
          if(_DEBUG)
          {
             System.out.println("  executeRecvMsg theEM: " + theEM.toString());
          }

          // Fill the header BO
          o_msghdr.setData("MessageType",theEM.getMsgType());
          o_msghdr.setData("AckRequested",theEM.getAckRequested());
          o_msghdr.setData("DestinationComponent",theEM.getDestinationComponent());
          o_msghdr.setData("SrcTradingPartnerID",theEM.getSrcTradingPartnerID());
          o_msghdr.setData("DstTradingPartnerID",theEM.getDstTradingPartnerID());
          o_msghdr.setData("BOCorrelationID",theEM.getBOCorrelationID());
          o_msghdr.setData("ExtricityProcessID",theEM.getExtricityProcessID());
          o_msghdr.setData("ProtocolAndVersion",theEM.getProtocolAndVersion());
          o_msghdr.setData("ProcessTransactionID",theEM.getProcessTransactionID());
          o_msghdr.setData("UniqueMsgID",theEM.getUniqueMsgID());
          // Get the XML body
          pd.setMsgXML(theEM.getBodyData());

          if(_DEBUG)
          {
             System.out.println("  executeRecvMsg MsgHdr=" + o_msghdr.toString(true)+
                                            "\n   XML="+pd.getMsgXML());
          }

          // Do we have a commit context
          if(expCommit)
          {
             // Fill in the commit context
             pd.setCommitContext(theEM.getLMSMessageID());
             if(_DEBUG)
             {
                    System.out.println("  executeRecvMsg GenCommitContext="+pd.getCommitContext());
             }
             // Save the ENA for this process
             saveEpicNativeAdapter(processID,theENA);
          }
          else
          {
             if(_DEBUG)
             {
                    System.out.println("  executeRecvMsg IMPLICIT-COMMIT");
             }
             // Commit the operation in-line
             commit(processID,theENA);
             // Return the ENA to pool
             retEpicNativeAdapter(theENA);
          }
   }
   return pd;
}

/**
 * Insert the method's description here.
 * Creation date: (10/16/00 4:41:19 PM)
 * @param processID String - Extricity public process id
 * @param i_msghdr com.extricity.document.api.Element
 * @param i_msgxml java.lang.String
 * @param o_commitcontext com.extricity.document.api.Element
 * @param o_opstatus com.extricity.document.api.Element
 * @exception com.extricity.adapter.api.ISException The exception description.
 */
public String executeSendMsg(String processID, Element i_msghdr, String i_msgxml, Element o_opstatus, String uniqueID)
   throws com.extricity.adapter.api.ISException
{
   EpicNativeAdapter theENA = getEpicNativeAdapter(processID);
   EpicMessageExt theEM;
   String CommitContext = null;

   if(_DEBUG)
   {
          System.out.println("executeSendMsg\n  processID="+processID+"\n  msgHdr="+i_msghdr.toString(true)+"\n  msgXML="+i_msgxml);
   }
   // Check if message already sent
   if(expCommit)
   {
          // Find the message on the _STATE_ queue based on the commit context and remove it
          ENAService theENAServ = new ENAService();
          theENAServ.setApplicationName(internalAppId);
          theENAServ.setBodyCategory("_STATE_");
          theENAServ.setBodyType("_STATE_");
          // Receive a message for a specific Correlation ID
          theENAServ.addFilter(theENAServ.FILTERNAME_LMS_CORRELATION_ID,EpicMessageExt.encodeLMSCorrelationID("_COMMIT_"+processID));
          theENAServ.setPeekOnly(true);
          theENAServ.setTimout(0);
          // Do the receive
          try
          {
                 if(theENA.receiveMsg(theENAServ) != null)
                 {
                        // Message already sent - Just return the commit context
                        if(_DEBUG)
                        {
                           System.out.println("  executeSendMsg MESSAGE-ALREADY-SENT");
                        }
                        return "_COMMIT_"+processID;
                 }
          }
          catch(AdapterException e)
          {
             // Return the ENA to pool
             retEpicNativeAdapter(theENA);

                 logException(processID,"Adapter",e.toString(),ADAPTER_EXCEPTION,"NONE");
                 throw new ISException(e.toString());
          }
   }
   // Send the message
   theEM = sendMsg(theENA,processID,i_msghdr,i_msgxml,uniqueID);

   if(expCommit)
   {
          try
          {
                 theEM.setDestinationComponent(internalAppId);
                 theEM.setBodyCategory("_STATE_");
                 theEM.setBodyType("_STATE_");
                 theEM.setLMSMessageID(theEM.LMS_MESSAGE_ID_NONE);
                 theEM.setExtricityProcessID("_COMMIT_"+processID);
                 // Remove the message data to save queue size
                 theEM.setBodyData(null);
                 if(_DEBUG)
                 {
                        System.out.println("  executeSendMsg theEM: " + theEM.toString());
                 }
                 // Save the state message
                 theENA.sendMsg(theEM);
          }
          catch(AdapterException e)
          {
             // Return the ENA to pool
             retEpicNativeAdapter(theENA);

                 logException(processID,"Adapter",e.toString(),ADAPTER_EXCEPTION,"NONE");
                 throw new ISException(e.toString());
          }
          // Fill in the commit context
          CommitContext = "_COMMIT_"+processID;
   }
   else
   {
          if(_DEBUG)
          {
                 System.out.println("  executeSendMsg IMPLICIT-COMMIT");
          }
   }
   // Commit the operation in-line
   commit(processID,theENA);
   // Return the ENA to pool
   retEpicNativeAdapter(theENA);
   // Return the commit context
   return CommitContext;
}

/**
 * Insert the method's description here.
 * Creation date: (11/6/00 2:14:16 PM)
 * @param processID java.lang.String
 * @param pd com.ibm.extricity.adapters.mqseries.mqak.ProcessData
 */
public void executeSetProcessData(String processID, ProcessDataInt pd)
   throws com.extricity.adapter.api.ISException
{
   EpicNativeAdapter theENA = getEpicNativeAdapter(processID);
   ENAService theENAServ = new ENAService();
   theENAServ.setApplicationName(internalAppId);
   theENAServ.setBodyCategory("_STATE_");
   theENAServ.setBodyType("_STATE_");

   if(_DEBUG)
   {
          System.out.println("executeSetProcessData:\n  processID="+processID+"\n  ProcessData="+pd.toString());
   }
   // Delete any previous copy
   executeDelProcessData(processID);
   try
   {
          // Fill the relevent fields
          EpicMessageExt theEM = new EpicMessageExt(internalAppId,"StateMessage");
          theEM.setAckRequested("False");
          theEM.setDestinationComponent(internalAppId);
          theEM.setDstTradingPartnerID(pd.getTradingPartner());
          theEM.setBOCorrelationID(pd.getBOCorrelationID());
          theEM.setExtricityProcessID(processID);
          theEM.setBodyCategory("_STATE_");
          theEM.setBodyType("_STATE_");
          if(_DEBUG)
          {
                 System.out.println("  executeSetProcessData theEM: " + theEM.toString());
          }
          // Send the message
          theENA.begin();
          theENA.sendMsg(theEM);
          // Commit the operation in-line
          theENA.commit();
   }
   catch(AdapterException e)
   {
          // Return the ENA to pool
          retEpicNativeAdapter(theENA);

          logException(processID,"Adapter",e.toString(),ADAPTER_EXCEPTION,"NONE");
          throw new ISException(e.toString());
   }

   // Return the ENA to pool
   retEpicNativeAdapter(theENA);
}



/**
 * Insert the method's description here.
 * Creation date: (10/23/00 3:07:55 PM)
 * @param args java.lang.String[]
 */
public static void main(String[] args)
{
   MQAOAdapterHelper ad = new MQAOAdapterHelper();
   Element msghdr = new TestElement();
   Element opstat = new TestElement();
   String comCtx = null;
   TestEventContext ec = new TestEventContext();
   // Create
   String theXML = "<Pip3A4PurchaseOrderRequest><PurchaseOrder><ProductLineItem><shipFrom><GlobalLocationIdentifier>Home</GlobalLocationIdentifier></shipFrom><ProductQuantity>10</ProductQuantity><LineNumber>001</LineNumber><productUnit><ProductPackageDescription><ProductDescription><GlobalProductIdentifier>Junk</GlobalProductIdentifier></ProductDescription></ProductPackageDescription></productUnit><requestedShipDate><DateStamp>11/30/2000</DateStamp></requestedShipDate><GlobalProductUnitOfMeasureCode>Piece</GlobalProductUnitOfMeasureCode><SpecialHandlingInstruction><SpecialHandlingText><FreeFormText>None</FreeFormText></SpecialHandlingText></SpecialHandlingInstruction><requestedPrice><FinancialAmount><GlobalCurrencyCode>USD</GlobalCurrencyCode><MonetaryAmount>1000.00</MonetaryAmount></FinancialAmount></requestedPrice></ProductLineItem><GlobalShipmentTermsCode>FOB</GlobalShipmentTermsCode><RevisionNumber>0</RevisionNumber><GlobalFinanceTermsCode>NET30</GlobalFinanceTermsCode><PartnerDescription><GlobalPartnerClassificationCode>Provider</GlobalPartnerClassificationCode></PartnerDescription><GlobalPurchaseOrderTypeCode>RN</GlobalPurchaseOrderTypeCode></PurchaseOrder><fromRole><PartnerRoleDescription><GlobalPartnerRoleClassificationCode>Buyer</GlobalPartnerRoleClassificationCode></PartnerRoleDescription></fromRole><toRole><PartnerRoleDescription><GlobalPartnerRoleClassificationCode>Seler</GlobalPartnerRoleClassificationCode></PartnerRoleDescription></toRole><thisDocumentGenerationDateTime><DateTimeStamp>11/2/2000 09:17:00</DateTimeStamp></thisDocumentGenerationDateTime><thisDocumentIdentifier><ProprietaryDocumentIdentifier>PO98798</ProprietaryDocumentIdentifier></thisDocumentIdentifier><GlobalDocumentFunctionCode>PO</GlobalDocumentFunctionCode></Pip3A4PurchaseOrderRequest>";
   // Accept
   //String theXML = "<Pip3A4PurchaseOrderAcceptance><PurchaseOrder><GlobalPurchaseOrderStatusCode>Accept</GlobalPurchaseOrderStatusCode><GlobalShipmentTermsCode>FOB</GlobalShipmentTermsCode><RevisionNumber>0</RevisionNumber><purchaseOrderDate><DateStamp>11/30/2000</DateStamp></purchaseOrderDate><purchaseOrderNumber><ProprietaryDocumentIdentifier>PO98798</ProprietaryDocumentIdentifier></purchaseOrderNumber></PurchaseOrder><fromRole><PartnerRoleDescription><GlobalPartnerRoleClassificationCode>Seler</GlobalPartnerRoleClassificationCode><PartnerDescription><GlobalPartnerClassificationCode>Seler</GlobalPartnerClassificationCode><BusinessDescription><GlobalBusinessIdentifier>Manufacturer</GlobalBusinessIdentifier><GlobalSupplyChainCode>Manufacturer</GlobalSupplyChainCode></BusinessDescription></PartnerDescription></PartnerRoleDescription></fromRole><toRole><PartnerRoleDescription><GlobalPartnerRoleClassificationCode>Buyer</GlobalPartnerRoleClassificationCode><PartnerDescription><GlobalPartnerClassificationCode>Buyer</GlobalPartnerClassificationCode><BusinessDescription><GlobalBusinessIdentifier>Shopper</GlobalBusinessIdentifier><GlobalSupplyChainCode>Shopper</GlobalSupplyChainCode></BusinessDescription></PartnerDescription></PartnerRoleDescription></toRole><thisDocumentGenerationDateTime><DateTimeStamp>11/2/2000 09:17:00</DateTimeStamp></thisDocumentGenerationDateTime><thisDocumentIdentifier><ProprietaryDocumentIdentifier>PO98798</ProprietaryDocumentIdentifier></thisDocumentIdentifier><requestingDocumentIdentifier><ProprietaryDocumentIdentifier>PO98798</ProprietaryDocumentIdentifier></requestingDocumentIdentifier><GlobalDocumentFunctionCode>PO</GlobalDocumentFunctionCode><requestingDocumentDateTime><DateTimeStamp>11/2/2000 09:17:00</DateTimeStamp></requestingDocumentDateTime></Pip3A4PurchaseOrderAcceptance>";
   String theCorID = new String("4.ijcxbwsq");//(new Date()).toString();
   //String theCorID = new String("16.ij12cmjo");//(new Date()).toString();
   //String theCorID = new String("14.ij12cmjo");//(new Date()).toString();
   String theMsgID = null;
   String pID = "4.iiclkt4n.im4d42.000000e2970e17104.ihxblcrg.im4d42..DICAM.847409406.ORG-3A4-1_1-Create Purchase Order.1.0.1";

   _DEBUG = true;

   try
   {
          ProcessDataInt pd = new ProcessData(theCorID,"847409406");
          /*ad.executeSetProcessData(pID,pd);
          pd = ad.executeGetProcessData(pID);
          System.out.println("PROCESSDATA: " + pd.toString());
          ad.executeDelProcessData(pID);*/

          if((new Random((new Date()).getTime())).nextFloat() < 1.0)
          {
                 theCorID = EpicMessageExt.NO_EXTRICITYPROCESSID;
          }
          ad.startup("BFM","BFM","GATEWAY","RosettaNet-1_1","DEFAULT",null,true,true,false,30);
          msghdr.setData("SrcTradingPartnerID","847409406");
          msghdr.setData("DstTradingPartnerID","103");
          msghdr.setData("BOCorrelationID",theCorID);
          msghdr.setData("ProcessTransactionID","3A4-1_1-CreatePurchaseOrder");
          System.out.println("SEND msghdr: " + msghdr.toString());
          System.out.println("   XML: " + theXML);
          comCtx = ad.executeSendMsg(theCorID,msghdr,theXML,opstat,"TestUniqueID");
          //comCtx = ad.executeSendMsg(theCorID,msghdr,theXML,opstat,"TestUniqueID");
          ad.executeCommit(theCorID,comCtx,opstat);

          //ad.poolENA.clear();
          ad.startup("GATEWAY","BFM","BFM","RosettaNet-1_1","DEFAULT",null,true,true,false,30);
          if(theCorID.compareTo(EpicMessageExt.NO_EXTRICITYPROCESSID) == 0)
          {
                 do
                 {
                        //theXML = ad.executeRecvMsg(theCorID,theMsgID,null,msghdr,comctx,opstat);
                        ad.checkForEvents(ec);
                        theMsgID = ec.getVariantEvent();
                 } while(theMsgID == null);
                 System.out.println("\n\n======================\nEVENT msgid: " + theMsgID + "\n================\n");
          }
          //theCorID = "Wed Oct 25 10:41:51 EDT ";
          msghdr.clearAll();
          ProcessDataInt pdXML = ad.executeRecvMsg(pID,theMsgID,false,null,msghdr,opstat);
          System.out.println("RECEIVE msghdr: " + msghdr.toString());
          System.out.println("   XML: " + pdXML.getMsgXML());
          ad.executeCommit(pID,pdXML.getCommitContext(),opstat);
          theCorID = msghdr.getData("BOCorrelationID");

          //ProcessData pd = new ProcessData(pID,"847409406");
          ad.executeSetProcessData(theCorID,pd);
          pd = ad.executeGetProcessData(theCorID);
          System.out.println("PROCESSDATA: " + pd.toString());
          ad.executeDelProcessData(theCorID);
   }
   catch(ISException e)
   {
          System.out.println("executeRecvMsg->ISException: " + e.toString());
   }
}

/**
 * onProcessCompletion method comment.
 */
public void onProcessCompletion(CRStation.defs.machine.ProcessID process_id)
{
   if(_DEBUG)
   {
          System.out.println("onProcessCompletion\n  process_id="+process_id.getDisplayName());
   }
   addEvent(process_id.getDisplayName());
}

/**
 * Insert the method's description here.
 * Creation date: (10/18/00 3:06:30 PM)
 * @return com.ibm.epic.adapters.eak.nativeadapter.EpicNativeAdapter
 * @param ProcessID java.lang.String
 */
private synchronized EpicNativeAdapter restEpicNativeAdapter(String ProcessID)
{
   return (EpicNativeAdapter)lockedENA.remove(ProcessID);
}

/**
 * Insert the method's description here.
 * Creation date: (10/18/00 3:02:55 PM)
 * @param theENA com.ibm.epic.adapters.eak.nativeadapter.EpicNativeAdapter
 */
private synchronized void retEpicNativeAdapter(EpicNativeAdapter theENA)
{
   poolENA.add(theENA);
}

/**
 * Insert the method's description here.
 * Creation date: (10/18/00 3:04:23 PM)
 * @param ProcessID java.lang.String
 * @param theENA com.ibm.epic.adapters.eak.nativeadapter.EpicNativeAdapter
 */
private synchronized void saveEpicNativeAdapter(String ProcessID, EpicNativeAdapter theENA)
{
   lockedENA.put(ProcessID,theENA);
}

/**
 * Insert the method's description here.
 * Creation date: (10/19/00 3:18:45 PM)
 * @param theENA com.ibm.epic.adapters.eak.nativeadapter.EpicNativeAdapter
 * @param processID java.lang.String
 * @param i_msghdr com.extricity.document.api.Element
 * @param i_msgxml java.lang.String
 */
private EpicMessageExt sendMsg(EpicNativeAdapter theENA, String processID, Element i_msghdr, String i_msgxml, String uniqueID)
   throws com.extricity.adapter.api.ISException
{
   EpicMessageExt theEM = null;

   try
   {
          // Create the message
          if(i_msghdr.getData("MessageType") == null)
          {
                 theEM = new EpicMessageExt(gatewayComp,"GatewayMessage");
          }
          else
          {
                 if(i_msghdr.getData("MessageType").compareTo("GatewayMessage") == 0)
                 {
                        theEM = new EpicMessageExt(gatewayComp,"GatewayMessage");
                 }
                 else if(i_msghdr.getData("MessageType").compareTo("GatewayCommand") == 0)
                 {
                        theEM = new EpicMessageExt(gatewayComp,"GatewayCommand");
                 }
                 else
                 {
                        theEM = new EpicMessageExt(gatewayComp,"GatewayMessage");
                 }
          }
          // Fill the message header
          theEM.setAckRequested("0");
          if(i_msghdr.getData("DestinationComponent") == null)
          {
                 theEM.setDestinationComponent(destComp);
          }
          else
          {
                 theEM.setDestinationComponent(i_msghdr.getData("DestinationComponent"));
          }
          theEM.setSrcTradingPartnerID(i_msghdr.getData("SrcTradingPartnerID"));
          theEM.setDstTradingPartnerID(i_msghdr.getData("DstTradingPartnerID"));
          if(i_msghdr.getData("BOCorrelationID") != null)
          {
                 theEM.setBOCorrelationID(i_msghdr.getData("BOCorrelationID"),true);
          }
          else
          {
                 // Look-up BO Correlation ID for ExtricityProcessID
                 ProcessDataInt pd = executeGetProcessData(processID);
                 if(pd.getBOCorrelationID() == null)
                 {
                        // Default
                        theEM.setBOCorrelationID(theEM.NO_BOCORRELATIONID,true);
                 }
                 else
                 {
                        theEM.setBOCorrelationID(pd.getBOCorrelationID(),true);
                 }
          }
          theEM.setExtricityProcessID(processID,false);
          if(i_msghdr.getData("ProtocolAndVersion") == null)
          {
                 theEM.setProtocolAndVersion(protAndVer);
          }
          else
          {
                 theEM.setProtocolAndVersion(i_msghdr.getData("ProtocolAndVersion"));
          }
          theEM.setProcessTransactionID(i_msghdr.getData("ProcessTransactionID"));
          if(i_msghdr.getData("UniqueMsgID") == null)
          {
             theEM.setUniqueMsgID(uniqueID);
          }
          else
          {
             theEM.setUniqueMsgID(i_msghdr.getData("UniqueMsgID"));
          }


          // Fill the message data
          theEM.setBodyData(i_msgxml);
          if(_DEBUG)
          {
                 System.out.println("  sendMsg theEM: " + theEM.toString());
          }
          // Send the message
          theENA.begin();
          theENA.sendMsg(theEM);
   }
   catch(AdapterException e)
   {
          // Return the ENA to pool
          retEpicNativeAdapter(theENA);

          logException(processID,"Adapter",e.toString(),ADAPTER_EXCEPTION,"NONE");
          throw new ISException(e.toString());
   }
   return theEM;
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 2:44:50 PM)
 */
public void shutdown() throws com.extricity.adapter.api.ISException
{
   // Close the process monitor functionality
   close();

   // Close the queue monitor
   stopMonitor = true;
   monitor.interrupt();

   // Release resources
   poolENA.clear();
   lockedENA.clear();
   termEvents.clear();
}



        protected Thread monitor = null;
        protected boolean stopMonitor = false;

/**
 * Insert the method's description here.
 * Creation date: (10/18/00 3:23:39 PM)
 * @param theENA com.ibm.epic.adapters.eak.nativeadapter.EpicNativeAdapter
 */
private void commit(String processID,EpicNativeAdapter theENA)
   throws com.extricity.adapter.api.ISException
{
   try
   {
          theENA.commit();
   }
   catch(AdapterException e)
   {
          logException(processID,"Adapter",e.toString(),ADAPTER_EXCEPTION,"NONE");
          throw new ISException(e.toString());
   }
}



/**
 * Insert the method's description here.
 * Creation date: (10/6/00 3:47:01 PM)
 * @return com.ibm.epic.adapters.eak.nativeadapter.EpicNativeAdapter
 * @exception com.ibm.epic.adapters.eak.common.AdapterException The exception description.
 */
private synchronized EpicNativeAdapter getEpicNativeAdapter(String processID)
        throws com.extricity.adapter.api.ISException
{
   EpicNativeAdapter theENA;

   if(poolENA.isEmpty())
   {
          try
          {
                 return new EpicNativeAdapter(gatewayComp,"IBM Extricity MQAK Adapter");
          }
          catch(AdapterException e)
          {
                 logException(processID,"Adapter",e.toString(),ADAPTER_EXCEPTION,"NONE");
                 throw new ISException(e.toString());
          }
   }
   else
   {
          return (EpicNativeAdapter)poolENA.remove(0);
   }
}



/**
 * Insert the method's description here.
 * Creation date: (5/23/00 4:45:32 PM)
 */
public void run()
{
        EpicNativeAdapter theENA;
        ENAService theENAServ = new ENAService();
        theENAServ.setApplicationName(gatewayComp);
        theENAServ.setBodyCategory(msgBodyCategory);
        theENAServ.setBodyType("DEFAULT");
        EpicMessageExt theEM;

        // Receive a message for a specific process
        theENAServ.addFilter(theENAServ.FILTERNAME_LMS_CORRELATION_ID,EpicMessageExt.encodeLMSCorrelationID(""));
        theENAServ.setPeekOnly(true);
        theENAServ.setTimout(30000);

        byte[] nocorl = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

        try
        {
                theENA = getEpicNativeAdapter("ProcessID=MQAK_1.0.1_TRANSLATOR");
        }
        catch(ISException e)
        {
                return;
        }

        while(true)
        {
                try
                {
                        // Exit the que monitor
                        if(stopMonitor)
                        {
                                // Return the ENA to pool
                                retEpicNativeAdapter(theENA);

                                return;
                        }
                        theEM = (EpicMessageExt)theENA.receiveMsg(theENAServ);
                        if(theEM == null)
                        {
                                if(_DEBUG)
                                {
                                        System.out.println("  run NO-MESSAGE-MEETING-CRITERIA");
                                }
                        }
                        else if( (theEM.getLMSCorrelationID().compareTo(new String(nocorl)) != 0) &&
                                     (theEM.getLMSCorrelationID().substring(0,6).compareTo("GWNONE") != 0) )
                        {
                                System.out.println(
                                        "Skipping Message with COrrelationID='" + theEM.getLMSCorrelationID() + "'"+theEM.getLMSCorrelationID().length());
                                theEM = null;
                                Thread.sleep(5000);
                        }
                        else
                        {
                                theENAServ.addFilter(theENAServ.FILTERNAME_LMS_MESSAGE_ID,theEM.getLMSMessageID());
                                theENAServ.setPeekOnly(false);
                                theENA.begin();
                                theEM = (EpicMessageExt) theENA.receiveMsg(theENAServ);
                                theENAServ.delFilter(theENAServ.FILTERNAME_LMS_MESSAGE_ID);
                                theENAServ.setPeekOnly(true);
                                theEM.setLMSCorrelationID(theEM.encodeLMSCorrelationID("NONE"));
                                if(_DEBUG)
                                {
                                        System.out.println("  run theEM: " + theEM.toString());
                                }
                                // Save the state message
                                theENA.sendMsg(theEM);
                                theENA.commit();
                        }
                }
                catch(AdapterException e)
                {
                        try
                        {
                                theENA.rollback();
                        }
                        catch(AdapterException x)
                        {
                        }
                        if(_DEBUG)
                        {
                                System.out.println("  run MQAK-EXCEPTION-RECEIVING-MESSAGE: " + e.toString());
                        }
                }
                catch(Exception e)
                {
                        try
                        {
                                theENA.rollback();
                        }
                        catch(AdapterException x)
                        {
                        }
                        if(_DEBUG)
                        {
                                System.out.println(
                                        "  run GENERAL-EXCEPTION-RECEIVING-MESSAGE: " + e.toString());
                        }
                        return;
                }
        }
}

        private String internalAppId = "GATEWAY";


        private static String ADAPTER_EXCEPTION = "EXCEPTION0402";
        private static String GENERAL_EXCEPTION = "EXCEPTION0402";
        private MQAOExceptionLogExt logExt = null;

/**
 * Insert the method's description here.
 * Creation date: (10/25/00 9:51:13 AM)
 * @return java.lang.String
 * @param prvProcID java.lang.String
 */
public void executeLogException(String processID, String subComponent,String logMessage,String exceptionId,String processName,String extData,Element opStatus)
        throws com.extricity.adapter.api.ISException
{
        if((exceptionId == null) || (exceptionId.compareTo("") == 0))
        {
                exceptionId = GENERAL_EXCEPTION;
        }
        if((processName == null) || (processName.compareTo("") == 0))
        {
                processName = "UNKNOWN";
        }
        try
        {
                logExceptionInt(processID,subComponent,logMessage,exceptionId,processName,extData);
        }
        catch(Exception e)
        {
                opStatus.setData("result","failure");
                opStatus.setData("reason",e.toString());
        }
}

/**
 * Insert the method's description here.
 * Creation date: (3/2/01 4:55:26 PM)
 * @param processID java.lang.String
 * @param subComponent java.lang.String
 * @param errMessage java.lang.String
 */
public void logException(String processID,String subComponent,String logMessage,String exceptionId,String processName)
{
        logException(processID,subComponent,logMessage,exceptionId,processName,null);
}

/**
 * Insert the method's description here.
 * Creation date: (3/2/01 4:55:26 PM)
 * @param processID java.lang.String
 * @param subComponent java.lang.String
 * @param errMessage java.lang.String
 */
public void logException(String processID,String subComponent,String logMessage,String exceptionId,String processName,String extData)
{
        try
        {
                logExceptionInt(processID,subComponent,logMessage,exceptionId,processName,extData);
        }
        catch(Exception e)
        {
                 System.out.println("  logException: Error while exception logging: "+e.toString());
                 System.out.println("                Log=!"+exceptionId+"!: "+subComponent+" "+processName+" "+processID+" "+logMessage);
        }
}

/**
 * Insert the method's description here.
 * Creation date: (3/2/01 4:55:26 PM)
 * @param processID java.lang.String
 * @param subComponent java.lang.String
 * @param errMessage java.lang.String
 */
private void logExceptionInt(String processID,String subComponent,String logMessage,String exceptionId,String processName,String extData)
        throws Exception
{
        if(exceptionId == null)
        {
                exceptionId = GENERAL_EXCEPTION;
        }
        else if(exceptionId.compareTo("") == 0)
        {
                exceptionId = GENERAL_EXCEPTION;
        }
        if(processName == null)
        {
                processName = "UNKNOWN";
        }
        if(logExt == null)
        {
                EpicLog epicLog = new EpicLog(gatewayComp,"GATEWAY");
                String stringMsg;
                try
                {
                        stringMsg = new EpicLogTraceException(exceptionId,
                                                                                                  new Object[]{subComponent,processName,processID}).toString();
                }
                catch(Exception e)
                {
                        stringMsg = null;
                }
                if((stringMsg == null) || (stringMsg.compareTo("") == 0))
                {
                        stringMsg = "!"+exceptionId+"!: "+subComponent+" "+processName+" "+processID;
                }
                epicLog.writeExceptionLog(gatewayComp,stringMsg + " " + logMessage,1);
        }
        else
        {
                logExt.logFromMsgFile(exceptionId,subComponent,processName,processID,logMessage,extData);
        }
//      System.out.println("===>logException:\n  processId="+processID+"\n  subComponent="+subComponent+
//                             "\n  logMessage="+logMessage+"\n  processName="+processName+"\n  extData="+extData);
}



        private int recvPollRate = 30;

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 4:05:34 PM)
 * @param gatewayApplication java.lang.String
 * @param gatewayComponent java.lang.String
 * @param destinationComponent java.lang.String
 * @param protocolAndVersion java.lang.String
 */
public void startup(String gatewaycomp, String internalappid, String destcomp, String protandver, String msgbodycat, String exceptionlogext, boolean debug, boolean expcommit, boolean adaptmessages, int recvpollrate)
        throws com.extricity.adapter.api.ISException
{
   gatewayComp = gatewaycomp;
   internalAppId = internalappid;
   destComp = destcomp;
   protAndVer = protandver;
   msgBodyCategory = msgbodycat;
   _DEBUG = debug;
   expCommit = expcommit;
   recvPollRate = recvpollrate;

   // Initialize the monitor functionality
   init();

   if(adaptmessages)
   {
           if(monitor == null)
           {
                  monitor = new Thread(this);
                  monitor.start();
           }
   }

   if(exceptionlogext != null)
   {
           if(exceptionlogext.compareTo("") != 0)
           {
                   try
                   {
                           Class logExtClass = Class.forName(exceptionlogext,true,getClass().getClassLoader());
                           logExt = (MQAOExceptionLogExt)logExtClass.newInstance();
                           //logExt = (MQAOExceptionLogExt)getClass().getClassLoader().loadClass(exceptionlogext).newInstance();
                   }
                   catch(Exception e)
                   {
                           System.out.println("Unable to load Exception Logging Extension Class:"+exceptionlogext+" Exception:"+e.toString());
                   }
           }
   }
}
        private static String PAMResponse_base = "PAMResponse";
public void executeAuditLog(String content, Element o_opstatus)
        throws com.extricity.adapter.api.ISException {

        String errorCode = "";
        // write audit logging information

        try {
                if (_DEBUG) {
                        System.out.print("executeAuditLog:: start to write to the audit log");

                }

                com.ibm.epic.LogTrace.EpicLog auditLog =
                        new com.ibm.epic.LogTrace.EpicLog("GATEWAY", "GATEWAY");

                /* @param applicationName The application name creating and sending the message
                * @param msgType The type of message being created (e.g. Application), may be null to use default
                * @param bodyType The type of body for the message (e.g.sync_salesorder)
                * @param bodyCategory The category of body for the message (e.g. OAG)
                * @param bodyData The body data. This is the data that will be transmitted. It can be in any format
                * but is usually expected to be XML usr data.*/
                com.ibm.epic.adapters.eak.mcs.EpicMessage msg =
                        new com.ibm.epic.adapters.eak.mcs.EpicMessage(
                                "GATEWAY",
                                null,
                                "DEFAULT",
                                "DEFAULT",
                                content);

                auditLog.writeAudit(msg);
                errorCode = "success";
        } catch (Exception e) {
                if (_DEBUG)
                        System.out.println("error connect to solution manager" + e.getMessage());

                errorCode = "failed";
        }

        o_opstatus.setData("result", errorCode);

}   /**
 * Insert the method's description here.
 * Creation date: (10/25/00 9:51:13 AM)
 * @return void
 */
public void executeBuyerAuthentication(String base, String filter, Element o_opstatus)
        throws com.extricity.adapter.api.ISException {

        /*
         * 1. set up ldap connection
         * 2. instantiate EpicDirectory
         * 3. authenticate
         * errorCode: ""(default value); setUpError(set up error); found(set up successful and found the entry);
         *   notFound(set up successful, entry not found)
         */

        String errorCode = "";
        com.ibm.epic.directory.EpicDirectory directory = null;
        try {
                directory = new com.ibm.epic.directory.EpicDirectory();
        } catch (Exception e) {
                if (_DEBUG)
                        System.out.println("executeBuyerAuthentication: LDAP set up error");
                errorCode = "setUpError";
        }
        if (errorCode != null && errorCode.length() == 0) {

                try {
                        NamingEnumeration searchResults =
                                directory.search(
                                        base,
                                        filter,
                                        javax.naming.directory.SearchControls.SUBTREE_SCOPE);
                        if (_DEBUG)
                                System.out.println("executeBuyerAuthentication:: found the entry" + filter+base);
                        errorCode = "found";

                } catch (Exception e) {
                        if (_DEBUG)
                                System.out.println("executeBuyerAuthentication: " + filter+base + " not found");
                        errorCode = "notFound";
                        if (_DEBUG)
                                System.out.println("executeBuyerAuthentication::" + e.getMessage());
                } finally {
                        try {
                                directory.close();
                        } catch (Exception e) {
                                //ignore if cannot close the directory context
                        }
                }
        }


        o_opstatus.setData("result", errorCode);


}   /**
 * Insert the method's description here.
 * Creation date: (3/7/2002 11:25:59 AM)
 * @return boolean
 * @param cardnumber java.lang.String
 * @exception com.extricity.adapter.api.ISException The exception description.
 */
public boolean executeCardCheck(String cardnumber)
        throws com.extricity.adapter.api.ISException {
        int weight = 2, sum = 0;
        boolean allzeros = true;

        if (cardnumber.length() == 0)
                return false;

        for (int i = 0; i < cardnumber.length(); i++) {
                if (cardnumber.charAt(i) != '0') {
                        allzeros = false;
                        break;
                }
        }
        if (allzeros)
                return false;

        // go through the number starting at the 'tens' place and perform the mod 10 weighting
        for (int pos = cardnumber.length() - 2; pos >= 0; pos--) {
                // weight current digit. Note: convert ascii code to the digit it represents
                int digit = weight * Character.digit(cardnumber.charAt(pos), 10);
                if (digit < 0)
                        return false; // digit is not valid

                // add the digit if less than 10 to the sum, otherwise add the sum of the digits if greater than or equal to 10
                sum = sum + (digit / 10) + (digit % 10);

                // alternately weight digits by a factors of 2 and 1
                weight = (weight == 2) ? 1 : 2;

        }
        // compute the numerical value of the last digit
        int last_digit =
                Character.digit(cardnumber.charAt(cardnumber.length() - 1), 10);

        // is the last digit the same as the computed check?
        if (last_digit == ((10 - (sum % 10)) % 10))
                return true; // yes! valid card number

        return false;
}/**
 * Insert the method's description here.
 * Creation date: (10/25/00 9:51:13 AM)
 * @return java.lang.String
 * @param prvProcID java.lang.String
 */
public String executeEncryptPCard(String pCard, Element o_opstatus)
        throws com.extricity.adapter.api.ISException {

        if (_DEBUG) {
                System.out.println("executeEncryptPCard:  PCard= " + pCard);
        }
        String status = null;
        String encodeResult = null;
        try {
                byte[] result = PSGCCEncryption.doEncrypt(pCard);
                if (_DEBUG)
                        System.out.println(
                                "executeEncryptPCard: after encryptioin,the PCard= " + new String(result));

                // encoding...
                BASE64Encoder encoder = new BASE64Encoder();
                encodeResult = encoder.encode(result);

                if (_DEBUG)
                        System.out.println(
                                "executeEncryptPCard: after encoding,the PCard= " + encodeResult);
                status = "success";

        } catch (Throwable e) {
                status = "failed";
                if (_DEBUG)
                        System.out.println("executeEncryptPCard: error " + e.toString());
        }

        o_opstatus.setData("result", status);

        return encodeResult;
}
public String executeGetAdminUserEmailAddr(
        String dn,
        String inAttrId,
        Element o_opstatus)
        throws com.extricity.adapter.api.ISException {

        String output_email_addr = null;
        String errorCode = "";
        com.ibm.epic.directory.EpicDirectory directory = null;
        try {
                directory = new com.ibm.epic.directory.EpicDirectory();
        } catch (Exception e) {
                output_email_addr = "";
                errorCode = "setUpError";
                if (_DEBUG) {
                        System.out.println("executeGetAdminUserEmailAddr: LDAP set up error occurred ");

                }

        }

        // no LDAP set up error
        if (errorCode != null && errorCode.length() == 0) {

                try {
                        String[] retAttrs = {inAttrId};
                        Attributes attributes = null;
                        // finding all the admin user entries

                        StringBuffer mailAddr = new StringBuffer();

                        attributes = directory.read(dn, retAttrs);

                        if (_DEBUG) {
                                System.out.println(
                                        "executeGetAdminUserEmailAddr:: attributes list " + attributes.toString());
                        }
                        NamingEnumeration attrlist = directory.getAttributeList(attributes);
                        while (attrlist.hasMore()) {
                                Attribute tempAttr = (Attribute) attrlist.nextElement();
                                Enumeration attrValueList = directory.getAttributeValueList(tempAttr);
                                // only retrieve the value of the mail attribute
                                while (attrValueList.hasMoreElements()) {
                                        String attrValue = (String) attrValueList.nextElement();

                                        mailAddr.append(attrValue);
                                        mailAddr.append(",");
                                }

                        }

                        errorCode = "found";
                        output_email_addr = mailAddr.substring(0, mailAddr.length() - 1);
                        if (_DEBUG) {
                                System.out.println(
                                        "executeGetAdminUserEmailAddr:: found the email address " + output_email_addr);
                        }

                } catch (Exception e) {
                        errorCode = "notFound";
                        output_email_addr = "";
                        if (_DEBUG) {
                                System.out.println(
                                        "executeGetAdminUserEmailAddr:: not found any email address " + e.getMessage());
                        }
                } finally {
                        try {
                                directory.close();
                        } catch (Exception e) {
                                //ignore if cannot close the directory context
                        }
                }
        }
        o_opstatus.setData("result", errorCode);

        return output_email_addr;
}public Vector executeReadResponseProperties(String processID, String baseFileName, String language, String cntryCode, String status)
 throws com.extricity.adapter.api.ISException{
Vector resp = new Vector();
try{
        System.out.println("Input values are : ");
        System.out.println("\t ProcessID - " + processID);
        System.out.println("\t basefile name - " + baseFileName);
        System.out.println("\t language - " + language);
        System.out.println("\t cntry code - " + cntryCode);
        System.out.println("\t status - " + status);


        java.util.ResourceBundle bundle = ResourceBundle.getBundle(PAMResponse_base, new java.util.Locale(language.trim(), cntryCode.trim()));
        //java.util.ResourceBundle bundle = ResourceBundle.getBundle("PAMResponse", new java.util.Locale("de", "de"));



        String code = bundle.getString(status);
        String text = bundle.getString(code);
        String data = bundle.getString(code+"Data");

        resp.addElement(code);
        resp.addElement(text);
        resp.addElement(data);

        System.out.println("Results read are : " + resp.toString());
        return resp;
} catch(Exception e)

{
        // Exception occured and unable to retrieve the information from properties file
        System.out.println("Unable to retrieve response information from property file. Details :");
        System.out.println(e.toString());
        // logException(processID,"Adapter",e.toString(),ADAPTER_EXCEPTION,"NONE");
        return resp;
}
}public boolean executeSendMail(
        String processID,
        String mailserver,
        String recipient,
        String sender,
        String subject,
        String msgtext)
        throws com.extricity.adapter.api.ISException {
        boolean debug = false;
        boolean rtnValue = false;

        //Set the host smtp address
        try {
                Properties props = System.getProperties();
                System.out.println("Contents of props : " + props.toString());
                props.put("mail.smtp.host", mailserver);

                // create some properties and get the default Session
                Session session = Session.getDefaultInstance(props, null);
                session.setDebug(debug);
                System.out.println("session passed");

                // create a message
                Message msg = new MimeMessage(session);

                // set the from and to address
                InternetAddress addressFrom =
                        new InternetAddress(sender);
                msg.setFrom(addressFrom);

                StringTokenizer st = new StringTokenizer(recipient, ",");
                InternetAddress[] addressTo;

                addressTo = new InternetAddress[st.countTokens()];
                for (int i = 0; i <= st.countTokens(); i++) {
                        String currString = (String) st.nextElement();
                        addressTo[i] = new InternetAddress(currString);
                }

                msg.setRecipients(Message.RecipientType.TO, addressTo);

                // Setting the Subject and Content Type
                msg.setSubject(subject);
                msg.setContent(msgtext, "text/plain");

                msg.saveChanges(); // implicit with send()
                Transport transport = session.getTransport("smtp");
                transport.connect(mailserver, "", "");
                transport.sendMessage(msg, msg.getAllRecipients());
                transport.close();

                rtnValue = true;
        } catch (Exception e) {
                rtnValue = false;
                System.out.println("Unable to send mail. Details :");
                System.out.println(e.toString());
                // logException(processID,"Adapter",e.toString(),ADAPTER_EXCEPTION,"NONE");
        }
        return rtnValue;
}}
