package com.ibm.extricity.adapters.mqseries.mqak;

/**
 * LMSMQExt.java 1.0    10/20/2000
 *
 * The LMSMQExt is derived from <EM>LMSMQ</EM> class.
 * This class is used to extend the MQ LMS for use with Extricity
 *
 * OCO Source Materials
 *
 * 5799-RNK
 *
 * (C) Copyright IBM Corp. 2000
 *
 * The source code for this program is not published
 * or otherwise divested of its trade secrets,
 * irrespective of what has been deposited with the
 * U. S. Copyright Office.
 *
 * @author Thomas W. Jaworski
**/
import java.lang.*;
import java.util.*;

import com.ibm.epic.common.*;
import java.io.*;
import com.ibm.epic.adapters.eak.nativeadapter.*;
import com.ibm.epic.adapters.eak.common.*;
import com.ibm.epic.adapters.eak.mcs.*;

import com.ibm.mq.*;
                     // Need to include the com.ibm.mq.jar file in
                     // the classpath.
import com.ibm.epic.trace.exception.*;
import com.ibm.epic.trace.client.*;
import com.ibm.logging.*;

public class LMSMQExt extends com.ibm.epic.adapters.eak.nativeadapter.LMSMQ
{
   //private com.ibm.mq.MQMessage receivedRequestMQMessage;

   /** Class Name to use in messages **/
   private static final String CLASS_NAME = "com.ibm.extricity.adapters.mqseries.mqak.LMSMQExt";

   /** Default formatter to use **/
   private static java.lang.String defaultFormatterName = "com.ibm.extricity.adapters.mqseries.mqak.MQNMRFH2FormatterExt";

   /** Communication Mode Name **/
   private static final String mode = "com.ibm.extricity.adapters.mqseries.mqak.LMSMQExt";

/** Gets the default formatter name.  Implemented by subclass.
* @return String Component Name
*
**/
protected String getDefaultFormatterName()
{
   return defaultFormatterName;
}

/**
 * Gets the commmunication mode.
 * @return String
**/
public String getMode()
{
   return mode;
}

/**
 * Reads the xml from queue determined from the ENAService values.
 * <UL>
 * <LI>If the received message is a request the MQMessage object
 * is stored, otherwise any previous request information is deleted.</LI>
 * </UL>
 *
 * The receive queue name to
 * use is obtained from the DirectoryService.  Criteria used is:
 * <UL>
 * <LI>Application Id from inputted ENAService.</LI>
 * <LI>Body Category from inputted ENAService.</LI>
 * <LI>Body Type from inputted ENAService.</LI>
 * </UL>
 * @param _enaService ENAService object
 * @return EpicMessage or null if no message.
 * @exception AdapterException Re-throws and if other exceptions received.
**/
public EpicMessage receiveRequest(ENAService enaService)
   throws AdapterException
{
   int timeout;

   if (trace)
          traceClient.writeTrace(IRecordType.TYPE_ENTRY, CLASS_NAME,
                                                "receiveRequest(ENAService)", "AQM5001", AdapterUtil.DEFAULTTRACEMSGFILE, new Object[]{"AQM5001"}); //@P6C

   setReceivedRequestMQMessage(null); // Set back to null, free's up memory.

   MQQueue putQ = getQueueCollection().getReceiveQueue( enaService ) ;

   // Check which timeout to use
   if(enaService.getTimout() == enaService.USE_DEFAULT_TIMEOUT)
   {
          //int timeout = getQueueCollection().getReceiveTimeout( enaService );
          timeout = getReceiveTimeOut(enaService.getApplicationName(),
                                                   enaService.getBodyCategory(),
                                                   enaService.getBodyType());
   }
   else
   {
          timeout = enaService.getTimout();
   }

   EpicMessageExt emR = null; // Return

   MQMessage mqMessage = null;
   MQGetMessageOptions mqGMO = null;
   String strMessage = null;

   try
   {
          if (trace)
          {
                 int num_msgs = putQ.getCurrentDepth();
                 traceClient.writeTrace(IRecordType.TYPE_INFO, CLASS_NAME,
                                                "receiveRequest(ENAService)", "AQM5003", AdapterUtil.DEFAULTTRACEMSGFILE,
                                                new Object[]{"AQM5003", "messages in the queue",
                                                                 new Integer(num_msgs)}); //@P6C
          }

          mqMessage = new MQMessage();

          mqGMO = new MQGetMessageOptions();
          mqGMO.options = MQC.MQGMO_FAIL_IF_QUIESCING // Stop if qmanager shutting down
                 | MQC.MQGMO_CONVERT ;// Suggested by Greg Brail

          // Check if we have any filtering to do
          Enumeration filterNames = enaService.getAllFilterNames();
          while(filterNames.hasMoreElements())
          {
                 String filterName = (String)filterNames.nextElement();
                 if(filterName == enaService.FILTERNAME_LMS_MESSAGE_ID)
                 {
                        mqMessage.messageId = EpicMessageExt.decodeLMSMessageID(enaService.getFilter(filterName));
                        mqGMO.matchOptions |= MQC.MQMO_MATCH_MSG_ID;
                 }
                 else if(filterName == enaService.FILTERNAME_LMS_CORRELATION_ID)
                 {
                        mqMessage.correlationId = EpicMessageExt.decodeLMSCorrelationID(enaService.getFilter(filterName));
                        mqGMO.matchOptions |= MQC.MQMO_MATCH_CORREL_ID;
                 }
                 /*
                 else
                 {
                   //$$$ Indicate and save header filters
                 }
                 */
          }
          /*
          //$$$ Setup a loop which peeks at all mesages meeting the current criteria
          //    and then checks each one if it matches the header filter criteria
          //    the header matching criteria have to be matched based on the Formater
          //    returned values as we do not directly know how to interpret field
          //    names.  This might necesitate an extension to the formater!
          */

          // Check for peek
          if(enaService.getPeekOnly())
          {
                 mqGMO.options |= MQC.MQGMO_BROWSE_FIRST;
          }
          // No transactioning for peek required!
          else
          {
// If running in a transaction - then receive using commit control
                 if (isTransacted())                                                   // @P16 A
                        mqGMO.options |= MQC.MQGMO_SYNCPOINT;                                  // @P16 A
          }

          setTimeOutOptions(timeout, mqGMO);

          putQ.get(mqMessage, mqGMO);
          // If a request then hold reference to it for future
          // replies.
          if(mqMessage.messageType  == MQC.MQMT_REQUEST)
          {
                 if (trace)
                 {
                        traceClient.writeTrace(IRecordType.TYPE_INFO, CLASS_NAME,
                                                        "receiveRequest(ENAService)", "AQM5156", AdapterUtil.DEFAULTTRACEMSGFILE, new Object[]{"AQM5156"}); //@P6C /*received a request*/
                        traceClient.writeTrace(IRecordType.TYPE_INFO, CLASS_NAME,
                                                  "receiveRequest(ENAService)", "AQM5003", AdapterUtil.DEFAULTTRACEMSGFILE,
                                                  new Object[]{"AQM5003", "MQMessage",
                                                         LMSMQ.stringMQMessageUtil(mqMessage, true)}); //@P6C
                 }

                 // Do not set the request data if we are only peeking
                 if(!enaService.getPeekOnly())
                 {
                        setReceivedRequestMQMessage(mqMessage);
                        setEnaService(enaService);
                 }
          } else {
                 if (trace)
                        traceClient.writeTrace(IRecordType.TYPE_INFO, CLASS_NAME,
                                                        "receiveRequest(ENAService)", "AQM5157", AdapterUtil.DEFAULTTRACEMSGFILE, new Object[]{"AQM5157"}); //@P6C /*received a datagram*/
          }
   } catch (MQException e) {
          if (e.completionCode == MQException.MQCC_FAILED)
          {
                 switch (e.reasonCode)
                 {
                        case MQException.MQRC_NO_MSG_AVAILABLE :
                        {
                           if (trace)
                                  traceClient.writeTrace(IRecordType.TYPE_INFO, CLASS_NAME,
                                                        "receiveRequest(ENAService)", "AQM5158", AdapterUtil.DEFAULTTRACEMSGFILE, new Object[]{"AQM5158"}); //@P6C /*no msgs, timeout*/
                           return emR;
                        } // end case MQException.MQRC_NO_MSG_AVAILABLE:
                        case MQException.MQRC_Q_MGR_STOPPING :

                        case MQException.MQRC_Q_MGR_QUIESCING :
                        {
                           if (trace)
                                  traceClient.writeTrace(IRecordType.TYPE_INFO, CLASS_NAME,
                                                        "receiveRequest(ENAService)", "AQM5159", AdapterUtil.DEFAULTTRACEMSGFILE, new Object[]{"AQM5159"}); //@P6C /*MQSeries stopping*/
                           return emR;
                        } // end case MQException.MQRC_Q_MGR_QUIESCING:
                 } // end switch
          } // end if (e.completionCode == MQException.MQCC_FAILED)


          throw new AdapterException("AQM0109", new Object[]{"AQM0109",
                 (CLASS_NAME + "::receiveRequest(ENAService)"),
                 getQueueManagerName(),
                 "",
                 (new Integer(e.completionCode)).toString(),
                 (new Integer(e.reasonCode)).toString()
                 });


   } // end catch
   try {
          emR = (EpicMessageExt)unmarshallMessage(mqMessage, enaService);
   }
   catch(OutOfMemoryError e)
   {
          setReceivedRequestMQMessage(null);

          if (trace)
                 traceClient.writeTrace(IRecordType.TYPE_ERR, CLASS_NAME,
                                                 "receiveRequest(ENAService)", "AQM5160", AdapterUtil.DEFAULTTRACEMSGFILE,
                                                 new Object[]{"AQM5160", "rollback()"});
          throw e;
   } catch(AdapterException e) {
          setReceivedRequestMQMessage(null);

          if (trace)
                 traceClient.writeTrace(IRecordType.TYPE_ERROR_EXC, CLASS_NAME,
                                                 "receiveRequest(ENAService)", "AQM5004", AdapterUtil.DEFAULTTRACEMSGFILE,
                                                 new Object[]{"AQM5004", e.getClass().getName(),
                                                                   e.getMessage(),"unmarshallMessage()"});
          throw e;
   } catch(Throwable e) {
          setReceivedRequestMQMessage(null);

          if (trace)
                 traceClient.writeTrace(IRecordType.TYPE_ERROR_EXC, CLASS_NAME,
                                                 "receiveRequest(ENAService)", "AQM5004", AdapterUtil.DEFAULTTRACEMSGFILE,
                                                 new Object[]{"AQM5004", e.getClass().getName(),
                                                                   e.getMessage(),"unmarshallMessage()"});

          throw new AdapterException("AQM0002", new Object[]{"AQM0002",
                 (CLASS_NAME + "::receiveRequest(ENAService)"),
                 e.getClass().getName(),
           EpicException.convertNulltoEmptyString(e.getMessage()),
                        new FormatEpicNLSMessage(AdapterException.PROP_NAME).formatMessage
                           ("AQM2032",new Object[]{AdapterUtil.convertStackTraceToString(e)})
                 });
   }

   if (trace)
          traceClient.writeTrace(IRecordType.TYPE_EXIT, CLASS_NAME,
                                                "receiveRequest(ENAService)", "AQM5002", AdapterUtil.DEFAULTTRACEMSGFILE, new Object[]{"AQM5002"});
   return emR;

}

/**
 * Converts the EpicMessage to an XML document and puts the xml to
 * a queue.  The destination queue name to use is obtained
 * from the DirectoryService.  Criteria used is:
 * <UL>
 * <LI>Destination Application Id from inputted EpicMessage.</LI>
 * <LI>Body Category from inputted EpicMessage.</LI>
 * <LI>Body Type from inputted EpicMessage.</LI>
 * </UL>
 *
 * @param epicMessage EpicMessage Object reference
 * @see #getReceiveQName(java.lang.String,java.lang.String,java.lang.String)
 * @exception AdapterException Re-throws
 **/
public void sendMsg(EpicMessage epicMessageOrg) throws AdapterException
{
   // Make sure we have the extended EpicMessage
   if(!(epicMessageOrg instanceof EpicMessageExt))
   {
          super.sendMsg(epicMessageOrg);
          return;
   }

   EpicMessageExt epicMessage = (EpicMessageExt)epicMessageOrg;

   if (trace)
          traceClient.writeTrace(IRecordType.TYPE_ENTRY, CLASS_NAME, "sendMsg(EpicMessage)", "AQM5001", AdapterUtil.DEFAULTTRACEMSGFILE, new Object[] {"AQM5001"}); //@P6C


   MQQueue putQ = getQueueCollection().getSendingQueue( epicMessage ) ;

   try {
          MQMessage mqMessage = createMQMessage(epicMessage);
          MQPutMessageOptions mqPMO = new MQPutMessageOptions();
          if (isTransacted())  {
                 mqPMO.options &= ~MQC.MQPMO_NO_SYNCPOINT;
                 mqPMO.options |= MQC.MQPMO_SYNCPOINT;
          }
          putQ.put(mqMessage, mqPMO);

          epicMessage.setLMSMessageID(mqMessage.messageId);
          epicMessage.setLMSCorrelationID(mqMessage.correlationId);

   } catch (MQException e) {
          // @P4C {

          AdapterException ae = new AdapterException("AQM0108", new Object[] {"AQM0108", (CLASS_NAME + "::sendMsg(EpicMessage)"), /* @P1c */
          getQueueManagerName(), "", (new Integer(e.completionCode)).toString(), (new Integer(e.reasonCode)).toString()});
          if (trace)
                 traceClient.writeTrace(IRecordType.TYPE_ERROR_EXC, CLASS_NAME, "sendMsg(EpicMessage)", "AQM5011", /*@P12C*/
                 AdapterUtil.DEFAULTTRACEMSGFILE, new Object[] {"AQM5011", ae.getClass().getName(), ae.getMessage()}); //@P6C //@P9C

          throw ae;
   }

   if (trace)
          traceClient.writeTrace(IRecordType.TYPE_EXIT, CLASS_NAME, "sendMsg(EpicMessage)", "AQM5002", AdapterUtil.DEFAULTTRACEMSGFILE, new Object[] {"AQM5002"}); //@P6C
   return;
}
}
