package com.ibm.extricity.adapters.mqseries.mqak;

/**
 * EpicMessageExt.java 1.0      10/6/2000
 *
 * The EpicMessageExt is derived from <EM>EpicMessage</EM> class.
 * This class is used to extend teh ePic message for use with Extricity
 *
 * OCO Source Materials
 *
 * 5799-RNK
 *
 * (C) Copyright IBM Corp. 2000
 *
 * The source code for this program is not published
 * or otherwise divested of its trade secrets,
 * irrespective of what has been deposited with the
 * U. S. Copyright Office.
 *
 * @author Thomas W. Jaworski
**/
public class EpicMessageExt extends com.ibm.epic.adapters.eak.mcs.EpicMessage
{

   private static final char[] _HEXTBL = { '0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F' };
   private static final byte[] _NO_ID = { 0x4e, 0x4f, 0x4e, 0x45 };
   public static final int LMS_CORELATION_ID_MAXLEN = 24;
   public static final String LMS_CORELATION_ID_NONE = null;
   public static final int LMS_MESSAGE_ID_MAXLEN = 24;     // Extended transport attributes
   public static final String LMS_MESSAGE_ID_NONE = null;
   private String lmsCorrelationID = NO_EXTRICITYPROCESSID;
   private String lmsMessageID = LMS_MESSAGE_ID_NONE;
   private boolean lmsMessageIDEncoded = false;
   public static final String NO_BOCORRELATIONID = new String(_NO_ID);
   public static final String NO_EXTRICITYPROCESSID = new String(_NO_ID);

/**
 * Parses the XML string and sets the field attribute values from the XML header.
 * The xml document in string format should contain an EPIC_HEADER element.
 *
 * @param epicXMLMessage XML String to read all the message parameters from
 *
 * @exception AdapterException catch parser errors
 **/
public EpicMessageExt(String epicXMLMessage) throws com.ibm.epic.adapters.eak.common.AdapterException
{
   super(epicXMLMessage);
}

/**
 * Creates an empty message and sets the source ID and the message type from the input params.
 * The message can be further initialized by calling any of the setXXX() methods on this
 * instance.
 *
 * @param srcID The source application name that is considered to be sending this message
 * @param messageType The type of message - may be null. This s the message type returned by getMessageType()
 *
 * @exception AdapterException  catch invalid initializations
 * of attributes. Catch exceptions reading configuration file.
 *
 * @see #getMsgType()
 *
 **/
public EpicMessageExt(String srcID,String messageType)
   throws com.ibm.epic.adapters.eak.common.AdapterException
{
   super(srcID,messageType);
}

/**
 * The purpose of this constructor is to create an Epic message given a specified
 * body type, body category and body data.  Body category and Body type are required,
 * while Body data is optional.  As an example, Body category = event and body type =
 * status change might be an event which requires no data.
 *
 * @param applicationName The application name creating and sending the message
 * @param msgType The type of message being created (e.g. Application), may be null to use default
 * @param bodyType The type of body for the message (e.g.sync_salesorder)
 * @param bodyCategory The category of body for the message (e.g. OAG)
 * @param bodyData The body data. This is the data that will be transmitted. It can be in any format
 * but is usually expected to be XML usr data.
 *
 * @exception AdapterException If failures occur in called methods
 *
 * @see #EpicMessage( String, String )
 *
 */
public EpicMessageExt(String applicationName, String msgType, String bodyType, String bodyCategory, String bodyData)
   throws com.ibm.epic.adapters.eak.common.AdapterException
{
   super(applicationName,msgType,bodyType,bodyCategory,bodyData);
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public String getBOCorrelationID()
{
   return getCorrelationID();
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public String getDestinationComponent()
{
   return getDestinationLogicalID();
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public String getExtricityProcessID()
{
   return getTransactionID();
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public String getProtocol()
{
   String prot = getBodyCategory();
   int pos;

   pos = prot.indexOf("_");
   if(pos < 0)
   {
          return "";
   }
   else
   {
          return prot.substring(0,pos);
   }
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public String getProtocolAndVersion()
{
   return getBodyCategory();
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public String getProtocolVersion()
{
   String prot = getBodyCategory();
   int pos;

   pos = prot.indexOf("_");
   if(pos < 0)
   {
          return "";
   }
   else
   {
          return prot.substring(pos);
   }
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public void setBOCorrelationID(String val)
   throws com.ibm.epic.adapters.eak.common.AdapterException
{
   setBOCorrelationID(val,false);
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public void setDestinationComponent(String param1)
   throws com.ibm.epic.adapters.eak.common.AdapterException
{
   setDestinationLogicalID(param1);
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public void setExtricityProcessID(String val)
   throws com.ibm.epic.adapters.eak.common.AdapterException
{
   setExtricityProcessID(val,true);
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public void setProtocolAndVersion(String param1)
   throws com.ibm.epic.adapters.eak.common.AdapterException
{
   setBodyCategory(param1);
}

/**
 * Creates an EpicMessage with DEFAULT for the bodyType & category.
 * Other fields are initialized with suitable defaults. This message
 * is useable but contains no data.
 *
 **/
public EpicMessageExt()
{
   super();
}

/**
 * Insert the method's description here.
 * Creation date: (11/15/00 1:35:00 PM)
 * @return byte[]
 * @param correlationID java.lang.String
 */
public static byte[] decodeLMSCorrelationID(String correlationID)
{
   if(correlationID == null)
   {
          return null;
   }
   else
   {
          return correlationID.getBytes();
   }
}

/**
 * Insert the method's description here.
 * Creation date: (11/15/00 1:35:00 PM)
 * @return byte[]
 * @param MessageID java.lang.String
 */
public static byte[] decodeLMSMessageID(String messageID)
{
   if(messageID == null)
   {
          return null;
   }
   else
   {
          int ix;
          byte[] ba = new byte[messageID.length() / 2];

          // Convert from hex representation
          for(ix = 0;ix < messageID.length();ix += 2)
          {
                 ba[ix/2] = Integer.decode("0x"+messageID.substring(ix,ix+2)).byteValue();
          }
          return ba;
   }
}

/**
 * Insert the method's description here.
 * Creation date: (11/3/00 11:44:25 AM)
 * @return java.lang.String
 * @param idVal java.lang.String
 */
public static String encodeLMSCorrelationID(String idVal)
{
   if(idVal == null)
   {
          return null;
   }
   else if(idVal.length() > LMS_CORELATION_ID_MAXLEN)
   {
          char[] res = new char[LMS_CORELATION_ID_MAXLEN/2];
          char[] hex = new char[LMS_CORELATION_ID_MAXLEN];
          int ix;
          for(ix = 0;ix < LMS_CORELATION_ID_MAXLEN/2;ix++)
          {
                 res[ix] = 0;
          }
          for(ix = 0;ix < idVal.length();ix++)
          {
                 res[ix % (LMS_CORELATION_ID_MAXLEN/2)] ^= idVal.charAt(ix);
          }
          for(ix = 0;ix < LMS_CORELATION_ID_MAXLEN/2;ix++)
          {
                 hex[(2*ix)] = _HEXTBL[(res[ix]/16)%16];
                 hex[(2*ix)+1] = _HEXTBL[res[ix]%16];
          }
          return new String(hex);
   }
   else
   {
          return idVal;
   }
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public byte[] getByteArrLMSCorrelationID()
{
   if(lmsCorrelationID == null)
   {
          return null;
   }
   else
   {
          return decodeLMSCorrelationID(lmsCorrelationID);
   }
}

/**
 * Insert the method's description here.
 * Creation date: (10/20/00 10:24:28 AM)
 * @return java.lang.String
 */
public byte[] getByteArrLMSMessageID()
{
   if(lmsMessageID == null)
   {
          return null;
   }
   else if(this.lmsMessageIDEncoded)
   {
          return decodeLMSMessageID(lmsMessageID);
   }
   else
   {
          return lmsMessageID.getBytes();
   }
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public String getDstTradingPartnerID()
{
   return getRespondToLogicalID();
}

/**
 * Insert the method's description here.
 * Creation date: (10/20/00 10:24:28 AM)
 * @return java.lang.String
 */
public String getLMSCorrelationID()
{
   return lmsCorrelationID;
}

/**
 * Insert the method's description here.
 * Creation date: (10/20/00 10:24:28 AM)
 * @return java.lang.String
 */
public String getLMSMessageID()
{
   return lmsMessageID;
}

/**
 * Insert the method's description here.
 * Creation date: (10/18/00 4:04:42 PM)
 * @return java.lang.String
 */
public String getProcessTransactionID()
{
   return getBodyType();
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public String getSrcTradingPartnerID()
{
   return getDeliveryCategory();
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
protected void setBOCorrelationID(String val,boolean asTransport)
   throws com.ibm.epic.adapters.eak.common.AdapterException
{
   if(asTransport)
   {
          setLMSCorrelationID(encodeLMSCorrelationID(val));
   }
   setCorrelationID(val);
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public void setDstTradingPartnerID(String param1)
   throws com.ibm.epic.adapters.eak.common.AdapterException
{
   setRespondToLogicalID(param1);
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
protected void setExtricityProcessID(String val,boolean asTransport)
   throws com.ibm.epic.adapters.eak.common.AdapterException
{
   if(asTransport)
   {
          setLMSCorrelationID(encodeLMSCorrelationID(val));
   }
   setTransactionID(val);
}

/**
 * Insert the method's description here.
 * Creation date: (10/20/00 10:22:26 AM)
 * @param correlationID java.lang.String
 */
public void setLMSCorrelationID(byte[] correlationID)
{
   if(correlationID == null)
   {
          lmsCorrelationID = null;
   }
   else
   {
          lmsCorrelationID = new String(correlationID);
   }
}

/**
 * Insert the method's description here.
 * Creation date: (10/20/00 10:22:26 AM)
 * @param correlationID java.lang.String
 */
public void setLMSCorrelationID(String correlationID)
{
   lmsCorrelationID = correlationID;
}

/**
 * Insert the method's description here.
 * Creation date: (10/20/00 10:22:26 AM)
 * @param messageID java.lang.String
 */
public void setLMSMessageID(byte[] messageID)
{
   if(messageID == null)
   {
          lmsMessageID = null;
          lmsMessageIDEncoded = false;
   }
   else
   {
          int ix;
          StringBuffer sb = new StringBuffer(messageID.length);

          // Encode into hex representation
          for(ix = 0;ix < messageID.length;ix++)
          {
             sb.append(_HEXTBL[(messageID[ix] >> 4) & 0x0f]);
             sb.append(_HEXTBL[messageID[ix] & 0x0f]);
          }
          setLMSMessageID(new String(sb),true);
   }
}

/**
 * Insert the method's description here.
 * Creation date: (10/20/00 10:22:26 AM)
 * @param messageID java.lang.String
 */
public void setLMSMessageID(String messageID)
{
   setLMSMessageID(messageID,false);
}

/**
 * Insert the method's description here.
 * Creation date: (10/20/00 10:22:26 AM)
 * @param messageID java.lang.String
 */
public void setLMSMessageID(String messageID,boolean isEncoded)
{
   lmsMessageID = messageID;
   lmsMessageIDEncoded = isEncoded;
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public void setProcessTransactionID(String param1)
   throws com.ibm.epic.adapters.eak.common.AdapterException
{
   setBodyType(param1);
}

/**
 * Insert the method's description here.
 * Creation date: (10/6/00 10:23:03 AM)
 * @return java.lang.String
 */
public void setSrcTradingPartnerID(String param1)
   throws com.ibm.epic.adapters.eak.common.AdapterException
{
   setDeliveryCategory(param1);
}

/**
 * Insert the method's description here.
 * Creation date: (10/24/00 4:47:49 PM)
 * @return java.lang.String
 */
public String toString()
{
   return "LMSMessageID:<"+lmsMessageID+">\n"+
                  "LMSCorrelationID:<"+lmsCorrelationID+">\n"+
                  super.toString();
}
}
