/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class BasicComboBoxUI
extends ComboBoxUI {
    protected JComboBox comboBox;
    protected boolean hasFocus = false;
    private boolean lightNav = false;
    private static final String LIGHTWEIGHT_KEYBOARD_NAVIGATION = "JComboBox.lightweightKeyboardNavigation";
    private static final String LIGHTWEIGHT_KEYBOARD_NAVIGATION_ON = "Lightweight";
    private static final String LIGHTWEIGHT_KEYBOARD_NAVIGATION_OFF = "Heavyweight";
    protected JList listBox;
    protected CellRendererPane currentValuePane = new CellRendererPane();
    protected ComboPopup popup;
    protected Component editor;
    protected JButton arrowButton;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected ItemListener itemListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener popupMouseListener;
    protected MouseMotionListener popupMouseMotionListener;
    protected KeyListener popupKeyListener;
    protected ListDataListener listDataListener;
    protected boolean isMinimumSizeDirty = true;
    protected Dimension cachedMinimumSize = new Dimension(0, 0);
    Dimension cachedDisplaySize = new Dimension(0, 0);

    static /* synthetic */ boolean access$0(BasicComboBoxUI basicComboBoxUI) {
        return basicComboBoxUI.lightNav;
    }

    public void addEditor() {
        this.removeEditor();
        this.editor = this.comboBox.getEditor().getEditorComponent();
        this.comboBox.add(this.editor);
    }

    public void configureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.setEnabled(this.comboBox.isEnabled());
            this.arrowButton.setRequestFocusEnabled(false);
            if (this.popupMouseListener != null) {
                this.arrowButton.addMouseListener(this.popupMouseListener);
            }
            if (this.popupMouseMotionListener != null) {
                this.arrowButton.addMouseMotionListener(this.popupMouseMotionListener);
            }
            this.arrowButton.resetKeyboardActions();
        }
    }

    protected void configureEditor() {
        AccessibleContext accessibleContext;
        this.editor.setFont(this.comboBox.getFont());
        if (this.popupKeyListener != null) {
            this.editor.addKeyListener(this.popupKeyListener);
        }
        if (this.editor instanceof Accessible && (accessibleContext = ((Accessible)((Object)this.editor)).getAccessibleContext()) != null) {
            accessibleContext.setAccessibleParent(this.comboBox);
        }
        this.comboBox.configureEditor(this.comboBox.getEditor(), this.comboBox.getSelectedItem());
    }

    protected JButton createArrowButton() {
        return new BasicArrowButton(5);
    }

    protected ComboBoxEditor createEditor() {
        return new BasicComboBoxEditor.UIResource();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ItemListener createItemListener() {
        return new ItemHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager();
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler();
    }

    protected ComboPopup createPopup() {
        BasicComboPopup basicComboPopup = new BasicComboPopup(this.comboBox);
        basicComboPopup.getAccessibleContext().setAccessibleParent(this.comboBox);
        return basicComboPopup;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected ListCellRenderer createRenderer() {
        return new BasicComboBoxRenderer.UIResource();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicComboBoxUI();
    }

    public Accessible getAccessibleChild(JComponent jComponent, int n) {
        switch (n) {
            case 0: {
                if (!(this.popup instanceof Accessible)) break;
                AccessibleContext accessibleContext = ((Accessible)((Object)this.popup)).getAccessibleContext();
                accessibleContext.setAccessibleParent(this.comboBox);
                return (Accessible)((Object)this.popup);
            }
            case 1: {
                if (!this.comboBox.isEditable() || !(this.editor instanceof Accessible)) break;
                AccessibleContext accessibleContext = ((Accessible)((Object)this.editor)).getAccessibleContext();
                accessibleContext.setAccessibleParent(this.comboBox);
                return (Accessible)((Object)this.editor);
            }
        }
        return null;
    }

    public int getAccessibleChildrenCount(JComponent jComponent) {
        if (this.comboBox.isEditable()) {
            return 2;
        }
        return 1;
    }

    protected Dimension getDefaultSize() {
        return new Dimension(100, 20);
    }

    protected Dimension getDisplaySize() {
        Dimension dimension = new Dimension();
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        ComboBoxModel comboBoxModel = this.comboBox.getModel();
        if (listCellRenderer != null && comboBoxModel.getSize() > 0) {
            Dimension dimension2;
            int n = 0;
            int n2 = comboBoxModel.getSize();
            while (n < n2) {
                Component component = listCellRenderer.getListCellRendererComponent(this.listBox, comboBoxModel.getElementAt(n), -1, false, false);
                this.currentValuePane.add(component);
                component.setFont(this.comboBox.getFont());
                dimension2 = component.getPreferredSize();
                this.currentValuePane.remove(component);
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
                ++n;
            }
            if (this.comboBox.isEditable()) {
                dimension2 = this.editor.getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
            this.cachedDisplaySize.setSize(dimension.width, dimension.height);
            return dimension;
        }
        return this.getDefaultSize();
    }

    protected Insets getInsets() {
        return this.comboBox.getInsets();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        dimension.width = Short.MAX_VALUE;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Insets insets = this.getInsets();
        Dimension dimension = this.getDisplaySize();
        dimension.height += insets.top + insets.bottom;
        int n = dimension.height - (insets.top + insets.bottom);
        dimension.width += insets.left + insets.right + n;
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this.getMinimumSize(jComponent);
        dimension.width += 4;
        return dimension;
    }

    protected void installComponents() {
        this.arrowButton = this.createArrowButton();
        this.comboBox.add(this.arrowButton);
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        LookAndFeel.installBorder(this.comboBox, "ComboBox.border");
    }

    protected void installKeyboardActions() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicComboBoxUI.this.setPopupVisible(BasicComboBoxUI.this.comboBox, false);
            }

            public boolean isEnabled() {
                return BasicComboBoxUI.this.comboBox.isEnabled();
            }
        };
        this.comboBox.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(27, 0), 1);
    }

    protected void installListeners() {
        this.itemListener = this.createItemListener();
        if (this.itemListener != null) {
            this.comboBox.addItemListener(this.itemListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.comboBox.addKeyListener(this.keyListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.comboBox.addFocusListener(this.focusListener);
        }
        if ((this.popupMouseListener = this.popup.getMouseListener()) != null) {
            this.comboBox.addMouseListener(this.popupMouseListener);
        }
        if ((this.popupMouseMotionListener = this.popup.getMouseMotionListener()) != null) {
            this.comboBox.addMouseMotionListener(this.popupMouseMotionListener);
        }
        if ((this.popupKeyListener = this.popup.getKeyListener()) != null) {
            this.comboBox.addKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && (this.listDataListener = this.createListDataListener()) != null) {
            this.comboBox.getModel().addListDataListener(this.listDataListener);
        }
    }

    public void installUI(JComponent jComponent) {
        this.isMinimumSizeDirty = true;
        this.comboBox = (JComboBox)jComponent;
        this.installDefaults();
        this.popup = this.createPopup();
        this.listBox = this.popup.getList();
        Object object = jComponent.getClientProperty(LIGHTWEIGHT_KEYBOARD_NAVIGATION);
        if (object != null) {
            if (object.equals(LIGHTWEIGHT_KEYBOARD_NAVIGATION_ON)) {
                this.lightNav = true;
            } else if (object.equals(LIGHTWEIGHT_KEYBOARD_NAVIGATION_OFF)) {
                this.lightNav = false;
            }
        }
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(this.createRenderer());
        }
        if (this.comboBox.getEditor() == null || this.comboBox.getEditor() instanceof UIResource) {
            this.comboBox.setEditor(this.createEditor());
        }
        this.installComponents();
        this.installListeners();
        if (this.arrowButton != null) {
            this.configureArrowButton();
        }
        if (this.editor != null) {
            this.configureEditor();
        }
        this.comboBox.setLayout(this.createLayoutManager());
        this.comboBox.setRequestFocusEnabled(true);
        Runnable runnable = new Runnable(){

            public void run() {
                if (BasicComboBoxUI.this.comboBox != null) {
                    if (BasicComboBoxUI.this.editor != null) {
                        BasicComboBoxUI.this.editor.setFont(BasicComboBoxUI.this.comboBox.getFont());
                    }
                    BasicComboBoxUI.this.installKeyboardActions();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public boolean isFocusTraversable(JComboBox jComboBox) {
        return this.comboBox.isEditable() ^ true;
    }

    protected boolean isNavigationKey(int n) {
        return n == 38 || n == 40;
    }

    public boolean isPopupVisible(JComboBox jComboBox) {
        return this.popup.isVisible();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(graphics, rectangle, this.hasFocus);
            this.paintCurrentValue(graphics, rectangle, this.hasFocus);
        }
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        Component component;
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        if (this.comboBox.getSelectedIndex() == -1) {
            return;
        }
        if (bl && !this.isPopupVisible(this.comboBox)) {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            component.setBackground(UIManager.getColor("ComboBox.background"));
        }
        component.setFont(this.comboBox.getFont());
        if (bl && !this.isPopupVisible(this.comboBox)) {
            component.setForeground(this.listBox.getSelectionForeground());
            component.setBackground(this.listBox.getSelectionBackground());
        } else if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
        Color color = graphics.getColor();
        if (this.comboBox.isEnabled()) {
            graphics.setColor(UIManager.getColor("ComboBox.background"));
        } else {
            graphics.setColor(UIManager.getColor("ComboBox.disabledBackground"));
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
    }

    protected Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int n3 = n2 - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            n3 = this.arrowButton.getWidth();
        }
        return new Rectangle(insets.left, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
    }

    public void removeEditor() {
        if (this.editor != null) {
            this.unconfigureEditor();
            this.comboBox.remove(this.editor);
        }
    }

    void repaintCurrentValue() {
        Rectangle rectangle = this.rectangleForCurrentValue();
        this.comboBox.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void selectNextPossibleValue() {
        int n = this.lightNav ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
        if (n < this.comboBox.getModel().getSize() - 1) {
            if (this.lightNav) {
                this.listBox.setSelectedIndex(n + 1);
                this.listBox.ensureIndexIsVisible(n + 1);
            } else {
                this.comboBox.setSelectedIndex(n + 1);
            }
            this.comboBox.repaint();
        }
    }

    protected void selectPreviousPossibleValue() {
        int n = this.lightNav ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
        if (n > 0) {
            if (this.lightNav) {
                this.listBox.setSelectedIndex(n - 1);
                this.listBox.ensureIndexIsVisible(n - 1);
            } else {
                this.comboBox.setSelectedIndex(n - 1);
            }
            this.comboBox.repaint();
        }
    }

    public void setPopupVisible(JComboBox jComboBox, boolean bl) {
        if (bl) {
            this.popup.show();
        } else {
            this.popup.hide();
        }
    }

    protected void toggleOpenClose() {
        this.setPopupVisible(this.comboBox, this.isPopupVisible(this.comboBox) ^ true);
    }

    public void unconfigureArrowButton() {
        if (this.arrowButton != null) {
            if (this.popupMouseListener != null) {
                this.arrowButton.removeMouseListener(this.popupMouseListener);
            }
            if (this.popupMouseMotionListener != null) {
                this.arrowButton.removeMouseMotionListener(this.popupMouseMotionListener);
            }
        }
    }

    protected void unconfigureEditor() {
        if (this.popupKeyListener != null) {
            this.editor.removeKeyListener(this.popupKeyListener);
        }
    }

    protected void uninstallComponents() {
        if (this.arrowButton != null) {
            this.unconfigureArrowButton();
        }
        if (this.editor != null) {
            this.unconfigureEditor();
        }
        this.comboBox.removeAll();
        this.arrowButton = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        LookAndFeel.uninstallBorder(this.comboBox);
    }

    protected void uninstallKeyboardActions() {
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
    }

    protected void uninstallListeners() {
        if (this.keyListener != null) {
            this.comboBox.removeKeyListener(this.keyListener);
        }
        if (this.itemListener != null) {
            this.comboBox.removeItemListener(this.itemListener);
        }
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.focusListener != null) {
            this.comboBox.removeFocusListener(this.focusListener);
        }
        if (this.popupMouseListener != null) {
            this.comboBox.removeMouseListener(this.popupMouseListener);
        }
        if (this.popupMouseMotionListener != null) {
            this.comboBox.removeMouseMotionListener(this.popupMouseMotionListener);
        }
        if (this.popupKeyListener != null) {
            this.comboBox.removeKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && this.listDataListener != null) {
            this.comboBox.getModel().removeListDataListener(this.listDataListener);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.setPopupVisible(this.comboBox, false);
        this.popup.uninstallingUI();
        this.uninstallKeyboardActions();
        this.comboBox.setLayout(null);
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(null);
        }
        if (this.comboBox.getEditor() == null || this.comboBox.getEditor() instanceof UIResource) {
            this.comboBox.setEditor(null);
        }
        this.keyListener = null;
        this.focusListener = null;
        this.listDataListener = null;
        this.popupKeyListener = null;
        this.popupMouseListener = null;
        this.popupMouseMotionListener = null;
        this.propertyChangeListener = null;
        this.popup = null;
        this.listBox = null;
        this.comboBox = null;
    }

    public class KeyHandler
    extends KeyAdapter {
        boolean isTypeAheadKey(KeyEvent keyEvent) {
            return !keyEvent.isAltDown() && !keyEvent.isControlDown() && !keyEvent.isMetaDown();
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (BasicComboBoxUI.this.comboBox.isEnabled() && !BasicComboBoxUI.this.isNavigationKey(keyEvent.getKeyCode()) && this.isTypeAheadKey(keyEvent) && BasicComboBoxUI.this.comboBox.selectWithKeyChar(keyEvent.getKeyChar())) {
                keyEvent.consume();
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            BasicComboBoxUI.this.hasFocus = true;
            BasicComboBoxUI.this.comboBox.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            BasicComboBoxUI.this.hasFocus = false;
            if (!focusEvent.isTemporary() && BasicComboBoxUI.this.comboBox.isLightWeightPopupEnabled()) {
                BasicComboBoxUI.this.setPopupVisible(BasicComboBoxUI.this.comboBox, false);
            }
            BasicComboBoxUI.this.comboBox.repaint();
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        public void contentsChanged(ListDataEvent listDataEvent) {
            if (listDataEvent.getIndex0() != -1 || listDataEvent.getIndex1() != -1) {
                BasicComboBoxUI.this.isMinimumSizeDirty = true;
                BasicComboBoxUI.this.comboBox.revalidate();
            }
            if (BasicComboBoxUI.this.editor != null) {
                BasicComboBoxUI.this.comboBox.configureEditor(BasicComboBoxUI.this.comboBox.getEditor(), BasicComboBoxUI.this.comboBox.getSelectedItem());
            }
            BasicComboBoxUI.this.comboBox.repaint();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            if (n == 0 && BasicComboBoxUI.this.comboBox.getItemCount() - (n2 - n + 1) == 0) {
                this.contentsChanged(listDataEvent);
            } else if (n != -1 || n2 != -1) {
                ListCellRenderer listCellRenderer = BasicComboBoxUI.this.comboBox.getRenderer();
                ComboBoxModel comboBoxModel = BasicComboBoxUI.this.comboBox.getModel();
                int n3 = BasicComboBoxUI.this.cachedDisplaySize.width;
                int n4 = BasicComboBoxUI.this.cachedDisplaySize.height;
                int n5 = n;
                while (n5 <= n2) {
                    Component component = listCellRenderer.getListCellRendererComponent(BasicComboBoxUI.this.listBox, comboBoxModel.getElementAt(n5), -1, false, false);
                    BasicComboBoxUI.this.currentValuePane.add(component);
                    component.setFont(BasicComboBoxUI.this.comboBox.getFont());
                    Dimension dimension = component.getPreferredSize();
                    n3 = Math.max(n3, dimension.width);
                    n4 = Math.max(n4, dimension.height);
                    BasicComboBoxUI.this.currentValuePane.remove(component);
                    ++n5;
                }
                if (BasicComboBoxUI.this.cachedDisplaySize.width < n3 || BasicComboBoxUI.this.cachedDisplaySize.height < n4) {
                    if (BasicComboBoxUI.this.cachedDisplaySize.width < n3) {
                        BasicComboBoxUI.this.cachedMinimumSize.width += n3 - BasicComboBoxUI.this.cachedDisplaySize.width;
                    }
                    if (BasicComboBoxUI.this.cachedDisplaySize.height < n4) {
                        BasicComboBoxUI.this.cachedMinimumSize.height += n4 - BasicComboBoxUI.this.cachedDisplaySize.height;
                    }
                    BasicComboBoxUI.this.cachedDisplaySize.setSize(n4, n3);
                    BasicComboBoxUI.this.comboBox.revalidate();
                    if (BasicComboBoxUI.this.editor != null) {
                        BasicComboBoxUI.this.comboBox.configureEditor(BasicComboBoxUI.this.comboBox.getEditor(), BasicComboBoxUI.this.comboBox.getSelectedItem());
                    }
                }
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }
    }

    public class ItemHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            ComboBoxModel comboBoxModel = BasicComboBoxUI.this.comboBox.getModel();
            Object object = comboBoxModel.getSelectedItem();
            if (BasicComboBoxUI.this.editor != null) {
                BasicComboBoxUI.this.comboBox.configureEditor(BasicComboBoxUI.this.comboBox.getEditor(), object);
            }
            BasicComboBoxUI.this.comboBox.repaint();
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                ComboBoxModel comboBoxModel = (ComboBoxModel)propertyChangeEvent.getNewValue();
                ComboBoxModel comboBoxModel2 = (ComboBoxModel)propertyChangeEvent.getOldValue();
                if (comboBoxModel2 != null && BasicComboBoxUI.this.listDataListener != null) {
                    comboBoxModel2.removeListDataListener(BasicComboBoxUI.this.listDataListener);
                }
                if (comboBoxModel != null && BasicComboBoxUI.this.listDataListener != null) {
                    comboBoxModel.addListDataListener(BasicComboBoxUI.this.listDataListener);
                }
                if (BasicComboBoxUI.this.editor != null) {
                    BasicComboBoxUI.this.comboBox.configureEditor(BasicComboBoxUI.this.comboBox.getEditor(), BasicComboBoxUI.this.comboBox.getSelectedItem());
                }
                BasicComboBoxUI.this.isMinimumSizeDirty = true;
                BasicComboBoxUI.this.comboBox.revalidate();
                BasicComboBoxUI.this.comboBox.repaint();
            } else if (string.equals("editor") && BasicComboBoxUI.this.comboBox.isEditable()) {
                BasicComboBoxUI.this.removeEditor();
                BasicComboBoxUI.this.addEditor();
            } else if (string.equals("editable")) {
                if (BasicComboBoxUI.this.comboBox.isEditable()) {
                    BasicComboBoxUI.this.comboBox.setRequestFocusEnabled(false);
                    if (BasicComboBoxUI.this.popupKeyListener != null) {
                        BasicComboBoxUI.this.comboBox.removeKeyListener(BasicComboBoxUI.this.popupKeyListener);
                    }
                    BasicComboBoxUI.this.addEditor();
                    if (BasicComboBoxUI.this.editor != null) {
                        BasicComboBoxUI.this.configureEditor();
                    }
                } else {
                    BasicComboBoxUI.this.comboBox.setRequestFocusEnabled(true);
                    if (BasicComboBoxUI.this.popupKeyListener != null) {
                        BasicComboBoxUI.this.comboBox.addKeyListener(BasicComboBoxUI.this.popupKeyListener);
                    }
                    BasicComboBoxUI.this.removeEditor();
                }
                BasicComboBoxUI.this.comboBox.revalidate();
                BasicComboBoxUI.this.comboBox.validate();
                BasicComboBoxUI.this.comboBox.revalidate();
                BasicComboBoxUI.this.comboBox.repaint();
            } else if (string.equals("enabled")) {
                boolean bl = BasicComboBoxUI.this.comboBox.isEnabled();
                if (bl) {
                    if (BasicComboBoxUI.this.editor != null) {
                        BasicComboBoxUI.this.editor.setEnabled(true);
                    }
                    if (BasicComboBoxUI.this.arrowButton != null) {
                        BasicComboBoxUI.this.arrowButton.setEnabled(true);
                    }
                } else {
                    if (BasicComboBoxUI.this.editor != null) {
                        BasicComboBoxUI.this.editor.setEnabled(false);
                    }
                    if (BasicComboBoxUI.this.arrowButton != null) {
                        BasicComboBoxUI.this.arrowButton.setEnabled(false);
                    }
                }
                BasicComboBoxUI.this.comboBox.repaint();
            } else if (string.equals("maximumRowCount")) {
                if (BasicComboBoxUI.this.isPopupVisible(BasicComboBoxUI.this.comboBox)) {
                    BasicComboBoxUI.this.setPopupVisible(BasicComboBoxUI.this.comboBox, false);
                    BasicComboBoxUI.this.setPopupVisible(BasicComboBoxUI.this.comboBox, true);
                }
            } else if (string.equals("font")) {
                BasicComboBoxUI.this.listBox.setFont(BasicComboBoxUI.this.comboBox.getFont());
                if (BasicComboBoxUI.this.editor != null) {
                    BasicComboBoxUI.this.editor.setFont(BasicComboBoxUI.this.comboBox.getFont());
                }
            } else if (string.equals(BasicComboBoxUI.LIGHTWEIGHT_KEYBOARD_NAVIGATION)) {
                Object object = propertyChangeEvent.getNewValue();
                if (object.equals(BasicComboBoxUI.LIGHTWEIGHT_KEYBOARD_NAVIGATION_ON)) {
                    BasicComboBoxUI.this.lightNav = true;
                } else if (object.equals(BasicComboBoxUI.LIGHTWEIGHT_KEYBOARD_NAVIGATION_OFF)) {
                    BasicComboBoxUI.this.lightNav = false;
                }
            }
        }
    }

    public class ComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            int n = jComboBox.getWidth();
            int n2 = jComboBox.getHeight();
            Insets insets = BasicComboBoxUI.this.getInsets();
            int n3 = n2 - (insets.top + insets.bottom);
            if (BasicComboBoxUI.this.arrowButton != null) {
                BasicComboBoxUI.this.arrowButton.setBounds(n - (insets.right + n3), insets.top, n3, n3);
            }
            if (BasicComboBoxUI.this.editor != null) {
                Rectangle rectangle = BasicComboBoxUI.this.rectangleForCurrentValue();
                BasicComboBoxUI.this.editor.setBounds(rectangle);
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            return container.getMinimumSize();
        }

        public Dimension preferredLayoutSize(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            return container.getPreferredSize();
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

