/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.util;

import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    private static boolean systemUsesDotDecimal = true;
    private static DecimalFormat dotDecimalFormat;
    private static DecimalFormat commaDecimalFormat;
    private static final byte PARENS = 0;
    private static final byte MULT_DIV = 1;
    private static final byte ADD_SUB = 2;
    private static final Character multChar1;
    private static final Character multChar2;
    private static final Character divChar;
    private static final Character plusChar;
    private static final Character minusChar;
    private static final Character leftParenChar;
    private static final Character rightParenChar;

    public static final boolean isInteger(String string) {
        if ((string = string.trim()).length() <= 0) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < '0' || c > '9') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static final String fieldIndex(String string, char c, int n) {
        int n2;
        int n3 = string.indexOf(c);
        int n4 = 0;
        int n5 = 0;
        int n6 = string.length();
        String string2 = "";
        do {
            if (n4 == n) {
                n2 = string.indexOf(c, n5);
                if (n2 >= 0) {
                    return string.substring(n5, n2);
                }
                return string.substring(n5, n6);
            }
            n2 = string.indexOf(c, n5);
            if (n2 < 0) {
                return "";
            }
            ++n4;
        } while ((n5 = n2 + 1) < n6);
        return "";
    }

    public static final String decode(String string) {
        int n = string.length();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\\') {
                if (++n2 >= n) {
                    stringBuffer.append(c);
                    break;
                }
                c = string.charAt(n2);
                if (c == 'n') {
                    stringBuffer.append('\n');
                } else if (c == 't') {
                    stringBuffer.append('\t');
                } else {
                    stringBuffer.append(c);
                }
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static final String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\t') {
                stringBuffer.append("\\t");
            } else if (c == '\n') {
                stringBuffer.append("\\n");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final String makeFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '_') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append('_');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final String stripNonNumbers(String string) {
        return StringUtils.stripNonNumbers(string, '.');
    }

    public static final String stripNonNumbers(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = string.length();
        boolean bl = false;
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 >= '0' && c2 <= '9') {
                stringBuffer.append(c2);
                bl2 = false;
            } else if (c2 == c && !bl) {
                bl = true;
                stringBuffer.append(c2);
                bl2 = false;
            } else if (c2 == '-' && bl2) {
                stringBuffer.append(c2);
                bl2 = false;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static final String getNLengthString(int n, char c) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static final String fillLeft(String string, int n, char c) {
        if (string == null) {
            return StringUtils.getNLengthString(n, c);
        }
        int n2 = string.length();
        if (n2 >= n) {
            return string.substring(0, n);
        }
        return StringUtils.getNLengthString(n - n2, c) + string;
    }

    public static final void sortStringArray(String[] stringArray) {
        StringUtils.quicksortAscending(stringArray, 0, stringArray.length - 1);
    }

    private static final void quicksortAscending(String[] stringArray, int n, int n2) {
        if (n < n2) {
            int n3 = StringUtils.partitionAscending(stringArray, n, n2);
            StringUtils.quicksortAscending(stringArray, n, n3 - 1);
            StringUtils.quicksortAscending(stringArray, n3, n2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final int partitionAscending(String[] var0, int var1_1, int var2_2) {
        var3_3 = var0[(var1_1 + var2_2) / 2];
        ** GOTO lbl15
        {
            ++var1_1;
            do {
                if (var0[var1_1].compareTo(var3_3) < 0) continue block0;
                while (var0[var2_2].compareTo(var3_3) > 0) {
                    --var2_2;
                }
                if (var1_1 > var2_2) continue;
                var4_4 = var0[var1_1];
                var0[var1_1] = var0[var2_2];
                var0[var2_2] = var4_4;
                ++var1_1;
                --var2_2;
lbl15:
                // 3 sources

            } while (var1_1 <= var2_2);
        }
        return var1_1;
    }

    public static final String fillRight(String string, int n, char c) {
        if (string == null) {
            return StringUtils.getNLengthString(n, c);
        }
        int n2 = string.length();
        if (n2 >= n) {
            return string.substring(0, n);
        }
        return string + StringUtils.getNLengthString(n - n2, c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final double parseFraction(String string, char c) {
        try {
            double d = 1.0;
            double d2 = 0.0;
            double d3 = 0.0;
            int n = string.indexOf(47);
            if (n <= 0) {
                return StringUtils.parseDouble(string.trim(), c);
            }
            String string2 = string.substring(0, n).trim();
            int n2 = string2.indexOf(32);
            if (n2 >= 0) {
                d3 = StringUtils.parseDouble(string2.substring(0, n2).trim(), c);
                string2 = string.substring(n2 + 1).trim();
            }
            d2 = StringUtils.parseDouble(string2, c);
            d = StringUtils.parseDouble(string.substring(n + 1).trim(), c);
            return d3 + d2 / d;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            System.err.println(stringArray[n] + " = " + StringUtils.parseRate(stringArray[n], '.'));
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final double parseRate(String string, char c) {
        double d = 0.0;
        boolean bl = false;
        string = string.trim();
        do {
            String string2;
            int n;
            if ((n = string.indexOf(32)) >= 0) {
                string2 = string.substring(0, n).trim();
                string = string.substring(n + 1).trim();
            } else {
                string2 = string;
                string = "";
            }
            if (string2.indexOf(47) >= 0) {
                d += StringUtils.parseFraction(string2, c);
                bl = true;
                continue;
            }
            try {
                d += StringUtils.parseDouble(string2, c);
                bl = true;
            }
            catch (Exception exception) {
            }
        } while (string.length() > 0);
        if (bl) {
            return d;
        }
        return d;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final double parseDouble(String string, char c) {
        try {
            return StringUtils.parseDoubleWithException(string, c);
        }
        catch (Exception exception) {
            System.err.println("Error parsing floating-point value (" + string + "): " + exception);
            exception.printStackTrace(System.err);
            return 1.0;
        }
    }

    public static final double parseDoubleWithException(String string, char c) throws Exception {
        if (c == '.') {
            return dotDecimalFormat.parse(string).doubleValue();
        }
        return commaDecimalFormat.parse(string).doubleValue();
    }

    public static final String formatPercentage(double d, char c) {
        String string = StringUtils.formatRate(d * 100.0, c);
        int n = string.indexOf(c);
        if (n >= 0) {
            return string.substring(0, n) + '.' + StringUtils.fillRight(string.substring(n + 1, Math.min(n + 3, string.length())), 2, '0');
        }
        return string + ".00";
    }

    public static final String formatRate(double d, char c) {
        if (c == '.') {
            return dotDecimalFormat.format(new Double(d));
        }
        return commaDecimalFormat.format(new Double(d));
    }

    public static final String formatCurrency(long l, boolean bl, char c, char c2) {
        return StringUtils.formatCurrency(l, bl, c, c2, 2);
    }

    public static final String formatCurrency(long l, boolean bl, char c, char c2, int n) {
        return StringUtils.formatCurrency(l, bl, c, c2, n, (int)Math.round(Math.pow(10.0, n)));
    }

    public static final String formatCurrency(long l, boolean bl, char c, char c2, int n, int n2) {
        boolean bl2;
        boolean bl3 = bl2 = l < 0L;
        if (bl2) {
            l *= -1L;
        }
        if (!bl) {
            String string = "";
            if (n > 0) {
                string = "" + c + StringUtils.fillLeft(String.valueOf(l % (long)n2), n, '0');
            }
            return new String((bl2 ? "-" : "") + l / (long)n2) + string;
        }
        StringBuffer stringBuffer = new StringBuffer("" + l / (long)n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringBuffer.length()) {
            if (n3 == 2 && n4 < stringBuffer.length() - 1) {
                stringBuffer.insert(stringBuffer.length() - n4 - 1, c2);
                ++n4;
                n3 = -1;
            }
            ++n3;
            ++n4;
        }
        return (bl2 ? "-" : "") + stringBuffer + (n > 0 ? c + StringUtils.fillLeft("" + l % (long)n2, n, '0') : "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final long parseQuickenDate(String string) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (string.indexOf(47) >= 0) {
            string2 = StringUtils.fieldIndex(string, '/', 0).trim();
            string3 = StringUtils.fieldIndex(string, '/', 1).trim();
            string4 = StringUtils.fieldIndex(string, '/', 2).trim();
        } else if (string.indexOf(46) >= 0) {
            string3 = StringUtils.fieldIndex(string, '.', 0).trim();
            string2 = StringUtils.fieldIndex(string, '.', 1).trim();
            string4 = StringUtils.fieldIndex(string, '.', 2).trim();
        } else if (string.indexOf(45) >= 0) {
            string2 = StringUtils.fieldIndex(string, '-', 0).trim();
            string3 = StringUtils.fieldIndex(string, '-', 1).trim();
            string4 = StringUtils.fieldIndex(string, '-', 2).trim();
        }
        try {
            calendar.set(2, Integer.parseInt(string2) - 1);
        }
        catch (Exception exception) {
        }
        try {
            calendar.set(5, Integer.parseInt(string3));
        }
        catch (Exception exception) {
        }
        try {
            int n = Integer.parseInt(string4);
            if (n > 1800) {
                calendar.set(1, n);
                return calendar.getTime().getTime();
            }
            if (n < 50) {
                calendar.set(1, n + 2000);
                return calendar.getTime().getTime();
            }
            calendar.set(1, n + 1900);
            return calendar.getTime().getTime();
        }
        catch (Exception exception) {
        }
        return calendar.getTime().getTime();
    }

    public static final boolean looksLikeFormula(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= '0' && c <= '9') {
                bl = true;
                if (bl2) {
                    return true;
                }
            } else if ((c == '-' || c == '*' || c == 'x' || c == 'X' || c == '/' || c == '+') && bl) {
                bl2 = true;
            }
            ++n;
        }
        return false;
    }

    public static final long parseCurrencyExpression(String string, char c, CurrencyType currencyType, CurrencyTable currencyTable) throws Exception {
        String string2;
        CurrencyType currencyType2 = null;
        string = String.valueOf(string).trim();
        int n = string.lastIndexOf(32);
        if (currencyTable != null && n > 0 && (currencyType2 = currencyTable.getCurrencyType(string2 = string.substring(n + 1))) != null) {
            string = string.substring(0, n).trim();
        }
        if (StringUtils.looksLikeFormula(string)) {
            System.err.println("\"" + string + "\" looks like a formular...");
            double d = StringUtils.parseFormula(string, c);
            if (currencyType2 != null) {
                long l = Math.round(d * Math.pow(10.0, currencyType2.getDecimalPlaces()));
                return currencyTable.convertValue(l, currencyType2, currencyType);
            }
            return Math.round(d * Math.pow(10.0, currencyType.getDecimalPlaces()));
        }
        if (currencyType2 != null) {
            long l = StringUtils.parseCurrency(string, c, currencyType2.getDecimalPlaces());
            return currencyTable.convertValue(l, currencyType2, currencyType);
        }
        return StringUtils.parseCurrency(string, c, currencyType.getDecimalPlaces());
    }

    private static final boolean isOperator(Object object) {
        return object instanceof Character;
    }

    public static final double parseFormula(String string, char c) throws Exception {
        Vector vector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " +-/*x()", true);
        boolean bl = true;
        Vector<Comparable<Character>> vector2 = new Vector<Comparable<Character>>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            if (!bl && "+-/*x".indexOf(string2) >= 0) {
                vector2.addElement(new Character(string2.charAt(0)));
                bl = true;
                continue;
            }
            if (bl && "-".indexOf(string2) >= 0) {
                vector2.addElement(new Double(-1.0));
                vector2.addElement(multChar1);
                bl = false;
                continue;
            }
            if (bl && "(".indexOf(string2) >= 0) {
                vector2.addElement(new Character(string2.charAt(0)));
                bl = true;
                continue;
            }
            if (!bl && ")".indexOf(string2) >= 0) {
                vector2.addElement(new Character(string2.charAt(0)));
                bl = false;
                continue;
            }
            if ("+-/*x".indexOf(string2) >= 0) {
                System.err.println("not expecting operator: " + string2);
                throw new Exception("Invalid token: \"" + string2 + "\", expecting value not operator");
            }
            vector2.addElement(new Double(StringUtils.parseDoubleWithException(string2, c)));
            bl = false;
        }
        return StringUtils.evaluateFormula(vector2);
    }

    private static final double evaluateFormula(Vector vector) throws Exception {
        Stack stack = new Stack();
        Stack stack2 = new Stack();
        int n = vector.size() - 1;
        while (n >= 0) {
            stack2.push(vector.elementAt(n));
            --n;
        }
        StringUtils.processFormula(stack, stack2, (byte)0);
        while (!stack.empty()) {
            stack2.push(stack.pop());
        }
        StringUtils.processFormula(stack, stack2, (byte)1);
        while (!stack.empty()) {
            stack2.push(stack.pop());
        }
        StringUtils.processFormula(stack, stack2, (byte)2);
        while (!stack.empty()) {
            stack2.push(stack.pop());
        }
        if (stack2.size() > 1) {
            throw new Exception("Invalid numeric expression: Too many tokens!");
        }
        if (stack2.size() < 1) {
            throw new Exception("Invalid numeric expression: not enough tokens!");
        }
        double d = 0.0;
        Object e = stack2.pop();
        if (!(e instanceof Double)) {
            throw new Exception("Invalid numeric expression: \"" + e + "\"");
        }
        d = (Double)e;
        return d;
    }

    private static final void processFormula(Stack stack, Stack stack2, byte by) throws Exception {
        byte by2 = by;
        while (!stack2.empty()) {
            Object e = stack2.pop();
            boolean bl = false;
            boolean bl2 = false;
            if (by2 == 1 && (e.equals(multChar1) || e.equals(multChar2) || e.equals(divChar)) || by2 == 2 && (e.equals(plusChar) || e.equals(minusChar))) {
                bl = true;
            } else if (by2 == 0 && e.equals(leftParenChar)) {
                bl2 = true;
            }
            if (bl2) {
                Vector vector = new Vector();
                int n = 1;
                while (n > 0 && !stack2.empty()) {
                    Object e2 = stack2.pop();
                    if (e2.equals(leftParenChar)) {
                        vector.addElement(e2);
                        ++n;
                        continue;
                    }
                    if (e2.equals(rightParenChar)) {
                        if (--n <= 0) break;
                        vector.addElement(e2);
                        continue;
                    }
                    vector.addElement(e2);
                }
                if (n != 0) {
                    throw new Exception("Error: unmatched \"(\"");
                }
                if (vector.size() <= 0) continue;
                stack.push(new Double(StringUtils.evaluateFormula(vector)));
                continue;
            }
            if (bl) {
                double d;
                double d2;
                if (stack.empty() || !(stack.peek() instanceof Double)) {
                    throw new Exception("Invalid expression: unexpected: \"" + e + "\"");
                }
                if (stack2.empty() || !(stack2.peek() instanceof Double)) {
                    throw new Exception("Invalid expression: unexpected: \"" + e + "\"");
                }
                if (by2 == 1 && (e.equals(multChar2) || e.equals(multChar1))) {
                    d2 = (Double)stack2.pop();
                    d = (Double)stack.pop();
                    stack.push(new Double(d * d2));
                    continue;
                }
                if (by2 == 1 && e.equals(divChar)) {
                    d2 = (Double)stack2.pop();
                    d = (Double)stack.pop();
                    if (d == 0.0) {
                        d = 1.0E-5;
                    }
                    stack.push(new Double(d / d2));
                    continue;
                }
                if (by2 == 2 && e.equals(plusChar)) {
                    d2 = (Double)stack2.pop();
                    d = (Double)stack.pop();
                    stack.push(new Double(d + d2));
                    continue;
                }
                if (by2 == 2 && e.equals(minusChar)) {
                    d2 = (Double)stack2.pop();
                    d = (Double)stack.pop();
                    stack.push(new Double(d - d2));
                    continue;
                }
                if (e.equals(rightParenChar)) {
                    throw new Exception("Error: got unopened grouping end char: " + e);
                }
                stack.push(e);
                continue;
            }
            stack.push(e);
        }
    }

    public static final long parseCurrency(String string, char c, int n) {
        return StringUtils.parseCurrency(string, c, n, (int)Math.round(Math.pow(10.0, n)));
    }

    public static final long parseCurrency(String string, char c, int n, int n2) {
        long l = 0L;
        string = StringUtils.stripNonNumbers(string, c).trim();
        boolean bl = false;
        if (string.length() <= 0) {
            return 0;
        }
        if (string.charAt(0) == '-') {
            bl = true;
            string = string.substring(1).trim();
        }
        if (string.length() <= 0) {
            return 0;
        }
        int n3 = string.indexOf(c);
        if (n3 < 0) {
            l = Long.parseLong(string) * (long)n2;
        } else if (n3 > 0) {
            String string2;
            l = Long.parseLong(string.substring(0, n3)) * (long)n2;
            if (n > 0 && string.length() - n3 > n + 1) {
                l += (long)Integer.parseInt(string.substring(n3 + 1, n3 + n + 1));
            } else if (n > 0 && (string2 = string.substring(n3 + 1, string.length()).trim()).length() > 0) {
                l += (long)Integer.parseInt(StringUtils.fillRight(string2, n, '0'));
            }
        } else if (n > 0 && (string = string.substring(1, Math.min(n + 1, string.length()))).length() > 0) {
            l = Integer.parseInt(StringUtils.fillRight(string, n, '0'));
        }
        if (bl) {
            return l * -1L;
        }
        return l;
    }

    public static final char guessDecimalType(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            char c = string.charAt(n);
            if (c == '.' || c == ',') {
                return c;
            }
            --n;
        }
        return '.';
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            systemUsesDotDecimal = !(new Double("5,5") == 5.5);
        }
        catch (Exception exception) {
        }
        dotDecimalFormat = new DecimalFormat("#.#################");
        DecimalFormatSymbols decimalFormatSymbols = dotDecimalFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        dotDecimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        commaDecimalFormat = new DecimalFormat("#.################");
        decimalFormatSymbols = commaDecimalFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator(',');
        decimalFormatSymbols.setGroupingSeparator('.');
        commaDecimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        multChar1 = new Character('*');
        multChar2 = new Character('x');
        divChar = new Character('/');
        plusChar = new Character('+');
        minusChar = new Character('-');
        leftParenChar = new Character('(');
        rightParenChar = new Character(')');
    }
}

