/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.util;

import com.seanreilly.util.DeepClone;
import com.seanreilly.util.StreamObject;
import com.seanreilly.util.StreamTable;
import com.seanreilly.util.StreamUtil;
import com.seanreilly.util.StringEncodingException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;

public class StreamVector
extends Vector
implements StreamObject {
    private String crap = "";

    public boolean isStreamTable() {
        return false;
    }

    public boolean isStreamVector() {
        return true;
    }

    public char startingDelimiter() {
        return '(';
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFrom(String string) throws StringEncodingException {
        StringReader stringReader = new StringReader(string);
        try {
            this.readFrom(stringReader);
            return;
        }
        catch (IOException iOException) {
            throw new StringEncodingException("IO exception: " + iOException.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object deepClone() {
        StreamVector streamVector = new StreamVector();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            try {
                if (object instanceof DeepClone) {
                    object = ((DeepClone)object).deepClone();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception cloning item in StreamVector: " + enumeration);
            }
            streamVector.addElement(object);
        }
        return streamVector;
    }

    public void readFrom(Reader reader) throws StringEncodingException, IOException {
        char c;
        while ((c = StreamUtil.getNonWhitespace(reader)) == '(') {
            this.readTheRest(reader);
        }
        throw new StringEncodingException("Expected '(', got '" + c + "'");
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(this.writeToString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String writeToString() {
        StringBuffer stringBuffer = new StringBuffer("(\n");
        int n = 0;
        while (n < this.size()) {
            Object e = this.elementAt(n);
            try {
                StreamObject streamObject = (StreamObject)e;
                stringBuffer.append(streamObject.writeToString());
            }
            catch (ClassCastException classCastException) {
                stringBuffer.append(StreamUtil.encodeString(e.toString()));
                stringBuffer.append("\n");
            }
            ++n;
        }
        stringBuffer.append(")\n");
        return stringBuffer.toString();
    }

    public void readTheRest(Reader reader) throws StringEncodingException, IOException {
        this.removeAllElements();
        while (true) {
            Cloneable cloneable;
            Object object;
            char c;
            if ((c = StreamUtil.getNonWhitespace(reader)) == '\"') {
                object = StreamUtil.readString(reader);
            } else if (c == '{') {
                cloneable = new StreamTable();
                ((StreamTable)cloneable).readTheRest(reader);
                object = cloneable;
            } else if (c == '(') {
                cloneable = new StreamVector();
                ((StreamVector)cloneable).readTheRest(reader);
                object = cloneable;
            } else {
                if (c == ')') {
                    return;
                }
                if (c == '\uffffffff') {
                    throw new StringEncodingException("Unexpected end of input while reading Vector.");
                }
                object = StreamUtil.readUndelimitedString(reader, c);
            }
            this.addElement(object);
        }
    }
}

