/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.util;

import com.seanreilly.util.DeepClone;
import com.seanreilly.util.StreamObject;
import com.seanreilly.util.StreamUtil;
import com.seanreilly.util.StreamVector;
import com.seanreilly.util.StringEncodingException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;

public class StreamTable
extends Hashtable
implements StreamObject,
DeepClone {
    private String crap = "";

    public boolean isStreamTable() {
        return true;
    }

    public boolean isStreamVector() {
        return false;
    }

    public char startingDelimiter() {
        return '{';
    }

    public Object get(String string) {
        return this.get((Object)string);
    }

    public void merge(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.put(k, hashtable.get(k));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object deepClone() {
        StreamTable streamTable = new StreamTable();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            Object object2 = this.get(object);
            try {
                if (object instanceof DeepClone) {
                    object = ((DeepClone)object).deepClone();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception cloning key in StreamTable: " + exception);
            }
            try {
                if (object2 instanceof DeepClone) {
                    object2 = ((DeepClone)object2).deepClone();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception cloning value in StreamTable: " + exception);
            }
            streamTable.put(object, object2);
        }
        return streamTable;
    }

    public void readFrom(InputStream inputStream) throws StringEncodingException, IOException {
        this.readFrom(new InputStreamReader(inputStream));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFrom(String string) throws StringEncodingException {
        StringReader stringReader = new StringReader(string);
        try {
            this.readFrom(stringReader);
            return;
        }
        catch (IOException iOException) {
            throw new StringEncodingException("IO exception: " + iOException.toString());
        }
    }

    public void readFrom(Reader reader) throws StringEncodingException, IOException {
        char c = StreamUtil.getNonWhitespace(reader);
        if (c != '{') {
            throw new StringEncodingException("Expected {, got " + c);
        }
        this.readTheRest(reader);
    }

    public void readFromFile(File file) throws StringEncodingException, IOException {
        FileReader fileReader = new FileReader(file);
        this.readFrom(fileReader);
        ((Reader)fileReader).close();
    }

    public void readFromFile(String string) throws StringEncodingException, IOException {
        this.readFromFile(new File(string));
    }

    public void writeToFile(String string) throws StringEncodingException, IOException {
        this.writeToFile(new File(string));
    }

    public void writeToFile(File file) throws StringEncodingException, IOException {
        FileWriter fileWriter = new FileWriter(file);
        this.writeTo(fileWriter);
        ((Writer)fileWriter).close();
    }

    public void readTheRest(Reader reader) throws StringEncodingException, IOException {
        this.clear();
        while (true) {
            Cloneable cloneable;
            Object object;
            String string;
            char c;
            if ((c = StreamUtil.getNonWhitespace(reader)) == '\"') {
                string = StreamUtil.readString(reader);
            } else {
                if (c == '}') {
                    return;
                }
                if (c == '\uffffffff') {
                    throw new StringEncodingException("Unexpected end of input in StreamTable.");
                }
                string = StreamUtil.readUndelimitedString(reader, c);
            }
            c = StreamUtil.getNonWhitespace(reader);
            if (c != '=') {
                throw new StringEncodingException("Expected \"=\" ");
            }
            c = StreamUtil.getNonWhitespace(reader);
            if (c == '\"') {
                object = StreamUtil.readString(reader);
            } else if (c == '{') {
                cloneable = new StreamTable();
                ((StreamTable)cloneable).readTheRest(reader);
                object = cloneable;
            } else if (c == '(') {
                cloneable = new StreamVector();
                ((StreamVector)cloneable).readTheRest(reader);
                object = cloneable;
            } else {
                if (c == '\uffffffff') {
                    throw new StringEncodingException("Unexpected end of input: Expected value for key: '" + string + "'");
                }
                object = StreamUtil.readUndelimitedString(reader, c);
            }
            this.put(string, object);
        }
    }

    public String toString() {
        return this.writeToString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String writeToString() {
        StringBuffer stringBuffer = new StringBuffer("{\n");
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            stringBuffer.append(StreamUtil.encodeString(k.toString()) + " = ");
            Object v = this.get(k);
            try {
                StreamObject streamObject = (StreamObject)v;
                stringBuffer.append(streamObject.writeToString());
            }
            catch (ClassCastException classCastException) {
                stringBuffer.append(StreamUtil.encodeString(v.toString()));
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(this.writeToString());
    }

    public StreamTable() {
    }

    public StreamTable(int n) {
        super(n);
    }

    public StreamTable(int n, float f) {
        super(n, f);
    }
}

