/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt.graph;

import com.seanreilly.awt.graph.BalloonHelp;
import com.seanreilly.awt.graph.DataSet;
import com.seanreilly.awt.graph.GraphPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;

public class LineGraphPanel
extends GraphPanel {
    protected int leftMargin = 80;
    protected int rightMargin = 40;
    protected int topMargin = 10;
    protected int bottomMargin = 30;
    protected int graphDepth = 10;
    protected int lineWidth = 1;
    protected int threeDXOffset = 3;
    protected int threeDYOffset = 2;
    private Number maxXn;
    private Number minXn;
    private Number maxYn;
    private Number minYn;
    private boolean showShadow = true;

    public void setShowShadow(boolean bl) {
        if (this.showShadow != bl) {
            this.showShadow = bl;
            this.renderGraph();
        }
    }

    public boolean getShowsShadow() {
        return this.showShadow;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void drawGraph(Graphics graphics, int n, int n2, boolean bl) {
        int n3;
        int n4;
        String string;
        Number[] numberArray;
        if (graphics == null) {
            return;
        }
        int n5 = this.getNumDataSets();
        int n6 = 0;
        int n7 = 0;
        this.maxYn = null;
        this.minYn = null;
        this.maxXn = null;
        this.minXn = null;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n, n2);
        if (n5 <= 0) {
            return;
        }
        DataSet dataSet = this.getDataSet(0);
        if (this.threeD) {
            this.graphDepth = Math.min(45, 9 * n5);
            n6 = (int)((float)n5 / (float)this.graphDepth) * 3;
            n7 = (int)((float)n5 / (float)this.graphDepth) * 2;
            this.lineWidth = this.graphDepth / n5;
            this.threeDYOffset = 2;
            this.threeDXOffset = 3;
        } else {
            this.graphDepth = 1;
            this.lineWidth = 1;
            this.threeDXOffset = 0;
            this.threeDYOffset = 0;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.leftMargin = 40;
        this.rightMargin = Math.max(this.graphDepth * this.threeDXOffset + 10, 20);
        this.bottomMargin = 20;
        this.topMargin = Math.max(this.graphDepth * this.threeDYOffset + 10, 40);
        int n8 = 0;
        while (n8 < n5) {
            numberArray = this.getDataSet(n8);
            if (numberArray.getNumValues() > 0) {
                Number number = numberArray.getMaxXValue();
                if (this.maxXn == null || number.doubleValue() > this.maxXn.doubleValue()) {
                    this.maxXn = number;
                }
                number = numberArray.getMaxYValue();
                if (this.maxYn == null || number.doubleValue() > this.maxYn.doubleValue()) {
                    this.maxYn = number;
                }
                number = numberArray.getMinXValue();
                if (this.minXn == null || number.doubleValue() < this.minXn.doubleValue()) {
                    this.minXn = number;
                }
                number = numberArray.getMinYValue();
                if (this.minYn == null || number.doubleValue() < this.minYn.doubleValue()) {
                    this.minYn = number;
                }
            }
            ++n8;
        }
        if (this.maxXn == null || this.maxYn == null || this.minXn == null || this.minYn == null) {
            String string2 = "No Data to Graph";
            graphics.setColor(Color.black);
            graphics.drawString(string2, n / 2 - fontMetrics.stringWidth(string2), (n2 + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent()) / 2);
            return;
        }
        Number[] numberArray2 = DataSet.getTicks(this.minYn, this.maxYn, n2 - this.bottomMargin - this.topMargin, this.getDataSet(0).getYType(), fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent());
        numberArray = DataSet.getTicks(this.minXn, this.maxXn, n - this.rightMargin - this.leftMargin, this.getDataSet(0).getXType(), Math.max(fontMetrics.stringWidth(DataSet.formatValue(this.maxXn, this.getDataSet(0).getXType())), fontMetrics.stringWidth(DataSet.formatValue(this.minXn, this.getDataSet(0).getXType()))) + 10);
        this.minYn = numberArray2[0];
        this.maxYn = numberArray2[numberArray2.length - 1];
        this.minXn = numberArray[0];
        this.maxXn = numberArray[numberArray.length - 1];
        this.leftMargin = Math.max(fontMetrics.stringWidth(DataSet.formatValue(this.maxYn, this.getDataSet(0).getYType())) + 3, Math.max(fontMetrics.stringWidth(DataSet.formatValue(this.minYn, this.getDataSet(0).getXType())) + 3, this.leftMargin));
        if (n2 - this.bottomMargin <= this.topMargin || n - this.rightMargin <= this.leftMargin) {
            return;
        }
        double d = this.maxXn.doubleValue();
        double d2 = this.minXn.doubleValue();
        double d3 = this.maxYn.doubleValue();
        double d4 = this.minYn.doubleValue();
        double d5 = d - d2;
        double d6 = d3 - d4;
        double d7 = (double)(n - this.rightMargin - this.leftMargin) / d5;
        double d8 = (double)(n2 - this.bottomMargin - this.topMargin) / d6;
        int n9 = 0;
        while (n9 < numberArray2.length) {
            string = DataSet.formatValue(numberArray2[n9], dataSet.getYType());
            n4 = fontMetrics.stringWidth(string);
            n3 = n2 - this.bottomMargin - (n2 - this.bottomMargin - this.topMargin) * n9 / (numberArray2.length - 1);
            graphics.setColor(Color.black);
            graphics.drawString(string, this.leftMargin - n4, n3);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(2, n3, this.leftMargin, n3);
            graphics.drawLine(this.leftMargin, n3, this.leftMargin + this.graphDepth * this.threeDXOffset, n3 - this.graphDepth * this.threeDYOffset);
            graphics.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, n3 - this.threeDYOffset * this.graphDepth, n - this.rightMargin + this.threeDXOffset * this.graphDepth, n3 - this.threeDYOffset * this.graphDepth);
            ++n9;
        }
        n9 = -1;
        n3 = 0;
        while (n3 < numberArray.length) {
            string = DataSet.formatValue(numberArray[n3], dataSet.getXType());
            int n10 = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
            n4 = fontMetrics.stringWidth(string);
            int n11 = (int)((numberArray[n3].doubleValue() - d2) * d7);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(this.leftMargin + n11, n2 - this.bottomMargin, this.leftMargin + n11, n2 - this.bottomMargin + n10 + 2);
            graphics.drawLine(this.leftMargin + n11, n2 - this.bottomMargin, this.leftMargin + n11 + this.graphDepth * this.threeDXOffset, n2 - this.bottomMargin - this.graphDepth * this.threeDYOffset);
            if (n11 > n9 && n11 + n4 + this.leftMargin < n - this.rightMargin) {
                graphics.drawLine(this.leftMargin + n11 + this.graphDepth * this.threeDXOffset, n2 - this.bottomMargin - this.graphDepth * this.threeDYOffset, this.leftMargin + n11 + this.graphDepth * this.threeDXOffset, this.topMargin - this.graphDepth * this.threeDYOffset);
                graphics.setColor(Color.blue);
                graphics.drawString(string, this.leftMargin + n11 + 2, n2 - this.bottomMargin + n10);
                n9 = n11 + n4;
            }
            ++n3;
        }
        graphics.setColor(Color.black);
        graphics.drawLine(this.leftMargin, this.topMargin, this.leftMargin, n2 - this.bottomMargin);
        graphics.drawLine(this.leftMargin, n2 - this.bottomMargin, n - this.rightMargin, n2 - this.bottomMargin);
        if (this.threeD) {
            graphics.drawLine(this.leftMargin, this.topMargin, this.leftMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth);
            graphics.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth, n - this.rightMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth);
            graphics.drawLine(this.leftMargin, n2 - this.bottomMargin, this.leftMargin + this.threeDXOffset * this.graphDepth, n2 - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            graphics.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth, this.leftMargin + this.threeDXOffset * this.graphDepth, n2 - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            graphics.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, n2 - this.bottomMargin - this.threeDYOffset * this.graphDepth, n - this.rightMargin + this.threeDXOffset * this.graphDepth, n2 - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            graphics.drawLine(n - this.rightMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth, n - this.rightMargin + this.threeDXOffset * this.graphDepth, n2 - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            graphics.drawLine(n - this.rightMargin + this.threeDXOffset * this.graphDepth, n2 - this.bottomMargin - this.threeDYOffset * this.graphDepth, n - this.rightMargin, n2 - this.bottomMargin);
        }
        if (!bl) {
            this.removeAllBalloonHelpItems();
        }
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        this.rightMargin -= this.graphDepth * this.threeDXOffset;
        this.leftMargin += this.graphDepth * this.threeDXOffset;
        this.topMargin -= this.graphDepth * this.threeDYOffset;
        this.bottomMargin += this.graphDepth * this.threeDYOffset;
        int n12 = 0;
        while (n12 < n5) {
            Object object;
            this.rightMargin += this.lineWidth * this.threeDXOffset;
            this.leftMargin -= this.lineWidth * this.threeDXOffset;
            this.bottomMargin -= this.lineWidth * this.threeDYOffset;
            this.topMargin += this.lineWidth * this.threeDYOffset;
            dataSet = this.getDataSet(n12);
            Color color = this.getColor(n12);
            boolean bl2 = true;
            String[] stringArray = dataSet.getDescription();
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            graphics.setColor(color);
            int n13 = dataSet.getNumValues();
            int[] nArray3 = new int[n13 * 2 + 1];
            int[] nArray4 = new int[n13 * 2 + 1];
            double d13 = 0.0;
            int n14 = 60;
            int n15 = 0;
            while (n15 < n13) {
                graphics.setColor(Color.black);
                graphics.drawLine(this.leftMargin, this.topMargin, this.leftMargin, n2 - this.bottomMargin);
                graphics.drawLine(this.leftMargin, n2 - this.bottomMargin, n - this.rightMargin, n2 - this.bottomMargin);
                d11 = (double)this.leftMargin + (dataSet.xvalues[n15].doubleValue() - d2) * d7;
                d12 = (double)(n2 - this.bottomMargin) - (dataSet.yvalues[n15].doubleValue() - d4) * d8;
                if (!bl2) {
                    if (this.threeD) {
                        boolean bl3;
                        object = new int[]{(int)d9, (int)d9 + this.threeDXOffset * this.lineWidth, (int)d11 + this.threeDXOffset * this.lineWidth, (int)d11};
                        int[] nArray5 = new int[]{n2 - this.bottomMargin, n2 - this.bottomMargin - this.lineWidth * this.threeDYOffset, n2 - this.bottomMargin - this.lineWidth * this.threeDYOffset, n2 - this.bottomMargin};
                        if (this.showShadow) {
                            graphics.setColor(color.darker().darker().darker());
                            graphics.setXORMode(Color.white);
                            graphics.fillPolygon(new Polygon((int[])object, nArray5, 4));
                            graphics.setPaintMode();
                        }
                        d13 = d11 != d9 ? (d12 - d10) / (d11 - d9) : 1000.0;
                        int n16 = 0;
                        boolean bl4 = bl3 = d13 > 0.0;
                        if (d13 < 0.0) {
                            d13 *= -1.0;
                        }
                        n16 = d13 <= 0.5 ? (int)(2.0 * d13 * 60.0) : (d13 <= 1.0 ? (int)(d13 * 70.0) : (d13 < 6.0 ? 75 + (int)((d13 - 1.0) / 5.0 * 10.0) : 80));
                        if (bl3) {
                            n16 *= -1;
                        }
                        graphics.setColor(new Color(Math.min(Math.max(color.getRed() + n16, 0), 255), Math.min(Math.max(color.getGreen() + n16, 0), 255), Math.min(Math.max(color.getBlue() + n16, 0), 255)));
                        nArray[0] = (int)d9;
                        nArray2[0] = (int)d10;
                        nArray[1] = (int)d9 + this.lineWidth * this.threeDXOffset;
                        nArray2[1] = (int)d10 - this.lineWidth * this.threeDYOffset;
                        nArray[2] = (int)d11 + this.lineWidth * this.threeDXOffset;
                        nArray2[2] = (int)d12 - this.lineWidth * this.threeDYOffset;
                        nArray[3] = (int)d11;
                        nArray2[3] = (int)d12;
                        graphics.fillPolygon(nArray, nArray2, 4);
                        graphics.setColor(color);
                        graphics.drawPolygon(nArray, nArray2, 4);
                    } else {
                        graphics.setColor(color);
                        graphics.drawLine((int)d9, (int)d10, (int)d11, (int)d12);
                    }
                }
                if (this.threeD) {
                    nArray3[n15] = (int)d11;
                    nArray3[n13 * 2 - n15 - 1] = (int)d11 + this.lineWidth * this.threeDXOffset;
                    nArray4[n15] = (int)d12;
                    nArray4[n13 * 2 - n15 - 1] = (int)d12 - this.lineWidth * this.threeDYOffset;
                } else {
                    nArray3[n15] = (int)d11;
                    nArray3[n13 * 2 - n15 - 1] = (int)d11;
                    nArray4[n15] = (int)d12 + 4;
                    nArray4[n13 * 2 - n15 - 1] = (int)d12 - 4;
                }
                bl2 = false;
                d9 = d11;
                d10 = d12;
                ++n15;
            }
            nArray3[nArray3.length - 1] = nArray3[0];
            nArray4[nArray4.length - 1] = nArray4[0];
            Number number = dataSet.getMaxYValue();
            object = dataSet.getMinYValue();
            if (!bl) {
                try {
                    this.addBalloonHelpArea(new BalloonHelp(stringArray, new Polygon(nArray3, nArray4, n13 * 2), new Dimension(n, n2), color));
                }
                catch (Exception exception) {
                    System.err.println("Got exception creating ballon help area: " + exception);
                }
            }
            ++n12;
        }
    }
}

