/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt.graph;

import com.seanreilly.awt.graph.KeyItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;

public class KeyPanel
extends JComponent {
    protected Vector keyItems;
    protected Image graphImage = null;
    protected Dimension graphSize = null;
    protected Graphics bufferG = null;
    private Font origFont = null;

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.graphSize = this.getSize();
        this.renderKey();
    }

    public void addKeyItem(KeyItem keyItem) {
        this.keyItems.addElement(keyItem);
        this.renderKey();
    }

    public final synchronized void renderKey() {
        if (this.graphSize.width <= 0 || this.graphSize.height <= 0) {
            return;
        }
        this.graphImage = this.createImage(this.graphSize.width, this.graphSize.height);
        if (this.graphImage == null) {
            return;
        }
        this.bufferG = this.graphImage.getGraphics();
        this.drawKey(this.bufferG, this.graphSize.width, this.graphSize.height);
    }

    public void drawKey(Graphics graphics, int n, int n2) {
        int n3;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        Font font = this.getFont();
        if (this.origFont == null) {
            this.origFont = font;
        }
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = 0;
        int n5 = 5;
        int n6 = n3 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 1;
        Enumeration enumeration = this.keyItems.elements();
        while (enumeration.hasMoreElements()) {
            KeyItem keyItem = (KeyItem)enumeration.nextElement();
            String string = keyItem.getLabel();
            int n7 = -1;
            do {
                graphics.setColor(keyItem.getColor());
                graphics.fillRect(n5, n6 - n3 + 2, 5, n3);
                if (n7 < 0) {
                    graphics.setColor(Color.black);
                } else {
                    graphics.setColor(Color.darkGray);
                }
                int n8 = string.indexOf(10, n7 + 1);
                String string2 = n8 >= 0 ? string.substring(n7 + 1, n8) : string.substring(n7 + 1, string.length());
                int n9 = n7 < 0 ? 7 : 12;
                graphics.drawString(string2, n5 + n9, n6);
                n4 = Math.max(n4, n9 + fontMetrics.stringWidth(string2));
                n7 = n8;
                if ((n6 += n3) > n2 - n3) {
                    n6 = n3;
                    if ((n5 += n4 + 5) + n4 > n && font.getSize() > 2) {
                        this.setFont(new Font(font.getName(), font.getStyle(), font.getSize() - 1));
                        this.drawKey(graphics, n, n2);
                        return;
                    }
                    n4 = 0;
                    continue;
                }
                if (n8 >= 0) continue;
                n6 += 3;
            } while (n7 >= 0);
        }
        this.setFont(this.origFont);
        this.repaint();
    }

    public void removeAllKeyItems() {
        this.keyItems.removeAllElements();
        this.renderKey();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public synchronized void update(Graphics graphics) {
        if (this.graphImage == null) {
            this.renderKey();
        }
        if (this.graphImage != null) {
            graphics.drawImage(this.graphImage, 0, 0, null);
        }
    }

    public KeyPanel() {
        this.setBackground(Color.white);
        this.graphSize = new Dimension(0, 0);
        this.setOpaque(true);
        this.keyItems = new Vector();
        this.repaint();
    }
}

