/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt.graph;

import com.seanreilly.awt.graph.BalloonHelp;
import com.seanreilly.awt.graph.DataSet;
import com.seanreilly.awt.graph.GraphPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;

public class BarGraphPanel
extends GraphPanel {
    protected int leftMargin = 80;
    protected int rightMargin = 10;
    protected int topMargin = 10;
    protected int bottomMargin = 30;
    protected int graphDepth = 100;
    protected int threeDXOffset = 3;
    protected int threeDYOffset = 2;
    protected int intervalType = -3;

    public void setInterval(int n) {
        this.intervalType = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void drawGraph(Graphics graphics, int n, int n2, boolean bl) {
        int n3;
        int n4;
        String string;
        int n5;
        Object object;
        if (graphics == null) {
            return;
        }
        int n6 = this.getNumDataSets();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n, n2);
        if (n6 <= 0) {
            return;
        }
        Number number = null;
        Number number2 = null;
        Number number3 = null;
        Number number4 = new Long(0L);
        int n7 = 0;
        while (n7 < this.getNumDataSets()) {
            object = this.getDataSet(n7);
            if (((DataSet)object).xvalues.length > 0) {
                Number number5 = ((DataSet)object).getMinXValue();
                if (number2 == null || number2.doubleValue() > number5.doubleValue()) {
                    number2 = number5;
                }
                number5 = ((DataSet)object).getMaxXValue();
                if (number == null || number.doubleValue() < number5.doubleValue()) {
                    number = number5;
                }
                number5 = ((DataSet)object).getMinYValue();
                if (number4 == null || ((Number)number4).doubleValue() > number5.doubleValue()) {
                    number4 = number5;
                }
                number5 = ((DataSet)object).getMaxYValue();
                if (number3 == null || number3.doubleValue() < number5.doubleValue()) {
                    number3 = number5;
                }
            }
            ++n7;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (number == null || number3 == null || number2 == null || number4 == null) {
            object = "No Data to Graph";
            graphics.setColor(Color.black);
            graphics.drawString((String)object, n / 2 - fontMetrics.stringWidth((String)object), (n2 + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent()) / 2);
            return;
        }
        int n8 = DataSet.getNumIntervals(this.intervalType, number2, number);
        int n9 = 0;
        int n10 = 0;
        int n11 = 1;
        if (this.threeD) {
            this.graphDepth = Math.min(45, 9 * n6);
            n9 = (int)((float)n6 / (float)this.graphDepth) * 3;
            n10 = (int)((float)n6 / (float)this.graphDepth) * 2;
            n11 = this.graphDepth / n6;
            n5 = this.graphDepth / n6;
            this.threeDYOffset = 2;
            this.threeDXOffset = 3;
        } else {
            this.graphDepth = 1;
            n11 = 1;
            n5 = 1;
            this.threeDXOffset = 0;
            this.threeDYOffset = 0;
        }
        this.leftMargin = 40;
        this.rightMargin = Math.max(this.graphDepth * this.threeDXOffset + 10, 20);
        this.bottomMargin = 20;
        this.topMargin = Math.max(this.graphDepth * this.threeDYOffset + 10, 40);
        if (n2 - this.bottomMargin <= this.topMargin || n - this.rightMargin <= this.leftMargin) {
            return;
        }
        Number[] numberArray = DataSet.getTicks(number4, number3, n2 - this.bottomMargin - this.topMargin, this.getDataSet(0).getYType(), fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent());
        Number[] numberArray2 = DataSet.getBarTicks(number2, n8, this.intervalType);
        this.leftMargin = Math.max(fontMetrics.stringWidth(DataSet.formatValue(number3, this.getDataSet(0).getYType())) + 3, Math.max(fontMetrics.stringWidth(DataSet.formatValue(number4, this.getDataSet(0).getXType())) + 3, this.leftMargin));
        double d = numberArray2[numberArray2.length - 1].doubleValue();
        double d2 = numberArray2[0].doubleValue();
        double d3 = numberArray[numberArray.length - 1].doubleValue();
        double d4 = numberArray[0].doubleValue();
        double d5 = d - d2;
        double d6 = d3 - d4;
        double d7 = (double)(n - this.rightMargin - this.leftMargin) / d5;
        double d8 = (double)(n2 - this.bottomMargin - this.topMargin) / d6;
        if (!bl) {
            this.removeAllBalloonHelpItems();
        }
        DataSet dataSet = this.getDataSet(0);
        int n12 = 0;
        while (n12 < numberArray.length) {
            string = DataSet.formatValue(numberArray[n12], dataSet.getYType());
            int n13 = fontMetrics.stringWidth(string);
            n4 = n2 - this.bottomMargin - (n2 - this.bottomMargin - this.topMargin) * n12 / (numberArray.length - 1);
            graphics.setColor(Color.black);
            graphics.drawString(string, this.leftMargin - n13, n4);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(2, n4, this.leftMargin, n4);
            graphics.drawLine(this.leftMargin, n4, this.leftMargin + this.graphDepth * this.threeDXOffset, n4 - this.graphDepth * this.threeDYOffset);
            graphics.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, n4 - this.threeDYOffset * this.graphDepth, n - this.rightMargin + this.threeDXOffset * this.graphDepth, n4 - this.threeDYOffset * this.graphDepth);
            ++n12;
        }
        n12 = -1;
        n4 = -1;
        int n14 = this.rightMargin - this.leftMargin;
        int n15 = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
        int n16 = 0;
        while (n16 < numberArray2.length) {
            n3 = (int)((numberArray2[n16].doubleValue() - d2) * d7);
            if (n16 < numberArray2.length - 1) {
                n14 = (int)((numberArray2[n16 + 1].doubleValue() - d2) * d7) - n3;
            }
            n4 = n3;
            graphics.setColor(Color.lightGray);
            graphics.drawLine(this.leftMargin + n3, n2 - this.bottomMargin, this.leftMargin + n3 + this.graphDepth * this.threeDXOffset, n2 - this.bottomMargin - this.graphDepth * this.threeDYOffset);
            graphics.drawLine(this.leftMargin + n3 + this.graphDepth * this.threeDXOffset, n2 - this.bottomMargin - this.graphDepth * this.threeDYOffset, this.leftMargin + n3 + this.graphDepth * this.threeDXOffset, this.topMargin - this.graphDepth * this.threeDYOffset);
            ++n16;
        }
        n12 = -1;
        n16 = 0;
        while (n16 < numberArray2.length) {
            string = DataSet.formatValue(numberArray2[n16], dataSet.getXType());
            n15 = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
            n3 = (int)((numberArray2[n16].doubleValue() - d2) * d7);
            if (n3 > n12) {
                graphics.setColor(Color.black);
                graphics.drawString(string, this.leftMargin + n3 + 2, n2 - this.bottomMargin + n15);
                graphics.setColor(Color.lightGray);
                graphics.drawLine(this.leftMargin + n3, n2 - this.bottomMargin, this.leftMargin + n3, n2 - this.bottomMargin + n15 + 2);
                n12 = n3 + fontMetrics.stringWidth(string) + 4;
            }
            ++n16;
        }
        graphics.setColor(Color.black);
        graphics.drawLine(this.leftMargin, this.topMargin, this.leftMargin, n2 - this.bottomMargin);
        graphics.drawLine(this.leftMargin, n2 - this.bottomMargin, n - this.rightMargin, n2 - this.bottomMargin);
        if (this.threeD) {
            graphics.drawLine(this.leftMargin, this.topMargin, this.leftMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth);
            graphics.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth, n - this.rightMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth);
            graphics.drawLine(this.leftMargin, n2 - this.bottomMargin, this.leftMargin + this.threeDXOffset * this.graphDepth, n2 - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            graphics.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth, this.leftMargin + this.threeDXOffset * this.graphDepth, n2 - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            graphics.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, n2 - this.bottomMargin - this.threeDYOffset * this.graphDepth, n - this.rightMargin + this.threeDXOffset * this.graphDepth, n2 - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            graphics.drawLine(n - this.rightMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth, n - this.rightMargin + this.threeDXOffset * this.graphDepth, n2 - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            graphics.drawLine(n - this.rightMargin + this.threeDXOffset * this.graphDepth, n2 - this.bottomMargin - this.threeDYOffset * this.graphDepth, n - this.rightMargin, n2 - this.bottomMargin);
        }
        if (this.threeD) {
            this.rightMargin -= this.graphDepth * this.threeDXOffset;
            this.leftMargin += this.graphDepth * this.threeDXOffset;
            this.topMargin -= this.graphDepth * this.threeDYOffset;
            this.bottomMargin += this.graphDepth * this.threeDYOffset;
        }
        n3 = 0;
        while (n3 < n6) {
            this.rightMargin += n5 * this.threeDXOffset;
            this.leftMargin -= n5 * this.threeDXOffset;
            this.bottomMargin -= n5 * this.threeDYOffset;
            this.topMargin += n5 * this.threeDYOffset;
            DataSet dataSet2 = this.getDataSet(n3);
            Color color = this.getColor(n3);
            String[] stringArray = dataSet2.getDescription();
            graphics.setColor(color);
            int n17 = dataSet2.getNumValues();
            int[] nArray = new int[n17 * 4];
            int[] nArray2 = new int[n17 * 4];
            int[] nArray3 = new int[4];
            int[] nArray4 = new int[4];
            double d9 = 0.0;
            int n18 = 60;
            int n19 = 0;
            while (n19 < n17) {
                if (n19 == 0) {
                    graphics.setColor(Color.black);
                    graphics.drawLine(this.leftMargin, this.topMargin, this.leftMargin, n2 - this.bottomMargin);
                    graphics.drawLine(this.leftMargin, n2 - this.bottomMargin, n - this.rightMargin, n2 - this.bottomMargin);
                }
                int n20 = (int)((double)this.leftMargin + (dataSet2.xvalues[n19].doubleValue() - d2) * d7);
                int n21 = n14;
                boolean bl2 = false;
                int n22 = 0;
                while (n22 < numberArray2.length - 1) {
                    if (dataSet2.xvalues[n19].longValue() >= numberArray2[n22].longValue() && dataSet2.xvalues[n19].longValue() < numberArray2[n22 + 1].longValue()) {
                        n20 = (int)((double)this.leftMargin + (numberArray2[n22].doubleValue() - d2) * d7);
                        if (n22 < numberArray2.length - 1) {
                            n21 = (int)((numberArray2[n22 + 1].doubleValue() - numberArray2[n22].doubleValue()) * d7);
                            bl2 = true;
                        }
                    }
                    ++n22;
                }
                if (!bl2 && numberArray2.length > 1) {
                    n22 = numberArray2.length - 1;
                    n21 = (int)((numberArray2[n22].doubleValue() - numberArray2[n22 - 1].doubleValue()) * d7);
                }
                int n23 = (int)((double)(n2 - this.bottomMargin) - (dataSet2.yvalues[n19].doubleValue() - d4) * d8);
                int n24 = (int)((dataSet2.yvalues[n19].doubleValue() - d4) * d8);
                if (this.threeD) {
                    nArray3[0] = n20;
                    nArray3[1] = n20 + n5 * this.threeDXOffset;
                    nArray3[2] = nArray3[1] + n21;
                    nArray3[3] = nArray3[0] + n21;
                    nArray4[0] = n23 + n24;
                    nArray4[1] = n23 - n5 * this.threeDYOffset + n24;
                    nArray4[2] = nArray4[1];
                    nArray4[3] = nArray4[0];
                    graphics.setColor(color.brighter());
                    graphics.fillPolygon(nArray3, nArray4, 4);
                    graphics.setColor(Color.black);
                    graphics.drawPolygon(nArray3, nArray4, 4);
                    nArray3[0] = n20;
                    nArray3[1] = n20 + n5 * this.threeDXOffset;
                    nArray3[2] = nArray3[1];
                    nArray3[3] = nArray3[0];
                    nArray4[0] = n23;
                    nArray4[1] = n23 - n5 * this.threeDYOffset;
                    nArray4[2] = nArray4[1] + n24;
                    nArray4[3] = nArray4[0] + n24;
                    graphics.setColor(color.darker());
                    graphics.fillPolygon(nArray3, nArray4, 4);
                    graphics.setColor(Color.black);
                    graphics.drawPolygon(nArray3, nArray4, 4);
                    nArray3[0] = n20;
                    nArray3[1] = n20 + n5 * this.threeDXOffset;
                    nArray3[2] = nArray3[1] + n21;
                    nArray3[3] = nArray3[0] + n21;
                    nArray4[0] = n23;
                    nArray4[1] = n23 - n5 * this.threeDYOffset;
                    nArray4[2] = nArray4[1];
                    nArray4[3] = nArray4[0];
                    graphics.setColor(color.brighter());
                    graphics.fillPolygon(nArray3, nArray4, 4);
                    graphics.setColor(Color.black);
                    graphics.drawPolygon(nArray3, nArray4, 4);
                    nArray3[0] = n20 + n21;
                    nArray3[1] = n20 + n21 + n5 * this.threeDXOffset;
                    nArray3[2] = nArray3[1];
                    nArray3[3] = nArray3[0];
                    nArray4[0] = n23;
                    nArray4[1] = n23 - n5 * this.threeDYOffset;
                    nArray4[2] = nArray4[1] + n24;
                    nArray4[3] = nArray4[0] + n24;
                    graphics.setColor(color.darker());
                    graphics.fillPolygon(nArray3, nArray4, 4);
                    graphics.setColor(Color.black);
                    graphics.drawPolygon(nArray3, nArray4, 4);
                } else {
                    n20 += (n21 /= n6) * n3;
                }
                graphics.setColor(color);
                graphics.fillRect(n20, n23, n21, n24);
                graphics.fillRect(n20, n23 + n24, n21, -n24);
                if (n21 > 3) {
                    graphics.setColor(Color.black);
                    graphics.drawRect(n20, n23, n21, n24);
                }
                nArray[n19 * 4] = n20;
                nArray[n19 * 4 + 1] = n20;
                nArray[n19 * 4 + 2] = n20 + n21;
                nArray[n19 * 4 + 3] = n20 + n21;
                nArray2[n19 * 4] = n23 + n24;
                nArray2[n19 * 4 + 1] = n23;
                nArray2[n19 * 4 + 2] = n23;
                nArray2[n19 * 4 + 3] = n23 + n24;
                ++n19;
            }
            if (!bl) {
                try {
                    this.addBalloonHelpArea(new BalloonHelp(stringArray, new Polygon(nArray, nArray2, nArray.length), new Dimension(n, n2), color));
                }
                catch (Exception exception) {
                    System.err.println("Got exception creating ballon help area: " + exception);
                }
            }
            ++n3;
        }
    }
}

