/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt;

import com.seanreilly.util.StringUtils;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;

public class JRateField
extends JTextField {
    private char dec;

    public void setDecimalCharacter(char c) {
        double d = this.getValue();
        this.dec = c;
        this.setValue(d);
    }

    public void setValue(double d) {
        super.setText(StringUtils.formatRate(d, this.dec));
        this.setCaretPosition(0);
        this.setScrollOffset(0);
    }

    public void setText(String string) {
        this.setValue(StringUtils.parseRate(string, this.dec));
    }

    public String getText() {
        return StringUtils.formatRate(this.getValue(), this.dec);
    }

    public double getValue() {
        String string = super.getText().trim();
        if (string.length() <= 0) {
            return 0.0;
        }
        return StringUtils.parseRate(string, this.dec);
    }

    public JRateField(char c) {
        this(8, c);
    }

    public JRateField(int n, char c) {
        super(n);
        this.dec = c;
        this.setHorizontalAlignment(2);
        JRateField jRateField = this;
        if (jRateField == null) {
            throw null;
        }
        this.addFocusListener(new FocusAdapter(jRateField){
            private final /* synthetic */ JRateField this$0;

            public final void focusGained(FocusEvent focusEvent) {
                this.this$0.selectAll();
            }

            public final void focusLost(FocusEvent focusEvent) {
                this.this$0.setValue(this.this$0.getValue());
            }
            {
                this.this$0 = jRateField;
                this.constructor$0(jRateField);
            }

            public void constructor$0(JRateField jRateField) {
            }
        });
    }
}

