/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt;

import com.seanreilly.awt.JLinkListener;
import com.seanreilly.awt.JUnderlineLabel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class JLinkLabel
extends JUnderlineLabel
implements MouseListener {
    private Vector linkListeners = new Vector();
    private Object linkTarget;
    private Color origFG;
    private boolean working = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void notifyLinkListeners() {
        Enumeration enumeration = this.linkListeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((JLinkListener)enumeration.nextElement()).linkActivated(this.linkTarget);
            }
            catch (Exception exception) {
                System.err.println("Exception notifying link listeners: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    public void addLinkListener(JLinkListener jLinkListener) {
        this.linkListeners.addElement(jLinkListener);
    }

    public void removeLinkListener(JLinkListener jLinkListener) {
        this.linkListeners.removeElement(jLinkListener);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.origFG = this.getForeground();
        this.setForeground(Color.red);
        this.repaint();
        this.working = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        JLinkLabel jLinkLabel = this;
        if (jLinkLabel == null) {
            throw null;
        }
        SwingUtilities.invokeLater(new Thread(jLinkLabel){
            private final /* synthetic */ JLinkLabel this$0;

            public final void run() {
                this.this$0.repaint();
                this.this$0.access$0();
                this.this$0.setForeground(this.this$0.access$1());
                this.this$0.access$3(false);
                this.this$0.setCursor(Cursor.getPredefinedCursor(0));
            }
            {
                this.this$0 = jLinkLabel;
                this.constructor$0(jLinkLabel);
            }

            public void constructor$0(JLinkLabel jLinkLabel) {
            }
        });
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.working) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /* synthetic */ void access$0() {
        this.notifyLinkListeners();
    }

    /* synthetic */ Color access$1() {
        return this.origFG;
    }

    /* synthetic */ boolean access$2() {
        return this.working;
    }

    /* synthetic */ void access$3(boolean bl) {
        this.working = bl;
    }

    public JLinkLabel(String string, Object object, int n) {
        super(string, n);
        this.linkTarget = object;
        this.addMouseListener(this);
    }
}

