/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JTextField;

public class JDateField
extends JTextField
implements KeyListener {
    private DateFormat dateFormat = null;
    private Calendar cal;

    private final void initHotKeys() {
        this.addKeyListener(this);
    }

    public void setDateFormat(DateFormat dateFormat) {
        Date date = this.getDate();
        this.dateFormat = dateFormat;
        this.setDate(date);
    }

    public Date setDate(Date date) {
        this.setText(this.dateFormat.format(date));
        return date;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Date getDate() {
        Date date = null;
        try {
            Calendar calendar = Calendar.getInstance();
            date = new Date(this.dateFormat.parse(this.getText()).getTime() + 46400000L);
            calendar.setTime(date);
            calendar.set(11, 12);
            calendar.set(12, 0);
            calendar.set(13, 0);
            boolean bl = false;
            if (calendar.get(1) < 50) {
                calendar.add(1, 2000);
                bl = true;
            } else if (calendar.get(1) < 100) {
                calendar.add(1, 1900);
                bl = true;
            }
            date = calendar.getTime();
            if (bl) {
                this.setDate(date);
            }
        }
        catch (Exception exception) {
        }
        if (date != null) return date;
        return new Date();
    }

    public void incrementDate() {
        Date date = this.getDate();
        if (date == null) {
            this.getToolkit().beep();
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        this.setDate(calendar.getTime());
    }

    public void decrementDate() {
        Date date = this.getDate();
        if (date == null) {
            this.getToolkit().beep();
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        this.setDate(calendar.getTime());
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '+' || c == '=') {
            keyEvent.consume();
            this.incrementDate();
        } else if (c == '-' || c == '_') {
            keyEvent.consume();
            this.decrementDate();
        } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '!' || c == '@' || c == '#' || c == '$' || c == '%' || c == '^' || c == '&' || c == '*' || c == '(' || c == ')' || c == '{' || c == '}' || c == '[' || c == ']' || c == ';' || c == '\'' || c == '\"' || c == '<' || c == '>' || c == '?' || c == '~' || c == '`') {
            keyEvent.consume();
        }
    }

    /* synthetic */ DateFormat access$0() {
        return this.dateFormat;
    }

    public JDateField(DateFormat dateFormat) {
        this(dateFormat, dateFormat.format(new Date()).length() + 4);
    }

    public JDateField(DateFormat dateFormat, int n) {
        super(n);
        this.dateFormat = dateFormat;
        this.initHotKeys();
        this.cal = Calendar.getInstance();
        JDateField jDateField = this;
        if (jDateField == null) {
            throw null;
        }
        this.addFocusListener(new FocusAdapter(jDateField){
            private final /* synthetic */ JDateField this$0;

            public final void focusGained(FocusEvent focusEvent) {
                String string = null;
                if (this.this$0.access$0() instanceof SimpleDateFormat) {
                    string = ((SimpleDateFormat)this.this$0.access$0()).toPattern();
                }
                int n = -1;
                int n2 = -1;
                if (string != null) {
                    n = string.indexOf(100);
                    n2 = string.lastIndexOf(100);
                }
                if (n >= 0 && n2 >= 0) {
                    this.this$0.select(n, n2 + 1);
                } else {
                    this.this$0.selectAll();
                }
            }

            public final void focusLost(FocusEvent focusEvent) {
                this.this$0.setDate(this.this$0.getDate());
            }
            {
                this.this$0 = jDateField;
                this.constructor$0(jDateField);
            }

            public void constructor$0(JDateField jDateField) {
            }
        });
    }
}

