/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt;

import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.util.StringUtils;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class JCurrencyField
extends JTextField {
    private CurrencyTable currencyTable;
    private CurrencyType currencyType;
    private int numDecimals;
    private int centMult;
    private char dec;
    private char com;

    public CurrencyType getCurrencyType() {
        return this.currencyType;
    }

    public synchronized void setDecimalCharacter(char c, char c2) {
        long l = this.getValue();
        this.dec = c;
        this.com = c2;
        this.setValue(l);
    }

    public synchronized void setCurrencyType(CurrencyType currencyType) {
        this.currencyType = currencyType;
        this.numDecimals = currencyType.getDecimalPlaces();
        this.centMult = (int)Math.round(Math.pow(10.0, this.numDecimals));
        this.setValue(this.getValue());
    }

    public void setValue(long l) {
        super.setText(StringUtils.formatCurrency(l, false, this.dec, this.com, this.numDecimals, this.centMult));
    }

    public void setText(String string) {
        this.setValue(StringUtils.parseCurrency(string, this.dec, this.currencyType.getDecimalPlaces()));
    }

    public String getText() {
        return StringUtils.formatCurrency(this.getValue(), false, this.dec, this.com, this.numDecimals, this.centMult);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getValue() {
        String string = super.getText().trim();
        if (string.length() <= 0) {
            return 0;
        }
        try {
            return StringUtils.parseCurrencyExpression(string, this.dec, this.currencyType, this.currencyTable);
        }
        catch (Exception exception) {
            try {
                JCurrencyField jCurrencyField = this;
                if (jCurrencyField == null) {
                    throw null;
                }
                SwingUtilities.invokeLater(new Runnable(jCurrencyField){
                    private final /* synthetic */ JCurrencyField this$0;

                    public final void run() {
                        this.this$0.selectAll();
                        this.this$0.requestFocus();
                    }
                    {
                        this.this$0 = jCurrencyField;
                        this.constructor$0(jCurrencyField);
                    }

                    public void constructor$0(JCurrencyField jCurrencyField) {
                    }
                });
                this.getToolkit().beep();
                this.getToolkit().beep();
                return 0;
            }
            catch (Exception exception2) {
            }
            return 0;
        }
    }

    public JCurrencyField(CurrencyType currencyType, CurrencyTable currencyTable, char c, char c2) {
        this(12, currencyType, currencyTable, c, c2);
    }

    public JCurrencyField(int n, CurrencyType currencyType, CurrencyTable currencyTable, char c, char c2) {
        super(n);
        this.currencyTable = currencyTable;
        this.dec = c;
        this.com = c2;
        this.setHorizontalAlignment(4);
        this.setCurrencyType(currencyType);
        JCurrencyField jCurrencyField = this;
        if (jCurrencyField == null) {
            throw null;
        }
        this.addFocusListener(new FocusAdapter(jCurrencyField){
            private final /* synthetic */ JCurrencyField this$0;

            public final void focusGained(FocusEvent focusEvent) {
                this.this$0.selectAll();
            }

            public final void focusLost(FocusEvent focusEvent) {
                this.this$0.setValue(this.this$0.getValue());
            }
            {
                this.this$0 = jCurrencyField;
                this.constructor$0(jCurrencyField);
            }

            public void constructor$0(JCurrencyField jCurrencyField) {
            }
        });
    }
}

