/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui.reporttool;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.AccountPopup;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JDateField;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TransactionsSettingsPanel
extends JPanel {
    private MoneydanceGUI moneydanceGUI;
    AccountPopup accountChoice;
    JDateField startDateField;
    JDateField endDateField;
    JComboBox subtotalByChoice;
    private DateFormat dateFormat;
    private RootAccount rootAccount;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restoreSettings(UserPreferences userPreferences, Account account) {
        long l = userPreferences.getLongSetting("gui.txn_report_start_date", 0L);
        long l2 = userPreferences.getLongSetting("gui.txn_report_end_date", 0L);
        if (l2 > 0L && l > 0L) {
            this.startDateField.setDate(new Date(l));
            this.endDateField.setDate(new Date(l2));
        }
        try {
            this.subtotalByChoice.setSelectedIndex(userPreferences.getIntSetting("gui.txn_report_subtotal_by", 0));
        }
        catch (Exception exception) {
        }
        if (account.getAccountType() == 0) {
            this.accountChoice.setSelectedIndex(0);
            int n = userPreferences.getIntSetting("gui.txn_report_account", -1);
            if (n < 0) return;
            Account account2 = this.rootAccount.getAccountById(n);
            if (account2 == null) return;
            this.accountChoice.setSelectedAccount(account2);
            return;
        }
        this.accountChoice.setSelectedItem(account);
    }

    public void saveSettings(UserPreferences userPreferences) {
        userPreferences.setSetting("gui.txn_report_start_date", this.startDateField.getDate().getTime());
        userPreferences.setSetting("gui.txn_report_end_date", this.endDateField.getDate().getTime());
        userPreferences.setSetting("gui.txn_report_subtotal_by", this.subtotalByChoice.getSelectedIndex());
        Account account = this.accountChoice.getSelectedAccount();
        if (account != null) {
            userPreferences.setSetting("gui.txn_report_account", account.getAccountNum());
        }
    }

    public void goneAway() {
        this.accountChoice.goneAway();
    }

    public TransactionsSettingsPanel(MoneydanceGUI moneydanceGUI, RootAccount rootAccount, Account account) {
        super(new GridBagLayout());
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.dateFormat = Main.getMainController().getPreferences().getShortDateFormatter();
        this.accountChoice = new AccountPopup(this.moneydanceGUI, rootAccount);
        this.accountChoice.setShowAccountsOfType(0, false);
        if (account.getAccountType() == 0) {
            this.accountChoice.setSelectedAccountIndex(0);
        } else {
            this.accountChoice.setSelectedAccount(account);
        }
        this.subtotalByChoice = new JComboBox();
        this.subtotalByChoice.addItem(this.moneydanceGUI.getResources().getString("report_subtotalby_none"));
        this.subtotalByChoice.addItem(this.moneydanceGUI.getResources().getString("report_subtotalby_day"));
        this.subtotalByChoice.addItem(this.moneydanceGUI.getResources().getString("report_subtotalby_week"));
        this.subtotalByChoice.addItem(this.moneydanceGUI.getResources().getString("report_subtotalby_month"));
        this.subtotalByChoice.addItem(this.moneydanceGUI.getResources().getString("report_subtotalby_year"));
        this.subtotalByChoice.addItem(this.moneydanceGUI.getResources().getString("report_subtotalby_account"));
        Calendar calendar = Calendar.getInstance();
        this.startDateField = new JDateField(this.dateFormat);
        this.endDateField = new JDateField(this.dateFormat);
        this.endDateField.setDate(calendar.getTime());
        calendar.set(2, 0);
        calendar.set(5, 1);
        this.startDateField.setDate(calendar.getTime());
        this.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("report_account") + ": ", 4), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.accountChoice, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, false, false));
        this.add((Component)this.subtotalByChoice, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 2, 1, true, false));
        int n = 2;
        int n2 = 0;
        this.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("report_begindate") + ": ", 4), AwtUtil.getConstraints(n++, n2, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.startDateField, AwtUtil.getConstraints(n--, n2++, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("report_enddate") + ": ", 4), AwtUtil.getConstraints(n++, n2, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.endDateField, AwtUtil.getConstraints(n++, n2++, 1.0f, 0.0f, 1, 1, true, false));
    }
}

