/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui.reporttool;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.AccountUtil;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.reporttool.RecordRow;
import com.seanreilly.apps.moneydance.view.gui.reporttool.Report;
import com.seanreilly.util.StringUtils;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class TransactionReport
extends Report {
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$BankTransaction;
    private MoneydanceGUI mdGUI;
    private RootAccount rootAccount;
    private CurrencyTable currencyTable;
    private String[] headerNames;
    private String[] headersWithBalance;
    private String[] headersWOutBalance;
    private Vector rows;
    private char dec;
    private char com;
    private long beginDate;
    private long endDate;
    private DateFormat dateFormat;
    private Account account;
    private int accountID;
    private CurrencyType currencyType;
    private int numDecimals;
    private String currencyPrefix;
    private String currencySuffix;

    public int getColumnWeight(int n) {
        switch (n) {
            case 0: {
                return 5;
            }
            case 4: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 15;
            }
        }
        return 10;
    }

    public int getMaxColumnWidth(int n) {
        switch (n) {
            case 4: {
                return 10;
            }
        }
        return -1;
    }

    public String getTitle1() {
        return this.mdGUI.getResources().getString("report_transactions") + ": " + this.account.getFullAccountName();
    }

    public String getTitle2() {
        if (this.beginDate <= 0L || this.endDate <= 0L) {
            return "";
        }
        return this.dateFormat.format(new Date(this.beginDate)) + " - " + this.dateFormat.format(new Date(this.endDate));
    }

    public String getColumnName(int n) {
        if (n >= 0 && this.headerNames != null && n < this.headerNames.length) {
            return this.headerNames[n];
        }
        return "";
    }

    public String[] getColumnNames() {
        return this.headerNames;
    }

    public int getColumnCount() {
        return this.headerNames.length;
    }

    public RecordRow getRow(int n) {
        return (RecordRow)this.rows.elementAt(n);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public void generateReport(long l, long l2, int n, Account account) {
        Transaction transaction;
        this.currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
        this.account = account;
        this.accountID = account.getAccountNum();
        this.beginDate = l;
        this.endDate = l2;
        this.rows.removeAllElements();
        Vector<Transaction> vector = new Vector<Transaction>();
        Enumeration enumeration = this.rootAccount.getTransactionSet().getAllTransactions();
        while (enumeration.hasMoreElements()) {
            transaction = (Transaction)enumeration.nextElement();
            if (!account.containsTransaction(transaction, false, true)) continue;
            vector.addElement(transaction);
        }
        if (n == 0 || n == 1 || n == 2 || n == 3 || n == 4) {
            AccountUtil.sortTransactions(vector, 7, this.accountID, this.rootAccount);
            this.headerNames = this.headersWithBalance;
            long l3 = account.getStartBalance();
            int n2 = 0;
            while (n2 < vector.size()) {
                Transaction transaction2 = (Transaction)vector.elementAt(n2);
                long l4 = transaction2.getDate();
                l3 += transaction2.getAmount(this.accountID);
                if (l4 >= l && l4 <= l2) {
                    RecordRow recordRow = new RecordRow(new String[7], new byte[7], new byte[7], new byte[7], null);
                    recordRow.reference = transaction2;
                    recordRow.labels[0] = this.dateFormat.format(new Date(transaction2.getDate()));
                    Account account2 = this.rootAccount.getAccountById(transaction2.getAccountId(this.accountID));
                    recordRow.labels[1] = account2 == null ? "[" + this.mdGUI.getResources().getString("split") + "]" : account2.getFullAccountName();
                    recordRow.labels[2] = transaction2.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : TransactionReport.class$("com.seanreilly.apps.moneydance.model.BankTransaction")) ? ((BankTransaction)transaction2).getCheckNumber() : "";
                    recordRow.labels[3] = transaction2.getDescription();
                    recordRow.labels[4] = String.valueOf(transaction2.getClearedStatus(this.accountID));
                    long l5 = transaction2.getAmount(this.accountID);
                    recordRow.labels[5] = StringUtils.formatCurrency(l5, true, this.dec, this.com, this.currencyType.getDecimalPlaces());
                    recordRow.labels[6] = StringUtils.formatCurrency(l3, true, this.dec, this.com, this.currencyType.getDecimalPlaces());
                    recordRow.align[5] = 2;
                    recordRow.align[6] = 2;
                    if (l5 < 0L) {
                        recordRow.color[5] = 2;
                    }
                    if (l3 < 0L) {
                        recordRow.color[6] = 2;
                    }
                    this.rows.addElement(recordRow);
                }
                ++n2;
            }
        } else {
            this.headerNames = this.headersWOutBalance;
            AccountUtil.sortTransactions(vector, 5, this.accountID, this.rootAccount);
            int n3 = 0;
            while (n3 < vector.size()) {
                transaction = (Transaction)vector.elementAt(n3);
                long l6 = transaction.getDate();
                if (l6 >= l && l6 <= l2) {
                    RecordRow recordRow = new RecordRow(new String[6], new byte[6], new byte[6], new byte[6], null);
                    recordRow.reference = transaction;
                    recordRow.labels[0] = this.dateFormat.format(new Date(transaction.getDate()));
                    Account account3 = this.rootAccount.getAccountById(transaction.getAccountId(this.accountID));
                    recordRow.labels[1] = account3 == null ? "[" + this.mdGUI.getResources().getString("split") + "]" : account3.getFullAccountName();
                    recordRow.labels[2] = transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : TransactionReport.class$("com.seanreilly.apps.moneydance.model.BankTransaction")) ? ((BankTransaction)transaction).getCheckNumber() : "";
                    recordRow.labels[3] = transaction.getDescription();
                    recordRow.labels[4] = String.valueOf(transaction.getClearedStatus(this.accountID));
                    long l7 = transaction.getAmount(this.accountID);
                    recordRow.labels[5] = StringUtils.formatCurrency(l7, true, this.dec, this.com, this.currencyType.getDecimalPlaces());
                    recordRow.align[5] = 2;
                    if (l7 < 0L) {
                        recordRow.color[5] = 2;
                    }
                    this.rows.addElement(recordRow);
                }
                ++n3;
            }
        }
        this.subtotalTransactions(n, 5, this.accountID);
    }

    private final void subtotalTransactions(int n, int n2, int n3) {
        boolean bl = false;
        if (n == 0 || n == 1 || n == 2 || n == 3 || n == 4) {
            long l = -1L;
            RecordRow recordRow = new RecordRow(new String[6], new byte[6], new byte[6], new byte[6], new byte[6]);
            recordRow.total[5] = 1;
            long l2 = 0L;
            Calendar calendar = Calendar.getInstance();
            int n4 = 0;
            while (n4 < this.rows.size()) {
                Transaction transaction = (Transaction)this.getRow((int)n4).reference;
                calendar.setTime(new Date(transaction.getDate()));
                if (n == 3) {
                    calendar.set(5, 0);
                } else if (n == 2) {
                    while (calendar.get(7) != calendar.getMinimum(7)) {
                        calendar.add(7, -1);
                    }
                } else if (n == 4) {
                    calendar.set(6, 0);
                }
                calendar.set(11, 12);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                long l3 = calendar.getTime().getTime();
                if (n != 0 && Math.abs(l3 - l) > 43200000L && l > 0L) {
                    recordRow.labels[n2] = StringUtils.formatCurrency(l2, true, this.dec, this.com, this.currencyType.getDecimalPlaces());
                    this.rows.insertElementAt(recordRow, n4++);
                    this.rows.insertElementAt(RecordRow.BLANK_ROW, n4++);
                    recordRow = new RecordRow(new String[6], new byte[6], new byte[6], new byte[6], new byte[6]);
                    recordRow.total[5] = 1;
                    l2 = 0L;
                }
                l = l3;
                long l4 = transaction.getAmount(n3);
                l2 += l4;
                ++n4;
            }
            if (l > 0L && n != 0) {
                recordRow.labels[n2] = StringUtils.formatCurrency(l2, true, this.dec, this.com, this.currencyType.getDecimalPlaces());
                this.rows.addElement(recordRow);
                this.rows.addElement(RecordRow.BLANK_ROW);
            }
        } else {
            int n5 = -1;
            RecordRow recordRow = new RecordRow(new String[6], new byte[6], new byte[6], new byte[6], new byte[6]);
            recordRow.total[5] = 1;
            long l = 0L;
            int n6 = 0;
            while (n6 < this.rows.size()) {
                Transaction transaction = (Transaction)this.getRow((int)n6).reference;
                if (n6 != 0 && transaction.getAccountId(n3) != n5) {
                    recordRow.labels[n2] = StringUtils.formatCurrency(l, true, this.dec, this.com, this.currencyType.getDecimalPlaces());
                    this.rows.insertElementAt(recordRow, n6++);
                    this.rows.insertElementAt(RecordRow.BLANK_ROW, n6++);
                    l = 0L;
                    recordRow = new RecordRow(new String[6], new byte[6], new byte[6], new byte[6], new byte[6]);
                    recordRow.total[5] = 1;
                }
                n5 = transaction.getAccountId(n3);
                l += transaction.getAmount(n3);
                ++n6;
            }
            recordRow.labels[n2] = StringUtils.formatCurrency(l, true, this.dec, this.com, this.currencyType.getDecimalPlaces());
            this.rows.addElement(recordRow);
            this.rows.addElement(RecordRow.BLANK_ROW);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TransactionReport(MoneydanceGUI moneydanceGUI, RootAccount rootAccount) {
        this.mdGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.currencyTable = rootAccount.getCurrencyTable();
        this.dateFormat = Main.getMainController().getPreferences().getShortDateFormatter();
        this.dec = Main.getMainController().getPreferences().getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        this.rows = new Vector();
        this.headersWithBalance = new String[]{moneydanceGUI.getResources().getString("table_column_date"), moneydanceGUI.getResources().getString("table_column_account"), moneydanceGUI.getResources().getString("table_column_checknum"), moneydanceGUI.getResources().getString("table_column_description"), moneydanceGUI.getResources().getString("table_column_clearedchar"), moneydanceGUI.getResources().getString("table_column_amount"), moneydanceGUI.getResources().getString("table_column_balance")};
        this.headersWOutBalance = new String[]{moneydanceGUI.getResources().getString("table_column_date"), moneydanceGUI.getResources().getString("table_column_account"), moneydanceGUI.getResources().getString("table_column_checknum"), moneydanceGUI.getResources().getString("table_column_description"), moneydanceGUI.getResources().getString("table_column_clearedchar"), moneydanceGUI.getResources().getString("table_column_amount")};
        this.headerNames = this.headersWithBalance;
    }
}

