/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui.reporttool;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.reporttool.BlankReport;
import com.seanreilly.apps.moneydance.view.gui.reporttool.RecordRow;
import com.seanreilly.apps.moneydance.view.gui.reporttool.Report;
import com.seanreilly.awt.AwtUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.PrintJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.util.Date;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ReportViewer
extends JPanel {
    private MoneydanceGUI mdGUI;
    private JPanel headerPanel;
    private JPanel reportPanel;
    private JLabel titleLabel;
    private JLabel dateLabel;
    private JTable reportTable;
    private ReportTableModel tableModel;
    private ReportCellRenderer reportCellRenderer;
    private Report report;
    private JFrame parentFrame;

    public void setReport(Report report) {
        this.report = report;
        this.titleLabel.setText(report.getTitle1());
        this.dateLabel.setText(report.getTitle2());
        this.tableModel.fireTableStructureChanged();
        this.tableModel.fireTableDataChanged();
        this.setColumnWidths();
        this.reportTable.sizeColumnsToFit(-1);
    }

    private final void setColumnWidths() {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        int n = 0;
        int n2 = 0;
        while (n2 < this.report.getColumnCount()) {
            n += this.report.getColumnWeight(n2);
            ++n2;
        }
        if (n <= 0) {
            return;
        }
        n2 = 0;
        while (n2 < this.report.getColumnCount()) {
            TableColumn tableColumn = this.reportTable.getColumnModel().getColumn(n2);
            tableColumn.setCellRenderer(this.reportCellRenderer);
            tableColumn.setWidth(this.report.getColumnWeight(n2) / n);
            int n3 = this.report.getMaxColumnWidth(n2);
            if (n3 > 0) {
                tableColumn.setMaxWidth(n3);
            }
            ++n2;
        }
    }

    private final String htmlify(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            if (c == ' ') {
                stringBuffer.setCharAt(n, '&');
                stringBuffer.insert(n + 1, "nbsp;");
                n += "nbsp;".length();
            } else if (c == '<') {
                stringBuffer.setCharAt(n, '&');
                stringBuffer.insert(n + 1, "lt;");
                n += "lt;".length();
            } else if (c == '>') {
                stringBuffer.setCharAt(n, '&');
                stringBuffer.insert(n + 1, "gt;");
                n += "gt;".length();
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveReport() {
        FileDialog fileDialog = new FileDialog((Frame)this.parentFrame, this.mdGUI.getResources().getString("choose_report_file_title"), 1);
        ReportViewer reportViewer = this;
        if (reportViewer == null) {
            throw null;
        }
        fileDialog.setFilenameFilter(reportViewer.new HtmlFilenameFilter());
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string == null || string2 == null) {
            return;
        }
        this.mdGUI.setWaitCursor();
        try {
            File file = new File(string2, string);
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            printStream.println("");
            printStream.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional\">");
            printStream.println("<HTML><HEAD>");
            printStream.println("   <META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html;" + " charset=iso-8859-1\">");
            printStream.println("   <META NAME=\"GENERATOR\" CONTENT=\"Moneydance\">");
            printStream.println("   <TITLE>Moneydance Report</TITLE>");
            printStream.println("</HEAD>");
            printStream.println("<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\"" + " VLINK=\"#0000AA\" ALINK=\"#FFFF00\">");
            printStream.println("&nbsp;");
            printStream.println("<CENTER>");
            printStream.println("  <H1>" + this.htmlify(this.titleLabel.getText()) + "</H1>");
            printStream.println("  <H3>" + this.htmlify(this.dateLabel.getText()) + "</H3>");
            printStream.println("</CENTER>\n<P>");
            printStream.println("<TABLE WIDTH=\"100%\" CELLSPACING=\"0\">");
            printStream.println(" <TR>");
            int n = 0;
            while (n < this.reportTable.getColumnCount()) {
                printStream.println("  <TH BGCOLOR=\"#AAAAAA\" ALIGN=\"CENTER\">" + this.htmlify(this.reportTable.getColumnName(n)) + "</TH>");
                ++n;
            }
            printStream.println(" </TR>");
            n = 0;
            while (n < this.report.getRowCount()) {
                printStream.println(" <TR>");
                RecordRow recordRow = this.report.getRow(n);
                int n2 = 0;
                while (n2 < this.report.getColumnCount()) {
                    String string3;
                    String string4 = recordRow.getLabel(n2);
                    int n3 = this.reportTable.convertColumnIndexToModel(n2);
                    switch (recordRow.getAlignment(n2)) {
                        case 4: {
                            string3 = "CENTER";
                            break;
                        }
                        case 2: {
                            string3 = "RIGHT";
                            break;
                        }
                        default: {
                            string3 = "LEFT";
                        }
                    }
                    String string5 = null;
                    switch (recordRow.getColor(n2)) {
                        case 4: {
                            string5 = "#0000FF";
                            break;
                        }
                        case 2: {
                            string5 = "#FF0000";
                            break;
                        }
                        default: {
                            string5 = null;
                        }
                    }
                    boolean bl = recordRow.getStyle(n2) == 2;
                    String string6 = "#FFFFFF";
                    printStream.print("  <TD ALIGN=\"" + string3 + "\">");
                    if (string5 != null) {
                        printStream.print("<FONT COLOR=\"" + string5 + "\">");
                    }
                    if (bl) {
                        printStream.print("<B>");
                    }
                    printStream.print("&nbsp;" + this.htmlify(string4));
                    if (bl) {
                        printStream.print("</B>");
                    }
                    if (string5 != null) {
                        printStream.print("</FONT>");
                    }
                    printStream.println("</TD>");
                    ++n2;
                }
                printStream.println(" </TR>");
                ++n;
            }
            printStream.println("</TABLE>");
            printStream.println("<HR>");
            printStream.println("<i>" + this.htmlify(this.mdGUI.getResources().getString("report_generated")) + ": " + this.htmlify(String.valueOf(new Date())) + "<br>");
            printStream.println(this.htmlify("Moneydance 2.0.3 (26)") + "</i>");
            printStream.println("</BODY>");
            printStream.println("</HTML>");
            printStream.close();
        }
        catch (Exception exception) {
            this.mdGUI.showErrorMessage(this.parentFrame, this.mdGUI.getResources().getString("err_save_report") + ": " + exception);
        }
        this.mdGUI.setDefaultCursor();
    }

    public void printReport() {
        PrintJob printJob = this.getToolkit().getPrintJob(this.parentFrame, this.mdGUI.getResources().getString("report"), new Properties());
        if (printJob == null) {
            return;
        }
        this.mdGUI.setWaitCursor();
        Dimension dimension = printJob.getPageDimension();
        int n = 5;
        int n2 = 40;
        int n3 = 40;
        int n4 = 20;
        int n5 = 20;
        int n6 = 20;
        Graphics graphics = printJob.getGraphics();
        if (Main.DEBUG) {
            System.err.println(" printer resolution: " + printJob.getPageResolution());
        }
        Font font = this.getFont();
        int n7 = 1;
        if (printJob.getPageResolution() > 80) {
            n7 = printJob.getPageResolution() / 55;
        }
        Font font2 = new Font(font.getName(), 1, font.getSize() * n7 + 4);
        Font font3 = new Font(font.getName(), 1, font.getSize() * n7 + 2);
        Font font4 = new Font(font.getName(), 1, font.getSize() * n7);
        Font font5 = new Font(font.getName(), 0, font.getSize() * n7 - 2);
        if (Main.DEBUG) {
            System.err.println(" title font size: " + font2.getSize());
            System.err.println(" date font size: " + font3.getSize());
            System.err.println(" subtitle font size: " + font4.getSize());
            System.err.println(" normal font size: " + font5.getSize());
        }
        Font font6 = font4;
        graphics.setColor(Color.black);
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = this.titleLabel.getText();
        graphics.drawString(string, dimension.width / 2 - fontMetrics.stringWidth(string) / 2, (n6 += fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 5) - fontMetrics.getMaxDescent() - 1);
        graphics.setFont(font3);
        fontMetrics = graphics.getFontMetrics();
        String string2 = this.dateLabel.getText();
        graphics.drawString(string2, dimension.width / 2 - fontMetrics.stringWidth(string2) / 2, (n6 += fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 5) - fontMetrics.getMaxDescent() - 1);
        n6 += 30;
        JTableHeader jTableHeader = this.reportTable.getTableHeader();
        TableColumnModel tableColumnModel = this.reportTable.getColumnModel();
        int n8 = 0;
        while (n8 < this.report.getRowCount()) {
            int n9;
            graphics.setFont(font6);
            fontMetrics = graphics.getFontMetrics();
            graphics.setColor(Color.lightGray);
            graphics.fillRect(40, (n6 += fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 5) - (fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 5), dimension.width - 80, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 5);
            graphics.setColor(Color.black);
            graphics.drawRect(40, n6 - (fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 5), dimension.width - 80, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 5);
            int n10 = dimension.width - 40 - 40;
            int n11 = this.reportTable.getSize().width;
            double d = (double)n10 / (double)n11;
            int n12 = 40;
            int n13 = 0;
            while (n13 < tableColumnModel.getColumnCount()) {
                TableColumn tableColumn = tableColumnModel.getColumn(this.reportTable.convertColumnIndexToModel(n13));
                n9 = (int)((double)tableColumn.getWidth() * d);
                int n14 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 5;
                String string3 = this.reportTable.getColumnName(n13);
                graphics.setClip(n12, n6 - n14, n9, n14);
                graphics.drawString(string3, n12 + n9 / 2 - fontMetrics.stringWidth(string3) / 2, n6 - fontMetrics.getMaxDescent() - 1);
                n12 += n9;
                ++n13;
            }
            graphics.setClip(0, 0, dimension.width, dimension.height);
            graphics.setFont(font5);
            while (n8 < this.report.getRowCount() && n6 < dimension.height - 20) {
                n12 = 40;
                n13 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 5;
                int n15 = 0;
                while (n15 < tableColumnModel.getColumnCount()) {
                    n9 = this.reportTable.convertColumnIndexToModel(n15);
                    TableColumn tableColumn = tableColumnModel.getColumn(n9);
                    int n16 = (int)((double)tableColumn.getWidth() * d);
                    TableCellRenderer tableCellRenderer = this.reportTable.getCellRenderer(n8, n15);
                    Component component = tableCellRenderer.getTableCellRendererComponent(this.reportTable, this.tableModel.getValueAt(n8, n9), false, false, n8, n9);
                    component.setSize(n16, n13);
                    component.paint(graphics.create(n12, n6, n16, n13));
                    n12 += n16;
                    ++n15;
                }
                n6 += n13;
                ++n8;
            }
            if (n8 >= this.report.getRowCount()) continue;
            graphics.dispose();
            graphics = printJob.getGraphics();
            n6 = 20;
        }
        graphics.dispose();
        printJob.end();
        this.mdGUI.setDefaultCursor();
    }

    /* synthetic */ Report access$0() {
        return this.report;
    }

    public ReportViewer(MoneydanceGUI moneydanceGUI, JFrame jFrame) {
        this.mdGUI = moneydanceGUI;
        this.parentFrame = jFrame;
        this.setBackground(Color.white);
        this.report = new BlankReport();
        ReportViewer reportViewer = this;
        if (reportViewer == null) {
            throw null;
        }
        this.tableModel = reportViewer.new ReportTableModel();
        this.reportTable = new JTable(this.tableModel);
        this.reportTable.setAutoCreateColumnsFromModel(true);
        this.reportTable.setRowSelectionAllowed(false);
        this.reportTable.setShowGrid(false);
        ReportViewer reportViewer2 = this;
        if (reportViewer2 == null) {
            throw null;
        }
        this.reportCellRenderer = reportViewer2.new ReportCellRenderer();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.headerPanel = new JPanel(gridBagLayout);
        this.headerPanel.setBackground(Color.white);
        this.reportPanel = new JPanel(gridBagLayout);
        this.reportPanel.setBackground(Color.white);
        this.add((Component)this.headerPanel, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.reportPanel, AwtUtil.getConstraints(0, 1, 1.0f, 1.0f, 2, 1, true, true));
        this.titleLabel = new JLabel("", 0);
        this.dateLabel = new JLabel("", 0);
        Font font = this.titleLabel.getFont();
        this.titleLabel.setFont(new Font(font.getName(), 1, font.getSize() + 6));
        this.headerPanel.add((Component)this.titleLabel, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, true, true));
        this.headerPanel.add((Component)this.dateLabel, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 1, 1, true, true));
        this.reportPanel.add((Component)new JScrollPane(this.reportTable), AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 1, true, true));
    }

    class HtmlFilenameFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string != null && string.toUpperCase().endsWith(".HTML");
        }

        HtmlFilenameFilter() {
        }
    }

    class ReportCellRenderer
    extends DefaultTableCellRenderer {
        Font boldFont;
        Font normalFont;
        Font italicFont;
        Font theFont;
        String label;
        boolean isSelected;
        boolean hasFocus;
        Color fgColor;
        byte alignment;
        boolean total;

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (this.isSelected) {
                graphics.setColor(Color.lightGray);
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
            if (this.hasFocus) {
                graphics.setColor(Color.gray);
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
            graphics.setColor(Color.black);
            if (this.total) {
                graphics.drawLine(0, 0, this.getSize().width + 1, 0);
            }
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.theFont);
            graphics.setFont(this.theFont);
            graphics.setColor(this.fgColor);
            if (this.alignment == 4) {
                graphics.drawString(this.label, dimension.width / 2 - fontMetrics.stringWidth(this.label) / 2, dimension.height - fontMetrics.getMaxDescent() - 1);
            } else if (this.alignment == 2) {
                graphics.drawString(this.label, dimension.width - fontMetrics.stringWidth(this.label) - 2, dimension.height - fontMetrics.getMaxDescent() - 1);
            } else {
                graphics.drawString(this.label, 2, dimension.height - fontMetrics.getMaxDescent() - 1);
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.isSelected = bl;
            this.hasFocus = bl2;
            RecordRow recordRow = ReportViewer.this.access$0().getRow(n);
            this.label = recordRow.getLabel(n2);
            switch (recordRow.getTotal(n2)) {
                case 1: {
                    this.total = true;
                    break;
                }
                default: {
                    this.total = false;
                }
            }
            switch (recordRow.getStyle(n2)) {
                case 4: {
                    this.theFont = this.italicFont;
                    break;
                }
                case 2: {
                    this.theFont = this.boldFont;
                    break;
                }
                default: {
                    this.theFont = this.normalFont;
                }
            }
            this.alignment = recordRow.getAlignment(n2);
            switch (recordRow.getColor(n2)) {
                case 2: {
                    this.fgColor = Color.red;
                    break;
                }
                case 4: {
                    this.fgColor = Color.blue;
                    break;
                }
                default: {
                    this.fgColor = Color.black;
                }
            }
            return this;
        }

        public ReportCellRenderer() {
            Font font = this.getFont();
            this.boldFont = new Font(font.getName(), 1, 12);
            this.normalFont = new Font(font.getName(), 0, 12);
            this.italicFont = new Font(font.getName(), 2, 12);
        }
    }

    class ReportTableModel
    extends AbstractTableModel {
        public int getRowCount() {
            return ReportViewer.this.access$0().getRowCount();
        }

        public String getColumnName(int n) {
            return ReportViewer.this.access$0().getColumnName(n);
        }

        public int getColumnCount() {
            return ReportViewer.this.access$0().getColumnCount();
        }

        public Object getValueAt(int n, int n2) {
            RecordRow recordRow = ReportViewer.this.access$0().getRow(n);
            if (recordRow == null) {
                return "???";
            }
            return recordRow.getLabel(n2);
        }

        ReportTableModel() {
        }
    }
}

