/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui.reporttool;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoListener;
import com.seanreilly.apps.moneydance.view.gui.AccountPanel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.reporttool.AccountBalanceReport;
import com.seanreilly.apps.moneydance.view.gui.reporttool.BalancesSettingsPanel;
import com.seanreilly.apps.moneydance.view.gui.reporttool.IncomeExpenseReport;
import com.seanreilly.apps.moneydance.view.gui.reporttool.IncomeExpenseSettingsPanel;
import com.seanreilly.apps.moneydance.view.gui.reporttool.ReportViewer;
import com.seanreilly.apps.moneydance.view.gui.reporttool.TransactionReport;
import com.seanreilly.apps.moneydance.view.gui.reporttool.TransactionsSettingsPanel;
import com.seanreilly.awt.AwtUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class ReportTool
extends JFrame
implements ActionListener,
AccountInfoListener,
ItemListener {
    private MoneydanceGUI mdGUI;
    private RootAccount rootAccount;
    private JPanel[] settingsPanels;
    private JPanel currentSettingsPanel = null;
    private JPanel settingsPanel;
    private JPanel buttonPanel;
    private JComboBox reportTypeChoice;
    private ReportViewer reportViewer;
    private JButton updateButton;
    private JButton doneButton;
    private JButton printButton;
    private JButton saveButton;
    private AccountPanel parentPanel;
    private char dec;
    private char com;
    private UserPreferences prefs;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void restoreSettings(Account account) {
        try {
            this.reportTypeChoice.setSelectedIndex(this.prefs.getIntSetting("gui.report_type", 0));
        }
        catch (Exception exception) {
        }
        ((TransactionsSettingsPanel)this.settingsPanels[0]).restoreSettings(this.prefs, account);
        ((BalancesSettingsPanel)this.settingsPanels[1]).restoreSettings(this.prefs);
        ((IncomeExpenseSettingsPanel)this.settingsPanels[2]).restoreSettings(this.prefs);
    }

    private final void saveSettings() {
        this.prefs.setSetting("gui.report_type", this.reportTypeChoice.getSelectedIndex());
        ((TransactionsSettingsPanel)this.settingsPanels[0]).saveSettings(this.prefs);
        ((BalancesSettingsPanel)this.settingsPanels[1]).saveSettings(this.prefs);
        ((IncomeExpenseSettingsPanel)this.settingsPanels[2]).saveSettings(this.prefs);
    }

    public void accountInfoUpdated(Object object) {
        this.rebuildReport();
    }

    private final void finishUp() {
        this.saveSettings();
        this.parentPanel.reporterIsDone(this);
        ((TransactionsSettingsPanel)this.settingsPanels[0]).goneAway();
    }

    private final void setSettingsType() {
        int n = this.reportTypeChoice.getSelectedIndex();
        if (this.currentSettingsPanel != null) {
            this.settingsPanel.remove(this.currentSettingsPanel);
        }
        this.currentSettingsPanel = this.settingsPanels[n];
        this.settingsPanel.add(this.currentSettingsPanel);
        this.validate();
    }

    private final void rebuildReport() {
        int n = this.reportTypeChoice.getSelectedIndex();
        if (n == 0) {
            TransactionsSettingsPanel transactionsSettingsPanel = (TransactionsSettingsPanel)this.settingsPanels[0];
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(transactionsSettingsPanel.endDateField.getDate());
            gregorianCalendar.set(11, 23);
            gregorianCalendar.set(12, 55);
            long l = gregorianCalendar.getTime().getTime();
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            gregorianCalendar2.setTime(transactionsSettingsPanel.startDateField.getDate());
            gregorianCalendar2.set(11, 1);
            gregorianCalendar2.set(12, 0);
            long l2 = gregorianCalendar2.getTime().getTime();
            int n2 = transactionsSettingsPanel.subtotalByChoice.getSelectedIndex();
            String string = String.valueOf(this.reportTypeChoice.getSelectedItem());
            Account account = (Account)transactionsSettingsPanel.accountChoice.getSelectedItem();
            TransactionReport transactionReport = new TransactionReport(this.mdGUI, this.rootAccount);
            transactionReport.generateReport(l2, l, n2, account);
            this.reportViewer.setReport(transactionReport);
        } else if (n == 1) {
            BalancesSettingsPanel balancesSettingsPanel = (BalancesSettingsPanel)this.settingsPanels[1];
            CurrencyType currencyType = (CurrencyType)balancesSettingsPanel.currencyChoice.getSelectedItem();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(balancesSettingsPanel.endDateField.getDate());
            gregorianCalendar.set(11, 15);
            gregorianCalendar.set(12, 55);
            long l = gregorianCalendar.getTime().getTime();
            boolean bl = balancesSettingsPanel.showAllAcountsCheckBox.isSelected();
            AccountBalanceReport accountBalanceReport = new AccountBalanceReport(this.mdGUI, this.rootAccount);
            accountBalanceReport.generateReport(l, currencyType, bl);
            this.reportViewer.setReport(accountBalanceReport);
        } else if (n == 2) {
            IncomeExpenseSettingsPanel incomeExpenseSettingsPanel = (IncomeExpenseSettingsPanel)this.settingsPanels[2];
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(incomeExpenseSettingsPanel.endDateField.getDate());
            gregorianCalendar.set(11, 23);
            gregorianCalendar.set(12, 55);
            long l = gregorianCalendar.getTime().getTime();
            GregorianCalendar gregorianCalendar3 = new GregorianCalendar();
            gregorianCalendar3.setTime(incomeExpenseSettingsPanel.startDateField.getDate());
            gregorianCalendar3.set(11, 1);
            gregorianCalendar3.set(12, 0);
            long l3 = gregorianCalendar3.getTime().getTime();
            IncomeExpenseReport incomeExpenseReport = new IncomeExpenseReport(this.mdGUI, this.rootAccount);
            incomeExpenseReport.generateReport(l3, l);
            this.reportViewer.setReport(incomeExpenseReport);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent != null && itemEvent.getSource() == this.reportTypeChoice) {
            this.setSettingsType();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.doneButton) {
            this.finishUp();
        } else if (actionEvent.getSource() == this.updateButton) {
            this.rebuildReport();
        } else if (actionEvent.getSource() == this.printButton) {
            this.reportViewer.printReport();
        } else if (actionEvent.getSource() == this.saveButton) {
            this.reportViewer.saveReport();
        }
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 201) {
            this.finishUp();
        }
        super.processEvent(aWTEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReportTool(MoneydanceGUI moneydanceGUI, Account account, AccountPanel accountPanel) {
        super(moneydanceGUI.getResources().getString("report_win_title") + ": " + account.getAccountName());
        this.mdGUI = moneydanceGUI;
        this.rootAccount = account.getRootAccount();
        this.parentPanel = accountPanel;
        this.prefs = Main.getMainController().getPreferences();
        try {
            ((Frame)this).setIconImage(AwtUtil.loadImage("/com/seanreilly/apps/moneydance/images/dollar.gif"));
        }
        catch (Exception exception) {
            System.err.println("exception: " + exception);
            exception.printStackTrace(System.err);
        }
        this.dec = this.prefs.getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.reportTypeChoice = new JComboBox();
        this.reportTypeChoice.addItem(moneydanceGUI.getResources().getString("report_transactions"));
        this.reportTypeChoice.addItem(moneydanceGUI.getResources().getString("report_balances"));
        this.reportTypeChoice.addItem(moneydanceGUI.getResources().getString("report_income_expenses"));
        this.settingsPanels = new JPanel[3];
        this.settingsPanels[0] = new TransactionsSettingsPanel(moneydanceGUI, this.rootAccount, account);
        this.settingsPanels[1] = new BalancesSettingsPanel(moneydanceGUI, this.rootAccount, account);
        this.settingsPanels[2] = new IncomeExpenseSettingsPanel(moneydanceGUI);
        this.doneButton = new JButton(moneydanceGUI.getResources().getString("report_done"));
        this.printButton = new JButton(moneydanceGUI.getResources().getString("report_print"));
        this.saveButton = new JButton(moneydanceGUI.getResources().getString("report_save"));
        this.updateButton = new JButton(moneydanceGUI.getResources().getString("report_update"));
        this.settingsPanel = new JPanel(gridBagLayout);
        this.settingsPanel.setBorder(new EtchedBorder());
        JPanel jPanel = new JPanel(gridBagLayout);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        this.reportViewer = new ReportViewer(moneydanceGUI, this);
        this.buttonPanel = new JPanel(gridBagLayout);
        this.getContentPane().add(jPanel2);
        jPanel2.add((Component)jPanel, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 3, 1, true, true));
        jPanel2.add((Component)new JLabel(" "), AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.settingsPanel, AwtUtil.getConstraints(1, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)new JLabel(" "), AwtUtil.getConstraints(2, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.reportViewer, AwtUtil.getConstraints(0, 2, 1.0f, 1.0f, 3, 1, true, true));
        jPanel2.add((Component)this.buttonPanel, AwtUtil.getConstraints(0, 3, 1.0f, 0.0f, 3, 1, true, false));
        this.buttonPanel.add((Component)this.saveButton, AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.buttonPanel.add((Component)this.printButton, AwtUtil.getConstraints(1, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.buttonPanel.add((Component)new JLabel(""), AwtUtil.getConstraints(2, 0, 1.0f, 0.0f, 1, 1, true, true));
        this.buttonPanel.add((Component)this.doneButton, AwtUtil.getConstraints(3, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("report_type") + ": ", 4), AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)this.reportTypeChoice, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, true, false, 17));
        int n = 0;
        int n2 = 0;
        while (n2 < this.settingsPanels.length) {
            gridBagLayout.setConstraints(this.settingsPanels[n2], AwtUtil.getConstraints(0, n, 1.0f, 0.0f, 4, 1, true, true));
            ++n2;
        }
        this.settingsPanel.add((Component)this.updateButton, AwtUtil.getConstraints(0, ++n, 1.0f, 0.0f, 4, 1, true, true));
        this.saveButton.addActionListener(this);
        this.printButton.addActionListener(this);
        this.doneButton.addActionListener(this);
        this.updateButton.addActionListener(this);
        this.reportTypeChoice.addItemListener(this);
        ((Component)this).setSize(650, 600);
        this.restoreSettings(account);
        this.setSettingsType();
        this.rebuildReport();
    }
}

