/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui.reporttool;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JDateField;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IncomeExpenseSettingsPanel
extends JPanel {
    private MoneydanceGUI moneydanceGUI;
    JDateField startDateField;
    JDateField endDateField;
    private DateFormat dateFormat;
    private RootAccount rootAccount;

    public void restoreSettings(UserPreferences userPreferences) {
        long l = userPreferences.getLongSetting("gui.expense_report_start_date", 0L);
        long l2 = userPreferences.getLongSetting("gui.expense_report_end_date", 0L);
        if (l2 > 0L && l > 0L) {
            this.startDateField.setDate(new Date(l));
            this.endDateField.setDate(new Date(l2));
        }
    }

    public void saveSettings(UserPreferences userPreferences) {
        userPreferences.setSetting("gui.txn_report_start_date", this.startDateField.getDate().getTime());
        userPreferences.setSetting("gui.txn_report_end_date", this.endDateField.getDate().getTime());
    }

    public IncomeExpenseSettingsPanel(MoneydanceGUI moneydanceGUI) {
        super(new GridBagLayout());
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = this.rootAccount;
        this.dateFormat = Main.getMainController().getPreferences().getShortDateFormatter();
        Calendar calendar = Calendar.getInstance();
        this.startDateField = new JDateField(this.dateFormat);
        this.endDateField = new JDateField(this.dateFormat);
        this.endDateField.setDate(calendar.getTime());
        calendar.set(2, 0);
        calendar.set(5, 1);
        this.startDateField.setDate(calendar.getTime());
        int n = 2;
        int n2 = 0;
        this.add((Component)new JLabel(" "), AwtUtil.getConstraints(n++, n2, 1.0f, 0.0f, 1, 1, true, true));
        this.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("report_begindate") + ": ", 4), AwtUtil.getConstraints(n++, n2, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.startDateField, AwtUtil.getConstraints(n--, n2++, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("report_enddate") + ": ", 4), AwtUtil.getConstraints(n++, n2, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.endDateField, AwtUtil.getConstraints(n++, n2, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)new JLabel(" "), AwtUtil.getConstraints(n++, n2, 1.0f, 0.0f, 1, 1, true, true));
    }
}

