/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui.reporttool;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.reporttool.RecordRow;
import com.seanreilly.apps.moneydance.view.gui.reporttool.Report;
import com.seanreilly.util.StringUtils;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class IncomeExpenseReport
extends Report {
    private MoneydanceGUI mdGUI;
    private RootAccount rootAccount;
    private CurrencyTable currencyTable;
    private String[] headerNames;
    private Vector rows;
    private char dec;
    private char com;
    private String TOTAL;
    private String OTHER;
    private long beginDate;
    private long endDate;

    public int getColumnWeight(int n) {
        switch (n) {
            case 0: {
                return 20;
            }
        }
        return 10;
    }

    public String getTitle1() {
        return this.mdGUI.getResources().getString("report_income_expenses");
    }

    public String getTitle2() {
        if (this.beginDate <= 0L || this.endDate <= 0L) {
            return "";
        }
        DateFormat dateFormat = Main.getMainController().getPreferences().getShortDateFormatter();
        return dateFormat.format(new Date(this.beginDate)) + " - " + dateFormat.format(new Date(this.endDate));
    }

    public String getColumnName(int n) {
        if (n >= 0 && this.headerNames != null && n < this.headerNames.length) {
            return this.headerNames[n];
        }
        return "";
    }

    public String[] getColumnNames() {
        return this.headerNames;
    }

    public int getColumnCount() {
        return this.headerNames.length;
    }

    public RecordRow getRow(int n) {
        return (RecordRow)this.rows.elementAt(n);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public void generateReport(long l, long l2) {
        Object object;
        this.beginDate = l;
        this.endDate = l2;
        this.rows.removeAllElements();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Object object2 = this.rootAccount.getTransactionSet().getAllTransactions();
        while (object2.hasMoreElements()) {
            int n;
            Object object3;
            object = (Transaction)object2.nextElement();
            long l3 = ((Transaction)object).getDate();
            if (l3 < l || l3 > l2) continue;
            int n2 = ((Transaction)object).getSourceAccountId();
            if (n2 > 0) {
                Integer n3 = new Integer(n2);
                object3 = (IEAccountData)hashtable.get(n3);
                if (object3 == null) {
                    IncomeExpenseReport incomeExpenseReport = this;
                    if (incomeExpenseReport == null) {
                        throw null;
                    }
                    object3 = incomeExpenseReport.new IEAccountData();
                    hashtable.put(n3, object3);
                    ((IEAccountData)object3).account = this.rootAccount.getAccountById(n2);
                    ((IEAccountData)object3).amount = 0L;
                }
                ((IEAccountData)object3).amount += ((Transaction)object).getAmount(n2);
            }
            if ((n = ((Transaction)object).getDestAccountId()) <= 0) continue;
            object3 = new Integer(n);
            IEAccountData iEAccountData = (IEAccountData)hashtable.get(object3);
            if (iEAccountData == null) {
                IncomeExpenseReport incomeExpenseReport = this;
                if (incomeExpenseReport == null) {
                    throw null;
                }
                iEAccountData = incomeExpenseReport.new IEAccountData();
                hashtable.put(object3, iEAccountData);
                iEAccountData.account = this.rootAccount.getAccountById(n);
                iEAccountData.amount = 0L;
            }
            iEAccountData.amount += ((Transaction)object).getAmount(n);
        }
        CurrencyType currencyType = this.currencyTable.getBaseType();
        object2 = this.mdGUI.getResources().getString("acct_type" + 5 + 'S');
        this.rows.addElement(this.getAcctTypeHeaderRow((String)object2));
        this.rows.addElement(RecordRow.BLANK_ROW);
        long l4 = this.computeTotalAmount(this.rootAccount, currencyType, hashtable, 5);
        object = (currencyType.getPrefix() + ' ' + StringUtils.formatCurrency(-l4, true, this.dec, this.com, currencyType.getDecimalPlaces()) + ' ' + currencyType.getSuffix()).trim();
        this.rows.addElement(this.getAcctTypeTotalRow((String)object2 + this.TOTAL, (String)object));
        this.rows.addElement(RecordRow.BLANK_ROW);
        object2 = this.mdGUI.getResources().getString("acct_type" + 4 + 'S');
        this.rows.addElement(this.getAcctTypeHeaderRow((String)object2));
        this.rows.addElement(RecordRow.BLANK_ROW);
        long l5 = this.computeTotalAmount(this.rootAccount, this.currencyTable.getBaseType(), hashtable, 4);
        object = (currencyType.getPrefix() + ' ' + StringUtils.formatCurrency(l5, true, this.dec, this.com, currencyType.getDecimalPlaces()) + ' ' + currencyType.getSuffix()).trim();
        this.rows.addElement(this.getAcctTypeTotalRow((String)object2 + this.TOTAL, (String)object));
        this.rows.addElement(RecordRow.BLANK_ROW);
        object = (currencyType.getPrefix() + ' ' + StringUtils.formatCurrency(-l4 - l5, true, this.dec, this.com, currencyType.getDecimalPlaces()) + ' ' + currencyType.getSuffix()).trim();
        this.rows.addElement(RecordRow.BLANK_ROW);
        this.rows.addElement(this.getGrandTotalRow((String)object));
    }

    private final RecordRow getGrandTotalRow(String string) {
        RecordRow recordRow = new RecordRow(new String[3], new byte[3], new byte[3], new byte[3], new byte[3]);
        recordRow.labels[0] = this.mdGUI.getResources().getString("report_ie_total");
        recordRow.labels[1] = string;
        recordRow.align[0] = 1;
        recordRow.align[1] = 2;
        recordRow.align[1] = 2;
        recordRow.style[0] = 2;
        recordRow.style[1] = 2;
        recordRow.style[1] = 2;
        recordRow.total[1] = 1;
        return recordRow;
    }

    private final RecordRow getAcctTypeTotalRow(String string, String string2) {
        CurrencyType currencyType = this.currencyTable.getBaseType();
        RecordRow recordRow = this.getAcctTypeHeaderRow(string);
        recordRow.labels[1] = string2;
        recordRow.total[1] = 1;
        return recordRow;
    }

    private final RecordRow getAcctTypeHeaderRow(String string) {
        CurrencyType currencyType = this.currencyTable.getBaseType();
        RecordRow recordRow = new RecordRow(new String[3], new byte[3], new byte[3], new byte[3], new byte[3]);
        recordRow.labels[0] = string;
        recordRow.style[0] = 2;
        recordRow.style[1] = 2;
        recordRow.style[2] = 2;
        recordRow.align[0] = 1;
        recordRow.align[1] = 2;
        recordRow.align[2] = 2;
        return recordRow;
    }

    private final RecordRow getAccountSubtotalRow(String string, String string2, String string3) {
        RecordRow recordRow = new RecordRow(new String[3], new byte[3], new byte[3], new byte[3], new byte[3]);
        recordRow.labels[0] = string;
        recordRow.labels[1] = string2;
        recordRow.labels[2] = string3;
        recordRow.align[0] = 1;
        recordRow.align[1] = 2;
        recordRow.align[2] = 2;
        recordRow.color[0] = 1;
        recordRow.color[1] = 1;
        recordRow.color[2] = 1;
        recordRow.style[0] = 2;
        recordRow.style[1] = 2;
        recordRow.style[2] = 2;
        recordRow.total[1] = 1;
        return recordRow;
    }

    private final RecordRow getAccountRow(String string, String string2) {
        RecordRow recordRow = new RecordRow(new String[3], new byte[3], new byte[3], new byte[3], null);
        recordRow.labels[0] = string;
        recordRow.labels[1] = string2;
        recordRow.align[0] = 1;
        recordRow.align[1] = 2;
        recordRow.align[2] = 2;
        return recordRow;
    }

    private final long computeTotalAmount(Account account, CurrencyType currencyType, Hashtable hashtable, int n) {
        int n2 = account.getAccountNum();
        int n3 = account.getAccountType();
        boolean bl = n3 == 0;
        IEAccountData iEAccountData = (IEAccountData)hashtable.get(new Integer(n2));
        CurrencyType currencyType2 = this.currencyTable.getCurrencyType(account.getCurrencyType());
        if (iEAccountData == null) {
            IncomeExpenseReport incomeExpenseReport = this;
            if (incomeExpenseReport == null) {
                throw null;
            }
            iEAccountData = incomeExpenseReport.new IEAccountData();
            iEAccountData.account = account;
            iEAccountData.amount = 0L;
        }
        long l = 0L;
        if (n3 == n) {
            l = iEAccountData.amount;
        }
        boolean bl2 = l == 0L;
        String string = "";
        int n4 = 1;
        if (n == 5) {
            n4 = -1;
        }
        string = (currencyType2.getPrefix() + ' ' + StringUtils.formatCurrency(l * (long)n4, true, this.dec, this.com, currencyType2.getDecimalPlaces()) + currencyType2.getSuffix()).trim();
        RecordRow recordRow = this.getAccountRow("   " + account, string);
        int n5 = this.rows.size();
        int n6 = 0;
        while (n6 < account.getSubAccountCount()) {
            Account account2 = account.getSubAccount(n6);
            l += this.computeTotalAmount(account2, currencyType2, hashtable, n);
            ++n6;
        }
        if (!bl) {
            boolean bl3;
            n6 = this.rows.size() == n5 ? 0 : 1;
            boolean bl4 = bl3 = n == n3;
            if (n6 != 0) {
                string = (currencyType2.getPrefix() + ' ' + StringUtils.formatCurrency(l * (long)n4, true, this.dec, this.com, currencyType2.getDecimalPlaces()) + ' ' + currencyType2.getSuffix()).trim();
                if (!bl2 && bl3) {
                    this.rows.addElement(this.getAccountRow("   " + "   " + account + this.OTHER, recordRow.labels[1]));
                }
                this.rows.insertElementAt(this.getAccountRow("   " + account, ""), n5);
                this.rows.addElement(this.getAccountSubtotalRow("   " + account.toString() + this.TOTAL, "", string));
            } else if (bl3 && !bl2) {
                this.rows.insertElementAt(recordRow, n5);
            }
        }
        return this.currencyTable.convertValue(l, currencyType2, currencyType);
    }

    public IncomeExpenseReport(MoneydanceGUI moneydanceGUI, RootAccount rootAccount) {
        this.mdGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.currencyTable = rootAccount.getCurrencyTable();
        this.TOTAL = moneydanceGUI.getResources().getString("report_total_suffix");
        this.OTHER = moneydanceGUI.getResources().getString("report_other_suffix");
        this.dec = Main.getMainController().getPreferences().getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        this.rows = new Vector();
        this.headerNames = new String[]{moneydanceGUI.getResources().getString("table_column_account"), "", ""};
    }

    class IEAccountData {
        Account account = null;
        long amount = 0L;

        IEAccountData() {
        }
    }
}

