/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui.reporttool;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.reporttool.RecordRow;
import com.seanreilly.apps.moneydance.view.gui.reporttool.Report;
import com.seanreilly.util.StringUtils;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AccountBalanceReport
extends Report {
    private MoneydanceGUI mdGUI;
    private RootAccount rootAccount;
    private CurrencyTable currencyTable;
    private String[] headers;
    private Vector rows;
    private char dec;
    private char com;
    private DateFormat dateFormat;
    private CurrencyType currencyType;
    private int numDecimals;
    private String currencyPrefix;
    private String currencySuffix;
    private String title2 = "";

    public String getTitle1() {
        return this.mdGUI.getResources().getString("report_balances");
    }

    public String getTitle2() {
        return this.title2;
    }

    public RecordRow getRow(int n) {
        return (RecordRow)this.rows.elementAt(n);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public String getColumnName(int n) {
        return this.headers[n];
    }

    public int getColumnCount() {
        return this.headers.length;
    }

    public int getColumnWeight(int n) {
        switch (n) {
            case 0: {
                return 20;
            }
        }
        return 10;
    }

    public void generateReport(long l, CurrencyType currencyType, boolean bl) {
        this.title2 = this.mdGUI.getResources().getString("as_of") + ": " + this.dateFormat.format(new Date(l));
        this.numDecimals = currencyType.getDecimalPlaces();
        this.currencyPrefix = currencyType.getPrefix();
        this.currencySuffix = currencyType.getSuffix();
        Hashtable<Integer, AccountData> hashtable = new Hashtable<Integer, AccountData>();
        this.rows = new Vector();
        Enumeration enumeration = this.rootAccount.getTransactionSet().getAllTransactions();
        while (enumeration.hasMoreElements()) {
            Transaction transaction = (Transaction)enumeration.nextElement();
            long l2 = transaction.getDate();
            if (l2 > l) continue;
            int n = transaction.getDestAccountId();
            int n2 = transaction.getSourceAccountId();
            Account account = this.rootAccount.getAccountById(n);
            Account account2 = this.rootAccount.getAccountById(n2);
            Integer n3 = new Integer(n);
            AccountData accountData = (AccountData)hashtable.get(n3);
            if (accountData == null) {
                AccountBalanceReport accountBalanceReport = this;
                if (accountBalanceReport == null) {
                    throw null;
                }
                accountData = accountBalanceReport.new AccountData();
                if (n >= 0) {
                    accountData.amount = account.getStartBalance();
                }
                accountData.account = account;
                hashtable.put(n3, accountData);
            }
            accountData.amount += transaction.getAmount(n);
            Integer n4 = new Integer(n2);
            AccountData accountData2 = (AccountData)hashtable.get(n4);
            if (accountData2 == null) {
                AccountBalanceReport accountBalanceReport = this;
                if (accountBalanceReport == null) {
                    throw null;
                }
                accountData2 = accountBalanceReport.new AccountData();
                if (n2 >= 0) {
                    accountData2.amount = account2.getStartBalance();
                }
                accountData2.account = account2;
                hashtable.put(n4, accountData2);
            }
            accountData2.amount += transaction.getAmount(n2);
        }
        this.addSubAccounts(this.rootAccount, hashtable, currencyType, bl);
    }

    private final long addSubAccounts(Account account, Hashtable hashtable, CurrencyType currencyType, boolean bl) {
        Account account2 = account;
        synchronized (account2) {
            boolean bl2 = false;
            long l = 0L;
            int n = 0;
            while (n < account.getSubAccountCount()) {
                bl2 = true;
                Account account3 = account.getSubAccount(n);
                if (bl || account3.isRegisterAccount()) {
                    AccountData accountData = (AccountData)hashtable.get(new Integer(account3.getAccountNum()));
                    if (accountData == null) {
                        AccountBalanceReport accountBalanceReport = this;
                        if (accountBalanceReport == null) {
                            throw null;
                        }
                        accountData = accountBalanceReport.new AccountData();
                        accountData.account = account3;
                        accountData.amount = account3.getStartBalance();
                    }
                    CurrencyType currencyType2 = this.currencyTable.getCurrencyType(accountData.account.getCurrencyType());
                    accountData.amount = this.currencyTable.convertValue(accountData.amount, currencyType2, currencyType);
                    l += accountData.amount;
                    this.rows.addElement(this.getAccountRow(accountData));
                    l += this.addSubAccounts(account3, hashtable, currencyType, bl);
                }
                ++n;
            }
            if (bl2) {
                String string = account.getAccountType() == 0 ? this.mdGUI.getResources().getString("report_total") : this.mdGUI.getResources().getString("report_subtotal_for") + ": " + account.getFullAccountName();
                this.rows.addElement(this.getSubtotalRow(string, l));
            }
            long l2 = l;
            Object var6_14 = null;
            return l2;
        }
    }

    private final RecordRow getAccountRow(AccountData accountData) {
        RecordRow recordRow = new RecordRow(new String[2], new byte[2], new byte[2], new byte[2], new byte[2]);
        recordRow.labels[0] = accountData.account.toString();
        recordRow.labels[1] = StringUtils.formatCurrency(accountData.amount, true, this.dec, this.com, this.numDecimals);
        recordRow.align[0] = 1;
        recordRow.align[1] = 2;
        recordRow.color[0] = 1;
        recordRow.color[1] = accountData.amount < 0L ? 2 : 1;
        recordRow.style[0] = 1;
        recordRow.style[1] = 1;
        return recordRow;
    }

    private final RecordRow getSubtotalRow(String string, long l) {
        RecordRow recordRow = new RecordRow(new String[2], new byte[2], new byte[2], new byte[2], new byte[2]);
        recordRow.labels[0] = string;
        recordRow.labels[1] = StringUtils.formatCurrency(l, true, this.dec, this.com, this.numDecimals);
        recordRow.align[0] = 1;
        recordRow.align[1] = 2;
        recordRow.color[0] = 1;
        recordRow.color[1] = l < 0L ? 2 : 1;
        recordRow.style[0] = 2;
        recordRow.style[1] = 2;
        recordRow.total[1] = 1;
        return recordRow;
    }

    public AccountBalanceReport(MoneydanceGUI moneydanceGUI, RootAccount rootAccount) {
        this.mdGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.currencyTable = rootAccount.getCurrencyTable();
        this.dec = Main.getMainController().getPreferences().getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        this.dateFormat = Main.getMainController().getPreferences().getShortDateFormatter();
        this.headers = new String[]{moneydanceGUI.getResources().getString("table_column_account"), moneydanceGUI.getResources().getString("table_column_amount")};
    }

    class AccountData {
        Account account;
        long amount = 0L;

        AccountData() {
        }
    }
}

