/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui.help;

import com.seanreilly.apps.moneydance.controller.Main;
import java.awt.Cursor;
import java.io.InputStream;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class HelpPane
extends JScrollPane
implements HyperlinkListener {
    JEditorPane htmlArea;
    String helpDir;
    String footerText;

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.htmlArea.setCursor(Cursor.getPredefinedCursor(3));
            HelpPane helpPane = this;
            if (helpPane == null) {
                throw null;
            }
            SwingUtilities.invokeLater(helpPane.new LinkRetriever(hyperlinkEvent.getDescription()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean setPage(String string) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(this.helpDir + string);
            if (inputStream == null) {
                System.err.println("page \"" + string + "\" does not exist!");
                return false;
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                int n;
                if ((n = inputStream.read()) < 0) {
                    stringBuffer.append(this.footerText);
                    this.htmlArea.setText(stringBuffer.toString());
                    try {
                        inputStream.close();
                        return true;
                    }
                    catch (Exception exception) {
                        return true;
                    }
                }
                stringBuffer.append((char)n);
            }
        }
        catch (Exception exception) {
            if (!Main.DEBUG) return false;
            System.err.println("got exception: " + exception);
            exception.printStackTrace(System.err);
            this.getToolkit().beep();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void linkActivated(String string) {
        if (string != null && string.toUpperCase().startsWith("HTTP://")) {
            try {
                this.htmlArea.setPage(string);
                return;
            }
            catch (Exception exception) {
                if (Main.DEBUG) {
                    System.err.println("error setting page: \"" + string + "\": " + exception);
                    exception.printStackTrace(System.err);
                }
                this.setPage("index.html");
                return;
            }
        }
        if (string != null) {
            this.setPage(string);
            return;
        }
        if (!Main.DEBUG) return;
        System.err.println("error: invalid link: " + string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HelpPane(String string, String string2) {
        block7: {
            this.footerText = "";
            this.helpDir = string;
            this.htmlArea = new JEditorPane("text/html", "");
            this.htmlArea.setEditable(false);
            this.htmlArea.addHyperlinkListener(this);
            this.getViewport().add(this.htmlArea);
            try {
                InputStream inputStream = this.getClass().getResourceAsStream(string + "footer.html");
                if (inputStream == null) {
                    System.err.println("page \"" + "footer.html" + "\" does not exist!");
                    break block7;
                }
                StringBuffer stringBuffer = new StringBuffer();
                while (true) {
                    int n;
                    if ((n = inputStream.read()) < 0) {
                        this.footerText = stringBuffer.toString();
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {
                        }
                        break;
                    }
                    stringBuffer.append((char)n);
                }
            }
            catch (Exception exception) {
                if (!Main.DEBUG) break block7;
                System.err.println("Error reading footer: " + exception);
                exception.printStackTrace(System.err);
            }
        }
        this.setPage(string2);
    }

    class LinkRetriever
    implements Runnable {
        String link;

        public void run() {
            HelpPane.this.linkActivated(this.link);
            HelpPane.this.htmlArea.setCursor(Cursor.getPredefinedCursor(0));
        }

        LinkRetriever(String string) {
            this.link = string;
        }
    }
}

