/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui.graphtool;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.AccountUtil;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoListener;
import com.seanreilly.apps.moneydance.view.gui.AccountPanel;
import com.seanreilly.apps.moneydance.view.gui.AccountPopup;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.graphtool.AccountData;
import com.seanreilly.apps.moneydance.view.gui.graphtool.DataSetGroup;
import com.seanreilly.apps.moneydance.view.gui.graphtool.TopAccountsSettingsPanel;
import com.seanreilly.apps.moneydance.view.gui.graphtool.TopIncomesSettingsPanel;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.GIFEncoder;
import com.seanreilly.awt.JDateField;
import com.seanreilly.awt.graph.BarGraphPanel;
import com.seanreilly.awt.graph.ColorEnumerator;
import com.seanreilly.awt.graph.DataSet;
import com.seanreilly.awt.graph.KeyItem;
import com.seanreilly.awt.graph.KeyPanel;
import com.seanreilly.awt.graph.LineGraphPanel;
import com.seanreilly.awt.graph.PieGraphPanel;
import com.seanreilly.util.Misc;
import com.seanreilly.util.StringUtils;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;

public class GraphTool
extends JFrame
implements ActionListener,
AccountInfoListener,
ItemListener {
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$BankTransaction;
    private MoneydanceGUI moneydanceGUI;
    private RootAccount rootAccount;
    private JPanel[] settingsPanels;
    private JPanel currentSettingsPanel = null;
    private JPanel settingsPanel;
    private JPanel graphPanel;
    private JPanel bottomGraphPanel;
    private JPanel topGraphPanel;
    private AccountPopup accountChoice;
    private JComboBox graphTypeChoice;
    private JComboBox groupByChoice;
    private JButton doneButton;
    private JButton saveButton;
    private JButton printButton;
    private JButton updateButton;
    private AccountPanel parentPanel;
    private JComboBox lineOrPieChoice;
    private JDateField startDateField;
    private JDateField endDateField;
    private JCheckBox use3dGraphs;
    private JCheckBox detailedKeyCheckbox;
    private LineGraphPanel lineGraph;
    private BarGraphPanel barGraph;
    private PieGraphPanel pieGraph;
    private KeyPanel key;
    private char dec;
    private char com;
    private GridBagConstraints graphConstraints;
    private UserPreferences prefs;
    private int lineHeight = 25;
    private int hdrHeight = this.lineHeight * 2;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void restoreStickySettings(Account account) {
        Object object;
        long l = -1L;
        long l2 = -1L;
        try {
            l = this.prefs.getLongSetting("gui.graph_start_date", -1L);
            l2 = this.prefs.getLongSetting("gui.graph_end_date", -1L);
        }
        catch (Exception exception) {
            l = -1L;
        }
        if (l > 0L && l2 > 0L) {
            this.startDateField.setDate(new Date(l));
            this.endDateField.setDate(new Date(l2));
        } else {
            object = Calendar.getInstance();
            this.endDateField.setDate(((Calendar)object).getTime());
            ((Calendar)object).set(2, 0);
            ((Calendar)object).set(5, 1);
            this.startDateField.setDate(((Calendar)object).getTime());
        }
        if (account.getAccountType() == 0) {
            int n;
            Account account2;
            this.accountChoice.setSelectedIndex(0);
            object = this.prefs.getSetting("gui.graph_selected_acct");
            if (object != null && (account2 = this.rootAccount.getAccountById(n = Integer.parseInt((String)object))) != null) {
                this.accountChoice.setSelectedItem(account2);
            }
        } else {
            this.accountChoice.setSelectedItem(account);
        }
        try {
            this.detailedKeyCheckbox.setSelected(this.prefs.getIntSetting("gui.graph_detailed_key", 0) == 1);
        }
        catch (Exception exception) {
        }
        try {
            this.use3dGraphs.setSelected(this.prefs.getIntSetting("gui.graph_dimension", 0) == 1);
        }
        catch (Exception exception) {
        }
        try {
            this.graphTypeChoice.setSelectedIndex(this.prefs.getIntSetting("gui.graph_type", 0));
        }
        catch (Exception exception) {
        }
        try {
            this.lineOrPieChoice.setSelectedIndex(this.prefs.getIntSetting("gui.graph_style", 0));
        }
        catch (Exception exception) {
        }
        try {
            this.groupByChoice.setSelectedIndex(this.prefs.getIntSetting("gui.graph_group", 0));
        }
        catch (Exception exception) {
        }
        ((TopAccountsSettingsPanel)this.settingsPanels[0]).restoreSettings(this.prefs);
        ((TopIncomesSettingsPanel)this.settingsPanels[1]).restoreSettings(this.prefs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void saveSettings() {
        this.prefs.setSetting("gui.graph_dimension", this.use3dGraphs.isSelected() ? "1" : "0");
        this.prefs.setSetting("gui.graph_detailed_key", this.detailedKeyCheckbox.isSelected() ? "1" : "0");
        this.prefs.setSetting("gui.graph_type", this.graphTypeChoice.getSelectedIndex());
        this.prefs.setSetting("gui.graph_start_date", this.startDateField.getDate().getTime());
        this.prefs.setSetting("gui.graph_end_date", String.valueOf(this.endDateField.getDate().getTime()));
        this.prefs.setSetting("gui.graph_type", this.graphTypeChoice.getSelectedIndex());
        this.prefs.setSetting("gui.graph_style", this.lineOrPieChoice.getSelectedIndex());
        this.prefs.setSetting("gui.graph_group", this.groupByChoice.getSelectedIndex());
        try {
            this.prefs.setSetting("gui.graph_selected_acct", String.valueOf(this.accountChoice.getSelectedAccount().getAccountNum()));
        }
        catch (Exception exception) {
        }
        ((TopAccountsSettingsPanel)this.settingsPanels[0]).saveSettings(this.prefs);
        ((TopIncomesSettingsPanel)this.settingsPanels[1]).saveSettings(this.prefs);
    }

    public void accountInfoUpdated(Object object) {
        this.rebuildGraph();
    }

    private final void finishUp() {
        this.parentPanel.grapherIsDone(this);
    }

    private final void setSettingsType() {
        int n = this.graphTypeChoice.getSelectedIndex();
        if (this.currentSettingsPanel != null) {
            this.settingsPanel.remove(this.currentSettingsPanel);
        }
        if (n == 3) {
            this.lineOrPieChoice.setSelectedIndex(0);
            this.lineOrPieChoice.setEnabled(false);
            this.groupByChoice.setEnabled(false);
        } else {
            this.lineOrPieChoice.setEnabled(true);
            this.groupByChoice.setEnabled(true);
        }
        this.currentSettingsPanel = this.settingsPanels[n];
        this.settingsPanel.add(this.currentSettingsPanel);
        this.validate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void saveGraph() {
        FileDialog fileDialog = new FileDialog((Frame)this, this.moneydanceGUI.getResources().getString("choose_graph_file_title"), 1);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string == null || string2 == null) {
            return;
        }
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        try {
            File file = new File(string2 + string);
            Dimension dimension = this.graphPanel.getSize();
            Image image = this.createImage(dimension.width, dimension.height + this.hdrHeight);
            Graphics graphics = image.getGraphics();
            this.renderGraphs(graphics, dimension.width, dimension.height + this.hdrHeight);
            new GIFEncoder(image).Write(new BufferedOutputStream(new FileOutputStream(file)));
        }
        catch (Exception exception) {
            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("save_graph_err") + String.valueOf(exception));
        }
        GraphTool graphTool = this;
        if (graphTool == null) {
            throw null;
        }
        SwingUtilities.invokeLater(new Runnable(graphTool){
            private final /* synthetic */ GraphTool this$0;

            public final void run() {
                ((Component)this.this$0).setCursor(Cursor.getPredefinedCursor(0));
            }
            {
                this.this$0 = graphTool;
                this.constructor$0(graphTool);
            }

            public void constructor$0(GraphTool graphTool) {
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void printGraph() {
        PrintJob printJob = this.getToolkit().getPrintJob(this, this.moneydanceGUI.getResources().getString("print_graph_title"), null);
        if (printJob == null) {
            return;
        }
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        try {
            Graphics graphics = printJob.getGraphics();
            if (graphics != null) {
                Dimension dimension = printJob.getPageDimension();
                this.renderGraphs(graphics.create(20, 20, dimension.width - 40, dimension.height - 40), dimension.width - 40, dimension.height - 40);
            }
            printJob.end();
        }
        catch (Exception exception) {
            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("save_graph_err") + String.valueOf(exception));
        }
        GraphTool graphTool = this;
        if (graphTool == null) {
            throw null;
        }
        SwingUtilities.invokeLater(new Runnable(graphTool){
            private final /* synthetic */ GraphTool this$0;

            public final void run() {
                ((Component)this.this$0).setCursor(Cursor.getPredefinedCursor(0));
            }
            {
                this.this$0 = graphTool;
                this.constructor$0(graphTool);
            }

            public void constructor$0(GraphTool graphTool) {
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void renderGraphs(Graphics graphics, int n, int n2) {
        try {
            int n3 = this.graphTypeChoice.getSelectedIndex();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n, this.hdrHeight);
            graphics.setColor(Color.black);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = 5;
            int n5 = this.lineHeight / 2 + (fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent()) / 2 - fontMetrics.getMaxDescent();
            String string = String.valueOf(this.graphTypeChoice.getSelectedItem());
            graphics.drawString(string, n4, n5);
            graphics.setColor(Color.gray);
            graphics.fillOval((n4 += fontMetrics.stringWidth(string) + 5) + 7, 7, this.lineHeight - 14, this.lineHeight - 14);
            graphics.setColor(Color.black);
            Account account = this.accountChoice.getSelectedAccount();
            string = account == null ? null : account.getFullAccountName();
            graphics.drawString(string, n4 += this.lineHeight + 5, n5);
            n4 += fontMetrics.stringWidth(string) + 5;
            n4 = 5;
            string = this.startDateField.getText().trim() + "  -  " + this.endDateField.getText().trim();
            graphics.drawString(string, n4, n5 += this.lineHeight);
            n4 += fontMetrics.stringWidth(string) + 5;
            if (n3 != 3) {
                graphics.setColor(Color.gray);
                graphics.fillOval(n4 + 7, this.lineHeight + 7, this.lineHeight - 14, this.lineHeight - 14);
                graphics.setColor(Color.black);
                string = String.valueOf(this.groupByChoice.getSelectedItem());
                graphics.drawString(string, n4 += this.lineHeight + 5, n5);
                n4 += fontMetrics.stringWidth(string) + 5;
            }
            int n6 = n2 - this.hdrHeight;
            if (n3 != 3) {
                this.pieGraph.drawGraph(graphics.create(0, this.hdrHeight, n6 / 2, n6 / 2), n6 / 2, n6 / 2, true);
                this.key.drawKey(graphics.create(n6 / 2, this.hdrHeight, n - n6 / 2, n6 / 2), n - n6 / 2, n6 / 2);
                this.lineGraph.drawGraph(graphics.create(0, n6 / 2 + this.hdrHeight, n, n6 / 2), n, n6 / 2, true);
                return;
            }
            Dimension dimension = this.lineGraph.getSize();
            this.lineGraph.drawGraph(graphics.create(0, this.hdrHeight, n, n6), n, n6, true);
            return;
        }
        catch (Exception exception) {
            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("save_graph_err") + String.valueOf(exception));
        }
    }

    private final void rebuildGraph() {
        boolean bl;
        int n = this.graphTypeChoice.getSelectedIndex();
        DataSetGroup[] dataSetGroupArray = null;
        if (n == 0) {
            dataSetGroupArray = this.rebuildTopExpenseGraph();
        } else if (n == 1) {
            dataSetGroupArray = this.rebuildTopIncomeGraph();
        } else if (n == 2) {
            dataSetGroupArray = this.rebuildIncomeExpenseGraph();
        } else if (n == 3) {
            dataSetGroupArray = this.rebuildAccountBalanceGraph();
        }
        this.graphPanel.setVisible(false);
        this.graphPanel.removeAll();
        if (n != 3) {
            this.graphPanel.setLayout(new GridLayout(2, 1));
            this.graphPanel.add(this.topGraphPanel);
            this.graphPanel.add(this.bottomGraphPanel);
        } else {
            this.graphPanel.setLayout(new BorderLayout());
            this.graphPanel.add((Component)this.bottomGraphPanel, "Center");
        }
        this.barGraph.removeAllDataSets();
        this.lineGraph.removeAllDataSets();
        this.pieGraph.removeAllDataSets();
        this.key.removeAllKeyItems();
        int n2 = this.groupByChoice.getSelectedIndex();
        boolean bl2 = bl = this.lineOrPieChoice.getSelectedIndex() == 0;
        if (dataSetGroupArray != null) {
            boolean bl3;
            Object object;
            ColorEnumerator colorEnumerator = new ColorEnumerator();
            long l = 0L;
            int n3 = 0;
            while (n3 < dataSetGroupArray.length) {
                object = dataSetGroupArray[n3].pieDataSet;
                if (object != null) {
                    bl3 = false;
                    while (bl3 < ((DataSet)object).yvalues.length) {
                        l += ((DataSet)object).yvalues[bl3].longValue();
                        bl3 += 1;
                    }
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < dataSetGroupArray.length) {
                String[] stringArray;
                Object object2;
                object = colorEnumerator.nextColor();
                boolean bl4 = bl3 = this.use3dGraphs == null ? true : (boolean)this.use3dGraphs.isSelected();
                if (bl) {
                    this.lineGraph.setThreeD(bl3);
                    this.lineGraph.addDataSetGraph(dataSetGroupArray[n3].lineDataSet, (Color)object);
                } else {
                    this.barGraph.setThreeD(bl3);
                    this.barGraph.addDataSetGraph(dataSetGroupArray[n3].lineDataSet, (Color)object);
                }
                if (dataSetGroupArray[n3].pieDataSet != null) {
                    this.pieGraph.setThreeD(bl3);
                    this.pieGraph.addDataSetGraph(dataSetGroupArray[n3].pieDataSet, (Color)object);
                }
                if (dataSetGroupArray[n3].pieDataSet != null && (object2 = dataSetGroupArray[n3].pieDataSet) != null) {
                    stringArray = dataSetGroupArray[n3].pieDataSet.getDescription();
                    long l2 = 0L;
                    int n4 = 0;
                    while (n4 < ((DataSet)object2).yvalues.length) {
                        l2 += ((DataSet)object2).yvalues[n4].longValue();
                        ++n4;
                    }
                    String[] stringArray2 = new String[stringArray.length + 2];
                    int n5 = 0;
                    while (n5 < stringArray.length) {
                        stringArray2[n5] = stringArray[n5];
                        ++n5;
                    }
                    stringArray2[stringArray2.length - 2] = StringUtils.formatPercentage((float)l2 / (float)l, this.dec) + " % ";
                    stringArray2[stringArray2.length - 1] = DataSet.formatValue(new Long(l2), ((DataSet)object2).getYType());
                    ((DataSet)object2).setDescription(stringArray2);
                }
                object2 = "";
                if (!this.detailedKeyCheckbox.isSelected()) {
                    object2 = dataSetGroupArray[n3].lineDataSet.getDescription()[0];
                } else {
                    stringArray = new StringBuffer();
                    String[] stringArray3 = dataSetGroupArray[n3].lineDataSet.getDescription();
                    int n6 = 0;
                    while (stringArray3 != null && n6 < stringArray3.length) {
                        stringArray.append('\n');
                        stringArray.append(stringArray3[n6]);
                        ++n6;
                    }
                    if (dataSetGroupArray[n3].pieDataSet != null) {
                        String[] stringArray4 = dataSetGroupArray[n3].pieDataSet.getDescription();
                        int n7 = 0;
                        while (stringArray4 != null && n7 < stringArray4.length) {
                            stringArray.append('\n');
                            stringArray.append(stringArray4[n7]);
                            ++n7;
                        }
                    }
                    object2 = stringArray.toString().trim();
                }
                this.key.addKeyItem(new KeyItem((String)object2, dataSetGroupArray[n3].lineDataSet, (Color)object));
                ++n3;
            }
        }
        this.bottomGraphPanel.removeAll();
        if (bl) {
            this.bottomGraphPanel.add(this.lineGraph);
        } else {
            if (n2 == 0) {
                this.barGraph.setInterval(-1);
            } else if (n2 == 1) {
                this.barGraph.setInterval(-2);
            } else if (n2 == 2) {
                this.barGraph.setInterval(-3);
            } else {
                this.barGraph.setInterval(-4);
            }
            this.bottomGraphPanel.add(this.barGraph);
        }
        this.graphPanel.revalidate();
        this.graphPanel.setVisible(true);
        if (bl) {
            this.lineGraph.renderGraph();
        } else {
            this.barGraph.renderGraph();
        }
        this.pieGraph.renderGraph();
        this.key.renderKey();
        this.validate();
    }

    private final DataSetGroup txn2DataSet(Vector vector, Account account, Account account2, boolean bl) {
        int n = account.getAccountNum();
        CurrencyType currencyType = account.getRootAccount().getCurrencyTable().getCurrencyType(account.getCurrencyType());
        DataSet.setCurrencyNumDecimalPlaces(currencyType.getDecimalPlaces());
        DataSet.setDecimalChar(this.dec);
        DataSet.setCommaChar(this.com);
        String string = account2 != null ? account2.getFullAccountName() : (!bl ? this.moneydanceGUI.getResources().getString("graph_income") : this.moneydanceGUI.getResources().getString("graph_expenses"));
        DataSet dataSet = new DataSet(string, 1, 1, 2);
        dataSet.yvalues[0] = new Long(0L);
        int n2 = this.groupByChoice.getSelectedIndex();
        AccountUtil.sortTransactions(vector, 7, n, this.rootAccount);
        DateValuePair dateValuePair = null;
        Calendar calendar = Calendar.getInstance();
        Vector<DateValuePair> vector2 = new Vector<DateValuePair>();
        long l = 0L;
        int n3 = 0;
        while (n3 < vector.size()) {
            Transaction transaction = (Transaction)vector.elementAt(n3);
            l = transaction.getDate();
            calendar.setTime(new Date(transaction.getDate()));
            calendar.set(16, calendar.getMinimum(16));
            calendar.set(11, calendar.getMinimum(11) + 2);
            calendar.set(12, calendar.getMinimum(12));
            calendar.set(13, calendar.getMinimum(13));
            calendar.set(14, calendar.getMinimum(14));
            boolean bl2 = false;
            if (n2 != 0) {
                if (n2 == 1) {
                    while (calendar.get(7) != calendar.getMinimum(7)) {
                        calendar.add(7, -1);
                    }
                } else if (n2 == 2) {
                    calendar.set(5, calendar.getMinimum(5));
                } else if (n2 == 3) {
                    calendar.set(6, calendar.getMinimum(6));
                }
            }
            calendar.set(11, calendar.getMinimum(11) + 2);
            long l2 = calendar.getTime().getTime();
            if (bl2 || dateValuePair == null || l2 - dateValuePair.date < -3600000L || l2 - dateValuePair.date > 3600000L) {
                if (dateValuePair != null) {
                    vector2.addElement(dateValuePair);
                }
                GraphTool graphTool = this;
                if (graphTool == null) {
                    throw null;
                }
                dateValuePair = graphTool.new DateValuePair(calendar.getTime().getTime(), transaction.getAmount(n) * (long)(bl ? -1 : 1));
            } else {
                dateValuePair.value = dateValuePair.value + transaction.getAmount(n) * (long)(bl ? -1 : 1);
            }
            ++n3;
        }
        if (dateValuePair != null) {
            vector2.addElement(dateValuePair);
        }
        DataSet dataSet2 = new DataSet(string, vector2.size(), 1, 2);
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long[] lArray = new long[vector2.size()];
        int n4 = 0;
        while (n4 < vector2.size()) {
            DateValuePair dateValuePair2 = (DateValuePair)vector2.elementAt(n4);
            if (n4 == 0) {
                l4 = dateValuePair2.value;
                l5 = dateValuePair2.value;
            } else {
                if (dateValuePair2.value > l5) {
                    l5 = dateValuePair2.value;
                }
                if (dateValuePair2.value < l4) {
                    l4 = dateValuePair2.value;
                }
            }
            lArray[n4] = dateValuePair2.value;
            l3 += dateValuePair2.value;
            dataSet2.xvalues[n4] = new Long(dateValuePair2.date);
            dataSet2.yvalues[n4] = new Long(dateValuePair2.value);
            dataSet.xvalues[0] = new Long(0L);
            dataSet.yvalues[0] = new Long(dataSet.yvalues[0].longValue() + dateValuePair2.value);
            ++n4;
        }
        Misc.sort(lArray);
        if (lArray.length > 0) {
            n4 = currencyType.getDecimalPlaces();
            dataSet.setDescription(new String[]{string});
            dataSet2.setDescription(new String[]{string, this.moneydanceGUI.getResources().getString("graph_max") + StringUtils.formatCurrency(l5, true, this.dec, this.com, n4), this.moneydanceGUI.getResources().getString("graph_min") + StringUtils.formatCurrency(l4, true, this.dec, this.com, n4), this.moneydanceGUI.getResources().getString("graph_avg") + StringUtils.formatCurrency(Math.round((double)l3 / (double)lArray.length), true, this.dec, this.com, n4), this.moneydanceGUI.getResources().getString("graph_med") + StringUtils.formatCurrency(lArray[lArray.length / 2], true, this.dec, this.com, n4)});
        } else {
            dataSet.setDescription(new String[]{string});
            dataSet2.setDescription(new String[]{string});
        }
        return new DataSetGroup(dataSet2, dataSet);
    }

    private final DataSetGroup balance2DataSet(Vector vector, Account account, boolean bl) {
        CurrencyType currencyType = account.getRootAccount().getCurrencyTable().getCurrencyType(account.getCurrencyType());
        DataSet.setCurrencyNumDecimalPlaces(currencyType.getDecimalPlaces());
        DataSet.setDecimalChar(this.dec);
        DataSet.setCommaChar(this.com);
        String string = account.getFullAccountName();
        DataSet dataSet = new DataSet(string, vector.size(), 1, 2);
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long[] lArray = new long[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            long l4;
            DateBalance dateBalance = (DateBalance)vector.elementAt(n);
            long l5 = l4 = bl ? dateBalance.balance * -1L : dateBalance.balance;
            if (n == 0) {
                l2 = l4;
                l3 = l4;
            } else {
                if (l4 > l3) {
                    l3 = l4;
                }
                if (l4 < l2) {
                    l2 = l4;
                }
            }
            lArray[n] = l4;
            l += l4;
            dataSet.xvalues[n] = new Long(dateBalance.date);
            dataSet.yvalues[n] = new Long(l4);
            ++n;
        }
        Misc.sort(lArray);
        if (lArray.length > 0) {
            n = currencyType.getDecimalPlaces();
            dataSet.setDescription(new String[]{string, this.moneydanceGUI.getResources().getString("graph_max") + StringUtils.formatCurrency(l3, true, this.dec, this.com, n), this.moneydanceGUI.getResources().getString("graph_min") + StringUtils.formatCurrency(l2, true, this.dec, this.com, n), this.moneydanceGUI.getResources().getString("graph_avg") + StringUtils.formatCurrency(Math.round((double)l / (double)lArray.length), true, this.dec, this.com, n), this.moneydanceGUI.getResources().getString("graph_med") + StringUtils.formatCurrency(lArray[lArray.length / 2], true, this.dec, this.com, n)});
        } else {
            dataSet.setDescription(new String[]{string});
        }
        return new DataSetGroup(dataSet, null);
    }

    private final DataSetGroup[] rebuildTopExpenseGraph() {
        Object object;
        Object object2;
        Object object3;
        Vector vector = new Vector();
        Account account = this.accountChoice.getSelectedAccount();
        if (account == null) {
            return null;
        }
        int n = account.getAccountNum();
        int n2 = (Integer)((TopAccountsSettingsPanel)this.settingsPanels[0]).topNumChoice.getSelectedItem();
        long l = this.startDateField.getDate().getTime();
        long l2 = this.endDateField.getDate().getTime();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Object object4 = this.rootAccount.getTransactionSet().getAllTransactions();
        while (object4.hasMoreElements()) {
            long l3;
            Transaction transaction = (Transaction)object4.nextElement();
            if (!account.containsTransaction(transaction, false, true) || (l3 = transaction.getDate()) < l || l3 > l2) continue;
            if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : GraphTool.class$("com.seanreilly.apps.moneydance.model.BankTransaction")) && ((BankTransaction)transaction).getSplitCount() > 0) {
                object3 = (BankTransaction)transaction;
                int n3 = 0;
                while (n3 < ((BankTransaction)object3).getSplitCount()) {
                    object2 = ((BankTransaction)object3).getSplit(n3);
                    object = new Integer(((Transaction)object2).getSourceAccountId());
                    AccountData accountData = (AccountData)hashtable.get(object);
                    if (accountData == null) {
                        accountData = new AccountData();
                        accountData.accountID = ((Transaction)object2).getSourceAccountId();
                        accountData.total = ((Transaction)object2).getAmount();
                        accountData.transactions.addElement(object2);
                        hashtable.put(object, accountData);
                    } else {
                        accountData.total += ((Transaction)object2).getAmount();
                        accountData.transactions.addElement(object2);
                    }
                    ++n3;
                }
                continue;
            }
            object = new Integer(transaction.getAccountId(n));
            object3 = (AccountData)hashtable.get(object);
            if (object3 == null) {
                object3 = new AccountData();
                ((AccountData)object3).accountID = transaction.getAccountId(n);
                ((AccountData)object3).total = transaction.getAmount(n);
                ((AccountData)object3).transactions.addElement(transaction);
                hashtable.put(object, object3);
                continue;
            }
            ((AccountData)object3).total += transaction.getAmount(n);
            ((AccountData)object3).transactions.addElement(transaction);
        }
        object4 = new Vector();
        int n4 = 0;
        while (n4 < n2) {
            if (hashtable.size() <= 0) break;
            boolean bl = true;
            long l4 = 0L;
            object3 = null;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (AccountData)enumeration.nextElement();
                if (bl) {
                    l4 = ((AccountData)object2).total;
                    object3 = object2;
                    bl = false;
                    continue;
                }
                if (((AccountData)object2).total >= l4) continue;
                object3 = object2;
                l4 = ((AccountData)object2).total;
            }
            if (((AccountData)object3).total >= 0L) break;
            ((Vector)object4).addElement(object3);
            hashtable.remove(new Integer(((AccountData)object3).accountID));
            ++n4;
        }
        DataSetGroup[] dataSetGroupArray = new DataSetGroup[((Vector)object4).size()];
        int n5 = 0;
        while (n5 < ((Vector)object4).size()) {
            AccountData accountData = (AccountData)((Vector)object4).elementAt(n5);
            object = this.rootAccount.getAccountById(accountData.accountID);
            dataSetGroupArray[n5] = this.txn2DataSet(accountData.transactions, account, (Account)object, true);
            ++n5;
        }
        return dataSetGroupArray;
    }

    private final DataSetGroup[] rebuildTopIncomeGraph() {
        Object object;
        Object object2;
        Object object3;
        Vector vector = new Vector();
        Account account = this.accountChoice.getSelectedAccount();
        if (account == null) {
            return null;
        }
        int n = account.getAccountNum();
        int n2 = (Integer)((TopIncomesSettingsPanel)this.settingsPanels[1]).topNumChoice.getSelectedItem();
        long l = this.startDateField.getDate().getTime();
        long l2 = this.endDateField.getDate().getTime();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Object object4 = this.rootAccount.getTransactionSet().getAllTransactions();
        while (object4.hasMoreElements()) {
            long l3;
            Transaction transaction = (Transaction)object4.nextElement();
            if (!account.containsTransaction(transaction, false, true) || (l3 = transaction.getDate()) < l || l3 > l2) continue;
            if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : GraphTool.class$("com.seanreilly.apps.moneydance.model.BankTransaction")) && ((BankTransaction)transaction).getSplitCount() > 0) {
                object3 = (BankTransaction)transaction;
                int n3 = 0;
                while (n3 < ((BankTransaction)object3).getSplitCount()) {
                    object2 = ((BankTransaction)object3).getSplit(n3);
                    object = new Integer(((Transaction)object2).getSourceAccountId());
                    AccountData accountData = (AccountData)hashtable.get(object);
                    if (accountData == null) {
                        accountData = new AccountData();
                        accountData.accountID = ((Transaction)object2).getSourceAccountId();
                        accountData.total = ((Transaction)object2).getAmount();
                        accountData.transactions.addElement(object2);
                        hashtable.put(object, accountData);
                    } else {
                        accountData.total += ((Transaction)object2).getAmount();
                        accountData.transactions.addElement(object2);
                    }
                    ++n3;
                }
                continue;
            }
            object = new Integer(transaction.getAccountId(n));
            object3 = (AccountData)hashtable.get(object);
            if (object3 == null) {
                object3 = new AccountData();
                ((AccountData)object3).accountID = transaction.getAccountId(n);
                ((AccountData)object3).total = transaction.getAmount(n);
                ((AccountData)object3).transactions.addElement(transaction);
                hashtable.put(object, object3);
                continue;
            }
            ((AccountData)object3).total += transaction.getAmount(n);
            ((AccountData)object3).transactions.addElement(transaction);
        }
        object4 = new Vector();
        int n4 = 0;
        while (n4 < n2) {
            if (hashtable.size() <= 0) break;
            boolean bl = true;
            long l4 = 0L;
            object3 = null;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (AccountData)enumeration.nextElement();
                if (bl) {
                    l4 = ((AccountData)object2).total;
                    object3 = object2;
                    bl = false;
                    continue;
                }
                if (((AccountData)object2).total <= l4) continue;
                object3 = object2;
                l4 = ((AccountData)object2).total;
            }
            if (((AccountData)object3).total <= 0L) break;
            ((Vector)object4).addElement(object3);
            hashtable.remove(new Integer(((AccountData)object3).accountID));
            ++n4;
        }
        DataSetGroup[] dataSetGroupArray = new DataSetGroup[((Vector)object4).size()];
        int n5 = 0;
        while (n5 < ((Vector)object4).size()) {
            AccountData accountData = (AccountData)((Vector)object4).elementAt(n5);
            object = this.rootAccount.getAccountById(accountData.accountID);
            dataSetGroupArray[n5] = this.txn2DataSet(accountData.transactions, account, (Account)object, false);
            ++n5;
        }
        return dataSetGroupArray;
    }

    private final DataSetGroup[] rebuildIncomeExpenseGraph() {
        Object object;
        Account account = this.accountChoice.getSelectedAccount();
        if (account == null) {
            return null;
        }
        int n = account.getAccountNum();
        long l = this.startDateField.getDate().getTime();
        long l2 = this.endDateField.getDate().getTime();
        Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
        DataSetGroup[] dataSetGroupArray = this.rootAccount.getTransactionSet().getAllTransactions();
        while (dataSetGroupArray.hasMoreElements()) {
            Integer n2;
            Object object2;
            long l3;
            object = (Transaction)dataSetGroupArray.nextElement();
            if (!account.containsTransaction((Transaction)object, false, true) || (l3 = ((Transaction)object).getDate()) < l || l3 > l2) continue;
            if (object.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : GraphTool.class$("com.seanreilly.apps.moneydance.model.BankTransaction")) && ((BankTransaction)object).getSplitCount() > 0) {
                object2 = (BankTransaction)object;
                int n3 = 0;
                while (n3 < ((BankTransaction)object2).getSplitCount()) {
                    SplitTransaction splitTransaction = ((BankTransaction)object2).getSplit(n3);
                    n2 = new Integer(splitTransaction.getAmount() > 0L ? -1 : -2);
                    AccountData accountData = (AccountData)hashtable.get(n2);
                    if (accountData == null) {
                        accountData = new AccountData();
                        accountData.accountID = n2;
                        accountData.total = splitTransaction.getAmount();
                        accountData.transactions.addElement(splitTransaction);
                        hashtable.put(n2, accountData);
                    } else {
                        accountData.total += splitTransaction.getAmount();
                        accountData.transactions.addElement(splitTransaction);
                    }
                    ++n3;
                }
                continue;
            }
            n2 = new Integer(((Transaction)object).getAmount(n) > 0L ? -1 : -2);
            object2 = (AccountData)hashtable.get(n2);
            if (object2 == null) {
                object2 = new AccountData();
                ((AccountData)object2).accountID = n2;
                ((AccountData)object2).total = ((Transaction)object).getAmount(n);
                ((AccountData)object2).transactions.addElement(object);
                hashtable.put(n2, object2);
                continue;
            }
            ((AccountData)object2).total += ((Transaction)object).getAmount(n);
            ((AccountData)object2).transactions.addElement(object);
        }
        dataSetGroupArray = new DataSetGroup[2];
        object = (AccountData)hashtable.get(new Integer(-1));
        if (object == null) {
            object = new AccountData();
            ((AccountData)object).accountID = -1;
            ((AccountData)object).total = 0L;
        }
        dataSetGroupArray[0] = this.txn2DataSet(((AccountData)object).transactions, account, null, false);
        System.err.println("calculated data: " + dataSetGroupArray[0].lineDataSet);
        AccountData accountData = (AccountData)hashtable.get(new Integer(-2));
        if (accountData == null) {
            accountData = new AccountData();
            accountData.accountID = -2;
            accountData.total = 0L;
        }
        dataSetGroupArray[1] = this.txn2DataSet(accountData.transactions, account, null, true);
        System.err.println("calculated data: " + dataSetGroupArray[1].lineDataSet);
        return dataSetGroupArray;
    }

    private final DataSetGroup[] rebuildAccountBalanceGraph() {
        Account account = this.accountChoice.getSelectedAccount();
        if (account == null) {
            return null;
        }
        int n = account.getAccountNum();
        long l = this.startDateField.getDate().getTime();
        long l2 = this.endDateField.getDate().getTime();
        Vector<Transaction> vector = new Vector<Transaction>();
        Enumeration enumeration = this.rootAccount.getTransactionSet().getAllTransactions();
        while (enumeration.hasMoreElements()) {
            Transaction transaction = (Transaction)enumeration.nextElement();
            if (!account.containsTransaction(transaction, false, true)) continue;
            vector.addElement(transaction);
        }
        AccountUtil.sortTransactions(vector, 7, n, this.rootAccount);
        long l3 = account.getStartBalance();
        long l4 = 0L;
        boolean bl = true;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        Date date = new Date();
        gregorianCalendar.setTime(new Date(0L));
        Vector<DateBalance> vector2 = new Vector<DateBalance>();
        int n2 = 0;
        while (n2 < vector.size()) {
            Transaction transaction = (Transaction)vector.elementAt(n2);
            l3 += transaction.getAmount(n);
            long l5 = transaction.getDate();
            if (l5 >= l && l5 <= l2) {
                date.setTime(l5);
                gregorianCalendar2.setTime(date);
                if (!(gregorianCalendar2.get(5) == gregorianCalendar.get(5) && gregorianCalendar2.get(2) == gregorianCalendar.get(2) && gregorianCalendar2.get(1) == gregorianCalendar.get(1) || bl)) {
                    GraphTool graphTool = this;
                    if (graphTool == null) {
                        throw null;
                    }
                    vector2.addElement(graphTool.new DateBalance(gregorianCalendar.getTime().getTime(), l4));
                }
                gregorianCalendar.setTime(date);
                l4 = l3;
                bl = false;
            }
            ++n2;
        }
        if (!bl && vector2.size() > 0) {
            GraphTool graphTool = this;
            if (graphTool == null) {
                throw null;
            }
            vector2.addElement(graphTool.new DateBalance(gregorianCalendar.getTime().getTime(), l4));
        }
        return new DataSetGroup[]{this.balance2DataSet(vector2, account, account.getAccountType() == 5)};
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent != null && itemEvent.getSource() == this.graphTypeChoice) {
            this.setSettingsType();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.doneButton) {
            this.finishUp();
        } else if (actionEvent.getSource() == this.saveButton) {
            GraphTool graphTool = this;
            if (graphTool == null) {
                throw null;
            }
            SwingUtilities.invokeLater(new Runnable(graphTool){
                private final /* synthetic */ GraphTool this$0;

                public final void run() {
                    this.this$0.access$1();
                }
                {
                    this.this$0 = graphTool;
                    this.constructor$0(graphTool);
                }

                public void constructor$0(GraphTool graphTool) {
                }
            });
        } else if (actionEvent.getSource() == this.printButton) {
            GraphTool graphTool = this;
            if (graphTool == null) {
                throw null;
            }
            SwingUtilities.invokeLater(new Runnable(graphTool){
                private final /* synthetic */ GraphTool this$0;

                public final void run() {
                    this.this$0.access$2();
                }
                {
                    this.this$0 = graphTool;
                    this.constructor$0(graphTool);
                }

                public void constructor$0(GraphTool graphTool) {
                }
            });
        } else if (actionEvent.getSource() == this.updateButton) {
            this.rebuildGraph();
        }
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 201) {
            this.finishUp();
        }
        super.processEvent(aWTEvent);
    }

    public void dispose() {
        this.saveSettings();
        super.dispose();
        this.accountChoice.goneAway();
    }

    /* synthetic */ void access$0() {
        this.rebuildGraph();
    }

    /* synthetic */ void access$1() {
        this.saveGraph();
    }

    /* synthetic */ void access$2() {
        this.printGraph();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GraphTool(MoneydanceGUI moneydanceGUI, Account account, AccountPanel accountPanel) {
        super(moneydanceGUI.getResources().getString("graph_win_title") + ": " + account.getAccountName());
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = account.getRootAccount();
        this.parentPanel = accountPanel;
        this.prefs = Main.getMainController().getPreferences();
        try {
            ((Frame)this).setIconImage(AwtUtil.loadImage("/com/seanreilly/apps/moneydance/images/dollar.gif"));
        }
        catch (Exception exception) {
            System.err.println("exception: " + exception);
            exception.printStackTrace(System.err);
        }
        this.dec = this.prefs.getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.accountChoice = new AccountPopup(this.moneydanceGUI, this.rootAccount);
        this.accountChoice.setShowAccountsOfType(0, false);
        this.graphTypeChoice = new JComboBox();
        this.graphTypeChoice.addItem(this.moneydanceGUI.getResources().getString("graph_top_expenses"));
        this.graphTypeChoice.addItem(this.moneydanceGUI.getResources().getString("graph_top_incomes"));
        this.graphTypeChoice.addItem(this.moneydanceGUI.getResources().getString("graph_income_expenses"));
        this.graphTypeChoice.addItem(this.moneydanceGUI.getResources().getString("graph_account_balance"));
        this.groupByChoice = new JComboBox();
        this.groupByChoice.addItem(this.moneydanceGUI.getResources().getString("graph_groupby_day"));
        this.groupByChoice.addItem(this.moneydanceGUI.getResources().getString("graph_groupby_week"));
        this.groupByChoice.addItem(this.moneydanceGUI.getResources().getString("graph_groupby_month"));
        this.groupByChoice.addItem(this.moneydanceGUI.getResources().getString("graph_groupby_year"));
        this.settingsPanels = new JPanel[5];
        this.settingsPanels[0] = new TopAccountsSettingsPanel(moneydanceGUI);
        this.settingsPanels[1] = new TopIncomesSettingsPanel(moneydanceGUI);
        this.settingsPanels[2] = new JPanel();
        this.settingsPanels[3] = new JPanel();
        this.settingsPanels[4] = new JPanel();
        this.use3dGraphs = new JCheckBox(this.moneydanceGUI.getResources().getString("graph_dimension_3") + " ");
        this.detailedKeyCheckbox = new JCheckBox(this.moneydanceGUI.getResources().getString("graph_detailed_key") + " ");
        this.startDateField = new JDateField(Main.getMainController().getPreferences().getShortDateFormatter());
        this.endDateField = new JDateField(Main.getMainController().getPreferences().getShortDateFormatter());
        this.barGraph = new BarGraphPanel();
        this.lineGraph = new LineGraphPanel();
        this.pieGraph = new PieGraphPanel();
        this.key = new KeyPanel();
        DataSet.dateFormat = this.prefs.getShortDateFormatter();
        this.doneButton = new JButton(moneydanceGUI.getResources().getString("graph_done"));
        this.saveButton = new JButton(moneydanceGUI.getResources().getString("graph_save"));
        this.printButton = new JButton(moneydanceGUI.getResources().getString("graph_print"));
        this.updateButton = new JButton(moneydanceGUI.getResources().getString("graph_update"));
        this.lineOrPieChoice = new JComboBox<String>(new String[]{moneydanceGUI.getResources().getString("graph_line"), moneydanceGUI.getResources().getString("graph_bar")});
        this.settingsPanel = new JPanel(gridBagLayout);
        this.settingsPanel.setBorder(new EtchedBorder());
        JPanel jPanel = new JPanel(gridBagLayout);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.graphPanel = new JPanel(new GridBagLayout());
        this.graphPanel.setBackground(Color.white);
        this.bottomGraphPanel = new JPanel(new GridLayout(1, 1));
        this.topGraphPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add(jPanel2);
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.graphPanel, "Center");
        jPanel2.add((Component)jPanel3, "South");
        jPanel3.add((Component)this.saveButton, AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, false, false));
        jPanel3.add((Component)this.printButton, AwtUtil.getConstraints(1, 0, 0.0f, 0.0f, 1, 1, false, false));
        jPanel3.add((Component)new JLabel(" "), AwtUtil.getConstraints(2, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel3.add((Component)this.doneButton, AwtUtil.getConstraints(3, 0, 0.0f, 0.0f, 1, 1, false, false));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("graph_type") + ": ", 4), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)this.graphTypeChoice, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("graph_account") + ": ", 4), AwtUtil.getConstraints(2, 0, 0.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)this.accountChoice, AwtUtil.getConstraints(3, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel.add((Component)this.settingsPanel, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 4, 1, true, false));
        this.bottomGraphPanel.add(this.lineGraph);
        this.use3dGraphs.setHorizontalTextPosition(0);
        this.use3dGraphs.setVerticalTextPosition(3);
        this.detailedKeyCheckbox.setHorizontalTextPosition(0);
        this.detailedKeyCheckbox.setVerticalTextPosition(3);
        this.graphPanel.add((Component)this.topGraphPanel, AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 1, true, true));
        this.graphPanel.add((Component)this.bottomGraphPanel, AwtUtil.getConstraints(0, 1, 1.0f, 1.0f, 1, 1, true, true));
        this.topGraphPanel.add((Component)this.pieGraph, AwtUtil.getConstraints(0, 0, 0.0f, 1.0f, 1, 1, true, true));
        this.topGraphPanel.add((Component)this.key, AwtUtil.getConstraints(1, 0, 2.0f, 1.0f, 1, 1, true, true));
        int n = 0;
        int n2 = 0;
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        this.settingsPanel.add((Component)jPanel4, AwtUtil.getConstraints(n++, n2, 0.0f, 0.0f, 1, 3, true, false));
        jPanel4.add((Component)this.use3dGraphs, AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 1, false, true, 10));
        jPanel4.add((Component)this.detailedKeyCheckbox, AwtUtil.getConstraints(0, 1, 1.0f, 1.0f, 1, 1, false, true, 10));
        this.settingsPanel.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("graph_begindate") + ": ", 4), AwtUtil.getConstraints(n++, n2, 0.0f, 0.0f, 1, 1, true, true));
        this.settingsPanel.add((Component)this.startDateField, AwtUtil.getConstraints(n--, n2++, 1.0f, 0.0f, 1, 1, true, false));
        this.settingsPanel.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("graph_enddate") + ": ", 4), AwtUtil.getConstraints(n++, n2, 0.0f, 0.0f, 1, 1, true, true));
        this.settingsPanel.add((Component)this.endDateField, AwtUtil.getConstraints(n++, n2++, 1.0f, 0.0f, 1, 1, true, false));
        n2 = 0;
        this.settingsPanel.add((Component)this.lineOrPieChoice, AwtUtil.getConstraints(n, n2++, 1.0f, 0.0f, 1, 1, true, true));
        this.settingsPanel.add((Component)this.groupByChoice, AwtUtil.getConstraints(n, n2++, 1.0f, 0.0f, 1, 1, true, false));
        n2 = 2;
        int n3 = 0;
        while (n3 < this.settingsPanels.length) {
            gridBagLayout.setConstraints(this.settingsPanels[n3], AwtUtil.getConstraints(1, n2, 1.0f, 0.0f, 3, 1, false, true));
            ++n3;
        }
        this.settingsPanel.add((Component)this.updateButton, AwtUtil.getConstraints(0, ++n2, 1.0f, 0.0f, 4, 1, true, true));
        this.saveButton.addActionListener(this);
        this.printButton.addActionListener(this);
        this.doneButton.addActionListener(this);
        this.updateButton.addActionListener(this);
        this.graphTypeChoice.addItemListener(this);
        this.restoreStickySettings(account);
        ((Component)this).setSize(650, 600);
        this.setSettingsType();
        GraphTool graphTool = this;
        if (graphTool == null) {
            throw null;
        }
        SwingUtilities.invokeLater(new Runnable(graphTool){
            private final /* synthetic */ GraphTool this$0;

            public final void run() {
                this.this$0.access$0();
            }
            {
                this.this$0 = graphTool;
                this.constructor$0(graphTool);
            }

            public void constructor$0(GraphTool graphTool) {
            }
        });
    }

    class DateValuePair {
        long date;
        long value;

        DateValuePair(long l, long l2) {
            this.date = l;
            this.value = l2;
        }
    }

    class DateBalance {
        long date;
        long balance;

        DateBalance(long l, long l2) {
            this.date = l;
            this.balance = l2;
        }
    }
}

