/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.TransactionReminder;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.ReminderTxnEditPanel;
import com.seanreilly.awt.AwtUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TxnReminderNotificationWindow
extends JDialog
implements ActionListener {
    private TransactionReminder reminder;
    private RootAccount rootAccount;
    private MoneydanceGUI moneydanceGUI;
    private boolean recordable = false;
    private Date eventDate;
    private JButton recordButton;
    private JButton ignoreButton;
    private JButton deferButton;
    private ReminderTxnEditPanel txnPanel;
    private JPanel detailPanel;

    private final void recordReminder() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(10, 12);
        calendar.set(12, 0);
        BankTransaction bankTransaction = new BankTransaction(-1L, -1, -1, 1.0, "", 0L, calendar.getTime().getTime(), new Date().getTime(), calendar.getTime().getTime(), ' ', ' ', "", null, "");
        if (!this.txnPanel.saveTransaction(bankTransaction)) {
            return;
        }
        Account account = this.rootAccount.getAccountById(bankTransaction.getDestAccountId());
        Account account2 = this.rootAccount.getAccountById(bankTransaction.getSourceAccountId());
        if (account == null) {
            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("r_txn_err1"));
            return;
        }
        CurrencyType currencyType = this.rootAccount.getCurrencyTable().getCurrencyType(account.getCurrencyType());
        if (bankTransaction.getSplitCount() > 0) {
            int n = 0;
            while (n < bankTransaction.getSplitCount()) {
                SplitTransaction splitTransaction = bankTransaction.getSplit(n);
                Account account3 = this.rootAccount.getAccountById(splitTransaction.getSourceAccountId());
                if (account3 == null) {
                    this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("r_txn_err2"));
                    return;
                }
                CurrencyType currencyType2 = this.rootAccount.getCurrencyTable().getCurrencyType(account3.getCurrencyType());
                double d = 1.0 / this.rootAccount.getCurrencyTable().getRawRate(currencyType, currencyType2);
                splitTransaction.setRate(d);
                ++n;
            }
        } else {
            if (account2 == null) {
                this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("r_txn_err3"));
                return;
            }
            CurrencyType currencyType3 = this.rootAccount.getCurrencyTable().getCurrencyType(account2.getCurrencyType());
            double d = 1.0 / this.rootAccount.getCurrencyTable().getRawRate(currencyType, currencyType3);
            bankTransaction.setRate(d);
        }
        this.rootAccount.getTransactionSet().addTransaction(bankTransaction);
        this.reminder.setAcknowledged(this.eventDate);
        this.rootAccount.getReminderSet().reminderModified(this.reminder);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private final void ignoreReminder() {
        if (!this.recordable) {
            return;
        }
        this.reminder.setAcknowledged(this.eventDate);
        this.rootAccount.getReminderSet().reminderModified(this.reminder);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.deferButton) {
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.recordButton && this.recordable) {
            this.recordReminder();
        } else if (actionEvent.getSource() == this.ignoreButton && this.recordable) {
            this.ignoreReminder();
        }
    }

    public void dispose() {
        super.dispose();
        this.txnPanel.goneAway();
    }

    public TxnReminderNotificationWindow(MoneydanceGUI moneydanceGUI, RootAccount rootAccount, TransactionReminder transactionReminder, Date date, boolean bl) {
        super(moneydanceGUI.getTopLevelFrame(), moneydanceGUI.getResources().getString("r_not_win"), true);
        this.reminder = transactionReminder;
        this.rootAccount = rootAccount;
        this.moneydanceGUI = moneydanceGUI;
        this.recordable = bl;
        this.eventDate = date;
        this.setDefaultCloseOperation(0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.txnPanel = new ReminderTxnEditPanel(moneydanceGUI, rootAccount, true);
        this.recordButton = new JButton(moneydanceGUI.getResources().getString("r_t_ack"));
        this.ignoreButton = new JButton(moneydanceGUI.getResources().getString("r_t_ign"));
        this.deferButton = new JButton(moneydanceGUI.getResources().getString("r_t_defer"));
        if (!bl) {
            this.recordButton.setEnabled(false);
            this.ignoreButton.setEnabled(false);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.txnPanel.populateFields(transactionReminder.getTransaction());
        jPanel.add((Component)this.txnPanel, AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)jPanel2, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.recordButton, AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.ignoreButton, AwtUtil.getConstraints(1, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)new JLabel(" "), AwtUtil.getConstraints(2, 0, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.deferButton, AwtUtil.getConstraints(3, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.deferButton.addActionListener(this);
        this.ignoreButton.addActionListener(this);
        this.recordButton.addActionListener(this);
        JFrame jFrame = moneydanceGUI.getTopLevelFrame();
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension.width + 20, dimension.height + 20);
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = jFrame.getSize();
        Point point = jFrame.getLocation();
        ((Component)this).setLocation(point.x + dimension3.width / 2 - dimension2.width / 2, point.y + dimension3.height / 2 - dimension2.height / 2);
    }
}

