/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.view.gui.CurrencyModel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JCurrencyField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TranslateCurrencyWindow
extends JDialog
implements ActionListener,
KeyListener,
ItemListener {
    private JComboBox fromCurrencyChoice;
    private JCurrencyField fromCurrencyField;
    private CurrencyModel fromCurrencyModel;
    private JComboBox destCurrencyChoice;
    private JCurrencyField destCurrencyField;
    private CurrencyModel destCurrencyModel;
    private JButton okButton;
    private MoneydanceGUI moneydanceGUI;
    private CurrencyTable currencyTable;

    private final void computeValue() {
        CurrencyType currencyType;
        CurrencyType currencyType2 = (CurrencyType)this.destCurrencyChoice.getSelectedItem();
        if (currencyType2 != this.destCurrencyField.getCurrencyType()) {
            this.destCurrencyField.setCurrencyType(currencyType2);
        }
        if ((currencyType = (CurrencyType)this.fromCurrencyChoice.getSelectedItem()) != this.fromCurrencyField.getCurrencyType()) {
            this.fromCurrencyField.setCurrencyType(currencyType);
        }
        long l = this.fromCurrencyField.getValue();
        this.destCurrencyField.setValue(this.currencyTable.convertValue(l, currencyType, currencyType2));
    }

    private final void okButtonPressed() {
        ((Component)this).setVisible(false);
        this.dispose();
        this.fromCurrencyModel.goneAway();
        this.destCurrencyModel.goneAway();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.computeValue();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.computeValue();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.okButtonPressed();
        }
    }

    public TranslateCurrencyWindow(JFrame jFrame, CurrencyTable currencyTable, MoneydanceGUI moneydanceGUI) {
        super(jFrame, moneydanceGUI.getResources().getString("translate_currency_win_title"), true);
        this.currencyTable = currencyTable;
        this.moneydanceGUI = moneydanceGUI;
        UserPreferences userPreferences = Main.getMainController().getPreferences();
        char c = userPreferences.getDecimalChar();
        char c2 = c == ',' ? (char)'.' : ',';
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add(jPanel);
        this.fromCurrencyModel = new CurrencyModel(currencyTable);
        this.fromCurrencyChoice = new JComboBox(this.fromCurrencyModel);
        this.fromCurrencyChoice.setSelectedItem(currencyTable.getBaseType());
        this.fromCurrencyField = new JCurrencyField((CurrencyType)this.fromCurrencyChoice.getSelectedItem(), currencyTable, c, c2);
        this.destCurrencyModel = new CurrencyModel(currencyTable);
        this.destCurrencyChoice = new JComboBox(this.destCurrencyModel);
        this.destCurrencyChoice.setSelectedItem(currencyTable.getBaseType());
        this.destCurrencyField = new JCurrencyField((CurrencyType)this.fromCurrencyChoice.getSelectedItem(), currencyTable, c, c2);
        this.destCurrencyField.setEditable(false);
        this.okButton = new JButton(this.moneydanceGUI.getResources().getString("ok"));
        jPanel.add((Component)this.fromCurrencyField, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.fromCurrencyChoice, AwtUtil.getConstraints(0, 2, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(" = "), AwtUtil.getConstraints(1, 1, 0.0f, 0.0f, 1, 2, true, true));
        jPanel.add((Component)this.destCurrencyField, AwtUtil.getConstraints(2, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.destCurrencyChoice, AwtUtil.getConstraints(2, 2, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(""), AwtUtil.getConstraints(0, 3, 0.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.okButton, AwtUtil.getConstraints(0, 5, 1.0f, 0.0f, 10, 1, false, false));
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension.width + 20, dimension.height + 200);
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = this.getToolkit().getScreenSize();
        ((Component)this).setLocation(dimension3.width / 2 - dimension2.width / 2, dimension3.height / 2 - dimension2.height / 2);
        this.fromCurrencyField.addKeyListener(this);
        this.fromCurrencyChoice.addItemListener(this);
        this.destCurrencyChoice.addItemListener(this);
        this.okButton.addActionListener(this);
    }
}

