/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.TransactionSortListener;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class TransactionRenderer
extends Component
implements ListCellRenderer {
    private static final int rowHeight = 18;
    private static final int secondRowIdx = 8;
    private static FontMetrics fm = null;
    private static Image clearedIcon = null;
    private static Image reconcilingIcon = null;
    private static final byte ALIGN_RIGHT = 0;
    private static final byte ALIGN_LEFT = 1;
    private static final byte ALIGN_CENTER = 2;
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$BankTransaction;
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction;
    private Transaction transaction = null;
    private int index = 0;
    private boolean isSelected = false;
    private boolean hasFocus = false;
    private int x = 0;
    private int y = 0;
    private int w = 0;
    private int h = 0;
    private Account account;
    private CurrencyType currencyType;
    private int accountNum;
    private RootAccount rootAccount;
    private CurrencyTable currencyTable;
    private MoneydanceGUI moneydanceGUI;
    private TransactionSortListener sortListener = null;
    private DateFormat shortDateFormat;
    private int numDecimals;
    private int centMult;
    private long highlightTxnID = -1L;
    private String splitLabel;
    private boolean isReconciler = false;
    private boolean showFullAcctPath = false;
    private char dec;
    private char com;
    private Color color1 = Color.white;
    private Color color2 = Color.cyan;
    private HeaderComponent headerRenderer = null;
    private String[] columnNames;
    private boolean twoLines = false;
    private UserPreferences prefs;
    private String colPrefID;
    private Rectangle[] colHeaders;
    private int sortColumn = -1;

    void setLabels() {
        this.shortDateFormat = Main.getMainController().getPreferences().getShortDateFormatter();
        this.splitLabel = this.moneydanceGUI.getResources().getString("split_label");
        this.columnNames = this.isReconciler ? new String[]{this.moneydanceGUI.getResources().getString("table_column_date"), this.moneydanceGUI.getResources().getString("table_column_checknum"), this.moneydanceGUI.getResources().getString("table_column_description"), this.moneydanceGUI.getResources().getString("table_column_clearedchar"), this.moneydanceGUI.getResources().getString("table_column_amount")} : new String[]{this.moneydanceGUI.getResources().getString("table_column_date"), this.moneydanceGUI.getResources().getString("table_column_checknum"), this.moneydanceGUI.getResources().getString("table_column_description"), this.moneydanceGUI.getResources().getString("table_column_account"), this.moneydanceGUI.getResources().getString("table_column_clearedchar"), this.moneydanceGUI.getResources().getString("table_column_debit"), this.moneydanceGUI.getResources().getString("table_column_credit"), this.moneydanceGUI.getResources().getString("table_column_balance"), this.moneydanceGUI.getResources().getString("table_column_balance"), this.moneydanceGUI.getResources().getString("table_column_memo"), this.moneydanceGUI.getResources().getString("table_column_taxdate"), this.moneydanceGUI.getResources().getString("table_column_rate")};
    }

    public void setColor1(Color color) {
        this.color1 = color;
    }

    public void setColor2(Color color) {
        this.color2 = color;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restoreColWidths(Graphics graphics, int n) {
        if (fm == null) {
            fm = graphics.getFontMetrics();
        }
        if (n <= 0) {
            this.setDefaultFieldWidths(graphics, n);
            return;
        }
        String string = this.prefs.getSetting(this.colPrefID);
        if (string == null || StringUtils.fieldIndex(string, ',', 7).length() <= 0) {
            this.setDefaultFieldWidths(graphics, n);
            return;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < 8) {
            String string2 = StringUtils.fieldIndex(string, ',', n3);
            int n4 = 5;
            try {
                n4 = Math.max((int)(new Double(string2) * (double)n), 5);
            }
            catch (Exception exception) {
            }
            this.colHeaders[n3].width = n4;
            this.colHeaders[n3].x = n2;
            this.colHeaders[n3 + 8].width = n4;
            this.colHeaders[n3 + 8].x = n2;
            n2 += n4;
            ++n3;
        }
    }

    public void saveColWidths() {
        if (this.colHeaders == null || this.w <= 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 8) {
            stringBuffer.append(StringUtils.formatRate((double)this.colHeaders[n].width / (double)this.w, '.'));
            stringBuffer.append(',');
            ++n;
        }
        this.prefs.setSetting(this.colPrefID, stringBuffer.toString());
    }

    public void setShowFullAccountPath(boolean bl) {
        this.showFullAcctPath = bl;
    }

    public Dimension getPreferredSize() {
        if (this.twoLines) {
            return new Dimension(50, 36);
        }
        return new Dimension(50, 18);
    }

    public void setDisplayTwoLines(boolean bl) {
        this.twoLines = bl;
    }

    public void setHighlightTransaction(Transaction transaction) {
        this.highlightTxnID = transaction != null ? transaction.getId() : -1L;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.transaction = (Transaction)object;
        this.index = n;
        this.isSelected = bl || this.highlightTxnID == ((Transaction)object).getId();
        this.hasFocus = bl2;
        return this;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 <= 0) {
            return;
        }
        if (this.colHeaders[2].width < 0 && n3 > 0) {
            this.restoreColWidths(this.getGraphics(), n3);
        } else if (n3 != this.w) {
            this.adjustFieldWidths(this.w, n3);
        }
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
        super.setBounds(n, n2, n3, n4);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (n3 <= 0) {
            return;
        }
        if (this.colHeaders[2].width < 0 && n3 > 0) {
            this.restoreColWidths(this.getGraphics(), n3);
        } else if (n3 != this.w) {
            this.adjustFieldWidths(this.w, n3);
        }
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
        super.reshape(n, n2, n3, n4);
    }

    public void paint(Graphics graphics) {
        if (this.isSelected) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, 0, this.w, this.h);
        } else if (this.twoLines) {
            int n = this.h / 2;
            graphics.setColor(this.color1);
            graphics.fillRect(0, 0, this.w, n);
            graphics.setColor(this.color2);
            graphics.fillRect(0, n, this.w, this.h - n);
        } else {
            if (this.index % 2 == 0) {
                graphics.setColor(this.color1);
            } else {
                graphics.setColor(this.color2);
            }
            graphics.fillRect(0, 0, this.w, this.h);
        }
        if (this.hasFocus && !this.isReconciler) {
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.w, this.h);
        }
        if (this.transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction = TransactionRenderer.class$("com.seanreilly.apps.moneydance.model.BankTransaction"))) && !this.isReconciler) {
            this.paintBankTransaction(graphics, (BankTransaction)this.transaction);
        } else if (this.transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction = TransactionRenderer.class$("com.seanreilly.apps.moneydance.model.BankTransaction")))) {
            this.paintRecBankTransaction(graphics, (BankTransaction)this.transaction);
        } else if (this.transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction : (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction = TransactionRenderer.class$("com.seanreilly.apps.moneydance.model.SplitTransaction"))) && !this.isReconciler) {
            this.paintSplitTransaction(graphics, (SplitTransaction)this.transaction);
        } else if (this.transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction : (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction = TransactionRenderer.class$("com.seanreilly.apps.moneydance.model.SplitTransaction")))) {
            this.paintRecSplitTransaction(graphics, (SplitTransaction)this.transaction);
        } else {
            this.paintDefaultTransaction(graphics, this.transaction);
        }
    }

    private final void setDefaultFieldWidths(Graphics graphics, int n) {
        int n2 = fm.stringWidth(StringUtils.formatCurrency(1000000000L, false, this.dec, this.com, this.numDecimals, this.centMult));
        if (this.isReconciler) {
            this.colHeaders[0].width = fm.stringWidth(this.shortDateFormat.format(new Date()) + "__");
            this.colHeaders[1].width = fm.stringWidth("10000000");
            this.colHeaders[3].width = 18;
            this.colHeaders[4].width = n2;
            int n3 = this.colHeaders[4].width + this.colHeaders[0].width + this.colHeaders[3].width + this.colHeaders[1].width;
            this.colHeaders[2].width = n - n3;
        } else {
            this.colHeaders[0].width = fm.stringWidth(this.shortDateFormat.format(new Date()) + "__");
            this.colHeaders[1].width = fm.stringWidth("10000000");
            this.colHeaders[4].width = 18;
            this.colHeaders[5].width = n2;
            this.colHeaders[6].width = n2;
            this.colHeaders[7].width = n2;
            int n4 = this.colHeaders[4].width + this.colHeaders[0].width + n2 * 3 + this.colHeaders[1].width;
            this.colHeaders[2].width = 2 * (n - n4) / 3;
            this.colHeaders[3].width = (n - n4) / 3;
        }
        this.calculateColumnPositions();
    }

    private final void adjustFieldWidths(int n, int n2) {
        int n3 = this.isReconciler ? 5 : 8;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            this.colHeaders[n5 + 8].width = this.colHeaders[n5].width = (int)Math.round((double)(this.colHeaders[n5].width * n2) / (double)n);
            n4 += this.colHeaders[n5].width;
            ++n5;
        }
        this.colHeaders[2].width += n2 - n4;
        this.calculateColumnPositions();
    }

    private final void calculateColumnPositions() {
        int n = 0;
        while (n < 8) {
            this.colHeaders[n + 8].width = this.colHeaders[n].width;
            if (n == 0) {
                this.colHeaders[n].x = 0;
                this.colHeaders[n + 8].x = 0;
            } else {
                this.colHeaders[n + 8].x = this.colHeaders[n].x = this.colHeaders[n - 1].x + this.colHeaders[n - 1].width;
            }
            ++n;
        }
    }

    private final void paintHeader(Graphics graphics, Dimension dimension) {
        Shape shape;
        int n;
        int n2 = dimension.width;
        int n3 = n = dimension.height;
        if (this.twoLines) {
            n3 = n / 2;
        }
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, n2, n);
        graphics.setColor(Color.white);
        graphics.drawLine(0, 0, n2, 0);
        graphics.drawLine(0, 0, 0, n);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(0, n - 1, n2 - 1, n - 1);
        graphics.drawLine(n2 - 1, 0, n2 - 1, n - 1);
        if (this.sortColumn >= 0) {
            shape = this.colHeaders[this.sortColumn];
            graphics.setColor(Color.darkGray);
            if (this.sortColumn < 8) {
                graphics.drawLine(shape.x, shape.y, shape.x + shape.width, shape.y);
            } else {
                graphics.drawLine(shape.x, shape.y + 1, shape.x + shape.width, shape.y + 1);
            }
            if (this.sortColumn == 0 || this.sortColumn == 8) {
                graphics.drawLine(shape.x, shape.y, shape.x, shape.y + shape.height);
            } else {
                graphics.drawLine(shape.x + 1, shape.y, shape.x + 1, shape.y + shape.height);
            }
        }
        graphics.setColor(Color.darkGray);
        graphics.drawLine(this.colHeaders[1].x, 0, this.colHeaders[1].x, n);
        graphics.drawLine(this.colHeaders[2].x, 0, this.colHeaders[2].x, n);
        graphics.drawLine(this.colHeaders[3].x, 0, this.colHeaders[3].x, n);
        graphics.drawLine(this.colHeaders[4].x, 0, this.colHeaders[4].x, n);
        graphics.drawLine(this.colHeaders[5].x, 0, this.colHeaders[5].x, n);
        graphics.drawLine(this.colHeaders[6].x, 0, this.colHeaders[6].x, n3);
        graphics.drawLine(this.colHeaders[7].x, 0, this.colHeaders[7].x, n3);
        if (this.twoLines) {
            graphics.drawLine(0, n / 2, dimension.width, n / 2);
        }
        shape = graphics.getClip();
        int n4 = n - 2 - fm.getMaxDescent();
        if (this.twoLines) {
            int n5 = n / 2 - fm.getMaxDescent();
        } else {
            int n6 = n - fm.getMaxDescent() - 2;
        }
        graphics.setColor(Color.black);
        this.paintField(graphics, shape, this.colHeaders[0], this.columnNames[0], (byte)2);
        if (this.twoLines) {
            this.paintField(graphics, shape, this.colHeaders[8], this.columnNames[8], (byte)2);
        }
        this.paintField(graphics, shape, this.colHeaders[1], this.columnNames[1], (byte)2);
        this.paintField(graphics, shape, this.colHeaders[2], this.columnNames[2], (byte)2);
        if (this.twoLines) {
            this.paintField(graphics, shape, this.colHeaders[10], this.columnNames[9], (byte)2);
        }
        this.paintField(graphics, shape, this.colHeaders[3], this.columnNames[3], (byte)2);
        if (this.twoLines) {
            this.paintField(graphics, shape, this.colHeaders[11], this.columnNames[11], (byte)2);
        }
        this.paintField(graphics, shape, this.colHeaders[4], this.columnNames[4], (byte)2);
        this.paintField(graphics, shape, this.colHeaders[5], this.columnNames[5], (byte)2);
        this.paintField(graphics, shape, this.colHeaders[6], this.columnNames[6], (byte)2);
        this.paintField(graphics, shape, this.colHeaders[7], this.columnNames[7], (byte)2);
    }

    private final void paintRecHeader(Graphics graphics, Dimension dimension) {
        Shape shape;
        int n;
        int n2 = dimension.width;
        int n3 = n = dimension.height;
        if (this.twoLines) {
            n3 = n / 2;
        }
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, n2, n);
        graphics.setColor(Color.white);
        graphics.drawLine(0, 0, n2, 0);
        graphics.drawLine(0, 0, 0, n);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(0, n - 1, n2 - 1, n - 1);
        graphics.drawLine(n2 - 1, 0, n2 - 1, n - 1);
        if (this.sortColumn >= 0) {
            shape = this.colHeaders[this.sortColumn];
            graphics.setColor(Color.darkGray);
            if (this.sortColumn < 8) {
                graphics.drawLine(shape.x, shape.y, shape.x + shape.width, shape.y);
            } else {
                graphics.drawLine(shape.x, shape.y + 1, shape.x + shape.width, shape.y + 1);
            }
            if (this.sortColumn == 0 || this.sortColumn == 8) {
                graphics.drawLine(shape.x, shape.y, shape.x, shape.y + shape.height);
            } else {
                graphics.drawLine(shape.x + 1, shape.y, shape.x + 1, shape.y + shape.height);
            }
        }
        graphics.setColor(Color.darkGray);
        graphics.drawLine(this.colHeaders[1].x, 0, this.colHeaders[1].x, n);
        graphics.drawLine(this.colHeaders[2].x, 0, this.colHeaders[2].x, n);
        graphics.drawLine(this.colHeaders[3].x, 0, this.colHeaders[3].x, n);
        graphics.drawLine(this.colHeaders[4].x, 0, this.colHeaders[4].x, n);
        shape = graphics.getClip();
        graphics.setColor(Color.black);
        this.paintField(graphics, shape, this.colHeaders[0], this.columnNames[0], (byte)2);
        this.paintField(graphics, shape, this.colHeaders[1], this.columnNames[1], (byte)2);
        this.paintField(graphics, shape, this.colHeaders[2], this.columnNames[2], (byte)2);
        this.paintField(graphics, shape, this.colHeaders[3], this.columnNames[3], (byte)2);
        this.paintField(graphics, shape, this.colHeaders[4], this.columnNames[4], (byte)2);
    }

    private final void paintField(Graphics graphics, Shape shape, Rectangle rectangle, String string, byte by) {
        graphics.setClip(shape);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        switch (by) {
            case 2: {
                graphics.drawString(string, (int)((double)rectangle.x + (double)rectangle.width / 2.0 - (double)fm.stringWidth(string) / 2.0), rectangle.y + rectangle.height - 4);
                break;
            }
            case 0: {
                graphics.drawString(string, rectangle.x + rectangle.width - fm.stringWidth(string) - 2, rectangle.y + rectangle.height - 4);
                break;
            }
            default: {
                graphics.drawString(string, rectangle.x + 2, rectangle.y + rectangle.height - 4);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void paintBankTransaction(Graphics graphics, BankTransaction bankTransaction) {
        Object object;
        double d;
        Account account;
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 18, this.w, 18);
        graphics.drawLine(0, this.h - 1, this.w, this.h - 1);
        graphics.drawLine(this.colHeaders[1].x, 0, this.colHeaders[1].x, this.h);
        graphics.drawLine(this.colHeaders[2].x, 0, this.colHeaders[2].x, this.h);
        graphics.drawLine(this.colHeaders[3].x, 0, this.colHeaders[3].x, this.h);
        graphics.drawLine(this.colHeaders[4].x, 0, this.colHeaders[4].x, this.h);
        graphics.drawLine(this.colHeaders[5].x, 0, this.colHeaders[5].x, this.h);
        graphics.drawLine(this.colHeaders[6].x, 0, this.colHeaders[6].x, this.h);
        graphics.drawLine(this.colHeaders[7].x, 0, this.colHeaders[7].x, this.h);
        graphics.setColor(Color.black);
        Shape shape = graphics.getClip();
        this.paintField(graphics, shape, this.colHeaders[0], this.shortDateFormat.format(new Date(bankTransaction.getDate())), (byte)1);
        if (this.twoLines) {
            graphics.setColor(Color.darkGray);
            this.paintField(graphics, shape, this.colHeaders[8], this.shortDateFormat.format(new Date(bankTransaction.getTaxableDate())), (byte)1);
            graphics.setColor(Color.black);
        }
        this.paintField(graphics, shape, this.colHeaders[1], bankTransaction.getCheckNumber(), (byte)1);
        this.paintField(graphics, shape, this.colHeaders[2], bankTransaction.getDescription(), (byte)1);
        if (this.twoLines) {
            this.paintField(graphics, shape, this.colHeaders[10], bankTransaction.getMemo(), (byte)1);
        }
        String string = "";
        if (bankTransaction.getSourceAccountId() != this.accountNum) {
            account = this.rootAccount.getAccountById(bankTransaction.getSourceAccountId());
            if (account == null && bankTransaction.getSourceAccountId() == -1) {
                string = this.splitLabel;
            }
        } else {
            account = this.rootAccount.getAccountById(bankTransaction.getDestAccountId());
            if (account == null && bankTransaction.getDestAccountId() == -1) {
                string = this.splitLabel;
            }
        }
        String string2 = null;
        string2 = account == null ? string : (this.showFullAcctPath ? string + account.getFullAccountName() : string + account.getAccountName());
        this.paintField(graphics, shape, this.colHeaders[3], string2, (byte)1);
        if (this.twoLines && (d = bankTransaction.getRate(this.accountNum)) != 1.0) {
            try {
                object = this.currencyTable.getCurrencyType(this.rootAccount.getAccountById(bankTransaction.getAccountId(this.accountNum)).getCurrencyType());
                d = CurrencyType.getXRelativeRate(this.currencyType, (CurrencyType)object, d);
                this.paintField(graphics, shape, this.colHeaders[11], StringUtils.formatRate(d, this.dec), (byte)1);
            }
            catch (Exception exception) {
                System.err.println("Got exception: " + exception);
                exception.printStackTrace(System.err);
            }
        }
        this.drawClearedStatus(graphics, shape, this.colHeaders[4], bankTransaction.getClearedStatus(this.accountNum));
        long l = bankTransaction.getAmount(this.accountNum);
        if (l <= 0L) {
            object = StringUtils.formatCurrency(l * -1L, false, this.dec, this.com, this.numDecimals, this.centMult);
            this.paintField(graphics, shape, this.colHeaders[5], (String)object, (byte)0);
        }
        if (l > 0L) {
            object = StringUtils.formatCurrency(l, false, this.dec, this.com, this.numDecimals, this.centMult);
            this.paintField(graphics, shape, this.colHeaders[6], (String)object, (byte)0);
        }
        long l2 = bankTransaction.getBalance(this.accountNum);
        String string3 = StringUtils.formatCurrency(l2, false, this.dec, this.com, this.numDecimals, this.centMult);
        if (l2 >= 0L) {
            graphics.setColor(Color.blue);
        } else {
            graphics.setColor(Color.red);
        }
        this.paintField(graphics, shape, this.colHeaders[7], string3, (byte)0);
    }

    private final void paintRecBankTransaction(Graphics graphics, BankTransaction bankTransaction) {
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 18, this.w, 18);
        graphics.drawLine(this.colHeaders[1].x, 0, this.colHeaders[1].x, 18);
        graphics.drawLine(this.colHeaders[2].x, 0, this.colHeaders[2].x, 18);
        graphics.drawLine(this.colHeaders[3].x, 0, this.colHeaders[3].x, 18);
        graphics.drawLine(this.colHeaders[4].x, 0, this.colHeaders[4].x, 18);
        graphics.drawLine(this.colHeaders[5].x, 0, this.colHeaders[5].x, 18);
        graphics.setColor(Color.black);
        Shape shape = graphics.getClip();
        this.paintField(graphics, shape, this.colHeaders[0], this.shortDateFormat.format(new Date(bankTransaction.getDate())), (byte)1);
        this.paintField(graphics, shape, this.colHeaders[1], bankTransaction.getCheckNumber(), (byte)1);
        this.paintField(graphics, shape, this.colHeaders[2], bankTransaction.getDescription(), (byte)1);
        this.drawClearedStatus(graphics, shape, this.colHeaders[3], bankTransaction.getClearedStatus(this.accountNum));
        String string = StringUtils.formatCurrency(bankTransaction.getAmount(this.accountNum), false, this.dec, this.com, this.numDecimals, this.centMult);
        this.paintField(graphics, shape, this.colHeaders[4], string, (byte)0);
    }

    private final void drawClearedStatus(Graphics graphics, Shape shape, Rectangle rectangle, char c) {
        graphics.setClip(shape);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (c == 'X') {
            graphics.drawImage(clearedIcon, rectangle.x + 2, -2, null, null);
        } else if (c == 'x') {
            graphics.drawImage(reconcilingIcon, rectangle.x + 2, -2, null, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void paintSplitTransaction(Graphics graphics, SplitTransaction splitTransaction) {
        String string;
        double d;
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 18, this.w, 18);
        graphics.drawLine(0, this.h - 1, this.w, this.h - 1);
        graphics.drawLine(this.colHeaders[1].x, 0, this.colHeaders[1].x, this.h);
        graphics.drawLine(this.colHeaders[2].x, 0, this.colHeaders[2].x, this.h);
        graphics.drawLine(this.colHeaders[3].x, 0, this.colHeaders[3].x, this.h);
        graphics.drawLine(this.colHeaders[4].x, 0, this.colHeaders[4].x, this.h);
        graphics.drawLine(this.colHeaders[5].x, 0, this.colHeaders[5].x, this.h);
        graphics.drawLine(this.colHeaders[6].x, 0, this.colHeaders[6].x, this.h);
        graphics.drawLine(this.colHeaders[7].x, 0, this.colHeaders[7].x, this.h);
        graphics.setColor(Color.black);
        Shape shape = graphics.getClip();
        this.paintField(graphics, shape, this.colHeaders[0], this.shortDateFormat.format(new Date(splitTransaction.getDate())), (byte)1);
        if (this.twoLines) {
            graphics.setColor(Color.darkGray);
            this.paintField(graphics, shape, this.colHeaders[8], this.shortDateFormat.format(new Date(splitTransaction.getTaxableDate())), (byte)1);
            graphics.setColor(Color.black);
        }
        this.paintField(graphics, shape, this.colHeaders[2], splitTransaction.getDescription(), (byte)1);
        Account account = this.rootAccount.getAccountById(splitTransaction.getParent().getDestAccountId());
        String string2 = null;
        string2 = account == null ? "???" : (this.showFullAcctPath ? account.getFullAccountName() : account.getAccountName());
        this.paintField(graphics, shape, this.colHeaders[3], "[split]" + string2, (byte)1);
        if (this.twoLines && (d = splitTransaction.getRate(this.accountNum)) != 1.0) {
            try {
                CurrencyType currencyType = this.currencyTable.getCurrencyType(this.rootAccount.getAccountById(splitTransaction.getAccountId(this.accountNum)).getCurrencyType());
                d = CurrencyType.getXRelativeRate(this.currencyType, currencyType, d);
                this.paintField(graphics, shape, this.colHeaders[11], StringUtils.formatRate(d, this.dec), (byte)1);
            }
            catch (Exception exception) {
                System.err.println("Got exception: " + exception);
                exception.printStackTrace(System.err);
            }
        }
        this.drawClearedStatus(graphics, shape, this.colHeaders[4], splitTransaction.getClearedStatus(this.accountNum));
        long l = splitTransaction.getAmount(this.accountNum);
        if (l <= 0L) {
            string = StringUtils.formatCurrency(l * -1L, false, this.dec, this.com, this.numDecimals, this.centMult);
            this.paintField(graphics, shape, this.colHeaders[5], string, (byte)0);
        }
        if (l > 0L) {
            string = StringUtils.formatCurrency(l, false, this.dec, this.com, this.numDecimals, this.centMult);
            this.paintField(graphics, shape, this.colHeaders[6], string, (byte)0);
        }
        if ((l = splitTransaction.getBalance(this.accountNum)) >= 0L) {
            graphics.setColor(Color.blue);
        } else {
            graphics.setColor(Color.red);
        }
        string = StringUtils.formatCurrency(l, false, this.dec, this.com, this.numDecimals, this.centMult);
        this.paintField(graphics, shape, this.colHeaders[7], string, (byte)0);
    }

    private final void paintRecSplitTransaction(Graphics graphics, SplitTransaction splitTransaction) {
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 18, this.w, 18);
        graphics.drawLine(this.colHeaders[1].x, 0, this.colHeaders[1].x, 18);
        graphics.drawLine(this.colHeaders[2].x, 0, this.colHeaders[2].x, 18);
        graphics.drawLine(this.colHeaders[3].x, 0, this.colHeaders[3].x, 18);
        graphics.drawLine(this.colHeaders[4].x, 0, this.colHeaders[4].x, 18);
        graphics.drawLine(this.colHeaders[5].x, 0, this.colHeaders[5].x, 18);
        graphics.setColor(Color.black);
        Shape shape = graphics.getClip();
        this.paintField(graphics, shape, this.colHeaders[0], this.shortDateFormat.format(new Date(splitTransaction.getDate())), (byte)1);
        this.paintField(graphics, shape, this.colHeaders[2], splitTransaction.getDescription(), (byte)1);
        this.drawClearedStatus(graphics, shape, this.colHeaders[3], splitTransaction.getClearedStatus(this.accountNum));
        String string = StringUtils.formatCurrency(splitTransaction.getAmount(this.accountNum), false, this.dec, this.com, this.numDecimals, this.centMult);
        this.paintField(graphics, shape, this.colHeaders[4], string, (byte)0);
    }

    private final void paintDefaultTransaction(Graphics graphics, Transaction transaction) {
        graphics.drawString(">>>>>>>>????<<<<<<<<<", 3, 16);
    }

    public HeaderComponent getHeaderRenderer(JList jList) {
        if (this.headerRenderer == null) {
            TransactionRenderer transactionRenderer = this;
            if (transactionRenderer == null) {
                throw null;
            }
            this.headerRenderer = transactionRenderer.new HeaderComponent(jList);
        }
        return this.headerRenderer;
    }

    public void setSortField(int n) {
        this.sortColumn = this.columnModelToView(n);
        if (this.headerRenderer != null) {
            this.headerRenderer.repaint();
        }
    }

    private final int columnModelToView(int n) {
        if (this.isReconciler) {
            switch (n) {
                case 0: {
                    return 0;
                }
                case 9: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
            }
            return -1;
        }
        switch (n) {
            case 0: {
                return 0;
            }
            case 9: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 5;
            }
        }
        return -1;
    }

    private final int columnViewToModel(int n) {
        if (this.isReconciler) {
            switch (n) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 9;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 3;
                }
            }
            return -1;
        }
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 3;
            }
        }
        return -1;
    }

    /* synthetic */ TransactionSortListener access$0() {
        return this.sortListener;
    }

    /* synthetic */ Rectangle[] access$1() {
        return this.colHeaders;
    }

    /* synthetic */ int access$2(int n) {
        return this.columnViewToModel(n);
    }

    /* synthetic */ int access$3() {
        return this.sortColumn;
    }

    /* synthetic */ void access$4(int n) {
        this.sortColumn = n;
    }

    /* synthetic */ void access$5() {
        this.calculateColumnPositions();
    }

    /* synthetic */ boolean access$6() {
        return this.twoLines;
    }

    static /* synthetic */ int access$7() {
        return rowHeight;
    }

    /* synthetic */ int access$9() {
        return this.w;
    }

    /* synthetic */ void access$10(int n) {
        this.w = n;
    }

    /* synthetic */ boolean access$11() {
        return this.isReconciler;
    }

    /* synthetic */ void access$12(Graphics graphics, Dimension dimension) {
        this.paintRecHeader(graphics, dimension);
    }

    /* synthetic */ void access$13(Graphics graphics, Dimension dimension) {
        this.paintHeader(graphics, dimension);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TransactionRenderer(Account account, MoneydanceGUI moneydanceGUI, boolean bl, boolean bl2, String string, TransactionSortListener transactionSortListener) {
        this(account, moneydanceGUI, bl, bl2, Color.cyan, Color.white, string, transactionSortListener);
    }

    public TransactionRenderer(Account account, MoneydanceGUI moneydanceGUI, boolean bl, boolean bl2, Color color, Color color2, String string, TransactionSortListener transactionSortListener) {
        this.colPrefID = string;
        this.account = account;
        this.accountNum = account.getAccountNum();
        this.currencyType = account.getRootAccount().getCurrencyTable().getCurrencyType(account.getCurrencyType());
        this.twoLines = bl;
        this.isReconciler = bl2;
        this.color1 = color;
        this.color2 = color2;
        this.moneydanceGUI = moneydanceGUI;
        this.prefs = Main.getMainController().getPreferences();
        this.sortListener = transactionSortListener;
        this.dec = this.prefs.getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        this.rootAccount = account.getRootAccount();
        this.currencyTable = this.rootAccount.getCurrencyTable();
        this.numDecimals = this.currencyType.getDecimalPlaces();
        this.centMult = (int)Math.round(Math.pow(10.0, this.numDecimals));
        this.colHeaders = new Rectangle[16];
        int n = 0;
        while (n < this.colHeaders.length) {
            this.colHeaders[n] = new Rectangle();
            this.colHeaders[n].height = 18;
            this.colHeaders[n].x = -1;
            this.colHeaders[n].width = -1;
            this.colHeaders[n].y = n < 8 ? 0 : 18;
            ++n;
        }
        this.setLabels();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            reconcilingIcon = new ImageIcon(AwtUtil.loadImage("/com/seanreilly/apps/moneydance/images/md_txn_reconciling_icon.gif")).getImage();
            clearedIcon = new ImageIcon(AwtUtil.loadImage("/com/seanreilly/apps/moneydance/images/md_txn_cleared_icon.gif")).getImage();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    class HeaderComponent
    extends JComponent {
        JList txnList;
        boolean isDragging = false;
        int resizeColumn = -1;

        private final void repaintList() {
            this.txnList.repaint();
        }

        private final int isOverBorder(int n) {
            int n2 = 3;
            int n3 = 0;
            int n4 = 0;
            while (n4 < 8) {
                if (n4 == 0) {
                    n3 += TransactionRenderer.this.access$1()[0].width;
                } else if (n4 == 1) {
                    n3 += TransactionRenderer.this.access$1()[1].width;
                } else if (n4 == 2) {
                    n3 += TransactionRenderer.this.access$1()[2].width;
                } else if (n4 == 3) {
                    n3 += TransactionRenderer.this.access$1()[3].width;
                } else if (n4 == 4) {
                    n3 += TransactionRenderer.this.access$1()[4].width;
                } else if (n4 == 5) {
                    n3 += TransactionRenderer.this.access$1()[5].width;
                } else if (n4 == 6) {
                    n3 += TransactionRenderer.this.access$1()[6].width;
                } else {
                    return -1;
                }
                if (n < n3 - n2) {
                    return -1;
                }
                if (n <= n3 + n2) {
                    return n4;
                }
                ++n4;
            }
            return -1;
        }

        public Dimension getPreferredSize() {
            if (TransactionRenderer.this.access$6()) {
                return new Dimension(100, 36);
            }
            return new Dimension(100, 18);
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (TransactionRenderer.this.access$1()[2].width < 0 && dimension.width > 0 || fm == null) {
                TransactionRenderer.this.restoreColWidths(graphics, dimension.width);
                TransactionRenderer.this.access$10(dimension.width);
            }
            if (TransactionRenderer.this.access$11()) {
                TransactionRenderer.this.access$12(graphics, dimension);
            } else {
                TransactionRenderer.this.access$13(graphics, dimension);
            }
        }

        /* synthetic */ TransactionRenderer access$0() {
            return TransactionRenderer.this;
        }

        /* synthetic */ int access$1(int n) {
            return this.isOverBorder(n);
        }

        /* synthetic */ void access$2() {
            this.repaintList();
        }

        HeaderComponent(JList jList) {
            this.txnList = jList;
            HeaderComponent headerComponent = this;
            if (headerComponent == null) {
                throw null;
            }
            this.addMouseListener(new MouseAdapter(headerComponent){
                private final /* synthetic */ HeaderComponent this$0;
                private final /* synthetic */ TransactionRenderer this$1;

                public final void mouseClicked(MouseEvent mouseEvent) {
                    if (this.this$1.access$0() == null) {
                        return;
                    }
                    Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                    int n = 0;
                    while (n < this.this$1.access$1().length) {
                        if (this.this$1.access$1()[n].contains(point)) {
                            int n2 = this.this$1.access$2(n);
                            if (n2 < 0) break;
                            if (n != this.this$1.access$3() && this.this$1.access$0() != null) {
                                this.this$1.access$0().setSortKey(n2);
                            }
                            this.this$1.access$4(n);
                            this.this$0.repaint();
                            break;
                        }
                        ++n;
                    }
                }

                public final void mousePressed(MouseEvent mouseEvent) {
                    this.this$0.resizeColumn = this.this$0.access$1(mouseEvent.getX());
                    this.this$0.isDragging = this.this$0.resizeColumn >= 0;
                }

                public final void mouseReleased(MouseEvent mouseEvent) {
                    if (this.this$0.isDragging) {
                        this.this$0.access$2();
                        this.this$0.setCursor(Cursor.getPredefinedCursor(0));
                        this.this$1.saveColWidths();
                    }
                    this.this$0.isDragging = false;
                    this.this$0.resizeColumn = -1;
                }

                public final void mouseExited(MouseEvent mouseEvent) {
                    if (!this.this$0.isDragging) {
                        this.this$0.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                {
                    this.this$0 = headerComponent;
                    this.this$1 = this.this$0.access$0();
                    this.constructor$0(headerComponent);
                }

                public void constructor$0(HeaderComponent headerComponent) {
                }
            });
            HeaderComponent headerComponent2 = this;
            if (headerComponent2 == null) {
                throw null;
            }
            this.addMouseMotionListener(new MouseMotionListener(headerComponent2){
                private final /* synthetic */ HeaderComponent this$0;
                private final /* synthetic */ TransactionRenderer this$1;

                public final void mouseMoved(MouseEvent mouseEvent) {
                    if (this.this$0.access$1(mouseEvent.getX()) >= 0) {
                        this.this$0.setCursor(Cursor.getPredefinedCursor(10));
                        this.this$0.isDragging = this.this$0.resizeColumn >= 0;
                    } else {
                        this.this$0.setCursor(Cursor.getPredefinedCursor(0));
                        this.this$0.isDragging = false;
                        this.this$0.resizeColumn = -1;
                    }
                }

                public final void mouseDragged(MouseEvent mouseEvent) {
                    if (!this.this$0.isDragging) {
                        this.this$0.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    int n = mouseEvent.getX();
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < this.this$0.resizeColumn) {
                        n2 += this.this$1.access$1()[n3].width;
                        ++n3;
                    }
                    if (n < n2 + 2) {
                        n = n2 + 2;
                    }
                    if (n > n2 + this.this$1.access$1()[this.this$0.resizeColumn].width + this.this$1.access$1()[this.this$0.resizeColumn + 1].width - 2) {
                        n = n2 + this.this$1.access$1()[this.this$0.resizeColumn].width + this.this$1.access$1()[this.this$0.resizeColumn + 1].width - 2;
                    }
                    n3 = this.this$1.access$1()[this.this$0.resizeColumn].width;
                    this.this$1.access$1()[this.this$0.resizeColumn].width = n - n2;
                    this.this$1.access$1()[this.this$0.resizeColumn + 1].width = this.this$1.access$1()[this.this$0.resizeColumn + 1].width + n3 - this.this$1.access$1()[this.this$0.resizeColumn].width;
                    this.this$1.access$5();
                    this.this$0.repaint();
                }
                {
                    this.this$0 = headerComponent;
                    this.this$1 = this.this$0.access$0();
                    this.constructor$0(headerComponent);
                }

                public void constructor$0(HeaderComponent headerComponent) {
                }
            });
        }
    }
}

