/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.view.gui.AccountPopup;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JCurrencyField;
import com.seanreilly.awt.JRateField;
import com.seanreilly.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SplitEditor
extends JDialog
implements ActionListener {
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$Account;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private JTable splitTable;
    private SplitTableModel dataModel;
    private JButton okButton;
    private JButton deleteButton;
    private JButton newButton;
    private JButton cancelButton;
    private BankTransaction parentTransaction;
    private RootAccount rootAccount;
    private CurrencyTable currencyTable;
    private JTextField descriptionField;
    private JLabel totalLabel;
    private DefaultCellEditor accountEditor;
    private DefaultCellEditor descriptionEditor;
    private DefaultCellEditor clearedEditor;
    private DefaultCellEditor amountEditor;
    private DefaultCellEditor rateEditor;
    private boolean wasCancelled = true;
    private MoneydanceGUI moneydanceGUI;
    private Account account;
    private CurrencyType currency;
    private char dec;
    private char com;
    private AccountPopup accountChoice;
    private boolean showRates = true;

    private final void initColumnSizes(JTable jTable, SplitTableModel splitTableModel) {
        TableColumn tableColumn = null;
        Component component = null;
        int n = 0;
        int n2 = 0;
        Object[] objectArray = splitTableModel.longValues;
        int n3 = 0;
        while (n3 < splitTableModel.getColumnCount()) {
            tableColumn = jTable.getColumnModel().getColumn(n3);
            component = tableColumn.getHeaderRenderer().getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
            n = component.getPreferredSize().width;
            component = jTable.getDefaultRenderer(splitTableModel.getColumnClass(n3)).getTableCellRendererComponent(jTable, objectArray[n3], false, false, 0, n3);
            n2 = component.getPreferredSize().width;
            tableColumn.setMinWidth(Math.max(n, n2));
            ++n3;
        }
        jTable.sizeColumnsToFit(-1);
    }

    public void setUpEditors(TableColumnModel tableColumnModel) {
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        this.accountChoice = new AccountPopup(this.account, this.moneydanceGUI);
        this.accountEditor = new DefaultCellEditor(this.accountChoice);
        this.accountEditor.setClickCountToStart(1);
        tableColumn.setCellEditor(this.accountEditor);
        tableColumn = tableColumnModel.getColumn(1);
        this.descriptionField = new JTextField();
        this.descriptionEditor = new DefaultCellEditor(this.descriptionField);
        this.descriptionEditor.setClickCountToStart(1);
        tableColumn.setCellEditor(this.descriptionEditor);
        tableColumn = tableColumnModel.getColumn(2);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(this.moneydanceGUI.getResources().getString("uncleared"));
        jComboBox.addItem(this.moneydanceGUI.getResources().getString("reconciling"));
        jComboBox.addItem(this.moneydanceGUI.getResources().getString("cleared"));
        this.clearedEditor = new DefaultCellEditor(jComboBox);
        this.clearedEditor.setClickCountToStart(1);
        tableColumn.setCellEditor(this.clearedEditor);
        tableColumn = tableColumnModel.getColumn(3);
        JCurrencyField jCurrencyField = new JCurrencyField(this.currency, this.currencyTable, this.dec, this.com);
        this.amountEditor = new DefaultCellEditor(jCurrencyField);
        this.amountEditor.setClickCountToStart(1);
        tableColumn.setCellEditor(this.amountEditor);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(4);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        if (this.showRates) {
            tableColumn = tableColumnModel.getColumn(4);
            JRateField jRateField = new JRateField(this.dec);
            this.rateEditor = new DefaultCellEditor(jRateField);
            this.rateEditor.setClickCountToStart(1);
            tableColumn.setCellEditor(this.rateEditor);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
        }
    }

    public synchronized void setSplits(Vector vector) {
        this.dataModel.setTransactions(vector);
        this.setTotalLabel();
    }

    private final void setTotalLabel() {
        Vector vector = this.dataModel.getTransactions();
        long l = 0L;
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Transaction transaction = (Transaction)vector.elementAt(n);
                l += transaction.getAmount();
                ++n;
            }
        }
        long l2 = 0L;
        long l3 = 0L;
        if (l < 0L) {
            l2 = -l;
        } else {
            l3 = l;
        }
        String string = this.moneydanceGUI.getResources().getString("txn_debit") + ": " + (this.currency.getPrefix() + ' ' + StringUtils.formatCurrency(l2, true, this.dec, this.com, this.currency.getDecimalPlaces())).trim() + "   " + this.moneydanceGUI.getResources().getString("txn_credit") + ": " + (this.currency.getPrefix() + ' ' + StringUtils.formatCurrency(l3, true, this.dec, this.com, this.currency.getDecimalPlaces())).trim();
        this.totalLabel.setText(string);
    }

    public Vector getSplits() {
        return this.dataModel.getTransactions();
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.accountEditor.stopCellEditing();
            this.descriptionEditor.stopCellEditing();
            this.amountEditor.stopCellEditing();
            this.clearedEditor.stopCellEditing();
            if (this.showRates) {
                this.rateEditor.stopCellEditing();
            }
            this.wasCancelled = false;
            ((Component)this).setVisible(false);
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.wasCancelled = true;
            ((Component)this).setVisible(false);
        } else if (actionEvent.getSource() == this.newButton) {
            Account account = this.accountChoice.getAccountAt(0);
            this.dataModel.addTransaction(new SplitTransaction(-1L, account.getAccountNum(), "", 0L, new Date().getTime(), ' ', this.parentTransaction));
        } else if (actionEvent.getSource() == this.deleteButton) {
            int n = this.splitTable.getSelectedRow();
            if (n >= 0) {
                this.accountEditor.stopCellEditing();
                this.descriptionEditor.stopCellEditing();
                this.amountEditor.stopCellEditing();
                this.clearedEditor.stopCellEditing();
                if (this.showRates) {
                    this.rateEditor.stopCellEditing();
                }
                this.dataModel.removeTransaction(n);
            }
            this.setTotalLabel();
        }
    }

    /* synthetic */ MoneydanceGUI access$0() {
        return this.moneydanceGUI;
    }

    /* synthetic */ CurrencyType access$1() {
        return this.currency;
    }

    /* synthetic */ boolean access$2() {
        return this.showRates;
    }

    /* synthetic */ RootAccount access$3() {
        return this.rootAccount;
    }

    /* synthetic */ char access$4() {
        return this.dec;
    }

    /* synthetic */ char access$5() {
        return this.com;
    }

    /* synthetic */ CurrencyTable access$6() {
        return this.currencyTable;
    }

    /* synthetic */ void access$11() {
        this.setTotalLabel();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SplitEditor(Frame frame, BankTransaction bankTransaction, RootAccount rootAccount, MoneydanceGUI moneydanceGUI, Account account, boolean bl) {
        super(frame, moneydanceGUI.getResources().getString("split_win_title"), true);
        this.parentTransaction = bankTransaction;
        this.rootAccount = rootAccount;
        this.moneydanceGUI = moneydanceGUI;
        this.account = account;
        this.currencyTable = rootAccount.getCurrencyTable();
        this.currency = this.currencyTable.getCurrencyType(account.getCurrencyType());
        this.showRates = bl;
        this.dec = Main.getMainController().getPreferences().getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        this.totalLabel = new JLabel(" ", 4);
        this.totalLabel.setBorder(new EtchedBorder());
        SplitEditor splitEditor = this;
        if (splitEditor == null) {
            throw null;
        }
        this.dataModel = splitEditor.new SplitTableModel();
        this.splitTable = new JTable(this.dataModel);
        this.splitTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.splitTable.setRowHeight(this.splitTable.getRowHeight() + 4);
        this.initColumnSizes(this.splitTable, this.dataModel);
        this.setUpEditors(this.splitTable.getColumnModel());
        JScrollPane jScrollPane = new JScrollPane(this.splitTable);
        this.okButton = new JButton(this.moneydanceGUI.getResources().getString("ok"));
        this.cancelButton = new JButton(this.moneydanceGUI.getResources().getString("cancel"));
        this.deleteButton = new JButton(this.moneydanceGUI.getResources().getString("delete_split"));
        this.newButton = new JButton(this.moneydanceGUI.getResources().getString("new_split"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.setContentPane(jPanel2);
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        jPanel.add((Component)this.totalLabel, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 5, 1, true, true));
        jPanel.add((Component)this.newButton, AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.deleteButton, AwtUtil.getConstraints(1, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)new JLabel(""), AwtUtil.getConstraints(2, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.cancelButton, AwtUtil.getConstraints(3, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.okButton, AwtUtil.getConstraints(4, 1, 0.0f, 0.0f, 1, 1, true, true));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        ((Component)this).setSize(700, 300);
        this.splitTable.sizeColumnsToFit(3);
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = frame.getSize();
        Point point = frame.getLocation();
        ((Component)this).setLocation(point.x + dimension3.width / 2 - dimension2.width / 2, point.y + dimension3.height / 2 - dimension2.height / 2);
    }

    class SplitTableModel
    extends AbstractTableModel {
        final String[] columnNames;
        private Vector transactions;
        private int lastEditedRow;
        private int numDecimals;
        private int centMult;
        public final Object[] longValues;

        public int getLastEditedRow() {
            return this.lastEditedRow;
        }

        public Vector getTransactions() {
            return this.transactions;
        }

        public void setTransactions(Vector vector) {
            this.transactions = vector;
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return SplitEditor.this.access$2() ? this.columnNames.length : this.columnNames.length - 1;
        }

        public int getRowCount() {
            return this.transactions.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            SplitTransaction splitTransaction = (SplitTransaction)this.transactions.elementAt(n);
            if (n2 == 0) {
                return SplitEditor.this.access$3().getAccountById(splitTransaction.getSourceAccountId());
            }
            if (n2 == 1) {
                return splitTransaction.getDescription();
            }
            if (n2 == 2) {
                char c = splitTransaction.getSourceClearedStatus();
                if (c == 'x') {
                    return SplitEditor.this.access$0().getResources().getString("reconciling");
                }
                if (c == 'X') {
                    return SplitEditor.this.access$0().getResources().getString("cleared");
                }
                return SplitEditor.this.access$0().getResources().getString("uncleared");
            }
            if (n2 == 3) {
                return StringUtils.formatCurrency(splitTransaction.getAmount(), false, SplitEditor.this.access$4(), SplitEditor.this.access$5(), this.numDecimals, this.centMult);
            }
            if (n2 == 4) {
                double d = 1.0;
                Account account = SplitEditor.this.access$3().getAccountById(splitTransaction.getSourceAccountId());
                if (account != null) {
                    CurrencyType currencyType = SplitEditor.this.access$6().getCurrencyType(account.getCurrencyType());
                    d = CurrencyType.getXRelativeRate(SplitEditor.this.access$1(), currencyType, splitTransaction.getRate());
                }
                return StringUtils.formatRate(d, SplitEditor.this.access$4());
            }
            return "???";
        }

        public Class getColumnClass(int n) {
            Class clazz;
            if (n == 0) {
                Class clazz2;
                if (class$Lcom$seanreilly$apps$moneydance$model$Account != null) {
                    clazz2 = class$Lcom$seanreilly$apps$moneydance$model$Account;
                } else {
                    Class clazz3 = SplitEditor.class$("com.seanreilly.apps.moneydance.model.Account");
                    clazz2 = clazz3;
                    class$Lcom$seanreilly$apps$moneydance$model$Account = clazz3;
                }
                return clazz2;
            }
            if (n == 1) {
                Class clazz4;
                if (class$Ljava$lang$String != null) {
                    clazz4 = class$Ljava$lang$String;
                } else {
                    Class clazz5 = SplitEditor.class$("java.lang.String");
                    clazz4 = clazz5;
                    class$Ljava$lang$String = clazz5;
                }
                return clazz4;
            }
            if (n == 2) {
                Class clazz6;
                if (class$Ljava$lang$String != null) {
                    clazz6 = class$Ljava$lang$String;
                } else {
                    Class clazz7 = SplitEditor.class$("java.lang.String");
                    clazz6 = clazz7;
                    class$Ljava$lang$String = clazz7;
                }
                return clazz6;
            }
            if (n == 3) {
                Class clazz8;
                if (class$Ljava$lang$String != null) {
                    clazz8 = class$Ljava$lang$String;
                } else {
                    Class clazz9 = SplitEditor.class$("java.lang.String");
                    clazz8 = clazz9;
                    class$Ljava$lang$String = clazz9;
                }
                return clazz8;
            }
            if (n == 4) {
                Class clazz10;
                if (class$Ljava$lang$String != null) {
                    clazz10 = class$Ljava$lang$String;
                } else {
                    Class clazz11 = SplitEditor.class$("java.lang.String");
                    clazz10 = clazz11;
                    class$Ljava$lang$String = clazz11;
                }
                return clazz10;
            }
            if (class$Ljava$lang$String != null) {
                clazz = class$Ljava$lang$String;
            } else {
                Class clazz12 = SplitEditor.class$("java.lang.String");
                clazz = clazz12;
                class$Ljava$lang$String = clazz12;
            }
            return clazz;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 4) {
                SplitTransaction splitTransaction = (SplitTransaction)this.transactions.elementAt(n);
                Account account = SplitEditor.this.access$3().getAccountById(splitTransaction.getSourceAccountId());
                if (SplitEditor.this.access$1().getID().equals(account.getCurrencyType())) {
                    return false;
                }
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setValueAt(Object object, int n, int n2) {
            this.lastEditedRow = n;
            try {
                SplitTransaction splitTransaction = (SplitTransaction)this.transactions.elementAt(n);
                if (n2 == 0) {
                    if (!(object instanceof Account)) return;
                    Account account = (Account)object;
                    if (splitTransaction.getSourceAccountId() != account.getAccountNum()) {
                        CurrencyType currencyType = SplitEditor.this.access$6().getCurrencyType(account.getCurrencyType());
                        double d = SplitEditor.this.access$6().getRate(SplitEditor.this.access$1(), currencyType);
                        d = CurrencyType.getXRelativeRate(currencyType, SplitEditor.this.access$1(), d);
                        splitTransaction.setRate(d);
                    }
                    splitTransaction.setSourceAccountId(((Account)object).getAccountNum());
                    this.fireTableRowsUpdated(n, n);
                    return;
                }
                if (n2 == 1) {
                    splitTransaction.setDescription(object.toString());
                    return;
                }
                if (n2 == 2) {
                    String string = object.toString();
                    if (string.equals("x") || string.equals(SplitEditor.this.access$0().getResources().getString("reconciling"))) {
                        splitTransaction.setSourceClearedStatus('x');
                        return;
                    }
                    if (!string.equals("X") && !string.equals(SplitEditor.this.access$0().getResources().getString("cleared"))) {
                        splitTransaction.setSourceClearedStatus(' ');
                        return;
                    }
                    splitTransaction.setSourceClearedStatus('X');
                    return;
                }
                if (n2 == 3) {
                    splitTransaction.setAmount(StringUtils.parseCurrency((String)object, SplitEditor.this.access$4(), this.numDecimals, this.centMult));
                    SplitEditor.this.access$11();
                    return;
                }
                if (n2 != 4) return;
                Account account = SplitEditor.this.access$3().getAccountById(splitTransaction.getSourceAccountId());
                CurrencyType currencyType = SplitEditor.this.access$6().getCurrencyType(account.getCurrencyType());
                double d = CurrencyType.getXRelativeRate(currencyType, SplitEditor.this.access$1(), StringUtils.parseRate((String)object, SplitEditor.this.access$4()));
                splitTransaction.setRate(d);
                return;
            }
            catch (Exception exception) {
            }
        }

        public synchronized void addTransaction(Transaction transaction) {
            this.transactions.addElement(transaction);
            this.fireTableRowsInserted(this.transactions.size() - 1, this.transactions.size() - 1);
        }

        public synchronized void removeTransaction(int n) {
            if (n < 0 || n >= this.transactions.size()) {
                return;
            }
            this.transactions.removeElementAt(n);
            this.fireTableRowsDeleted(n, n);
        }

        public SplitTableModel() {
            this.columnNames = new String[]{SplitEditor.this.access$0().getResources().getString("txn_account"), SplitEditor.this.access$0().getResources().getString("txn_payee"), SplitEditor.this.access$0().getResources().getString("txn_status"), SplitEditor.this.access$0().getResources().getString("txn_amount"), SplitEditor.this.access$0().getResources().getString("txn_rate")};
            this.lastEditedRow = -1;
            this.longValues = new Object[]{"Maximum Length Account-----------", "Maximum Length Payee-----", "Status-----", new Integer(20), "8.888888888"};
            this.numDecimals = SplitEditor.this.access$1().getDecimalPlaces();
            this.centMult = (int)Math.round(Math.pow(10.0, this.numDecimals));
            this.transactions = new Vector();
        }
    }
}

