/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.TransactionRenderer;
import com.seanreilly.awt.AwtUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SelectChecksWindow
extends JDialog
implements ActionListener {
    private JButton okButton;
    private JButton cancelButton;
    private JList checkList;
    private Vector allChecks;
    private Object[] selectedValues = null;
    private MoneydanceGUI mdGUI;

    public Vector getSelectedChecks() {
        if (this.selectedValues == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < this.selectedValues.length) {
            vector.addElement(this.selectedValues[n]);
            ++n;
        }
        return vector;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.selectedValues = this.checkList.getSelectedValues();
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.selectedValues = null;
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SelectChecksWindow(MoneydanceGUI moneydanceGUI, Account account, Vector vector, Vector vector2) {
        super(moneydanceGUI.getTopLevelFrame(), moneydanceGUI.getResources().getString("printchk_select_checks"), true);
        this.allChecks = vector;
        this.mdGUI = moneydanceGUI;
        this.setDefaultCloseOperation(0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        this.getContentPane().add(jPanel);
        this.checkList = new JList(vector);
        TransactionRenderer transactionRenderer = new TransactionRenderer(account, moneydanceGUI, false, true, Color.white, Color.white, "", null);
        this.checkList.setCellRenderer(transactionRenderer);
        this.checkList.setSelectionMode(2);
        JScrollPane jScrollPane = new JScrollPane(this.checkList);
        jScrollPane.setColumnHeaderView(transactionRenderer.getHeaderRenderer(this.checkList));
        Vector<Integer> vector3 = new Vector<Integer>();
        int n = 0;
        while (n < vector2.size()) {
            Object e = vector2.elementAt(n);
            int n2 = vector.indexOf(e);
            if (n2 < 0) {
                vector2.removeElementAt(n);
                --n;
            } else if (!vector3.contains(new Integer(n2))) {
                vector3.addElement(new Integer(n2));
            }
            ++n;
        }
        int[] nArray = new int[vector3.size()];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = (Integer)vector3.elementAt(n3);
            ++n3;
        }
        this.checkList.setSelectedIndices(nArray);
        this.okButton = new JButton(moneydanceGUI.getResources().getString("ok"));
        this.cancelButton = new JButton(moneydanceGUI.getResources().getString("cancel"));
        jPanel.add((Component)new JLabel("   "), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printchk_select_checks")), AwtUtil.getConstraints(1, 1, 1.0f, 0.0f, 2, 1, true, false));
        jPanel.add((Component)jScrollPane, AwtUtil.getConstraints(1, 2, 1.0f, 1.0f, 2, 1, true, true));
        jPanel.add((Component)new JLabel("   "), AwtUtil.getConstraints(1, 3, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.okButton, AwtUtil.getConstraints(1, 4, 1.0f, 1.0f, 1, 1, false, false));
        jPanel.add((Component)this.cancelButton, AwtUtil.getConstraints(2, 4, 1.0f, 1.0f, 1, 1, false, false));
        jPanel.add((Component)new JLabel("   "), AwtUtil.getConstraints(3, 5, 0.0f, 0.0f, 1, 1, true, true));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.pack();
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(400, dimension.height + 40);
        try {
            JFrame jFrame = moneydanceGUI.getTopLevelFrame();
            Dimension dimension2 = jFrame.getSize();
            Point point = jFrame.getLocation();
            ((Component)this).setLocation(point.x + dimension2.width / 2 - dimension.width / 2, point.y + dimension2.height / 2 - dimension.height / 2);
            return;
        }
        catch (Exception exception) {
            if (!Main.DEBUG) return;
            exception.printStackTrace(System.err);
        }
    }
}

