/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.ExpenseAccount;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.view.Resources;
import com.seanreilly.apps.moneydance.view.gui.AccountKeySelectionManager;
import com.seanreilly.apps.moneydance.view.gui.AccountListModel;
import com.seanreilly.apps.moneydance.view.gui.AccountTreeCellRenderer;
import com.seanreilly.apps.moneydance.view.gui.EditTransactionListener;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.SplitEditor;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JCurrencyField;
import com.seanreilly.awt.JDateField;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class ReminderTxnEditPanel
extends JPanel
implements ActionListener,
FocusListener,
ItemListener {
    private JDateField dateField;
    private JDateField taxableDateField;
    private JComboBox primaryAcctChoice;
    private JComboBox secondaryAcctChoice;
    private JTextField descriptionField;
    private JCurrencyField debitAmountField;
    private JCurrencyField creditAmountField;
    private JComboBox checkNumField;
    private JTextArea memoField;
    private AccountListModel primaryAccountModel;
    private AccountListModel secondaryAccountModel;
    private JButton splitsButton;
    private boolean commitMode = false;
    private EditTransactionListener listener = this.listener;
    private BankTransaction currentTxn;
    private RootAccount rootAccount;
    private Vector splits = null;
    private String splitStr;
    private MoneydanceGUI moneydanceGUI;
    private boolean editingSplits = false;

    private final long getTransactionAmount() {
        long l = 0L;
        l -= this.debitAmountField.getValue();
        return l += this.creditAmountField.getValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void populateFields(BankTransaction bankTransaction) {
        String string;
        this.currentTxn = bankTransaction;
        this.secondaryAcctChoice.setEnabled(true);
        Account account = this.rootAccount.getAccountById(bankTransaction.getDestAccountId());
        if (account != null) {
            this.primaryAcctChoice.setSelectedItem(account);
        } else {
            try {
                this.primaryAcctChoice.setSelectedIndex(0);
            }
            catch (Exception exception) {
            }
        }
        if (bankTransaction.getSplitCount() > 0) {
            this.secondaryAcctChoice.setEnabled(false);
            this.secondaryAccountModel.setSelectedAccount(null);
        } else {
            int n = bankTransaction.getSourceAccountId();
            if (n < 0) {
                if (this.secondaryAccountModel.getSize() <= 0) {
                    this.rootAccount.addSubAccount(new ExpenseAccount("", -1, this.rootAccount.getCurrencyTable().getBaseType().getID(), null, null, this.rootAccount));
                }
                this.secondaryAccountModel.setSelectedAccountIndex(0);
            } else {
                this.secondaryAccountModel.setSelectedAccount(this.rootAccount.getAccountById(n));
            }
        }
        this.secondaryAcctChoice.repaint();
        if (this.commitMode) {
            if (bankTransaction.getDate() > 0L) {
                this.dateField.setDate(new Date(bankTransaction.getDate()));
            } else {
                this.dateField.setDate(new Date());
            }
            if (bankTransaction.getTaxableDate() > 0L) {
                this.taxableDateField.setDate(new Date(bankTransaction.getTaxableDate()));
            } else {
                this.taxableDateField.setDate(new Date());
            }
        }
        this.descriptionField.setText(bankTransaction.getDescription());
        this.checkNumField.setSelectedItem(bankTransaction.getCheckNumber());
        if (this.commitMode && (string = String.valueOf(this.checkNumField.getSelectedItem())).startsWith("<") && string.endsWith(">")) {
            this.checkNumField.setSelectedItem(account.getNextCheckNumber());
        }
        this.memoField.setText(bankTransaction.getMemo());
        long l = bankTransaction.getAmount();
        if (l <= 0L) {
            this.debitAmountField.setValue(l * -1L);
            this.creditAmountField.setText("");
        } else {
            this.debitAmountField.setText("");
            this.creditAmountField.setValue(l);
        }
        this.splits = new Vector();
        int n = 0;
        while (n < bankTransaction.getSplitCount()) {
            SplitTransaction splitTransaction = bankTransaction.getSplit(n).duplicate();
            splitTransaction.resetDirty();
            this.splits.addElement(splitTransaction);
            ++n;
        }
        this.setSplitsLabel();
        if (this.splits.size() > 0) {
            this.debitAmountField.setEnabled(false);
            this.creditAmountField.setEnabled(false);
            return;
        }
        this.debitAmountField.setEnabled(true);
        this.creditAmountField.setEnabled(true);
    }

    public synchronized boolean saveTransaction(BankTransaction bankTransaction) {
        Account account = (Account)this.primaryAcctChoice.getSelectedItem();
        if (account == null) {
            this.primaryAcctChoice.setSelectedIndex(0);
        }
        account = (Account)this.primaryAcctChoice.getSelectedItem();
        int n = 0;
        while (n < this.splits.size()) {
            SplitTransaction splitTransaction = (SplitTransaction)this.splits.elementAt(n);
            if (splitTransaction.getSourceAccountId() == account.getAccountNum()) {
                this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("split_acct_conflict"));
                return false;
            }
            ++n;
        }
        if (this.commitMode) {
            bankTransaction.setDate(this.dateField.getDate().getTime());
            bankTransaction.setTaxableDate(this.taxableDateField.getDate().getTime());
        }
        bankTransaction.setDescription(this.descriptionField.getText());
        long l = this.getTransactionAmount();
        bankTransaction.setCheckNumber(String.valueOf(this.checkNumField.getSelectedItem()));
        bankTransaction.setMemo(this.memoField.getText());
        while (bankTransaction.getSplitCount() > 0) {
            bankTransaction.removeSplit(0);
        }
        if (this.splits == null) {
            this.splits = new Vector();
        }
        int n2 = 0;
        while (n2 < this.splits.size()) {
            bankTransaction.addSplit((SplitTransaction)this.splits.elementAt(n2));
            ++n2;
        }
        bankTransaction.setDestAccountId(account.getAccountNum());
        if (bankTransaction.getSplitCount() <= 0) {
            Account account2 = (Account)this.secondaryAcctChoice.getSelectedItem();
            if (account2 == null) {
                this.secondaryAcctChoice.setSelectedIndex(0);
            }
            account2 = (Account)this.secondaryAcctChoice.getSelectedItem();
            bankTransaction.setSourceAccountId(account2.getAccountNum());
        } else {
            bankTransaction.setSourceAccountId(-1);
        }
        bankTransaction.setRate(1.0);
        bankTransaction.setAmount(l);
        this.populateFields(bankTransaction);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final synchronized void editSplits() {
        if (this.editingSplits) {
            return;
        }
        try {
            this.editingSplits = true;
            SplitEditor splitEditor = new SplitEditor(this.moneydanceGUI.getTopLevelFrame(), this.currentTxn, this.rootAccount, this.moneydanceGUI, (Account)this.primaryAcctChoice.getSelectedItem(), false);
            Vector vector = new Vector();
            if (this.splits == null) {
                this.splits = new Vector();
            }
            Enumeration enumeration = this.splits.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            splitEditor.setSplits(vector);
            ((Component)splitEditor).setVisible(true);
            if (!splitEditor.wasCancelled()) {
                long l = 0L;
                this.splits = splitEditor.getSplits();
                Enumeration enumeration2 = this.splits.elements();
                while (enumeration2.hasMoreElements()) {
                    SplitTransaction splitTransaction = (SplitTransaction)enumeration2.nextElement();
                    l += splitTransaction.getAmount();
                }
                if (this.splits.size() <= 0) {
                    this.secondaryAcctChoice.setEnabled(true);
                    this.debitAmountField.setEnabled(true);
                    this.creditAmountField.setEnabled(true);
                    if (this.secondaryAcctChoice.getSelectedItem() == null) {
                        int n = this.currentTxn.getSourceAccountId();
                        if (n >= 0) {
                            this.secondaryAccountModel.setSelectedAccount(this.rootAccount.getAccountById(n));
                        } else {
                            this.secondaryAccountModel.setSelectedAccountIndex(0);
                        }
                    }
                    this.debitAmountField.setEnabled(true);
                    this.creditAmountField.setEnabled(true);
                } else {
                    this.secondaryAcctChoice.setEnabled(false);
                    this.secondaryAccountModel.setSelectedAccount(null);
                    this.creditAmountField.setEnabled(false);
                    this.debitAmountField.setEnabled(false);
                }
                this.secondaryAcctChoice.repaint();
                if (l <= 0L) {
                    this.debitAmountField.setValue(l * -1L);
                    this.creditAmountField.setText("");
                } else {
                    this.debitAmountField.setText("");
                    this.creditAmountField.setValue(l);
                }
            }
            this.setSplitsLabel();
            Object var2_8 = null;
            this.editingSplits = false;
            return;
        }
        catch (Throwable throwable) {
            Object var2_9 = null;
            this.editingSplits = false;
            throw throwable;
        }
    }

    private final void setSplitsLabel() {
        if (this.splits != null && this.splits.size() > 0) {
            this.splitsButton.setLabel(this.splitStr + " (" + this.splits.size() + ")");
        } else {
            this.splitsButton.setLabel(this.splitStr);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string;
        if (itemEvent.getSource() == this.primaryAccountModel) {
            Account account = (Account)itemEvent.getItem();
            if (account == this.secondaryAccountModel.getSelectedItem()) {
                this.secondaryAccountModel.setSelectedAccountIndex(0);
            }
            this.secondaryAccountModel.clearDontShowAccounts();
            this.secondaryAccountModel.setShowAccount(account, false);
            Account account2 = (Account)this.primaryAcctChoice.getSelectedItem();
            CurrencyType currencyType = this.rootAccount.getCurrencyTable().getCurrencyType(account2.getCurrencyType());
            this.debitAmountField.setCurrencyType(currencyType);
            this.creditAmountField.setCurrencyType(currencyType);
        } else if (itemEvent.getSource() == this.checkNumField && this.commitMode && (string = String.valueOf(this.checkNumField.getSelectedItem())).startsWith("<") && string.endsWith(">")) {
            Account account = (Account)this.primaryAcctChoice.getSelectedItem();
            this.checkNumField.setSelectedItem(account.getNextCheckNumber());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.splitsButton) {
            this.editSplits();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof JTextComponent) {
            ((JTextComponent)focusEvent.getSource()).selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void goneAway() {
        this.primaryAccountModel.goneAway();
        this.secondaryAccountModel.goneAway();
    }

    public ReminderTxnEditPanel(MoneydanceGUI moneydanceGUI, RootAccount rootAccount, boolean bl) {
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.commitMode = bl;
        Resources resources = this.moneydanceGUI.getResources();
        UserPreferences userPreferences = Main.getMainController().getPreferences();
        char c = userPreferences.getDecimalChar();
        char c2 = c == ',' ? (char)'.' : ',';
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel(gridBagLayout);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        JPanel jPanel5 = new JPanel(gridBagLayout);
        this.primaryAccountModel = new AccountListModel(rootAccount);
        this.primaryAccountModel.setShowAccountsOfType(0, false);
        this.primaryAccountModel.setShowAccountsOfType(1, true);
        this.primaryAccountModel.setShowAccountsOfType(2, true);
        this.primaryAccountModel.setShowAccountsOfType(3, true);
        this.primaryAccountModel.setShowAccountsOfType(4, false);
        this.primaryAccountModel.setShowAccountsOfType(5, false);
        this.primaryAcctChoice = new JComboBox(this.primaryAccountModel);
        this.primaryAcctChoice.setEditable(false);
        this.secondaryAccountModel = new AccountListModel(rootAccount);
        this.secondaryAccountModel.setShowAccount((Account)this.primaryAccountModel.getSelectedItem(), false);
        this.secondaryAcctChoice = new JComboBox(this.secondaryAccountModel);
        this.secondaryAcctChoice.setEditable(false);
        AccountTreeCellRenderer accountTreeCellRenderer = new AccountTreeCellRenderer(this.moneydanceGUI);
        accountTreeCellRenderer.setRealBackground(this.getBackground());
        this.secondaryAcctChoice.setRenderer(accountTreeCellRenderer);
        this.secondaryAcctChoice.setKeySelectionManager(new AccountKeySelectionManager());
        this.primaryAcctChoice.setRenderer(accountTreeCellRenderer);
        this.primaryAcctChoice.setKeySelectionManager(new AccountKeySelectionManager());
        this.descriptionField = new JTextField(25);
        Account account = (Account)this.primaryAcctChoice.getSelectedItem();
        CurrencyTable currencyTable = rootAccount.getCurrencyTable();
        CurrencyType currencyType = currencyTable.getCurrencyType(account.getCurrencyType());
        this.debitAmountField = new JCurrencyField(currencyType, currencyTable, c, c2);
        this.creditAmountField = new JCurrencyField(currencyType, currencyTable, c, c2);
        this.checkNumField = new JComboBox<String>(new String[]{resources.getString("chknum_dep"), resources.getString("chknum_transfer"), resources.getString("chknum_atm"), "{" + resources.getString("chknum_print") + "}", "<" + resources.getString("chknum_nextchecknum") + ">"});
        this.checkNumField.setEditable(true);
        this.memoField = new JTextArea(3, 10);
        this.memoField.setLineWrap(true);
        if (bl) {
            this.dateField = new JDateField(userPreferences.getShortDateFormatter());
            this.dateField.setDate(new Date());
            this.taxableDateField = new JDateField(userPreferences.getShortDateFormatter());
            this.taxableDateField.setDate(new Date());
        }
        this.splitStr = resources.getString("split_txn");
        this.splitsButton = new JButton(this.splitStr);
        this.add((Component)jPanel4, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 1, 1, true, true));
        this.add((Component)new JLabel("  "), AwtUtil.getConstraints(1, 1, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)jPanel3, AwtUtil.getConstraints(2, 1, 1.0f, 0.0f, 1, 1, true, true));
        if (bl) {
            jPanel4.add((Component)new JLabel(resources.getString("r_txn_primacct") + ": ", 4), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
            jPanel4.add((Component)this.primaryAcctChoice, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, true, true));
            jPanel4.add((Component)new JLabel(resources.getString("txn_checknum") + ": ", 4), AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, true));
            jPanel4.add((Component)this.checkNumField, AwtUtil.getConstraints(1, 1, 1.0f, 0.0f, 1, 1, true, true));
            jPanel3.add((Component)new JLabel(resources.getString("txn_date") + ": ", 4), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
            jPanel3.add((Component)this.dateField, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, true, true));
            jPanel3.add((Component)new JLabel(resources.getString("txn_tax_date") + ": ", 4), AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, true));
            jPanel3.add((Component)this.taxableDateField, AwtUtil.getConstraints(1, 1, 1.0f, 0.0f, 1, 1, true, true));
        } else {
            jPanel4.add((Component)new JLabel(resources.getString("r_txn_primacct") + ": ", 4), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
            jPanel4.add((Component)this.primaryAcctChoice, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, true, true));
            jPanel3.add((Component)new JLabel(resources.getString("txn_checknum") + ": ", 4), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
            jPanel3.add((Component)this.checkNumField, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, true, true));
        }
        this.add((Component)jPanel5, AwtUtil.getConstraints(0, 2, 1.0f, 1.0f, 3, 1, true, true));
        jPanel5.add((Component)new JLabel(resources.getString("txn_payee") + ": ", 2), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 2, 1, true, true));
        JPanel jPanel6 = new JPanel(new GridLayout(1, 2));
        jPanel6.setOpaque(false);
        jPanel6.add(new JLabel(resources.getString("txn_debit") + ": ", 2));
        jPanel6.add(new JLabel(resources.getString("txn_credit") + ": ", 2));
        jPanel5.add((Component)jPanel6, AwtUtil.getConstraints(2, 0, 0.0f, 0.0f, 2, 1, true, true));
        jPanel5.add((Component)this.descriptionField, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 2, 1, true, true));
        jPanel6 = new JPanel(new GridLayout(1, 2));
        jPanel6.setOpaque(false);
        jPanel6.add(this.debitAmountField);
        jPanel6.add(this.creditAmountField);
        jPanel5.add((Component)jPanel6, AwtUtil.getConstraints(2, 1, 0.0f, 0.0f, 2, 1, true, true));
        jPanel5.add((Component)new JLabel(resources.getString("r_txn_secacct") + ": "), AwtUtil.getConstraints(0, 2, 0.0f, 0.0f, 1, 1, true, true));
        jPanel5.add((Component)this.secondaryAcctChoice, AwtUtil.getConstraints(1, 2, 1.0f, 0.0f, 1, 1, true, true));
        jPanel5.add((Component)new JLabel(resources.getString("txn_memo") + ": ", 2), AwtUtil.getConstraints(0, 3, 0.0f, 0.0f, 1, 1, true, true));
        JPanel jPanel7 = new JPanel(gridBagLayout);
        this.add((Component)jPanel7, AwtUtil.getConstraints(0, 4, 1.0f, 1.0f, 3, 1, true, true));
        JScrollPane jScrollPane = new JScrollPane(this.memoField);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel7.add((Component)jScrollPane, AwtUtil.getConstraints(0, 0, 1.0f, 2.0f, 1, 1, true, true));
        jPanel7.add((Component)this.splitsButton, AwtUtil.getConstraints(1, 0, 0.0f, 1.0f, 1, 1, true, false, 15));
        Color color = new Color(userPreferences.getIntSetting("gui.txn_edit_bg", 0x65FFFF));
        this.setBackground(color);
        jPanel.setOpaque(false);
        jPanel3.setOpaque(false);
        jPanel4.setOpaque(false);
        jPanel2.setOpaque(false);
        jPanel5.setOpaque(false);
        jPanel7.setOpaque(false);
        this.splitsButton.addActionListener(this);
        this.splitsButton.setMnemonic('s');
        this.splitsButton.registerKeyboardAction(this, "edit_transaction_splits", KeyStroke.getKeyStroke(83, 2), 2);
        this.descriptionField.addFocusListener(this);
        this.checkNumField.addFocusListener(this);
        this.memoField.addFocusListener(this);
        this.secondaryAccountModel.addItemListener(this);
        this.checkNumField.addItemListener(this);
        this.primaryAccountModel.addItemListener(this);
    }
}

