/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JRateField;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class RateEditor
extends JPanel
implements ItemListener {
    private CurrencyTable currencyTable;
    private MoneydanceGUI moneydanceGUI;
    private JComboBox rateDirectionChoice;
    private JRateField rateField;
    private CurrencyType currency1 = null;
    private CurrencyType currency2 = null;
    private DefaultComboBoxModel choiceModel = new DefaultComboBoxModel();
    private int lastDirection = 0;
    private char dec;
    private char com;

    public synchronized void setValue(CurrencyType currencyType, CurrencyType currencyType2, double d) {
        this.currency1 = currencyType;
        this.currency2 = currencyType2;
        if (d == 0.0) {
            d = 1.0E-9;
        }
        if (this.rateDirectionChoice.getSelectedIndex() <= 0) {
            this.rateField.setValue(d);
        } else {
            this.rateField.setValue(1.0 / d);
        }
        this.resetDirectionChoice();
        this.validate();
    }

    public synchronized double getValue() {
        if (this.rateDirectionChoice.getSelectedIndex() == 0) {
            return this.rateField.getValue();
        }
        return 1.0 / this.rateField.getValue();
    }

    private final void resetDirectionChoice() {
        if (this.currency1 == null || this.currency2 == null || this.currency2.getID().equals(this.currency1.getID())) {
            this.rateField.setValue(1.0);
            this.rateField.setEditable(false);
            this.rateDirectionChoice.setEnabled(false);
            return;
        }
        this.rateField.setEditable(true);
        this.rateDirectionChoice.setEnabled(true);
        int n = this.rateDirectionChoice.getSelectedIndex();
        this.choiceModel.insertElementAt(this.currency1.getID() + '/' + this.currency2.getID(), 0);
        if (this.choiceModel.getSize() > 2) {
            this.choiceModel.removeElementAt(1);
        }
        this.choiceModel.insertElementAt(this.currency2.getID() + '/' + this.currency1.getID(), 1);
        if (this.choiceModel.getSize() > 2) {
            this.choiceModel.removeElementAt(2);
        }
        if (n >= 0) {
            this.rateDirectionChoice.setSelectedIndex(n);
        } else {
            this.rateDirectionChoice.setSelectedIndex(0);
        }
    }

    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.rateDirectionChoice) {
            int n = this.rateDirectionChoice.getSelectedIndex();
            if (n != this.lastDirection) {
                double d = this.rateField.getValue();
                if (d == 0.0) {
                    d = 1.0E-8;
                }
                this.rateField.setValue(1.0 / d);
            }
            this.lastDirection = n;
        }
    }

    public RateEditor(MoneydanceGUI moneydanceGUI, CurrencyTable currencyTable) {
        this.currencyTable = currencyTable;
        this.moneydanceGUI = moneydanceGUI;
        this.setLayout(new GridBagLayout());
        this.dec = Main.getMainController().getPreferences().getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        this.rateField = new JRateField(this.dec);
        this.rateDirectionChoice = new JComboBox(this.choiceModel);
        int n = 0;
        this.add((Component)this.rateField, AwtUtil.getConstraints(1, n, 1.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.rateDirectionChoice, AwtUtil.getConstraints(2, n++, 0.0f, 0.0f, 1, 1, true, true));
        this.rateDirectionChoice.addItemListener(this);
        this.resetDirectionChoice();
    }
}

