/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.view.gui.CalibratePrinterWindow;
import com.seanreilly.apps.moneydance.view.gui.CheckPrinter;
import com.seanreilly.apps.moneydance.view.gui.LastPrintedCheckWindow;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.SelectChecksWindow;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JDateField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class PrintChecksWindow
extends JDialog
implements ActionListener,
ItemListener {
    private JTextField firstCheckNumField;
    private JRadioButton allChecksRadioButton;
    private JRadioButton checksThroughRadioButton;
    private JRadioButton selectedChecksRadioButton;
    private JButton selectChecksButton;
    private JDateField checksDateField;
    private JRadioButton oneCheckFPRadioButton;
    private JRadioButton twoCheckFPRadioButton;
    private JRadioButton threeCheckFPRadioButton;
    private JButton printButton;
    private JButton cancelButton;
    private JButton calibrateButton;
    private MoneydanceGUI mdGUI;
    private Account account;
    private Vector toBePrinted;
    private Vector selectedChecks;
    private String checkPage1;
    private String checkPage2;
    private String checkPage3;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void printChecks() {
        long l;
        Object object;
        long l2 = -1L;
        try {
            l2 = Long.parseLong(this.firstCheckNumField.getText().trim());
        }
        catch (Exception exception) {
            this.mdGUI.showInfoMessage(this.mdGUI.getResources().getString("invalid_checknum"));
            return;
        }
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < this.toBePrinted.size()) {
            object = (Transaction)this.toBePrinted.elementAt(n);
            if (!(object instanceof BankTransaction)) {
                if (Main.DEBUG) {
                    System.err.println("cannot print non-bank transactions!!!");
                }
                this.toBePrinted.removeElementAt(n);
                --n;
            } else if (!((Transaction)object).needsToBePrinted()) {
                this.toBePrinted.removeElementAt(n);
                --n;
            } else if (this.allChecksRadioButton.isSelected()) {
                vector.addElement(object);
            } else if (this.checksThroughRadioButton.isSelected()) {
                if (this.checksDateField.getDate().getTime() + 33200000L > ((Transaction)object).getDate()) {
                    vector.addElement(object);
                }
            } else if (this.selectedChecks.contains(object)) {
                vector.addElement(object);
            }
            ++n;
        }
        if (vector.size() <= 0) {
            this.mdGUI.showInfoMessage(this.mdGUI.getResources().getString("no_checks_to_print"));
            return;
        }
        n = 3;
        if (this.twoCheckFPRadioButton.isSelected()) {
            n = 2;
        } else if (this.oneCheckFPRadioButton.isSelected()) {
            n = 1;
        }
        object = this.account.getRootAccount().getCurrencyTable();
        CurrencyType currencyType = ((CurrencyTable)object).getCurrencyType(this.account.getCurrencyType());
        CheckPrinter checkPrinter = new CheckPrinter(this.mdGUI, currencyType);
        if (!checkPrinter.initialize(n)) {
            return;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            BankTransaction bankTransaction = (BankTransaction)vector.elementAt(n2);
            checkPrinter.printCheck(bankTransaction);
            ++n2;
        }
        checkPrinter.end();
        LastPrintedCheckWindow lastPrintedCheckWindow = new LastPrintedCheckWindow(this.mdGUI, l2, l2 + (long)vector.size() - 1L);
        ((Component)lastPrintedCheckWindow).setVisible(true);
        long l3 = l = l2 + (long)vector.size() - 1L;
        if (!lastPrintedCheckWindow.allChecksPrinted()) {
            l3 = lastPrintedCheckWindow.getFirstErrorCheck() - 1L;
        }
        this.account.setParameter("next_check_to_print", String.valueOf(l + 1L));
        this.firstCheckNumField.setText(String.valueOf(l + 1L));
        int n3 = 0;
        while (n3 < vector.size()) {
            BankTransaction bankTransaction = (BankTransaction)vector.elementAt(n3);
            if ((long)n3 + l2 <= l3) {
                bankTransaction.setCheckNumber(String.valueOf(l2 + (long)n3));
                this.account.getRootAccount().getTransactionSet().transactionModified(bankTransaction);
                this.toBePrinted.removeElement(bankTransaction);
            }
            ++n3;
        }
        if (this.toBePrinted.size() <= 0) {
            ((Component)this).setVisible(false);
        }
    }

    private final void calibratePrinter() {
        CurrencyTable currencyTable = this.account.getRootAccount().getCurrencyTable();
        CurrencyType currencyType = currencyTable.getCurrencyType(this.account.getCurrencyType());
        CalibratePrinterWindow calibratePrinterWindow = new CalibratePrinterWindow(this.mdGUI, this.account, currencyType);
        ((Component)calibratePrinterWindow).setVisible(true);
    }

    private final void selectChecksToPrint() {
        SelectChecksWindow selectChecksWindow = new SelectChecksWindow(this.mdGUI, this.account, this.toBePrinted, this.selectedChecks);
        ((Component)selectChecksWindow).setVisible(true);
        Vector vector = selectChecksWindow.getSelectedChecks();
        if (vector == null) {
            return;
        }
        this.selectedChecks = vector;
    }

    private final void refreshCheckSelection() {
        this.selectChecksButton.setEnabled(false);
        this.checksDateField.setEnabled(false);
        if (!this.allChecksRadioButton.isSelected()) {
            if (this.checksThroughRadioButton.isSelected()) {
                this.checksDateField.setEnabled(true);
            } else {
                this.selectChecksButton.setEnabled(true);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.printButton) {
            this.printChecks();
        } else if (object == this.calibrateButton) {
            this.calibratePrinter();
        } else if (object == this.cancelButton) {
            ((Component)this).setVisible(false);
        } else if (object == this.selectChecksButton) {
            this.selectChecksToPrint();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.selectedChecksRadioButton || object == this.allChecksRadioButton || object == this.checksThroughRadioButton) {
            this.refreshCheckSelection();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrintChecksWindow(MoneydanceGUI moneydanceGUI, Account account, Vector vector) {
        ImageIcon imageIcon;
        ImageIcon imageIcon2;
        ImageIcon imageIcon3;
        block7: {
            super(moneydanceGUI.getTopLevelFrame(), moneydanceGUI.getResources().getString("print_checks"), true);
            this.checkPage1 = "/com/seanreilly/apps/moneydance/images/checkpage1.gif";
            this.checkPage2 = "/com/seanreilly/apps/moneydance/images/checkpage2.gif";
            this.checkPage3 = "/com/seanreilly/apps/moneydance/images/checkpage3.gif";
            this.mdGUI = moneydanceGUI;
            this.toBePrinted = vector;
            this.account = account;
            this.selectedChecks = new Vector();
            int n = 0;
            while (vector != null && n < vector.size()) {
                this.selectedChecks.addElement(vector.elementAt(n));
                ++n;
            }
            imageIcon3 = null;
            imageIcon2 = null;
            imageIcon = null;
            try {
                imageIcon3 = new ImageIcon(AwtUtil.loadImage(this.checkPage1));
                imageIcon2 = new ImageIcon(AwtUtil.loadImage(this.checkPage2));
                imageIcon = new ImageIcon(AwtUtil.loadImage(this.checkPage3));
            }
            catch (Exception exception) {
                if (!Main.DEBUG) break block7;
                exception.printStackTrace(System.err);
            }
        }
        this.oneCheckFPRadioButton = new JRadioButton(moneydanceGUI.getResources().getString("one"), false);
        this.twoCheckFPRadioButton = new JRadioButton(moneydanceGUI.getResources().getString("two"), false);
        this.threeCheckFPRadioButton = new JRadioButton(moneydanceGUI.getResources().getString("three"), true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.oneCheckFPRadioButton);
        buttonGroup.add(this.twoCheckFPRadioButton);
        buttonGroup.add(this.threeCheckFPRadioButton);
        String string = account.getParameter("next_check_to_print");
        if (string == null) {
            string = account.getNextCheckNumber();
        }
        this.firstCheckNumField = new JTextField(string);
        this.allChecksRadioButton = new JRadioButton(moneydanceGUI.getResources().getString("all_checks"), true);
        this.checksThroughRadioButton = new JRadioButton(moneydanceGUI.getResources().getString("checks_through_date"), false);
        this.selectedChecksRadioButton = new JRadioButton(moneydanceGUI.getResources().getString("selected_checks"), false);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.allChecksRadioButton);
        buttonGroup2.add(this.checksThroughRadioButton);
        buttonGroup2.add(this.selectedChecksRadioButton);
        this.checksDateField = new JDateField(Main.getMainController().getPreferences().getShortDateFormatter());
        this.checksDateField.setDate(new Date());
        this.selectChecksButton = new JButton(moneydanceGUI.getResources().getString("select_checks"));
        this.printButton = new JButton(moneydanceGUI.getResources().getString("print_all_checks"));
        this.calibrateButton = new JButton(moneydanceGUI.getResources().getString("calibrate_printer"));
        this.cancelButton = new JButton(moneydanceGUI.getResources().getString("done"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        JPanel jPanel5 = new JPanel(gridBagLayout);
        Border border = BorderFactory.createEtchedBorder();
        border = BorderFactory.createTitledBorder(border, moneydanceGUI.getResources().getString("select_checks"));
        jPanel3.setBorder(border);
        border = BorderFactory.createEtchedBorder();
        border = BorderFactory.createTitledBorder(border, moneydanceGUI.getResources().getString("checks_on_1st_page"));
        jPanel4.setBorder(border);
        this.getContentPane().add(jPanel);
        jPanel2.add((Component)new JLabel(moneydanceGUI.getResources().getString("1st_chk_num") + ":  ", 4), AwtUtil.getConstraints(0, 0, 0.5f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.firstCheckNumField, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, true, true));
        jPanel3.add((Component)this.allChecksRadioButton, AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 1, true, false));
        jPanel3.add((Component)this.checksThroughRadioButton, AwtUtil.getConstraints(0, 1, 1.0f, 1.0f, 1, 1, true, false));
        jPanel3.add((Component)this.checksDateField, AwtUtil.getConstraints(1, 1, 1.0f, 1.0f, 1, 1, true, false));
        jPanel3.add((Component)this.selectedChecksRadioButton, AwtUtil.getConstraints(0, 2, 1.0f, 1.0f, 1, 1, true, false));
        jPanel3.add((Component)this.selectChecksButton, AwtUtil.getConstraints(1, 2, 1.0f, 1.0f, 1, 1, true, false));
        jPanel4.add((Component)this.threeCheckFPRadioButton, AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 1, false, false));
        jPanel4.add((Component)new JLabel("  "), AwtUtil.getConstraints(1, 0, 1.0f, 1.0f, 1, 1, false, false));
        jPanel4.add((Component)this.twoCheckFPRadioButton, AwtUtil.getConstraints(2, 0, 1.0f, 1.0f, 1, 1, false, false));
        jPanel4.add((Component)new JLabel("  "), AwtUtil.getConstraints(3, 0, 1.0f, 1.0f, 1, 1, false, false));
        jPanel4.add((Component)this.oneCheckFPRadioButton, AwtUtil.getConstraints(4, 0, 1.0f, 1.0f, 1, 1, false, false));
        if (imageIcon3 != null && imageIcon2 != null && imageIcon != null) {
            jPanel4.add((Component)new JLabel(imageIcon), AwtUtil.getConstraints(0, 1, 1.0f, 1.0f, 1, 1, false, false));
            jPanel4.add((Component)new JLabel("  "), AwtUtil.getConstraints(1, 1, 1.0f, 1.0f, 1, 1, false, false));
            jPanel4.add((Component)new JLabel(imageIcon2), AwtUtil.getConstraints(2, 1, 1.0f, 1.0f, 1, 1, false, false));
            jPanel4.add((Component)new JLabel("  "), AwtUtil.getConstraints(3, 1, 1.0f, 1.0f, 1, 1, false, false));
            jPanel4.add((Component)new JLabel(imageIcon3), AwtUtil.getConstraints(4, 1, 1.0f, 1.0f, 1, 1, false, false));
        }
        jPanel5.add((Component)this.printButton, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel5.add((Component)this.calibrateButton, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel5.add((Component)this.cancelButton, AwtUtil.getConstraints(2, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel.add((Component)new JLabel(" "), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)jPanel2, AwtUtil.getConstraints(1, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)new JLabel(" "), AwtUtil.getConstraints(1, 2, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)jPanel3, AwtUtil.getConstraints(1, 3, 1.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)new JLabel(" "), AwtUtil.getConstraints(1, 4, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)jPanel4, AwtUtil.getConstraints(1, 5, 1.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)new JLabel(" "), AwtUtil.getConstraints(1, 6, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)jPanel5, AwtUtil.getConstraints(1, 7, 1.0f, 0.0f, 1, 1, true, true));
        this.calibrateButton.addActionListener(this);
        this.printButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.selectChecksButton.addActionListener(this);
        this.allChecksRadioButton.addItemListener(this);
        this.checksThroughRadioButton.addItemListener(this);
        this.selectedChecksRadioButton.addItemListener(this);
        this.refreshCheckSelection();
        this.pack();
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension);
        try {
            JFrame jFrame = moneydanceGUI.getTopLevelFrame();
            Dimension dimension2 = jFrame.getSize();
            Point point = jFrame.getLocation();
            ((Component)this).setLocation(point.x + dimension2.width / 2 - dimension.width / 2, point.y + dimension2.height / 2 - dimension.height / 2);
            return;
        }
        catch (Exception exception) {
            if (!Main.DEBUG) return;
            exception.printStackTrace(System.err);
        }
    }
}

