/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Common;
import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PreferencesWindow
extends JDialog
implements ActionListener {
    private JCheckBox confirmTxnChangesCheckBox;
    private JCheckBox checkVersionCheckBox;
    private JCheckBox beepOnTxnChangeCheckBox;
    private JCheckBox restoreDesktopCheckBox;
    private JCheckBox fullAcctPathCheckBox;
    private JCheckBox seekRecordedTxnCheckBox;
    private JCheckBox newTxnOnRecordCheckBox;
    private JComboBox dateFormatChoice;
    private JComboBox timeFormatChoice;
    private JComboBox decimalCharChoice;
    private JComboBox localeChoice;
    private JComboBox lookAndFeelChoice;
    private JButton acctBgButton;
    private JButton acctFgButton;
    private JButton hpBgButton;
    private JButton txnList1BgButton;
    private JButton txnList2BgButton;
    private JButton txnEditBgButton;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private String[] localeCountries = new String[]{"us", "fr", "br", "uk", "it", "de"};
    private String[] localeLanguages = new String[]{"EN", "FR", "PT", "EN", "IT", "DE"};
    private String[] localeNames = new String[]{"US English", "French", "Brazil/Portuguese", "UK English", "Italian", "German"};
    private String[] lookAndFeelNames;
    private MoneydanceGUI moneydanceGUI;
    private JFrame parentFrame;
    private ResourceBundle resources;

    private final void populateFields() {
        UserPreferences userPreferences = Main.getMainController().getPreferences();
        this.acctFgButton.setBackground(new Color(userPreferences.getIntSetting("gui.acct_header_fg", 0xFFFF00)));
        this.acctBgButton.setBackground(new Color(userPreferences.getIntSetting("gui.acct_header_bg", 7931521)));
        this.hpBgButton.setBackground(new Color(userPreferences.getIntSetting("gui.homepage_bg", 0xFFFFFF)));
        this.txnList1BgButton.setBackground(new Color(userPreferences.getIntSetting("gui.txn_list_color1", 0xFFFFFF)));
        this.txnList2BgButton.setBackground(new Color(userPreferences.getIntSetting("gui.txn_list_color2", 0x65FFFF)));
        this.txnEditBgButton.setBackground(new Color(userPreferences.getIntSetting("gui.txn_edit_bg", 0x65FFFF)));
        if (userPreferences.getSetting("gui.register_follows_txns", "y").equals("y")) {
            this.seekRecordedTxnCheckBox.setSelected(true);
        } else {
            this.seekRecordedTxnCheckBox.setSelected(false);
        }
        if (userPreferences.getSetting("confirm_transaction_changes", "y").equals("y")) {
            this.confirmTxnChangesCheckBox.setSelected(true);
        } else {
            this.confirmTxnChangesCheckBox.setSelected(false);
        }
        if (userPreferences.getSetting("show_full_account_path", "n").equals("y")) {
            this.fullAcctPathCheckBox.setSelected(true);
        } else {
            this.fullAcctPathCheckBox.setSelected(false);
        }
        if (userPreferences.getSetting("check_version_at_startup", "n").equals("y")) {
            this.checkVersionCheckBox.setSelected(true);
        } else {
            this.checkVersionCheckBox.setSelected(false);
        }
        if (userPreferences.getSetting("beep_on_transaction_change", "y").equals("y")) {
            this.beepOnTxnChangeCheckBox.setSelected(true);
        } else {
            this.beepOnTxnChangeCheckBox.setSelected(false);
        }
        if (userPreferences.getSetting("restore_desktop_on_startup", "y").equals("y")) {
            this.restoreDesktopCheckBox.setSelected(true);
        } else {
            this.restoreDesktopCheckBox.setSelected(false);
        }
        if (userPreferences.getSetting("gui.new_txn_on_record", "y").equals("y")) {
            this.newTxnOnRecordCheckBox.setSelected(true);
        } else {
            this.newTxnOnRecordCheckBox.setSelected(false);
        }
        this.decimalCharChoice.setSelectedItem(new Character(userPreferences.getDecimalChar()));
        this.dateFormatChoice.setSelectedItem(userPreferences.getSetting("date_format", "MM/dd/yyyy"));
        this.timeFormatChoice.setSelectedItem(userPreferences.getSetting("time_format", "h:mm a"));
        String string = userPreferences.getSetting("locale.country", "us");
        String string2 = userPreferences.getSetting("locale.language", "EN");
        int n = -1;
        int n2 = 0;
        while (n2 < this.localeCountries.length) {
            if (this.localeCountries[n2].equals(string)) {
                n = n2;
                if (this.localeLanguages[n2].equals(string2)) {
                    n = n2;
                    break;
                }
            }
            ++n2;
        }
        if (n < 0) {
            this.localeChoice.setSelectedIndex(0);
        } else {
            this.localeChoice.setSelectedIndex(n);
        }
        String string3 = userPreferences.getSetting("look_and_feel", "metal");
        if (string3.equals("windows")) {
            this.lookAndFeelChoice.setSelectedIndex(2);
        } else if (string3.equals("motif")) {
            this.lookAndFeelChoice.setSelectedIndex(1);
        } else {
            this.lookAndFeelChoice.setSelectedIndex(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void saveFields() {
        UserPreferences userPreferences;
        block29: {
            int n;
            Character c;
            String string;
            userPreferences = Main.getMainController().getPreferences();
            if (this.seekRecordedTxnCheckBox.isSelected()) {
                userPreferences.setSetting("gui.register_follows_txns", "y");
            } else {
                userPreferences.setSetting("gui.register_follows_txns", "n");
            }
            if (this.confirmTxnChangesCheckBox.isSelected()) {
                userPreferences.setSetting("confirm_transaction_changes", "y");
            } else {
                userPreferences.setSetting("confirm_transaction_changes", "n");
            }
            if (this.fullAcctPathCheckBox.isSelected()) {
                userPreferences.setSetting("show_full_account_path", "y");
            } else {
                userPreferences.setSetting("show_full_account_path", "n");
            }
            if (this.checkVersionCheckBox.isSelected()) {
                userPreferences.setSetting("check_version_at_startup", "y");
            } else {
                userPreferences.setSetting("check_version_at_startup", "n");
            }
            if (this.beepOnTxnChangeCheckBox.isSelected()) {
                userPreferences.setSetting("beep_on_transaction_change", "y");
            } else {
                userPreferences.setSetting("beep_on_transaction_change", "n");
            }
            if (this.restoreDesktopCheckBox.isSelected()) {
                userPreferences.setSetting("restore_desktop_on_startup", "y");
            } else {
                userPreferences.setSetting("restore_desktop_on_startup", "n");
            }
            if (this.newTxnOnRecordCheckBox.isSelected()) {
                userPreferences.setSetting("gui.new_txn_on_record", "y");
            } else {
                userPreferences.setSetting("gui.new_txn_on_record", "n");
            }
            String string2 = (String)this.dateFormatChoice.getSelectedItem();
            if (string2 != null) {
                userPreferences.setSetting("date_format", string2);
            }
            if ((string = (String)this.timeFormatChoice.getSelectedItem()) != null) {
                userPreferences.setSetting("time_format", string);
            }
            if ((c = (Character)this.decimalCharChoice.getSelectedItem()) != null) {
                userPreferences.setSetting("decimal_character", c.toString());
            }
            if ((n = this.localeChoice.getSelectedIndex()) >= 0) {
                userPreferences.setSetting("locale.country", this.localeCountries[n]);
                userPreferences.setSetting("locale.language", this.localeLanguages[n]);
            }
            userPreferences.setSetting("gui.acct_header_fg", String.valueOf(this.acctFgButton.getBackground().getRGB()));
            userPreferences.setSetting("gui.acct_header_bg", String.valueOf(this.acctBgButton.getBackground().getRGB()));
            userPreferences.setSetting("gui.homepage_bg", String.valueOf(this.hpBgButton.getBackground().getRGB()));
            userPreferences.setSetting("gui.txn_list_color1", String.valueOf(this.txnList1BgButton.getBackground().getRGB()));
            userPreferences.setSetting("gui.txn_list_color2", String.valueOf(this.txnList2BgButton.getBackground().getRGB()));
            userPreferences.setSetting("gui.txn_edit_bg", String.valueOf(this.txnEditBgButton.getBackground().getRGB()));
            int n2 = this.lookAndFeelChoice.getSelectedIndex();
            String string3 = userPreferences.getSetting("look_and_feel", "metal");
            if (n2 < 0) {
                n2 = 0;
            }
            try {
                String string4 = string3;
                if (n2 == 0) {
                    string4 = "metal";
                    if (!string3.equals("metal")) {
                        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                        SwingUtilities.updateComponentTreeUI(this.moneydanceGUI.getTopLevelFrame());
                    }
                    userPreferences.setSetting("look_and_feel", "metal");
                    break block29;
                }
                if (n2 == 1) {
                    if (!string3.equals("motif")) {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                        SwingUtilities.updateComponentTreeUI(this.moneydanceGUI.getTopLevelFrame());
                    }
                    userPreferences.setSetting("look_and_feel", "motif");
                    break block29;
                }
                if (n2 == 2 && !string3.equals("windows")) {
                    if (!string3.equals("windows")) {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                        SwingUtilities.updateComponentTreeUI(this.moneydanceGUI.getTopLevelFrame());
                    }
                    userPreferences.setSetting("look_and_feel", "windows");
                }
            }
            catch (Exception exception) {
                this.moneydanceGUI.showErrorMessage(this.resources.getString("unable_to_set_laf"));
            }
        }
        try {
            userPreferences.writeSettings(Common.getPreferencesFile());
            userPreferences.firePreferencesUpdated();
            return;
        }
        catch (Exception exception) {
            this.moneydanceGUI.showErrorMessage("Error saving preferences: " + exception.getMessage());
            exception.printStackTrace(System.err);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.saveFields();
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (object == this.cancelButton) {
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (object == this.acctFgButton) {
            this.editColor((JButton)object, this.resources.getString("pref_acct_fg_col"));
        } else if (object == this.acctBgButton) {
            this.editColor((JButton)object, this.resources.getString("pref_acct_bg_col"));
        } else if (object == this.hpBgButton) {
            this.editColor((JButton)object, this.resources.getString("pref_hp_bg_col"));
        } else if (object == this.txnList1BgButton) {
            this.editColor((JButton)object, this.resources.getString("pref_txn_list1_bg_col"));
        } else if (object == this.txnList2BgButton) {
            this.editColor((JButton)object, this.resources.getString("pref_txn_list2_bg_col"));
        } else if (object == this.txnEditBgButton) {
            this.editColor((JButton)object, this.resources.getString("pref_txn_edit_bg_col"));
        }
    }

    private final void editColor(JButton jButton, String string) {
        Color color = JColorChooser.showDialog(this, this.resources.getString("pref_col_chooser") + ": " + string, jButton.getBackground());
        jButton.setBackground(color);
        jButton.repaint();
    }

    public PreferencesWindow(JFrame jFrame, MoneydanceGUI moneydanceGUI) {
        super(jFrame, moneydanceGUI.getResources().getString("pref_header"), true);
        this.parentFrame = jFrame;
        this.moneydanceGUI = moneydanceGUI;
        this.resources = moneydanceGUI.getResources();
        this.lookAndFeelNames = new String[]{this.resources.getString("java_laf"), this.resources.getString("motif_laf"), this.resources.getString("windows_laf")};
        this.confirmTxnChangesCheckBox = new JCheckBox(this.resources.getString("confirm_txn_changes"));
        this.checkVersionCheckBox = new JCheckBox(this.resources.getString("check_version_at_startup"));
        this.beepOnTxnChangeCheckBox = new JCheckBox(this.resources.getString("beep_on_txn_change"));
        this.restoreDesktopCheckBox = new JCheckBox(this.resources.getString("restore_settings_on_startup"));
        this.fullAcctPathCheckBox = new JCheckBox(this.resources.getString("show_full_account_path"));
        this.newTxnOnRecordCheckBox = new JCheckBox(this.resources.getString("new_transaction_on_record"));
        this.seekRecordedTxnCheckBox = new JCheckBox(this.resources.getString("seek_to_recorded_txns"));
        this.acctBgButton = new JButton("");
        this.acctFgButton = new JButton("");
        this.hpBgButton = new JButton("");
        this.txnList1BgButton = new JButton("");
        this.txnList2BgButton = new JButton("");
        this.txnEditBgButton = new JButton("");
        this.decimalCharChoice = new JComboBox<Character>(new Character[]{new Character('.'), new Character(',')});
        this.dateFormatChoice = new JComboBox<String>(new String[]{"MM/dd/yyyy", "MM.dd.yyyy", "MM-dd-yyyy", "yyyy/MM/dd", "yyyy.MM.dd", "yyyy-MM-dd", "dd/MM/yyyy", "dd.MM.yyyy", "dd-MM-yyyy"});
        this.timeFormatChoice = new JComboBox<String>(new String[]{"h:mm a", "H:mm"});
        this.localeChoice = new JComboBox<String>(this.localeNames);
        this.lookAndFeelChoice = new JComboBox<String>(this.lookAndFeelNames);
        this.okButton = new JButton(this.resources.getString("ok"));
        this.cancelButton = new JButton(this.resources.getString("cancel"));
        this.buttonPanel = new JPanel(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        int n = 0;
        int n2 = 0;
        jPanel.add((Component)new JLabel("  "), AwtUtil.getConstraints(n2++, n++, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)new JLabel(this.resources.getString("pref_header"), 0), AwtUtil.getConstraints(n2, n++, 1.0f, 0.0f, 3, 1, true, true));
        jPanel.add((Component)this.confirmTxnChangesCheckBox, AwtUtil.getConstraints(n2, n++, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)this.checkVersionCheckBox, AwtUtil.getConstraints(n2, n++, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)this.beepOnTxnChangeCheckBox, AwtUtil.getConstraints(n2, n++, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)this.restoreDesktopCheckBox, AwtUtil.getConstraints(n2, n++, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)this.fullAcctPathCheckBox, AwtUtil.getConstraints(n2, n++, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)this.newTxnOnRecordCheckBox, AwtUtil.getConstraints(n2, n++, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)this.seekRecordedTxnCheckBox, AwtUtil.getConstraints(n2, n++, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(" "), AwtUtil.getConstraints(n2, n++, 0.0f, 1.0f, 1, 1, true, true));
        n = 2;
        jPanel.add((Component)new JLabel(this.resources.getString("date_format") + ": ", 4), AwtUtil.getConstraints(++n2, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.dateFormatChoice, AwtUtil.getConstraints(n2 + 1, n++, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(this.resources.getString("time_format") + ": ", 4), AwtUtil.getConstraints(n2, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.timeFormatChoice, AwtUtil.getConstraints(n2 + 1, n++, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(this.resources.getString("decimal_char") + ": ", 4), AwtUtil.getConstraints(n2, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.decimalCharChoice, AwtUtil.getConstraints(n2 + 1, n++, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(this.resources.getString("locale") + ": ", 4), AwtUtil.getConstraints(n2, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.localeChoice, AwtUtil.getConstraints(n2 + 1, n++, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(this.resources.getString("look_and_feel") + ": ", 4), AwtUtil.getConstraints(n2, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.lookAndFeelChoice, AwtUtil.getConstraints(n2 + 1, n++, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel("  "), AwtUtil.getConstraints(n2 + 2, n, 0.0f, 0.0f, 1, 1, true, true));
        n = 0;
        n2 = 0;
        jPanel2.add((Component)new JLabel(this.resources.getString("pref_acct_bg_col") + ": ", 4), AwtUtil.getConstraints(n2, n, 0.0f, 1.0f, 1, 1, true, true));
        jPanel2.add((Component)this.acctBgButton, AwtUtil.getConstraints(n2 + 1, n++, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)new JLabel(this.resources.getString("pref_acct_fg_col") + ": ", 4), AwtUtil.getConstraints(n2, n, 0.0f, 1.0f, 1, 1, true, true));
        jPanel2.add((Component)this.acctFgButton, AwtUtil.getConstraints(n2 + 1, n++, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)new JLabel(this.resources.getString("pref_hp_bg_col") + ": ", 4), AwtUtil.getConstraints(n2, n, 0.0f, 1.0f, 1, 1, true, true));
        jPanel2.add((Component)this.hpBgButton, AwtUtil.getConstraints(n2 + 1, n++, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)new JLabel(this.resources.getString("pref_txn_list1_bg_col") + ": ", 4), AwtUtil.getConstraints(n2, n, 0.0f, 1.0f, 1, 1, true, true));
        jPanel2.add((Component)this.txnList1BgButton, AwtUtil.getConstraints(n2 + 1, n++, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)new JLabel(this.resources.getString("pref_txn_list2_bg_col") + ": ", 4), AwtUtil.getConstraints(n2, n, 0.0f, 1.0f, 1, 1, true, true));
        jPanel2.add((Component)this.txnList2BgButton, AwtUtil.getConstraints(n2 + 1, n++, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)new JLabel(this.resources.getString("pref_txn_edit_bg_col") + ": ", 4), AwtUtil.getConstraints(n2, n, 0.0f, 1.0f, 1, 1, true, true));
        jPanel2.add((Component)this.txnEditBgButton, AwtUtil.getConstraints(n2 + 1, n++, 1.0f, 0.0f, 1, 1, true, true));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(this.resources.getString("pref_general"), null, jPanel);
        jTabbedPane.addTab(this.resources.getString("pref_colors"), null, jPanel2);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.okButton, AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 1, false, false));
        this.buttonPanel.add((Component)this.cancelButton, AwtUtil.getConstraints(1, 0, 1.0f, 1.0f, 1, 1, false, false));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.acctFgButton.addActionListener(this);
        this.acctBgButton.addActionListener(this);
        this.hpBgButton.addActionListener(this);
        this.txnList1BgButton.addActionListener(this);
        this.txnList2BgButton.addActionListener(this);
        this.txnEditBgButton.addActionListener(this);
        this.populateFields();
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension.width + 40, dimension.height + 60);
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = jFrame.getSize();
        Point point = jFrame.getLocation();
        ((Component)this).setLocation(point.x + dimension3.width / 2 - dimension2.width / 2, point.y + dimension3.height / 2 - dimension2.height / 2);
    }
}

