/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JRateField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NewCurrencyWindow
extends JDialog
implements ActionListener {
    private JTextField idField;
    private JTextField nameField;
    private JRateField rateField;
    private JTextField tickerSymbolField;
    private JTextField prefixField;
    private JTextField suffixField;
    private JComboBox numDecimalChoice;
    private JButton okButton;
    private JButton cancelButton;
    private ResourceBundle resources = Main.getMainController().getPreferences().getResources();
    private CurrencyTable currencyTable;
    private CurrencyType newCurrencyType = null;

    public CurrencyType getNewCurrencyType() {
        return this.newCurrencyType;
    }

    private final void okButtonPressed() {
        String string = this.idField.getText().trim();
        if (string.length() <= 0) {
            JOptionPane.showMessageDialog(this, this.resources.getString("empty_currency_id_msg"), this.resources.getString("error"), 0);
            return;
        }
        double d = this.rateField.getValue();
        if (d == 0.0) {
            JOptionPane.showMessageDialog(this, this.resources.getString("got_zero_rate"), this.resources.getString("error"), 0);
            return;
        }
        CurrencyType currencyType = this.currencyTable.getCurrencyType(this.idField.getText());
        if (currencyType != null) {
            JOptionPane.showMessageDialog(this, this.resources.getString("currency_id_exists_msg"), this.resources.getString("error"), 0);
            return;
        }
        this.newCurrencyType = new CurrencyType(string, this.nameField.getText(), d, (Integer)this.numDecimalChoice.getSelectedItem(), this.prefixField.getText(), this.suffixField.getText(), this.tickerSymbolField.getText());
        this.newCurrencyType.setXRelativeRate(d, this.currencyTable.getBaseType());
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private final void cancelButtonPressed() {
        this.newCurrencyType = null;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.okButtonPressed();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.cancelButtonPressed();
        }
    }

    public NewCurrencyWindow(CurrencyTable currencyTable) {
        super((Frame)null, Main.getMainController().getPreferences().getResources().getString("new_currency_win_title"), true);
        this.currencyTable = currencyTable;
        char c = Main.getMainController().getPreferences().getDecimalChar();
        int n = c == ',' ? 46 : 44;
        this.idField = new JTextField("");
        this.nameField = new JTextField("", 20);
        this.rateField = new JRateField(c);
        this.tickerSymbolField = new JTextField();
        this.prefixField = new JTextField();
        this.suffixField = new JTextField();
        this.numDecimalChoice = new JComboBox<Integer>(new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5)});
        this.okButton = new JButton(this.resources.getString("ok"));
        this.cancelButton = new JButton(this.resources.getString("cancel"));
        int n2 = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add(jPanel);
        jPanel.add((Component)new JLabel(this.resources.getString("currency_id") + ":  ", 4), AwtUtil.getConstraints(0, n2, 0.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.idField, AwtUtil.getConstraints(1, n2++, 1.0f, 1.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(this.resources.getString("currency_name") + ":  ", 4), AwtUtil.getConstraints(0, n2, 0.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.nameField, AwtUtil.getConstraints(1, n2++, 1.0f, 1.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(this.resources.getString("currency_rate") + ":  ", 4), AwtUtil.getConstraints(0, n2, 0.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.rateField, AwtUtil.getConstraints(1, n2++, 1.0f, 1.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(this.resources.getString("currency_ticker") + ":  ", 4), AwtUtil.getConstraints(0, n2, 0.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.tickerSymbolField, AwtUtil.getConstraints(1, n2++, 1.0f, 1.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(this.resources.getString("currency_prefix") + ":  ", 4), AwtUtil.getConstraints(0, n2, 0.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.prefixField, AwtUtil.getConstraints(1, n2++, 1.0f, 1.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(this.resources.getString("currency_suffix") + ":  ", 4), AwtUtil.getConstraints(0, n2, 0.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.suffixField, AwtUtil.getConstraints(1, n2++, 1.0f, 1.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(this.resources.getString("currency_num_decimal_points") + ":  ", 4), AwtUtil.getConstraints(0, n2, 0.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.numDecimalChoice, AwtUtil.getConstraints(1, n2++, 1.0f, 1.0f, 1, 1, true, false));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, AwtUtil.getConstraints(0, n2++, 1.0f, 0.0f, 2, 1, true, true));
        jPanel2.add((Component)this.okButton, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel2.add((Component)this.cancelButton, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, false, false));
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension.width + 40, dimension.height + 40);
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = this.getToolkit().getScreenSize();
        ((Component)this).setLocation(dimension3.width / 2 - dimension2.width / 2, dimension3.height / 2 - dimension2.height / 2);
    }
}

