/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Reminder;
import com.seanreilly.apps.moneydance.model.ReminderListener;
import com.seanreilly.apps.moneydance.model.ReminderSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JComponent;

public class MonthView
extends JComponent
implements ReminderListener {
    private static String[] dayHeader = new String[]{"S", "M", "T", "W", "R", "F", "S"};
    protected Calendar monthBeginning;
    private Image bufferImg = null;
    private Rectangle nextMonthButton = null;
    private Rectangle prevMonthButton = null;
    private Vector dayRectangles = new Vector();
    private Font titleFont;
    private Font normalFont;
    private int dayWidth = 0;
    private DateFormat longDateFormat;
    private DateFormat dateFormat;
    private DateFormat shortDateFormat;
    private DateFormat superShortDateFormat;
    private ReminderSet reminderSet;
    private boolean showDayHeaders = true;
    private DayRect selectedDay = null;

    private final synchronized void doClickOnDay(DayRect dayRect) {
    }

    private final void gotoPreviousMonth() {
        this.monthBeginning.add(2, -1);
        this.render();
        this.repaint();
    }

    private final void gotoNextMonth() {
        this.monthBeginning.add(2, 1);
        this.render();
        this.repaint();
    }

    public void reminderAdded(Reminder reminder) {
        this.reminderModified(reminder);
    }

    public void reminderRemoved(Reminder reminder) {
        this.reminderModified(reminder);
    }

    public void reminderModified(Reminder reminder) {
        this.render();
        this.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.bufferImg = null;
        Dimension dimension = this.getSize();
        this.recalcFonts(dimension);
        this.recalcButtons(dimension);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Serializable serializable;
        if (this.bufferImg == null) {
            serializable = this.getSize();
            this.bufferImg = this.createImage(serializable.width, serializable.height);
            this.render();
        }
        if (this.bufferImg != null) {
            graphics.drawImage(this.bufferImg, 0, 0, null);
            serializable = this;
            synchronized (serializable) {
                if (this.selectedDay != null) {
                    System.err.println("painting selected day...");
                    graphics.setXORMode(Color.white);
                    graphics.fillRect(this.selectedDay.bounds.x, this.selectedDay.bounds.y, this.selectedDay.bounds.width, this.selectedDay.bounds.height);
                    graphics.setPaintMode();
                }
            }
        }
    }

    private final void recalcFonts(Dimension dimension) {
        FontMetrics fontMetrics;
        this.normalFont = this.getFont();
        this.showDayHeaders = dimension.height >= 120;
        this.dayWidth = dimension.width / 7;
        String string = "30";
        this.titleFont = new Font(this.normalFont.getName(), 1, this.normalFont.getSize());
        while (this.titleFont.getSize() < 18 && (fontMetrics = ((Component)this).getFontMetrics(this.titleFont)).getMaxDescent() + fontMetrics.getMaxAscent() < dimension.height / 6) {
            this.titleFont = new Font(this.titleFont.getName(), 0, this.titleFont.getSize() + 1);
        }
    }

    private final void recalcButtons(Dimension dimension) {
        int n;
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.titleFont);
        int n2 = n = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        int n3 = 1;
        this.prevMonthButton = new Rectangle(n3, 1, n2 - 1, n - 1);
        n3 = this.getSize().width - n2 - 1;
        this.nextMonthButton = new Rectangle(n3, 1, n2 - 1, n - 1);
    }

    private final void render() {
        Serializable serializable;
        int n;
        if (this.bufferImg == null) {
            return;
        }
        Graphics graphics = this.bufferImg.getGraphics();
        Dimension dimension = this.getSize();
        graphics.setColor(Color.cyan);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.titleFont);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, dimension.width, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 2);
        graphics.setColor(Color.black);
        graphics.setFont(this.titleFont);
        String string = this.longDateFormat.format(this.monthBeginning.getTime());
        int n2 = this.nextMonthButton.x - (this.prevMonthButton.x + this.prevMonthButton.width);
        if (fontMetrics.stringWidth(string) >= n2 && fontMetrics.stringWidth(string = this.dateFormat.format(this.monthBeginning.getTime())) >= n2 && fontMetrics.stringWidth(string = this.shortDateFormat.format(this.monthBeginning.getTime())) >= n2) {
            string = this.superShortDateFormat.format(this.monthBeginning.getTime());
        }
        graphics.drawString(string, dimension.width / 2 - fontMetrics.stringWidth(string) / 2, fontMetrics.getMaxAscent() + 2);
        graphics.setColor(Color.black);
        int[] nArray = new int[]{this.prevMonthButton.x, this.prevMonthButton.x + this.prevMonthButton.width, this.prevMonthButton.x + this.prevMonthButton.width};
        int[] nArray2 = new int[]{this.prevMonthButton.y + this.prevMonthButton.height / 2, this.prevMonthButton.y, this.prevMonthButton.y + this.prevMonthButton.height};
        graphics.fillPolygon(nArray, nArray2, 3);
        graphics.setColor(Color.black);
        nArray = new int[]{this.nextMonthButton.x + this.nextMonthButton.width, this.nextMonthButton.x, this.nextMonthButton.x};
        nArray2 = new int[]{this.nextMonthButton.y + this.nextMonthButton.height / 2, this.nextMonthButton.y, this.nextMonthButton.y + this.nextMonthButton.height};
        graphics.fillPolygon(nArray, nArray2, 3);
        int n3 = this.nextMonthButton.y + this.nextMonthButton.height + 1;
        graphics.setFont(this.normalFont);
        fontMetrics = ((Component)this).getFontMetrics(this.normalFont);
        if (this.showDayHeaders) {
            int n4 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 2;
            graphics.setColor(Color.gray);
            graphics.fillRect(0, n3, dimension.width, n4);
            graphics.setColor(Color.white);
            n = 0;
            while (n < 7) {
                graphics.drawString(dayHeader[n], n * dimension.width / 7 + this.dayWidth / 2 - fontMetrics.stringWidth(dayHeader[n]) / 2, n3 + n4 - fontMetrics.getMaxDescent() - 1);
                ++n;
            }
            n3 += n4;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(0, n3, dimension.width, dimension.height - n3);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, n3, this.dayWidth, dimension.height - n3);
        graphics.fillRect(this.dayWidth * 6, n3, dimension.width - this.dayWidth * 6, dimension.height - n3);
        graphics.setColor(Color.black);
        graphics.drawLine(1 * this.dayWidth, n3, 1 * this.dayWidth, dimension.height);
        graphics.drawLine(2 * this.dayWidth, n3, 2 * this.dayWidth, dimension.height);
        graphics.drawLine(3 * this.dayWidth, n3, 3 * this.dayWidth, dimension.height);
        graphics.drawLine(4 * this.dayWidth, n3, 4 * this.dayWidth, dimension.height);
        graphics.drawLine(5 * this.dayWidth, n3, 5 * this.dayWidth, dimension.height);
        graphics.drawLine(6 * this.dayWidth, n3, 6 * this.dayWidth, dimension.height);
        Calendar calendar = (Calendar)this.monthBeginning.clone();
        calendar.set(5, 1);
        n = calendar.get(7);
        calendar.add(2, 1);
        calendar.add(5, -1);
        int n5 = calendar.get(5);
        int n6 = n - 1 + n5;
        int n7 = n6 / 7;
        if ((double)n7 < (double)n6 / 7.0) {
            ++n7;
        }
        int n8 = (dimension.height - n3) / n7;
        int n9 = 0;
        while (n9 < n7) {
            graphics.drawLine(0, n3 + n8 * n9, dimension.width, n3 + n8 * n9);
            ++n9;
        }
        String string2 = "30";
        while (this.normalFont.getSize() >= 4 && (((FontMetrics)(serializable = graphics.getFontMetrics(this.normalFont))).getMaxDescent() + ((FontMetrics)serializable).getMaxAscent() >= n8 || ((FontMetrics)serializable).stringWidth(string2) >= this.dayWidth)) {
            this.normalFont = new Font(this.normalFont.getName(), 0, this.normalFont.getSize() - 1);
        }
        serializable = Calendar.getInstance();
        int n10 = ((Calendar)serializable).get(2);
        int n11 = ((Calendar)serializable).get(5);
        int n12 = ((Calendar)serializable).get(1);
        graphics.setFont(this.normalFont);
        this.dayRectangles.removeAllElements();
        calendar = (Calendar)this.monthBeginning.clone();
        int n13 = this.monthBeginning.get(2);
        int n14 = calendar.get(2);
        int n15 = calendar.get(1);
        Rectangle rectangle = null;
        while (calendar.get(2) == n13) {
            int n16 = calendar.get(4) - 1;
            int n17 = calendar.get(7) - 1;
            int n18 = calendar.get(5);
            String string3 = String.valueOf(n18);
            Vector vector = this.reminderSet != null ? this.reminderSet.getEventsInDay(calendar) : new Vector();
            boolean bl = n11 == n18 && n10 == n14 && n12 == n15;
            int n19 = n17 == 6 ? dimension.width - 6 * this.dayWidth : this.dayWidth;
            int n20 = n16 == n7 - 1 ? dimension.height - (n7 - 1) * n8 : n8;
            Rectangle rectangle2 = new Rectangle(this.dayWidth * n17 + 1, n3 + n16 * n8 + 1, n19 - 1, n20 - 1);
            MonthView monthView = this;
            if (monthView == null) {
                throw null;
            }
            DayRect dayRect = monthView.new DayRect(rectangle2, (Calendar)calendar.clone());
            this.dayRectangles.addElement(dayRect);
            Rectangle rectangle3 = graphics.getClipBounds();
            graphics.setClip(rectangle2);
            if (vector.size() > 0) {
                graphics.setColor(Color.yellow.brighter().brighter());
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            graphics.setColor(Color.black);
            int n21 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 2;
            int n22 = n3 + n8 * n16 + fontMetrics.getMaxAscent() + 1;
            graphics.drawString(string3, this.dayWidth * n17 + 2, n22);
            n22 += n21;
            int n23 = 0;
            while (n23 < vector.size() && n22 < rectangle2.y + rectangle2.height) {
                Reminder reminder = (Reminder)vector.elementAt(n23);
                graphics.drawString(reminder.getDescription(), this.dayWidth * n17 + 2, n22);
                n22 += n21;
                ++n23;
            }
            calendar.roll(6, true);
            if (bl) {
                rectangle = rectangle2;
            }
            graphics.setClip(rectangle3);
        }
        if (rectangle != null) {
            graphics.setClip(0, 0, dimension.width, dimension.height);
            graphics.setColor(Color.red);
            graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 180);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 200);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("MonthView");
        frame.add(new MonthView());
        ((Component)frame).setSize(400, 400);
        ((Component)frame).setVisible(true);
    }

    /* synthetic */ Rectangle access$0() {
        return this.prevMonthButton;
    }

    /* synthetic */ void access$1() {
        this.gotoPreviousMonth();
    }

    /* synthetic */ Rectangle access$2() {
        return this.nextMonthButton;
    }

    /* synthetic */ void access$3() {
        this.gotoNextMonth();
    }

    /* synthetic */ Vector access$4() {
        return this.dayRectangles;
    }

    /* synthetic */ void access$5(DayRect dayRect) {
        this.doClickOnDay(dayRect);
    }

    public MonthView() {
        this(new Date());
    }

    public MonthView(Date date) {
        this(date, null);
    }

    public MonthView(Date date, ReminderSet reminderSet) {
        this.reminderSet = reminderSet;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.monthBeginning = calendar = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.getMinimum(5));
        this.longDateFormat = new SimpleDateFormat("MMMM yyyy");
        this.dateFormat = new SimpleDateFormat("MMM yyyy");
        this.shortDateFormat = new SimpleDateFormat("MM/yy");
        this.superShortDateFormat = new SimpleDateFormat("MMM");
        MonthView monthView = this;
        if (monthView == null) {
            throw null;
        }
        this.addMouseListener(monthView.new MonthMouseListener());
    }

    class MonthMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (MonthView.this.access$0() != null && MonthView.this.access$0().contains(point)) {
                MonthView.this.access$1();
            } else if (MonthView.this.access$2() != null && MonthView.this.access$2().contains(point)) {
                MonthView.this.access$3();
            } else {
                Enumeration enumeration = MonthView.this.access$4().elements();
                while (enumeration.hasMoreElements()) {
                    DayRect dayRect = (DayRect)enumeration.nextElement();
                    if (!dayRect.bounds.contains(point)) continue;
                    MonthView.this.access$5(dayRect);
                }
            }
        }

        MonthMouseListener() {
        }
    }

    class DayRect {
        Rectangle bounds;
        Calendar day;

        DayRect(Rectangle rectangle, Calendar calendar) {
            this.bounds = rectangle;
            this.day = calendar;
        }
    }
}

