/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.PreferencesListener;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.AccountListener;
import com.seanreilly.apps.moneydance.model.Reminder;
import com.seanreilly.apps.moneydance.model.ReminderListener;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.model.TransactionListener;
import com.seanreilly.apps.moneydance.view.Resources;
import com.seanreilly.apps.moneydance.view.gui.AccountPanel;
import com.seanreilly.apps.moneydance.view.gui.InterfacePanel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class MainFrame
extends JFrame
implements ActionListener,
PreferencesListener {
    public static final String TITLE = "Moneydance 2.0.3 (26)";
    private MenuBar menuBar;
    private Menu fileMenu;
    private Menu toolsMenu;
    private Menu helpMenu;
    private Menu toolsCalcMenu;
    private MenuItem fileNewMenuItem;
    private MenuItem fileOpenMenuItem;
    private MenuItem fileSaveMenuItem;
    private MenuItem fileSaveAsMenuItem;
    private MenuItem filePreferencesMenuItem;
    private MenuItem fileQuitMenuItem;
    private MenuItem toolsImportMenuItem;
    private MenuItem toolsExportMenuItem;
    private MenuItem toolsCurrencyMenuItem;
    private MenuItem toolsTranslateCurrencyMenuItem;
    private MenuItem toolsRemindersMenuItem;
    private MenuItem toolsCOAMenuItem;
    private MenuItem toolsNormalCalcMenuItem;
    private MenuItem toolsLoanCalcMenuItem;
    private MenuItem helpAboutMenuItem;
    private MenuItem helpHelpMenuItem;
    private InterfacePanel currentPanel = null;
    private UserPreferences prefs;
    private ModificationListener modificationListener = null;
    private MoneydanceGUI moneydanceGUI;
    private boolean accountWasModified = false;
    private String titleBarString = "";

    public void preferencesUpdated() {
        this.setLabels();
    }

    private final void setLabels() {
        Resources resources = Main.getMainController().getPreferences().getResources();
        this.fileMenu.setLabel(resources.getString("file"));
        this.toolsMenu.setLabel(resources.getString("tools"));
        this.helpMenu.setLabel(resources.getString("help"));
        this.fileNewMenuItem.setLabel(resources.getString("new..."));
        this.fileOpenMenuItem.setLabel(resources.getString("open..."));
        this.fileSaveMenuItem.setLabel(resources.getString("save"));
        this.fileSaveAsMenuItem.setLabel(resources.getString("save_as..."));
        this.filePreferencesMenuItem.setLabel(resources.getString("preferences..."));
        this.fileQuitMenuItem.setLabel(resources.getString("quit"));
        this.toolsImportMenuItem.setLabel(resources.getString("import_data..."));
        this.toolsExportMenuItem.setLabel(resources.getString("export_data..."));
        this.toolsCurrencyMenuItem.setLabel(resources.getString("edit_currencies..."));
        this.toolsTranslateCurrencyMenuItem.setLabel(resources.getString("translate_currencies..."));
        this.toolsRemindersMenuItem.setLabel(resources.getString("reminders..."));
        this.toolsCOAMenuItem.setLabel(resources.getString("coa"));
        this.helpAboutMenuItem.setLabel(resources.getString("about_moneydance"));
        this.helpHelpMenuItem.setLabel(resources.getString("help_contents"));
        this.toolsCalcMenu.setLabel(resources.getString("tools_calc"));
        this.toolsNormalCalcMenuItem.setLabel(resources.getString("tools_normal_calc"));
        this.toolsLoanCalcMenuItem.setLabel(resources.getString("tools_loan_calc"));
    }

    public void goingAway() {
        if (this.currentPanel != null) {
            this.currentPanel.goingAway();
        }
        this.prefs.removeListener(this);
        if (this.currentPanel != null) {
            this.currentPanel.goneAway();
        }
    }

    public void setCurrentAccount(RootAccount rootAccount, File file) {
        if (this.currentPanel != null) {
            this.currentPanel.goingAway();
        }
        if (rootAccount == null) {
            this.accountClosed();
        } else {
            this.accountOpened(rootAccount, file);
        }
        if (this.currentPanel != null) {
            this.currentPanel.goneAway();
        }
        this.getContentPane().removeAll();
        AccountPanel accountPanel = new AccountPanel(this.moneydanceGUI, rootAccount);
        this.currentPanel = accountPanel;
        this.currentPanel.loadWorkspace();
        this.getContentPane().add((Component)accountPanel, "Center");
        this.getContentPane().validate();
    }

    public void setTitleString(File file) {
        this.titleBarString = file == null ? TITLE : TITLE + file.getAbsolutePath();
        this.setTitleBar();
    }

    private final void setTitleBar() {
        this.setTitle((this.accountWasModified ? "* " : "") + this.titleBarString);
    }

    private final synchronized void showCOAWindow() {
        if (this.currentPanel != null && this.currentPanel instanceof AccountPanel) {
            ((AccountPanel)this.currentPanel).showCOA();
        }
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 201) {
            this.moneydanceGUI.exit();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MainFrame mainFrame = this;
        if (mainFrame == null) {
            throw null;
        }
        SwingUtilities.invokeLater(mainFrame.new ActionEventHandler(actionEvent));
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void saveWorkspace() {
        Point point = this.getLocationOnScreen();
        Dimension dimension = this.getSize();
        if (point.x >= 0 && point.y >= 0 && dimension.width > 0 && dimension.height > 0) {
            this.prefs.setSetting("gui.screen_location", "" + point.x + 'x' + point.y);
            this.prefs.setSetting("gui.screen_size", "" + dimension.width + 'x' + dimension.height);
        }
        if (this.currentPanel != null) {
            this.currentPanel.saveWorkspace();
        }
    }

    private final void fileWasModified() {
        RootAccount rootAccount;
        this.accountWasModified = this.currentPanel != null ? ((rootAccount = this.currentPanel.getRootAccount()) != null ? rootAccount.isUnsavedData() : false) : false;
        this.setTitleBar();
    }

    private final void fileWasSaved() {
        RootAccount rootAccount;
        if (this.currentPanel != null && (rootAccount = this.currentPanel.getRootAccount()) != null) {
            this.accountWasModified = rootAccount.isUnsavedData();
        }
        this.setTitleBar();
    }

    public void accountOpened(RootAccount rootAccount, File file) {
        this.accountWasModified = rootAccount.isUnsavedData();
        rootAccount.addAccountListener(this.modificationListener);
        rootAccount.getTransactionSet().addTransactionListener(this.modificationListener);
        rootAccount.getReminderSet().addReminderListener(this.modificationListener);
        this.fileSaveAsMenuItem.setEnabled(true);
        this.fileSaveMenuItem.setEnabled(true);
        this.toolsExportMenuItem.setEnabled(true);
        this.toolsRemindersMenuItem.setEnabled(true);
        this.toolsTranslateCurrencyMenuItem.setEnabled(true);
        this.toolsCurrencyMenuItem.setEnabled(true);
        this.toolsCOAMenuItem.setEnabled(true);
        this.setTitleString(file);
    }

    public void accountClosed() {
        RootAccount rootAccount;
        if (this.currentPanel != null && (rootAccount = this.currentPanel.getRootAccount()) != null) {
            rootAccount.removeAccountListener(this.modificationListener);
            rootAccount.getTransactionSet().removeTransactionListener(this.modificationListener);
            rootAccount.getReminderSet().removeReminderListener(this.modificationListener);
        }
        this.accountWasModified = false;
        this.fileSaveAsMenuItem.setEnabled(false);
        this.fileSaveMenuItem.setEnabled(false);
        this.toolsExportMenuItem.setEnabled(false);
        this.toolsRemindersMenuItem.setEnabled(false);
        this.toolsTranslateCurrencyMenuItem.setEnabled(false);
        this.toolsCurrencyMenuItem.setEnabled(false);
        this.toolsCOAMenuItem.setEnabled(false);
        this.setTitleString(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restoreWorkspace() {
        int n;
        int n2;
        String string = this.prefs.getSetting("gui.screen_location", "10x10");
        String string2 = this.prefs.getSetting("gui.screen_size", "700x400");
        int n3 = string.indexOf(120);
        if (n3 > 0) {
            try {
                n2 = Integer.parseInt(string.substring(0, n3));
                n = Integer.parseInt(string.substring(n3 + 1));
                ((Component)this).setLocation(n2, n);
            }
            catch (Exception exception) {
                System.err.println("Error trying to set window location: " + exception);
            }
        }
        if ((n3 = string2.indexOf(120)) > 0) {
            try {
                n2 = Integer.parseInt(string2.substring(0, n3));
                n = Integer.parseInt(string2.substring(n3 + 1));
                ((Component)this).setSize(new Dimension(n2, n));
            }
            catch (Exception exception) {
                System.err.println("Error trying to set window size: " + exception);
            }
        }
        if (this.currentPanel != null) {
            this.currentPanel.loadWorkspace();
        }
    }

    /* synthetic */ MenuItem access$0() {
        return this.fileNewMenuItem;
    }

    /* synthetic */ MoneydanceGUI access$1() {
        return this.moneydanceGUI;
    }

    /* synthetic */ MenuItem access$2() {
        return this.fileOpenMenuItem;
    }

    /* synthetic */ MenuItem access$3() {
        return this.fileSaveMenuItem;
    }

    /* synthetic */ void access$4() {
        this.fileWasSaved();
    }

    /* synthetic */ MenuItem access$5() {
        return this.fileSaveAsMenuItem;
    }

    /* synthetic */ MenuItem access$6() {
        return this.filePreferencesMenuItem;
    }

    /* synthetic */ MenuItem access$7() {
        return this.toolsImportMenuItem;
    }

    /* synthetic */ MenuItem access$8() {
        return this.toolsExportMenuItem;
    }

    /* synthetic */ MenuItem access$9() {
        return this.toolsCurrencyMenuItem;
    }

    /* synthetic */ MenuItem access$10() {
        return this.toolsTranslateCurrencyMenuItem;
    }

    /* synthetic */ MenuItem access$11() {
        return this.toolsRemindersMenuItem;
    }

    /* synthetic */ MenuItem access$12() {
        return this.toolsCOAMenuItem;
    }

    /* synthetic */ void access$13() {
        this.showCOAWindow();
    }

    /* synthetic */ MenuItem access$14() {
        return this.toolsLoanCalcMenuItem;
    }

    /* synthetic */ MenuItem access$15() {
        return this.toolsNormalCalcMenuItem;
    }

    /* synthetic */ MenuItem access$16() {
        return this.fileQuitMenuItem;
    }

    /* synthetic */ MenuItem access$17() {
        return this.helpAboutMenuItem;
    }

    /* synthetic */ MenuItem access$18() {
        return this.helpHelpMenuItem;
    }

    /* synthetic */ void access$19() {
        this.fileWasModified();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MainFrame(MoneydanceGUI moneydanceGUI) {
        super(TITLE);
        try {
            ((Frame)this).setIconImage(AwtUtil.loadImage("/com/seanreilly/apps/moneydance/images/dollar.gif"));
        }
        catch (Exception exception) {
            System.err.println("exception: " + exception);
            exception.printStackTrace(System.err);
        }
        this.prefs = Main.getMainController().getPreferences();
        this.moneydanceGUI = moneydanceGUI;
        this.getContentPane().setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.menuBar = new MenuBar();
        this.fileMenu = new Menu(" ");
        this.menuBar.add(this.fileMenu);
        this.fileNewMenuItem = new MenuItem(" ");
        this.fileMenu.add(this.fileNewMenuItem);
        this.fileOpenMenuItem = new MenuItem(" ", new MenuShortcut(79));
        this.fileMenu.add(this.fileOpenMenuItem);
        this.fileSaveMenuItem = new MenuItem(" ", new MenuShortcut(83));
        this.fileMenu.add(this.fileSaveMenuItem);
        this.fileSaveAsMenuItem = new MenuItem(" ");
        this.fileMenu.add(this.fileSaveAsMenuItem);
        this.filePreferencesMenuItem = new MenuItem(" ", new MenuShortcut(80));
        this.fileMenu.add(this.filePreferencesMenuItem);
        this.fileQuitMenuItem = new MenuItem(" ", new MenuShortcut(81));
        this.fileMenu.add(this.fileQuitMenuItem);
        this.toolsMenu = new Menu(" ");
        this.menuBar.add(this.toolsMenu);
        this.toolsImportMenuItem = new MenuItem(" ");
        this.toolsMenu.add(this.toolsImportMenuItem);
        this.toolsExportMenuItem = new MenuItem(" ");
        this.toolsMenu.add(this.toolsExportMenuItem);
        this.toolsCurrencyMenuItem = new MenuItem(" ");
        this.toolsMenu.add(this.toolsCurrencyMenuItem);
        this.toolsTranslateCurrencyMenuItem = new MenuItem(" ");
        this.toolsMenu.add(this.toolsTranslateCurrencyMenuItem);
        this.toolsRemindersMenuItem = new MenuItem(" ");
        this.toolsMenu.add(this.toolsRemindersMenuItem);
        this.toolsCOAMenuItem = new MenuItem(" ");
        this.toolsMenu.add(this.toolsCOAMenuItem);
        this.toolsCalcMenu = new Menu(" ");
        this.toolsMenu.add(this.toolsCalcMenu);
        this.toolsNormalCalcMenuItem = new MenuItem(" ");
        this.toolsCalcMenu.add(this.toolsNormalCalcMenuItem);
        this.toolsLoanCalcMenuItem = new MenuItem(" ");
        this.toolsCalcMenu.add(this.toolsLoanCalcMenuItem);
        this.helpMenu = new Menu(" ");
        this.menuBar.setHelpMenu(this.helpMenu);
        this.helpAboutMenuItem = new MenuItem(" ");
        this.helpMenu.add(this.helpAboutMenuItem);
        this.helpHelpMenuItem = new MenuItem(" ");
        this.helpMenu.add(this.helpHelpMenuItem);
        this.setMenuBar(this.menuBar);
        this.enableEvents(201L);
        this.accountClosed();
        this.fileNewMenuItem.addActionListener(this);
        this.fileOpenMenuItem.addActionListener(this);
        this.fileSaveMenuItem.addActionListener(this);
        this.fileSaveAsMenuItem.addActionListener(this);
        this.filePreferencesMenuItem.addActionListener(this);
        this.fileQuitMenuItem.addActionListener(this);
        this.toolsImportMenuItem.addActionListener(this);
        this.toolsExportMenuItem.addActionListener(this);
        this.toolsCurrencyMenuItem.addActionListener(this);
        this.toolsTranslateCurrencyMenuItem.addActionListener(this);
        this.toolsRemindersMenuItem.addActionListener(this);
        this.toolsCOAMenuItem.addActionListener(this);
        this.helpAboutMenuItem.addActionListener(this);
        this.helpHelpMenuItem.addActionListener(this);
        this.toolsNormalCalcMenuItem.addActionListener(this);
        this.toolsLoanCalcMenuItem.addActionListener(this);
        this.toolsLoanCalcMenuItem.setEnabled(false);
        this.toolsExportMenuItem.setEnabled(false);
        this.setLabels();
        this.prefs.addListener(this);
        ((Component)this).setSize(700, 400);
        MainFrame mainFrame = this;
        if (mainFrame == null) {
            throw null;
        }
        this.modificationListener = mainFrame.new ModificationListener();
    }

    class ActionEventHandler
    implements Runnable {
        ActionEvent evt;

        public void run() {
            if (this.evt.getSource() == MainFrame.this.access$0()) {
                MainFrame.this.access$1().newFile();
            } else if (this.evt.getSource() == MainFrame.this.access$2()) {
                MainFrame.this.access$1().openFile();
            } else if (this.evt.getSource() == MainFrame.this.access$3()) {
                MainFrame.this.access$1().saveCurrentAccount();
                MainFrame.this.access$4();
            } else if (this.evt.getSource() == MainFrame.this.access$5()) {
                MainFrame.this.access$1().saveCurrentAccountAs();
                MainFrame.this.access$4();
            } else if (this.evt.getSource() == MainFrame.this.access$6()) {
                MainFrame.this.access$1().editPreferences();
            } else if (this.evt.getSource() == MainFrame.this.access$7()) {
                MainFrame.this.access$1().importFile();
            } else if (this.evt.getSource() == MainFrame.this.access$8()) {
                MainFrame.this.access$1().exportFile();
            } else if (this.evt.getSource() == MainFrame.this.access$9()) {
                MainFrame.this.access$1().editCurrencies();
            } else if (this.evt.getSource() == MainFrame.this.access$10()) {
                MainFrame.this.access$1().translateCurrencies();
            } else if (this.evt.getSource() == MainFrame.this.access$11()) {
                MainFrame.this.access$1().showReminders();
            } else if (this.evt.getSource() == MainFrame.this.access$12()) {
                MainFrame.this.access$13();
            } else if (this.evt.getSource() == MainFrame.this.access$14()) {
                MainFrame.this.access$1().showLoanCalculator();
            } else if (this.evt.getSource() == MainFrame.this.access$15()) {
                MainFrame.this.access$1().showCalculator();
            } else if (this.evt.getSource() == MainFrame.this.access$16()) {
                MainFrame.this.access$1().exit();
            } else if (this.evt.getSource() == MainFrame.this.access$17()) {
                MainFrame.this.access$1().showAbout();
            } else if (this.evt.getSource() == MainFrame.this.access$18()) {
                MainFrame.this.access$1().showHelp();
            }
        }

        ActionEventHandler(ActionEvent actionEvent) {
            this.evt = actionEvent;
        }
    }

    private class ModificationListener
    implements AccountListener,
    TransactionListener,
    ReminderListener {
        public void transactionRemoved(Transaction transaction) {
            MainFrame.this.access$19();
        }

        public void transactionAdded(Transaction transaction) {
            MainFrame.this.access$19();
        }

        public void transactionModified(Transaction transaction) {
            MainFrame.this.access$19();
        }

        public void accountModified(Account account) {
            MainFrame.this.access$19();
        }

        public void reminderRemoved(Reminder reminder) {
            MainFrame.this.access$19();
        }

        public void reminderAdded(Reminder reminder) {
            MainFrame.this.access$19();
        }

        public void reminderModified(Reminder reminder) {
            MainFrame.this.access$19();
        }

        ModificationListener() {
        }
    }
}

