/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JTextPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LastPrintedCheckWindow
extends JDialog
implements ActionListener {
    private JButton okButton;
    private JTextField checkNumField;
    private long firstCheckNum;
    private long lastCheckNum;
    private MoneydanceGUI mdGUI;

    public boolean allChecksPrinted() {
        return this.checkNumField.getText().trim().length() <= 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getFirstErrorCheck() {
        try {
            return Long.parseLong(this.checkNumField.getText().trim());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean validateEntry() {
        boolean bl;
        block5: {
            if (this.checkNumField.getText().trim().length() <= 0) {
                return true;
            }
            bl = false;
            try {
                long l = Long.parseLong(this.checkNumField.getText().trim());
                if (l < this.firstCheckNum || l > this.lastCheckNum) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = true;
                if (!Main.DEBUG) break block5;
                exception.printStackTrace(System.err);
            }
        }
        if (bl) {
            this.mdGUI.showErrorMessage(this.mdGUI.getResources().getString("printchk_first_err_error1") + this.firstCheckNum + this.mdGUI.getResources().getString("printchk_first_err_error2") + this.lastCheckNum + this.mdGUI.getResources().getString("printchk_first_err_error3"));
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton && this.validateEntry()) {
            ((Component)this).setVisible(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LastPrintedCheckWindow(MoneydanceGUI moneydanceGUI, long l, long l2) {
        super(moneydanceGUI.getTopLevelFrame(), moneydanceGUI.getResources().getString("printchk_verify"), true);
        this.firstCheckNum = l;
        this.lastCheckNum = l2;
        this.mdGUI = moneydanceGUI;
        this.setDefaultCloseOperation(0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        this.getContentPane().add(jPanel);
        this.okButton = new JButton(moneydanceGUI.getResources().getString("ok"));
        this.checkNumField = new JTextField("", 8);
        jPanel.add((Component)new JTextPanel(moneydanceGUI.getResources().getString("printchk_first_err_text1") + l + moneydanceGUI.getResources().getString("printchk_first_err_text2") + l2 + moneydanceGUI.getResources().getString("printchk_first_err_text3")), AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 2, 1, false, false));
        jPanel.add((Component)new JLabel(" "), AwtUtil.getConstraints(0, 1, 1.0f, 1.0f, 2, 1, true, true));
        jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printchk_first_err_num") + ": ", 2), AwtUtil.getConstraints(0, 2, 0.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.checkNumField, AwtUtil.getConstraints(1, 2, 1.0f, 1.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(" "), AwtUtil.getConstraints(0, 3, 1.0f, 1.0f, 2, 1, true, true));
        jPanel.add((Component)this.okButton, AwtUtil.getConstraints(0, 4, 1.0f, 1.0f, 2, 1, false, false));
        this.okButton.addActionListener(this);
        this.pack();
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension);
        try {
            JFrame jFrame = moneydanceGUI.getTopLevelFrame();
            Dimension dimension2 = jFrame.getSize();
            Point point = jFrame.getLocation();
            ((Component)this).setLocation(point.x + dimension2.width / 2 - dimension.width / 2, point.y + dimension2.height / 2 - dimension.height / 2);
            return;
        }
        catch (Exception exception) {
            if (!Main.DEBUG) return;
            exception.printStackTrace(System.err);
        }
    }
}

