/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.AccountListModel;
import com.seanreilly.apps.moneydance.view.gui.CurrencyModel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ImportWindow
extends JDialog
implements ActionListener,
ItemListener {
    private static String lastDirectory = null;
    private JButton okButton;
    private JButton cancelButton;
    private JComboBox currencyTypeChoice;
    private JTextField fileNameField;
    private JButton chooseFileButton;
    private CurrencyTable currencyTable;
    private JRadioButton newAccountBox;
    private JRadioButton existingAccountBox;
    private JCheckBox matchTxnsCheckbox;
    private JCheckBox accountsOnlyCheckbox;
    private AccountListModel accountModel;
    private JComboBox existingAccountChoice;
    private JComboBox dateFormatChoice;
    private MoneydanceGUI moneydanceGUI;
    private RootAccount rootAccount;
    private JFrame parentFrame;
    private boolean isNewAccountSet = false;
    private CurrencyModel currencyModel;
    private byte[] formatChoices = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};

    protected void chooseFileButtonPressed() {
        FileDialog fileDialog = new FileDialog((Frame)this.parentFrame, this.moneydanceGUI.getResources().getString("choose_qif_file_title"), 0);
        if (lastDirectory != null) {
            fileDialog.setDirectory(lastDirectory);
        }
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string == null || string2 == null) {
            return;
        }
        this.fileNameField.setText(string2 + string);
        lastDirectory = string2;
    }

    private final void setNewExistingSelection() {
        if (this.existingAccountBox.isSelected()) {
            this.existingAccountChoice.setEnabled(true);
            this.matchTxnsCheckbox.setEnabled(true);
        } else {
            this.existingAccountChoice.setEnabled(false);
            this.matchTxnsCheckbox.setEnabled(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.newAccountBox || itemEvent.getSource() == this.existingAccountBox) {
            this.setNewExistingSelection();
        }
    }

    public void dispose() {
        super.dispose();
        this.goneAway();
    }

    public void goneAway() {
        this.accountModel.goneAway();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            block13: {
                try {
                    try {
                        this.moneydanceGUI.setSuspendRefresh(true);
                        int n = this.dateFormatChoice.getSelectedIndex();
                        if (n < 0 || n >= this.formatChoices.length) {
                            n = 0;
                        }
                        byte by = this.formatChoices[n];
                        File file = new File(this.fileNameField.getText().trim());
                        if (!file.exists() || !file.canRead()) {
                            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("unable_to_read_file") + ": " + this.fileNameField.getText());
                            Object var3_6 = null;
                            this.moneydanceGUI.setSuspendRefresh(false);
                            this.rootAccount.accountModified(this.rootAccount);
                            return;
                        }
                        if (this.isNewAccountSet) {
                            Main.getMainController().setCurrentAccount(this.rootAccount, null);
                        }
                        if (this.existingAccountBox.isSelected()) {
                            Main.getMainController().importQIFIntoAccount(this.rootAccount, file, by, (CurrencyType)this.currencyTypeChoice.getSelectedItem(), (Account)this.existingAccountChoice.getSelectedItem(), this.matchTxnsCheckbox.isSelected(), this.accountsOnlyCheckbox.isSelected());
                        } else {
                            Main.getMainController().importQIFIntoNewAccount(this.rootAccount, file, by, (CurrencyType)this.currencyTypeChoice.getSelectedItem(), this.accountsOnlyCheckbox.isSelected());
                        }
                    }
                    catch (Exception exception) {
                        this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("qif_import_error") + ": " + exception);
                        if (Main.DEBUG) {
                            System.err.println("QIF Import error: " + exception);
                            exception.printStackTrace(System.err);
                        }
                        Object var3_8 = null;
                        this.moneydanceGUI.setSuspendRefresh(false);
                        this.rootAccount.accountModified(this.rootAccount);
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_9 = null;
                    this.moneydanceGUI.setSuspendRefresh(false);
                    this.rootAccount.accountModified(this.rootAccount);
                    throw throwable;
                }
                Object var3_7 = null;
                this.moneydanceGUI.setSuspendRefresh(false);
                this.rootAccount.accountModified(this.rootAccount);
            }
            ((Component)this).setVisible(false);
            this.dispose();
            return;
        }
        if (actionEvent.getSource() == this.cancelButton) {
            ((Component)this).setVisible(false);
            this.dispose();
            return;
        }
        if (actionEvent.getSource() != this.chooseFileButton) return;
        this.chooseFileButtonPressed();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImportWindow(JFrame jFrame, RootAccount rootAccount, MoneydanceGUI moneydanceGUI) {
        super((Frame)jFrame, moneydanceGUI.getResources().getString("import_qif_header"));
        this.moneydanceGUI = moneydanceGUI;
        this.parentFrame = jFrame;
        if (rootAccount == null) {
            rootAccount = new RootAccount(this.currencyTable.getBaseType().getID(), CurrencyTable.createDefaultTable(this.moneydanceGUI.getResources().getString("default_currency")));
            this.isNewAccountSet = true;
        }
        this.rootAccount = rootAccount;
        this.currencyTable = rootAccount.getCurrencyTable();
        this.setDefaultCloseOperation(0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        this.getContentPane().add(jPanel);
        this.accountModel = new AccountListModel(rootAccount);
        this.accountModel.setShowAccountsOfType(1, true);
        this.accountModel.setShowAccountsOfType(3, true);
        this.accountModel.setShowAccountsOfType(2, true);
        this.accountModel.setShowAccountsOfType(4, false);
        this.accountModel.setShowAccountsOfType(5, false);
        this.accountModel.setShowAccountsOfType(0, false);
        this.existingAccountChoice = new JComboBox(this.accountModel);
        try {
            this.existingAccountChoice.setSelectedIndex(0);
        }
        catch (Exception exception) {
        }
        String[] stringArray = new String[]{this.moneydanceGUI.getResources().getString("qif_datefmt_auto"), "MM/DD/YY", "MM.DD.YY", "MM-DD-YY", "DD/MM/YY", "DD.MM.YY", "DD-MM-YY", "YY/MM/DD", "YY.MM.DD", "YY-MM-DD"};
        this.dateFormatChoice = new JComboBox<String>(stringArray);
        this.newAccountBox = new JRadioButton(this.moneydanceGUI.getResources().getString("new_account") + ": ", true);
        this.existingAccountBox = new JRadioButton(this.moneydanceGUI.getResources().getString("existing_account") + ": ", false);
        if (this.accountModel.getSize() <= 0) {
            this.existingAccountBox.setEnabled(false);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.newAccountBox);
        buttonGroup.add(this.existingAccountBox);
        this.okButton = new JButton(this.moneydanceGUI.getResources().getString("ok"));
        this.cancelButton = new JButton(this.moneydanceGUI.getResources().getString("cancel"));
        this.chooseFileButton = new JButton(this.moneydanceGUI.getResources().getString("choose_file"));
        this.fileNameField = new JTextField(25);
        this.currencyModel = new CurrencyModel(this.currencyTable);
        this.currencyTypeChoice = new JComboBox(this.currencyModel);
        this.currencyTypeChoice.setSelectedItem(this.currencyTable.getBaseType());
        this.matchTxnsCheckbox = new JCheckBox(this.moneydanceGUI.getResources().getString("match_txns"), true);
        this.accountsOnlyCheckbox = new JCheckBox(this.moneydanceGUI.getResources().getString("import_accts_only"), false);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)new JLabel("  "), AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 3, 1, true, true));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("import_qif_header") + ": ", 0), AwtUtil.getConstraints(0, n++, 1.0f, 0.0f, 3, 1, true, true));
        jPanel.add((Component)new JLabel("  "), AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 3, 1, true, true));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("import_into_acct") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 2, true, true));
        jPanel.add((Component)this.newAccountBox, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 2, 1, true, true));
        JPanel jPanel3 = new JPanel(gridBagLayout);
        jPanel3.add((Component)this.existingAccountBox, AwtUtil.getConstraints(0, 0, 0.0f, 1.0f, 1, 1, true, false));
        jPanel3.add((Component)this.existingAccountChoice, AwtUtil.getConstraints(1, 0, 1.0f, 1.0f, 1, 1, true, false));
        jPanel.add((Component)jPanel3, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 2, 1, true, true));
        jPanel.add((Component)this.matchTxnsCheckbox, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 2, 1, true, true));
        jPanel.add((Component)this.accountsOnlyCheckbox, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 2, 1, true, true));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("from_file") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.fileNameField, AwtUtil.getConstraints(1, n, 1.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.chooseFileButton, AwtUtil.getConstraints(2, n++, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("qif_datefmt") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.dateFormatChoice, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 2, 1, true, true));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("currency_type") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.currencyTypeChoice, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 2, 1, true, true));
        jPanel.add((Component)new JLabel("  "), AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 3, 1, true, true));
        jPanel.add((Component)jPanel2, AwtUtil.getConstraints(0, n++, 1.0f, 0.0f, 3, 1, true, true));
        jPanel2.add((Component)this.okButton, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel2.add((Component)this.cancelButton, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, false, false));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension.width + 20, dimension.height + 20);
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = jFrame.getSize();
        Point point = jFrame.getLocation();
        ((Component)this).setLocation(point.x + dimension3.width / 2 - dimension2.width / 2, point.y + dimension3.height / 2 - dimension2.height / 2);
        this.chooseFileButton.addActionListener(this);
        this.newAccountBox.addItemListener(this);
        this.existingAccountBox.addItemListener(this);
        this.setNewExistingSelection();
    }
}

