/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.CurrencyModel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExportWindow
extends JDialog
implements ActionListener,
ItemListener {
    private JButton okButton;
    private JButton cancelButton;
    private JComboBox formatChoice;
    private JComboBox currencyTypeChoice;
    private JTextField fileNameField;
    private JButton chooseFileButton;
    private CurrencyTable currencyTable;
    private MoneydanceGUI moneydanceGUI;
    private RootAccount rootAccount;
    private JFrame parentFrame;

    private final void formatUpdated() {
        int n = this.formatChoice.getSelectedIndex();
        this.currencyTypeChoice.setEnabled(n == 0);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.formatChoice) {
            this.formatUpdated();
        }
    }

    protected void chooseFileButtonPressed() {
        FileDialog fileDialog = new FileDialog((Frame)this.parentFrame, this.moneydanceGUI.getResources().getString("choose_exp_file_title"), 1);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string == null || string2 == null) {
            return;
        }
        this.fileNameField.setText(string2 + string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            if (this.fileNameField.getText().trim().length() <= 0) {
                this.moneydanceGUI.showInfoMessage(this.moneydanceGUI.getResources().getString("qif_err_nofilename"));
                return;
            }
            try {
                File file = new File(this.fileNameField.getText().trim());
                if (this.rootAccount == null) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    return;
                }
                Main main = Main.getMainController();
                if (this.formatChoice.getSelectedIndex() == 0) {
                    main.exportAllAccountsIntoQIF(this.rootAccount, file, (CurrencyType)this.currencyTypeChoice.getSelectedItem());
                } else {
                    main.exportAllAccountsIntoTD(this.rootAccount, file);
                }
            }
            catch (Exception exception) {
                this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("qif_export_error") + ": " + exception.getMessage());
                System.err.println("Export error: " + exception);
                exception.printStackTrace(System.err);
            }
            ((Component)this).setVisible(false);
            this.dispose();
            return;
        }
        if (actionEvent.getSource() == this.cancelButton) {
            ((Component)this).setVisible(false);
            this.dispose();
            return;
        }
        if (actionEvent.getSource() != this.chooseFileButton) return;
        this.chooseFileButtonPressed();
    }

    public ExportWindow(JFrame jFrame, RootAccount rootAccount, MoneydanceGUI moneydanceGUI) {
        super((Frame)jFrame, moneydanceGUI.getResources().getString("export_qif_header"));
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.parentFrame = jFrame;
        this.currencyTable = rootAccount.getCurrencyTable();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add(jPanel);
        this.formatChoice = new JComboBox<String>(new String[]{moneydanceGUI.getResources().getString("format_qif"), moneydanceGUI.getResources().getString("format_tabdel")});
        this.okButton = new JButton(this.moneydanceGUI.getResources().getString("ok"));
        this.cancelButton = new JButton(this.moneydanceGUI.getResources().getString("cancel"));
        this.chooseFileButton = new JButton(this.moneydanceGUI.getResources().getString("choose_file"));
        this.fileNameField = new JTextField(25);
        this.currencyTypeChoice = new JComboBox(new CurrencyModel(this.currencyTable));
        this.currencyTypeChoice.setSelectedItem(this.currencyTable.getBaseType());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)new JLabel("  "), AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 3, 1, true, true));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("export_qif_header"), 0), AwtUtil.getConstraints(0, n++, 1.0f, 0.0f, 3, 1, true, true));
        jPanel.add((Component)new JLabel("  "), AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 3, 1, true, true));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("export_format") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.formatChoice, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 2, 1, true, true));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("to_file") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.fileNameField, AwtUtil.getConstraints(1, n, 1.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.chooseFileButton, AwtUtil.getConstraints(2, n++, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("currency_type") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.currencyTypeChoice, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 2, 1, true, true));
        jPanel.add((Component)new JLabel("  "), AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 3, 1, true, true));
        jPanel.add((Component)jPanel2, AwtUtil.getConstraints(0, n++, 1.0f, 0.0f, 3, 1, true, true));
        jPanel2.add((Component)this.okButton, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel2.add((Component)this.cancelButton, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, false, false));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.formatChoice.addItemListener(this);
        this.formatUpdated();
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension.width + 20, dimension.height + 20);
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = jFrame.getSize();
        Point point = jFrame.getLocation();
        ((Component)this).setLocation(point.x + dimension3.width / 2 - dimension2.width / 2, point.y + dimension3.height / 2 - dimension2.height / 2);
        this.chooseFileButton.addActionListener(this);
    }
}

